---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-Service一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行 199-207（serviceColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行 209-210（TableHandler 登録）
- E-03: `pkg/printers/internalversion/printers.go` 行 1387-1409（printService 関数）
- E-04: `pkg/printers/internalversion/printers.go` 行 1411-1421（printServiceList 関数）
- E-05: `pkg/printers/internalversion/printers.go` 行 1343-1373（getServiceExternalIP 関数）
- E-06: `pkg/printers/internalversion/printers.go` 行 1375-1385（makePortString 関数）
- E-07: `pkg/printers/internalversion/printers.go` 行 81-82（loadBalancerWidth 定数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Service のカラムは Name, Type, Cluster-IP, External-IP, Port(s), Age + wide: Selector | E-01 | ○ |
| C-02 | ClusterIP は Spec.ClusterIPs[0] から取得 | E-03 (行1393-1394) | ○ |
| C-03 | ClusterIPs が空なら "<none>" | E-03 (行1392) | ○ |
| C-04 | External-IP は getServiceExternalIP で算出 | E-03 (行1397) | ○ |
| C-05 | ClusterIP タイプ: ExternalIPs があれば結合、なければ "<none>" | E-05 (行1345-1349) | ○ |
| C-06 | NodePort タイプ: ExternalIPs があれば結合、なければ "<none>" | E-05 (行1350-1354) | ○ |
| C-07 | LoadBalancer タイプ: LB IP + ExternalIPs を結合、なければ "<pending>" | E-05 (行1355-1368) | ○ |
| C-08 | ExternalName タイプ: Spec.ExternalName を表示 | E-05 (行1369-1370) | ○ |
| C-09 | Port(s) は makePortString で生成 | E-03 (行1398) | ○ |
| C-10 | ポートは "{port}/{protocol}" 形式 | E-06 (行1379) | ○ |
| C-11 | NodePort 設定時は "{port}:{nodePort}/{protocol}" 形式 | E-06 (行1381) | ○ |
| C-12 | Port(s) が空なら "<none>" | E-03 (行1399-1401) | ○ |
| C-13 | Name, Type, ClusterIP, ExternalIP, Ports, Age をセルに追加 | E-03 (行1403) | ○ |
| C-14 | Wide 時に Selector を追加 | E-03 (行1404-1406) | ○ |
| C-15 | Selector は labels.FormatLabels | E-03 (行1405) | ○ |
| C-16 | loadBalancerWidth は 16 | E-07 | ○ |
| C-17 | LB IP は非 wide 時に 16 文字で切り詰め | E-05, E-07 | ○ |
| C-18 | printServiceList は Items を順に委譲 | E-04 | ○ |
| C-19 | Name カラムは Format: "name" | E-01 (行200) | ○ |
| C-20 | Selector の Priority は 1 | E-01 (行206) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: External-IP のタイプ別ロジックはコードに忠実で低リスク
- 0: makePortString のフォーマットはシンプルで低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] serviceColumnDefinitions の 7 カラムが設計書と一致しているか確認
- [ ] getServiceExternalIP の 4 タイプ別ロジックが正しいか確認
- [ ] makePortString の NodePort 分岐が正しいか確認
- [ ] loadBalancerWidth の切り詰めロジックが正しいか確認
