---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **BR-027（クラスタブートストラップ）**：kubeadmの業務要件としての位置付けは推測を含む
  2. **BR-030（kubectl CLIによるクラスタ操作）**：CLIツールを業務要件として分類することの妥当性は要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pkg/controller/deployment/deployment_controller.go` - DeploymentControllerの定義、maxRetries=15、ローリングアップデート/リクリエイト戦略のパッケージコメント
- E-02: `pkg/controller/replicaset/replica_set.go` - ReplicaSetController実装、ReplicationControllerとの共有ロジックのコメント
- E-03: `pkg/controller/statefulset/stateful_set.go` - StatefulSetController実装、history パッケージのインポート
- E-04: `pkg/controller/daemon/daemon_controller.go` - DaemonSetController実装、NodeAffinityインポート
- E-05: `pkg/controller/job/job_controller.go` - JobController実装、DefaultJobPodFailureBackOff/MaxPodCreateDeletePerSync定数
- E-06: `pkg/controller/cronjob/cronjob_controllerv2.go` - CronJobController実装
- E-07: `pkg/scheduler/scheduler.go` - Scheduler構造体、ErrNoNodesAvailable、Extenders、Filterフレームワーク
- E-08: `pkg/controller/podautoscaler/horizontal.go` - HorizontalController実装、autoscaling/v2 APIインポート
- E-09: `pkg/controller/nodelifecycle/node_lifecycle_controller.go` - NodeLifecycleController、Taint設定コメント、LeaseベースハートビートのLeaseインポート
- E-10: `pkg/kubelet/` - Kubeletパッケージ群（eviction, container, probe, config等のサブディレクトリ）
- E-11: `pkg/kubelet/eviction/eviction_manager.go` - EvictionManager実装、ephemeralcontainerfs/ephemeralpodfs/emptydirfsシグナル定数
- E-12: `pkg/controller/resourcequota/resource_quota_controller.go` - ResourceQuotaController実装
- E-13: `pkg/controller/endpointslice/endpointslice_controller.go` - EndpointSliceController実装、topologycacheインポート
- E-14: `pkg/proxy/` - proxyパッケージ（iptables/ipvs/nftablesサブディレクトリ）
- E-15: `pkg/controller/volume/` - Volumeコントローラ群（attachdetach/persistentvolume/expand/pvcprotection/pvprotection）
- E-16: `pkg/controller/serviceaccount/` - ServiceAccountController、TokenController、LegacyServiceAccountTokenCleaner
- E-17: `pkg/controller/certificates/` - CertificateController、approver/signer/rootcacertpublisher/clustertrustbundlepublisher
- E-18: `pkg/registry/rbac/` - RBAC APIグループのレジストリ実装
- E-19: `pkg/apis/abac/` - ABACポリシーAPI定義
- E-20: `pkg/controller/clusterroleaggregation/` - ClusterRoleAggregationController
- E-21: `plugin/pkg/admission/` - ビルトインAdmissionプラグイン群
- E-22: `pkg/controller/namespace/namespace_controller.go` - NamespaceController実装
- E-23: `pkg/controller/garbagecollector/garbagecollector.go` - GarbageCollector実装、graph_builder.go
- E-24: `pkg/controller/disruption/disruption.go` - DisruptionController実装
- E-25: `pkg/controller/ttl/` および `pkg/controller/ttlafterfinished/` - TTLコントローラ群
- E-26: `pkg/controller/podgc/` - PodGCController
- E-27: `pkg/controller/storageversiongc/` および `pkg/controller/storageversionmigrator/` - StorageVersionコントローラ群
- E-28: `pkg/registry/` - 全APIグループのレジストリ実装（apps/batch/core/networking/rbac等）
- E-29: `pkg/controller/servicecidrs/` - ServiceCIDRコントローラ
- E-30: `pkg/controller/validatingadmissionpolicystatus/` - ValidatingAdmissionPolicyステータスコントローラ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001: Deploymentによるローリングアップデート・リクリエイト戦略でのデプロイ管理 | E-01 | ○ |
| C-02 | BR-002: ReplicaSetによるPodレプリカ数維持、adopt/releaseによる所有権管理 | E-02 | ○ |
| C-03 | BR-003: StatefulSetによる順序付きPod管理、ControllerRevisionによる履歴管理 | E-03 | ○ |
| C-04 | BR-004: DaemonSetによる全ノードへのPod配置、NodeAffinityフィルタリング | E-04 | ○ |
| C-05 | BR-005: Jobによるバッチジョブ実行、Pod障害バックオフ制御 | E-05 | ○ |
| C-06 | BR-006: CronJobによる定期ジョブスケジューリング、同時実行ポリシー制御 | E-06 | ○ |
| C-07 | BR-007: Filter/Score/BindフェーズによるPodスケジューリング | E-07 | ○ |
| C-08 | BR-008: HPAによるメトリクスベースのPod自動スケーリング | E-08 | ○ |
| C-09 | BR-009: ノード健全性監視、Taint付与、Leaseベースハートビート検知 | E-09 | ○ |
| C-10 | BR-010: Kubeletによるノード上のPod実行管理、CRI連携 | E-10 | ○ |
| C-11 | BR-011: QoSクラスに基づくリソースエビクション | E-11 | ○ |
| C-12 | BR-012: ResourceQuotaによるNamespace単位のリソース使用量制限 | E-12 | ○ |
| C-13 | BR-013: EndpointSliceによるサービスディスカバリ、トポロジキャッシュ最適化 | E-13 | ○ |
| C-14 | BR-014: kube-proxyによるiptables/ipvs/nftablesベースのサービスルーティング | E-14 | ○ |
| C-15 | BR-015: PV/PVCの自動バインディング・プロビジョニング・リサイズ | E-15 | ○ |
| C-16 | BR-016: Finalizerによる使用中PVC/PVの保護 | E-15 | ○ |
| C-17 | BR-017: ServiceAccountの自動作成、トークン管理、レガシートークンクリーンアップ | E-16 | ○ |
| C-18 | BR-018: CSRの自動承認・署名、ルートCA証明書配布、ClusterTrustBundle管理 | E-17 | ○ |
| C-19 | BR-019: RBAC/ABACによるアクセス制御、ClusterRole自動集約 | E-18, E-19, E-20 | ○ |
| C-20 | BR-020: Validating/Mutating WebhookおよびビルトインAdmissionプラグインによるリクエスト検証・変更 | E-21, E-30 | ○ |
| C-21 | BR-021: Namespace削除時のカスケード削除 | E-22 | ○ |
| C-22 | BR-022: OwnerReferenceに基づく依存リソースのカスケード削除 | E-23 | ○ |
| C-23 | BR-023: PDBに基づく自発的Pod中断時の可用性保証 | E-24 | ○ |
| C-24 | BR-024: 完了Jobの自動削除（TTL After Finished）、ノードTTL管理 | E-25 | ○ |
| C-25 | BR-025: 終了済みPodおよび孤立Podの自動削除 | E-26 | ○ |
| C-26 | BR-026: APIサーバーストレージバージョンの追跡・マイグレーション | E-27 | ○ |
| C-27 | BR-027: kubeadmによるクラスタ初期化・ノード参加・証明書管理 | **根拠なし** | △ |
| C-28 | BR-028: 全Kubernetesリソースに対するRESTful API、バリデーション、デフォルト値設定 | E-28 | ○ |
| C-29 | BR-029: Service IPアドレス範囲の管理・割り当て | E-29 | ○ |
| C-30 | BR-030: kubectlによるリソースCRUD、ログ参照、ポートフォワード、exec | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- BR-027（kubeadmによるクラスタブートストラップ）：cmd/kubeadm/のコードを詳細に解析していないため、具体的な業務フローの根拠が不足している。kubeadmはKubernetes本体のコントローラではなくCLIツールであり、業務要件としての分類が適切かは要検討。
  - 候補：cmd/kubeadm/app/ / cmd/kubeadm/app/phases/ / docs/
- BR-030（kubectl CLIによるクラスタ操作）：pkg/kubectl/およびcmd/kubectl/のコードを網羅的に解析していないため、具体的な機能一覧の根拠が不足している。CLIツールを業務要件として定義することの妥当性は別途検討が必要。
  - 候補：cmd/kubectl/kubectl.go / pkg/kubectl/ / staging/src/k8s.io/kubectl/

## 5) リスクフラグ（レビュー観点）
- 0: Kubernetesはインフラストラクチャソフトウェアであり、一般的な業務アプリケーションとは異なるため、「業務要件」の定義をコンテナオーケストレーションの運用要件として解釈している。この解釈が要件定義の目的と合致するか確認が必要。
- 1: 一部のコントローラ（StorageVersion GC, ServiceCIDR等）はアルファ/ベータ機能である可能性があり、プロダクション環境での安定性に注意が必要。
- 1: Dynamic Resource Allocation（pkg/controller/resourceclaim/）やDevice Taint Eviction（pkg/controller/devicetainteviction/）等の新しい機能が業務要件一覧に含まれていない可能性がある。

## 6) レビュアーチェックリスト（最小）
- [ ] Kubernetesの「業務要件」の定義・粒度が、レビュー目的に合致しているか
- [ ] 各業務要件のカテゴリ分類が適切か（特にワークロード管理とバッチ処理の境界）
- [ ] 優先度の設定が運用環境の要件と整合しているか
- [ ] BR-027（kubeadm）およびBR-030（kubectl）を業務要件として含めることが適切か
- [ ] Dynamic Resource Allocation等の新機能を業務要件として追加する必要があるか
- [ ] 各業務要件の「概要」がコードの実装と整合しているか
