---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 160
  claims_with_evidence: 155
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：155 / 160、根拠なし：5
- 優先レビュー（高）
  1. **C-140（DNS）**：クラスター内DNS機能はCoreDNS等の外部コンポーネントが主体であり、本プロジェクト内のコードだけでは根拠が不十分
  2. **C-135（Imageボリューム）**：pkg/volume/image ディレクトリの存在は確認したが、比較的新しい機能であり説明の正確性は要確認
  3. **C-48（GangSchedulingプラグイン）**：比較的新しい機能であり、ディレクトリの存在は確認したが詳細な動作説明の正確性は要確認
  4. **C-159（External JWT）**：staging配下のディレクトリ存在は確認したが、機能の詳細説明は推測を含む
  5. **C-160（KMS暗号化プロバイダー）**：staging配下のディレクトリ存在は確認したが、機能説明の一部は一般的知識に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `cmd/kube-apiserver` - API Serverメインエントリポイント
- E-02: `cmd/kube-controller-manager` - Controller Managerメインエントリポイント
- E-03: `cmd/kube-scheduler` - Schedulerメインエントリポイント
- E-04: `cmd/kubelet` - Kubeletメインエントリポイント
- E-05: `cmd/kube-proxy` - kube-proxyメインエントリポイント
- E-06: `cmd/kubeadm` - kubeadmメインエントリポイント
- E-07: `cmd/cloud-controller-manager` - Cloud Controller Managerエントリポイント
- E-08: `cmd/kubectl` - kubectlメインエントリポイント
- E-09: `cmd/kubectl-convert` - kubectl-convertエントリポイント
- E-10: `pkg/controlplane/` - コントロールプレーン実装
- E-11: `pkg/controller/deployment` - Deploymentコントローラー
- E-12: `pkg/controller/replicaset` - ReplicaSetコントローラー
- E-13: `pkg/controller/statefulset` - StatefulSetコントローラー
- E-14: `pkg/controller/daemon` - DaemonSetコントローラー
- E-15: `pkg/controller/job` - Jobコントローラー
- E-16: `pkg/controller/cronjob` - CronJobコントローラー
- E-17: `pkg/controller/namespace` - Namespaceコントローラー
- E-18: `pkg/controller/serviceaccount` - ServiceAccountコントローラー
- E-19: `pkg/controller/endpoint` - Endpointコントローラー
- E-20: `pkg/controller/endpointslice` - EndpointSliceコントローラー
- E-21: `pkg/controller/nodeipam` - Node IPAMコントローラー
- E-22: `pkg/controller/nodelifecycle` - Node Lifecycleコントローラー
- E-23: `pkg/controller/ttl` - TTLコントローラー
- E-24: `pkg/controller/ttlafterfinished` - TTL After Finishedコントローラー
- E-25: `pkg/controller/garbagecollector` - Garbage Collectorコントローラー
- E-26: `pkg/controller/resourcequota` - ResourceQuotaコントローラー
- E-27: `pkg/controller/podautoscaler` - HPAコントローラー
- E-28: `pkg/controller/podgc` - Pod GCコントローラー
- E-29: `pkg/controller/disruption` - Disruptionコントローラー
- E-30: `pkg/controller/certificates` - Certificate署名コントローラー
- E-31: `pkg/controller/clusterroleaggregation` - ClusterRoleAggregationコントローラー
- E-32: `pkg/controller/storageversiongc` - StorageVersionGCコントローラー
- E-33: `pkg/controller/storageversionmigrator` - StorageVersionMigratorコントローラー
- E-34: `pkg/controller/resourceclaim` - ResourceClaimコントローラー
- E-35: `pkg/controller/servicecidrs` - ServiceCIDRsコントローラー
- E-36: `pkg/controller/tainteviction` - Taint Evictionコントローラー
- E-37: `pkg/controller/devicetainteviction` - Device Taint Evictionコントローラー
- E-38: `pkg/controller/replication` - Replicationコントローラー
- E-39: `pkg/controller/bootstrap` - Bootstrapコントローラー
- E-40: `pkg/controller/validatingadmissionpolicystatus` - ValidatingAdmissionPolicy Statusコントローラー
- E-41: `pkg/controller/volume` - Volume関連コントローラー
- E-42: `pkg/scheduler/` - スケジューラーコア
- E-43: `pkg/scheduler/framework/` - スケジューラーフレームワーク
- E-44: `pkg/scheduler/framework/plugins/` - スケジューラープラグイン群
- E-45: `pkg/kubelet/` - Kubelet実装ディレクトリ
- E-46: `pkg/kubelet/kuberuntime` - コンテナランタイム管理
- E-47: `pkg/kubelet/images` - イメージ管理
- E-48: `pkg/kubelet/prober` - プローブ実装
- E-49: `pkg/kubelet/cm/` - コンテナマネージャ（CPU、メモリ、デバイス、DRA）
- E-50: `pkg/kubelet/volumemanager` - ボリュームマネージャ
- E-51: `pkg/kubelet/eviction` - Eviction管理
- E-52: `pkg/kubelet/nodeshutdown` - ノードシャットダウン管理
- E-53: `pkg/kubelet/pleg` - PLEG
- E-54: `pkg/kubelet/status` - ステータス管理
- E-55: `pkg/kubelet/server` - Kubelet APIサーバー
- E-56: `pkg/kubelet/pluginmanager` - プラグインマネージャ
- E-57: `pkg/kubelet/stats` - 統計情報収集
- E-58: `pkg/kubelet/certificate` - 証明書管理
- E-59: `pkg/kubelet/logs` - ログ管理
- E-60: `pkg/kubelet/configmap` - ConfigMap配信
- E-61: `pkg/kubelet/secret` - Secret配信
- E-62: `pkg/kubelet/userns` - ユーザー名前空間管理
- E-63: `pkg/kubelet/preemption` - Preemption管理
- E-64: `pkg/kubelet/sysctl` - Sysctl管理
- E-65: `pkg/kubelet/lifecycle` - ライフサイクル管理
- E-66: `pkg/kubelet/qos` - QoS管理
- E-67: `pkg/kubelet/runtimeclass` - RuntimeClass管理
- E-68: `pkg/proxy/iptables` - iptablesプロキシ
- E-69: `pkg/proxy/ipvs` - IPVSプロキシ
- E-70: `pkg/proxy/nftables` - nftablesプロキシ
- E-71: `pkg/proxy/healthcheck` - プロキシヘルスチェック
- E-72: `pkg/proxy/conntrack` - Conntrack管理
- E-73: `pkg/proxy/topology.go` - トポロジールーティング
- E-74: `staging/src/k8s.io/kubectl/pkg/cmd/` - kubectlコマンド群
- E-75: `pkg/volume/` - ボリュームプラグイン群
- E-76: `pkg/registry/` - APIリソースレジストリ群
- E-77: `staging/src/k8s.io/apiextensions-apiserver` - CRD拡張
- E-78: `staging/src/k8s.io/kube-aggregator` - API Aggregation
- E-79: `staging/src/k8s.io/client-go` - Goクライアントライブラリ
- E-80: `staging/src/k8s.io/apimachinery` - API基盤ライブラリ
- E-81: `staging/src/k8s.io/component-base` - コンポーネント基盤
- E-82: `staging/src/k8s.io/cri-api` - CRI API定義
- E-83: `staging/src/k8s.io/cri-client` - CRIクライアント
- E-84: `staging/src/k8s.io/dynamic-resource-allocation` - DRA
- E-85: `staging/src/k8s.io/pod-security-admission` - Pod Security Admission
- E-86: `staging/src/k8s.io/metrics` - メトリクスAPI
- E-87: `staging/src/k8s.io/code-generator` - コード生成
- E-88: `staging/src/k8s.io/cloud-provider` - クラウドプロバイダー
- E-89: `staging/src/k8s.io/externaljwt` - 外部JWT
- E-90: `staging/src/k8s.io/kms` - KMS
- E-91: `test/` - テストフレームワーク
- E-92: `build/` - ビルドシステム
- E-93: `hack/` - 開発ユーティリティ
- E-94: `Makefile` - メインMakefile
- E-95: `pkg/auth/authorizer` - 認可実装
- E-96: `pkg/securitycontext` - SecurityContext管理
- E-97: `pkg/security` - セキュリティ関連
- E-98: `api/openapi-spec` - OpenAPI仕様
- E-99: `pkg/registry/flowcontrol` - フローコントロール
- E-100: `pkg/registry/scheduling` - スケジューリング
- E-101: `pkg/registry/rbac` - RBAC
- E-102: `pkg/registry/coordination` - Coordination

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | API Serverコア | E-01, E-10 | ○ |
| C-02 | 認証（Authentication） | E-01（staging/apiserver/pkg/authentication） | ○ |
| C-03 | 認可（Authorization） | E-95, E-101 | ○ |
| C-04 | アドミッション制御 | E-76（admissionregistration） | ○ |
| C-05 | API拡張（CRD/Aggregation） | E-77, E-78 | ○ |
| C-06 | OpenAPI仕様公開 | E-98 | ○ |
| C-07 | Deploymentコントローラー | E-11 | ○ |
| C-08 | ReplicaSetコントローラー | E-12 | ○ |
| C-09 | StatefulSetコントローラー | E-13 | ○ |
| C-10 | DaemonSetコントローラー | E-14 | ○ |
| C-11 | Jobコントローラー | E-15 | ○ |
| C-12 | CronJobコントローラー | E-16 | ○ |
| C-13 | Namespaceコントローラー | E-17 | ○ |
| C-14 | ServiceAccountコントローラー | E-18 | ○ |
| C-15 | Endpointコントローラー | E-19 | ○ |
| C-16 | EndpointSliceコントローラー | E-20 | ○ |
| C-17 | Node IPAMコントローラー | E-21 | ○ |
| C-18 | Node Lifecycleコントローラー | E-22 | ○ |
| C-19 | TTLコントローラー | E-23 | ○ |
| C-20 | TTL After Finishedコントローラー | E-24 | ○ |
| C-21 | Garbage Collectorコントローラー | E-25 | ○ |
| C-22 | ResourceQuotaコントローラー | E-26 | ○ |
| C-23 | HPAコントローラー | E-27 | ○ |
| C-24 | PodGCコントローラー | E-28 | ○ |
| C-25 | Disruption Budgetコントローラー | E-29 | ○ |
| C-26 | Certificate署名コントローラー | E-30 | ○ |
| C-27 | ClusterRoleAggregationコントローラー | E-31 | ○ |
| C-28 | StorageVersionGCコントローラー | E-32 | ○ |
| C-29 | StorageVersionMigratorコントローラー | E-33 | ○ |
| C-30 | ResourceClaimコントローラー | E-34 | ○ |
| C-31 | ServiceCIDRsコントローラー | E-35 | ○ |
| C-32 | Taint Evictionコントローラー | E-36 | ○ |
| C-33 | Device Taint Evictionコントローラー | E-37 | ○ |
| C-34 | Replicationコントローラー | E-38 | ○ |
| C-35 | Bootstrapコントローラー | E-39 | ○ |
| C-36 | ValidatingAdmissionPolicy Statusコントローラー | E-40 | ○ |
| C-37 | Volume関連コントローラー | E-41 | ○ |
| C-38 | Podスケジューリング | E-42 | ○ |
| C-39 | スケジューラーフレームワーク | E-43 | ○ |
| C-40 | NodeAffinityプラグイン | E-44 | ○ |
| C-41 | NodeResourcesプラグイン | E-44 | ○ |
| C-42 | InterPodAffinityプラグイン | E-44 | ○ |
| C-43 | TaintTolerationプラグイン | E-44 | ○ |
| C-44 | VolumeBindingプラグイン | E-44 | ○ |
| C-45 | PodTopologySpreadプラグイン | E-44 | ○ |
| C-46 | Preemptionプラグイン | E-44 | ○ |
| C-47 | DynamicResourcesプラグイン | E-44 | ○ |
| C-48 | GangSchedulingプラグイン | E-44 | △ |
| C-49 | Podライフサイクル管理 | E-45 | ○ |
| C-50 | コンテナランタイム管理 | E-46 | ○ |
| C-51 | イメージ管理 | E-47 | ○ |
| C-52 | ノードステータス管理 | E-45 | ○ |
| C-53 | ヘルスチェック（Probe） | E-48 | ○ |
| C-54 | リソース管理（CPU/メモリ） | E-49 | ○ |
| C-55 | デバイス管理 | E-49 | ○ |
| C-56 | DRA（Kubelet側） | E-49 | ○ |
| C-57 | ボリューム管理 | E-50 | ○ |
| C-58 | Eviction管理 | E-51 | ○ |
| C-59 | ノードシャットダウン管理 | E-52 | ○ |
| C-60 | PLEG | E-53 | ○ |
| C-61 | ステータス管理 | E-54 | ○ |
| C-62 | ログ管理 | E-59 | ○ |
| C-63 | 統計情報収集 | E-57 | ○ |
| C-64 | 証明書管理 | E-58 | ○ |
| C-65 | ConfigMap/Secret配信 | E-60, E-61 | ○ |
| C-66 | Kubelet API Server | E-55 | ○ |
| C-67 | プラグイン管理 | E-56 | ○ |
| C-68 | ユーザー名前空間管理 | E-62 | ○ |
| C-69 | Preemption管理 | E-63 | ○ |
| C-70 | Sysctl管理 | E-64 | ○ |
| C-71 | Pod Admission制御 | E-65 | ○ |
| C-72 | QoS管理 | E-66 | ○ |
| C-73 | RuntimeClass管理 | E-67 | ○ |
| C-74 | Serviceプロキシ（iptables） | E-68 | ○ |
| C-75 | Serviceプロキシ（IPVS） | E-69 | ○ |
| C-76 | Serviceプロキシ（nftables） | E-70 | ○ |
| C-77 | ヘルスチェック（proxy） | E-71 | ○ |
| C-78 | Conntrack管理 | E-72 | ○ |
| C-79 | トポロジー対応ルーティング | E-73 | ○ |
| C-80〜C-117 | kubectlコマンド群（get, create, apply, delete等） | E-74 | ○ |
| C-118〜C-121 | kubeadm機能群 | E-06 | ○ |
| C-122〜C-135 | ボリュームプラグイン群 | E-75 | ○ |
| C-135 | Imageボリューム | E-75 | △ |
| C-136 | ResourceQuota管理 | E-76 | ○ |
| C-137 | LimitRange管理 | E-76 | ○ |
| C-138 | Pod Security Admission | E-85 | ○ |
| C-139 | Service管理 | E-76 | ○ |
| C-140 | DNS | **根拠なし** | △ |
| C-141 | PersistentVolume管理 | E-76 | ○ |
| C-142 | PersistentVolumeClaim管理 | E-76 | ○ |
| C-143 | Cloud Controller Manager | E-07, E-88 | ○ |
| C-144 | client-go | E-79 | ○ |
| C-145 | apimachinery | E-80 | ○ |
| C-146 | component-base | E-81 | ○ |
| C-147 | CRI API定義 | E-82 | ○ |
| C-148 | CRIクライアント | E-83 | ○ |
| C-149 | Dynamic Resource Allocation | E-84 | ○ |
| C-150 | SecurityContext管理 | E-96, E-97 | ○ |
| C-151 | メトリクスサーバー連携 | E-86 | ○ |
| C-152 | code-generator | E-87 | ○ |
| C-153 | E2Eテストフレームワーク | E-91 | ○ |
| C-154 | ビルドシステム | E-92, E-93, E-94 | ○ |
| C-155 | API Priority and Fairness | E-99 | ○ |
| C-156 | PriorityClass管理 | E-100 | ○ |
| C-157 | RBAC管理 | E-101 | ○ |
| C-158 | リース管理 | E-102 | ○ |
| C-159 | 外部JWT署名 | E-89 | △ |
| C-160 | 暗号化プロバイダー | E-90 | △ |

## 4) 不足情報（Unknown / Missing）
- **DNS（C-140）**：Kubernetesクラスター内のDNS機能はCoreDNS（外部コンポーネント）に依存しており、本リポジトリ内にはDNSサーバー実装は含まれない。Serviceリソースの管理コードから間接的に推測した記述である。
  - 候補：CoreDNSリポジトリ / KubernetesドキュメントのDNS仕様 / staging/src/k8s.io/client-go内のDNS関連ユーティリティ
- **Imageボリューム（C-135）**：pkg/volume/image ディレクトリは存在するが、比較的新しい機能であり、ソースコードの詳細確認が十分でない。
  - 候補：pkg/volume/image 内のソースコード / Kubernetes Enhancement Proposals (KEP)
- **GangScheduling（C-48）**：ディレクトリの存在は確認したが、Alpha段階の機能である可能性があり、説明の正確性は要確認。
  - 候補：pkg/scheduler/framework/plugins/gangscheduling 内のソースコード / KEP
- **External JWT（C-159）**：staging配下にディレクトリが存在するが、機能の詳細は一般的知識に基づく記述。
  - 候補：staging/src/k8s.io/externaljwt 内のソースコード / KEP
- **KMS（C-160）**：staging配下にディレクトリが存在するが、暗号化プロバイダーとしての説明は一般的知識に基づく。
  - 候補：staging/src/k8s.io/kms 内のソースコード / Kubernetesドキュメントの暗号化設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分の機能（C-01〜C-37, C-38〜C-47, C-49〜C-79, C-80〜C-134, C-136〜C-139, C-141〜C-158）- ディレクトリ構造およびファイル名から機能の存在と概要が明確に確認できる
- **1（中リスク）**: C-48（GangScheduling）、C-135（Imageボリューム）、C-159（External JWT）、C-160（KMS） - ディレクトリは存在するが、機能の詳細説明には推測を含む可能性がある
- **2（高リスク）**: C-140（DNS）- 本リポジトリ内に直接のDNS実装コードがなく、外部コンポーネント依存の機能を含めるべきかの判断が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 全160件の機能が適切なカテゴリに分類されているか確認
- [ ] 各機能の説明が対応するソースコードディレクトリの実装と整合しているか確認
- [ ] DNS（C-140）を機能一覧に含めるべきか（外部コンポーネント依存のため）判断
- [ ] GangScheduling（C-48）の機能説明が実装と一致しているか確認
- [ ] Imageボリューム（C-135）の機能説明が実装と一致しているか確認
- [ ] External JWT（C-159）およびKMS（C-160）の機能説明の正確性を確認
- [ ] Kubernetesのバージョンに依存する機能（Alpha/Beta/GA）のステータスが考慮されているか確認
- [ ] 機能の粒度が一貫しているか確認（例：kubectlコマンド個別 vs コントローラー単位）
- [ ] 重要な機能が漏れていないか確認（例：admission webhook、network policy等）
