# 機能設計書 1-API Serverコア

## 概要

本ドキュメントは、Kubernetes API Serverのコア機能に関する機能設計書である。API Serverはクラスターの中心的コンポーネントであり、全てのリソース操作のエントリーポイントとして機能する。

### 本機能の処理概要

API Serverコアは、Kubernetes APIのRESTエンドポイントを提供し、クライアントからのHTTPリクエストを受け付けて、認証・認可・アドミッション制御を経てリソースの永続化（etcdへの保存）を行う中心的コンポーネントである。

**業務上の目的・背景**：Kubernetesクラスターの全てのコンポーネント（kubectl、コントローラー、スケジューラー、Kubelet等）は、API Serverを経由してリソースの操作を行う。API Serverは「クラスターの真実の源泉（Single Source of Truth）」として機能し、宣言的なリソース管理を可能にする。API Serverが存在しなければ、クラスター内のコンポーネント間の通信やリソース管理は不可能となる。

**機能の利用シーン**：全てのKubernetes操作がこの機能を利用する。具体的には、kubectlコマンドの実行、コントローラーによるリコンシリエーション、スケジューラーによるPodの割り当て、Kubeletによるステータス報告など、あらゆるリソースのCRUD操作時にAPI Serverが介在する。

**主要な処理内容**：
1. HTTPリクエストの受信とルーティング（RESTハンドラへの振り分け）
2. 認証チェーン（Authentication Chain）によるリクエスト送信者の特定
3. 認可チェーン（Authorization Chain）によるアクセス許可の判定
4. アドミッション制御（Mutating/Validating）によるリソースの検証・変換
5. etcdストレージへのリソースの永続化（CRUD操作）
6. Watchメカニズムによるリソース変更の通知
7. APIグループ・バージョンの管理とAPIディスカバリ
8. "kubernetes" Serviceエンドポイントの維持管理

**関連システム・外部連携**：etcd（永続化ストレージ）、Webhook（認証・認可・アドミッション）、API Aggregation Layer（拡張APIサーバー）、各種コントローラー、スケジューラー、Kubelet

**権限による制御**：RBAC、ABAC、Webhook等の認可モードにより、ユーザーやサービスアカウントごとにアクセス可能なリソースと操作が制限される。匿名アクセスの有効/無効も設定可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | kubectl create | API連携 | リソース作成リクエストをAPI Serverに送信しRESTエンドポイントを介して永続化する |
| 2 | kubectl expose | API連携 | Serviceリソース作成リクエストをAPI Serverに送信する |
| 3 | kubectl run | API連携 | Pod作成リクエストをAPI Serverに送信する |
| 4 | kubectl set | API連携 | リソースフィールド更新リクエストをAPI Serverに送信する |
| 6 | kubectl get | API連携 | リソース取得リクエストをAPI Serverに送信しレスポンスを受信する |
| 7 | kubectl edit | API連携 | 編集済みリソースの更新リクエストをAPI Serverに送信する |
| 8 | kubectl delete | API連携 | リソース削除リクエストをAPI Serverに送信する |
| 13 | kubectl cluster-info | API連携 | クラスター情報取得のためAPI Serverにリクエストを送信する |
| 24 | kubectl proxy | API連携 | プロキシ経由で全てのAPI Serverリクエストを中継する |
| 40 | kubectl version | API連携 | サーバーバージョン取得のためAPI Serverにリクエストを送信する |

## 機能種別

CRUD操作 / API基盤サービス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| HTTP Method | string | Yes | GET/POST/PUT/PATCH/DELETE | 有効なHTTPメソッドであること |
| API Path | string | Yes | /api/v1/..., /apis/... 等のリソースパス | 有効なAPIグループ・バージョン・リソースであること |
| Request Body | JSON/YAML | No | リソースマニフェスト（POST/PUT/PATCH時） | スキーマバリデーション |
| Authorization Header | string | Yes | Bearer token, client certificate等 | 認証チェーン通過 |
| Content-Type | string | No | application/json, application/yaml等 | サポートされるContent-Type |
| fieldManager | string | No | Server-Side Apply時のフィールドマネージャー名 | 128文字以内 |
| dryRun | string | No | All指定でドライラン実行 | "All"のみ有効 |

### 入力データソース

HTTPリクエスト（kubectl、client-go、その他HTTPクライアント）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| APIリソース | JSON/YAML | 要求されたリソースオブジェクト |
| Status | object | エラー時のStatusオブジェクト |
| HTTP Status Code | int | 200, 201, 204, 400, 401, 403, 404, 409, 422等 |
| Watch Event | JSON | Watchリクエスト時のイベントストリーム（ADDED, MODIFIED, DELETED） |

### 出力先

HTTPレスポンス、Watch Event Stream

## 処理フロー

### 処理シーケンス

```
1. HTTPリクエスト受信
   └─ GenericAPIServerがリクエストを受信しハンドラチェーンに渡す
2. 認証（Authentication）
   └─ 複数の認証方式（x509, token, OIDC等）を順次試行し、ユーザー情報を特定
3. 監査ログ記録
   └─ リクエストの監査イベントを記録
4. 認可（Authorization）
   └─ RBAC/ABAC/Webhook等の認可モードでアクセス許可を判定
5. アドミッション制御（Mutating）
   └─ MutatingAdmissionWebhookおよびビルトインプラグインによるリソース変換
6. オブジェクトスキーマバリデーション
   └─ リソースのスキーマに基づくバリデーション
7. アドミッション制御（Validating）
   └─ ValidatingAdmissionWebhookおよびビルトインプラグインによる検証
8. etcdストレージ操作
   └─ リソースの永続化（Create/Update/Delete）またはリスト/取得
9. レスポンス返却
   └─ シリアライズしてHTTPレスポンスとして返却
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B[認証]
    B -->|失敗| Z1[401 Unauthorized]
    B -->|成功| C[監査ログ記録]
    C --> D[認可]
    D -->|拒否| Z2[403 Forbidden]
    D -->|許可| E{変更操作?}
    E -->|Yes| F[Mutating Admission]
    E -->|No| H[etcd読み取り]
    F --> G[Validating Admission]
    G -->|拒否| Z3[422 Unprocessable]
    G -->|許可| I[etcd書き込み]
    I --> J[レスポンス返却]
    H --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-1 | リソースバージョニング | 全リソースはresourceVersionを持ち、楽観的排他制御に使用 | UPDATE/PATCH操作時 |
| BR-2 | Namespace分離 | Namespace scopedリソースは指定Namespace内でのみ操作可能 | Namespace scopedリソースの全操作 |
| BR-3 | ファイナライザー制御 | Finalizerが設定されたリソースは即時削除されず、DeletionTimestampが設定される | DELETE操作時 |
| BR-4 | カスケード削除 | OwnerReferenceに基づきオーナーリソース削除時に子リソースも削除 | オーナーリソースのDELETE操作時 |
| BR-5 | エンドポイント自動更新 | "kubernetes" Serviceのエンドポイントを定期的にリコンサイル | 10秒間隔（デフォルト） |

### 計算ロジック

リソースバージョンはetcdのModRevisionに基づいて自動的に割り当てられる。楽観的排他制御により、更新時に現在のresourceVersionと一致しない場合はConflictエラー（409）が返却される。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース作成 | etcd | INSERT | リソースオブジェクトをetcdに保存 |
| リソース取得 | etcd | SELECT | etcdからリソースオブジェクトを読み取り |
| リソース更新 | etcd | UPDATE | etcd上のリソースオブジェクトを更新 |
| リソース削除 | etcd | DELETE | etcd上のリソースオブジェクトを削除 |
| リソース一覧 | etcd | SELECT | プレフィックスベースでリソースを一覧取得 |
| リソース監視 | etcd | WATCH | etcdのWatchストリームでリソース変更を監視 |

### テーブル別操作詳細

#### etcd

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | /registry/{group}/{resource}/{namespace}/{name} | シリアライズされたリソースオブジェクト | キーはリソースのAPIグループ・種別・Namespace・名前で構成 |
| SELECT | /registry/{group}/{resource}/... | プレフィックス一致またはキー完全一致 | List操作時はプレフィックス検索 |
| UPDATE | /registry/{group}/{resource}/{namespace}/{name} | 更新されたリソースオブジェクト | resourceVersionによる楽観的排他制御 |
| DELETE | /registry/{group}/{resource}/{namespace}/{name} | - | Finalizerが空の場合のみ物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | BadRequest | リクエストが不正な場合 | リクエスト内容を修正 |
| 401 | Unauthorized | 認証に失敗した場合 | 有効な認証情報を提供 |
| 403 | Forbidden | 認可に失敗した場合 | 適切なRBACロールを付与 |
| 404 | NotFound | リソースが存在しない場合 | リソース名・Namespaceを確認 |
| 409 | Conflict | resourceVersionの不一致 | 最新のリソースを取得して再試行 |
| 422 | Unprocessable | バリデーションまたはアドミッション制御で拒否 | リソースマニフェストを修正 |
| 429 | TooManyRequests | API Priority and Fairnessによるレート制限 | リトライバックオフで再試行 |
| 500 | InternalServerError | サーバー内部エラー | サーバーログを確認 |
| 503 | ServiceUnavailable | etcd到達不能等 | etcdクラスターの状態を確認 |

### リトライ仕様

クライアント側でExponential Backoffによるリトライを推奨。API Priority and Fairnessによる429レスポンスにはRetry-Afterヘッダーが含まれる。

## トランザクション仕様

etcdのトランザクション機能を利用した楽観的排他制御を採用。単一リソースの更新はアトミックに実行される。複数リソースにまたがるトランザクションは提供されない（結果整合性モデル）。

## パフォーマンス要件

- APIリクエストのレイテンシ: 99パーセンタイルで1秒以内（単一リソース操作）
- List操作: 大規模クラスター（5000ノード）で30秒以内
- Watch: 変更検知後1秒以内にイベント配信
- API Priority and Fairnessにより、優先度の高いリクエストが低いリクエストより優先される

## セキュリティ考慮事項

- TLS暗号化（必須）：全てのAPI通信はTLSで暗号化
- 認証：複数方式をサポート（x509クライアント証明書、Bearer Token、OIDC、Webhook等）
- 認可：RBAC（推奨）によるきめ細かいアクセス制御
- 監査ログ：全てのAPIリクエストを監査ログに記録可能
- etcd暗号化：Secretリソース等の機密データをetcd保存時に暗号化可能

## 備考

API Serverは高可用性のために複数インスタンスを起動可能。etcdへのリーダーエレクションは不要（ステートレス設計）だが、"kubernetes" Serviceのエンドポイント管理にはリースベースのリコンサイラーを使用する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

API Serverの設定構造と、リクエスト処理に関わるコア型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | instance.go | `pkg/controlplane/instance.go` | Instance構造体とExtra構造体がAPI Serverの設定を保持する。ServiceIPRange, APIServerServiceIP等のフィールドを確認 |
| 1-2 | config.go | `cmd/kube-apiserver/app/config.go` | サーバーオプションから実行時設定への変換ロジック |

**読解のコツ**: `pkg/controlplane`はKubernetes固有のAPI Server拡張であり、`staging/src/k8s.io/apiserver`の汎用APIサーバーフレームワーク上に構築されている。まず汎用フレームワークの`GenericAPIServer`を理解してからKubernetes固有の拡張を読むとよい。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | apiserver.go | `cmd/kube-apiserver/apiserver.go` | main関数。`app.NewAPIServerCommand()`を呼び出してCobraコマンドを生成 |
| 2-2 | server.go | `cmd/kube-apiserver/app/server.go` | `NewAPIServerCommand()`関数（**70行目**）でCobraコマンドを構成。`RunE`（**93行目**）が実際のサーバー起動処理 |

**主要処理フロー**:
1. **32-35行目**（apiserver.go）: main関数でコマンド生成とCLI実行
2. **70行目**（server.go）: NewAPIServerCommandでCobraコマンド生成
3. **93行目**（server.go）: RunE内でサーバーオプションの検証と起動

#### Step 3: サーバー初期化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | aggregator.go | `cmd/kube-apiserver/app/aggregator.go` | API Aggregation Layerの設定。拡張APIサーバーとの統合 |
| 3-2 | instance.go | `pkg/controlplane/instance.go` | **256行目**: Complete関数でServiceIPRange等のデフォルト値設定。**239行目**: createEndpointReconcilerでエンドポイントリコンサイラー作成 |

#### Step 4: RESTストレージ登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | instance.go | `pkg/controlplane/instance.go` | **87-107行目**: 各APIグループのRESTストレージプロバイダーのインポート。corerest, appsrest, batchrest等 |

### プログラム呼び出し階層図

```
main() [cmd/kube-apiserver/apiserver.go]
    │
    ├─ app.NewAPIServerCommand() [cmd/kube-apiserver/app/server.go]
    │      │
    │      └─ RunE()
    │             │
    │             ├─ Complete() → Config構築
    │             ├─ Validate() → 設定検証
    │             └─ Run()
    │                    │
    │                    ├─ CreateServerChain()
    │                    │      ├─ CreateKubeAPIServerConfig()
    │                    │      ├─ createAPIExtensionsServer() → CRD処理
    │                    │      ├─ CreateKubeAPIServer() → コアAPI処理
    │                    │      └─ createAggregatorServer() → API Aggregation
    │                    │
    │                    └─ PrepareRun() → Run()
    │                           └─ GenericAPIServer.Run()
    │                                  ├─ 認証ハンドラ
    │                                  ├─ 認可ハンドラ
    │                                  ├─ アドミッション制御
    │                                  └─ RESTストレージハンドラ
    │
    └─ cli.Run(command) [component-base/cli]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HTTPリクエスト ──────▶ GenericAPIServer ──────▶ HTTPレスポンス
(kubectl/client-go)    │
                       ├─ Authentication Chain
                       ├─ Audit Logging
                       ├─ Authorization Chain
                       ├─ Admission Control
                       │    ├─ Mutating Webhooks
                       │    └─ Validating Webhooks
                       └─ Storage Backend ──────▶ etcd
                            └─ Watch Stream ──────▶ Informerクライアント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| apiserver.go | `cmd/kube-apiserver/apiserver.go` | ソース | エントリーポイント（main関数） |
| server.go | `cmd/kube-apiserver/app/server.go` | ソース | APIServerコマンド定義と起動ロジック |
| config.go | `cmd/kube-apiserver/app/config.go` | ソース | サーバー設定の構築 |
| aggregator.go | `cmd/kube-apiserver/app/aggregator.go` | ソース | API Aggregation Layer設定 |
| instance.go | `pkg/controlplane/instance.go` | ソース | KubeAPIServerインスタンス定義 |
| import_known_versions.go | `pkg/controlplane/import_known_versions.go` | ソース | 既知のAPIバージョンのインポート |
| rest/ | `pkg/registry/core/rest/` | ソース | コアAPIグループのRESTストレージ |
| options/ | `cmd/kube-apiserver/app/options/` | ソース | コマンドラインオプション定義 |
