# 機能設計書 104-認証情報確認（auth）

## 概要

本ドキュメントは、`kubectl auth` コマンドによる認証・認可情報確認機能の設計を記述する。ユーザーのアクセス権限確認、RBAC設定の調整、自身のユーザー属性確認の3つのサブコマンドを提供する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesクラスターの認可制御において、ユーザーやサービスアカウントが特定の操作を実行できるかを事前確認することは、セキュリティ管理とトラブルシューティングに不可欠である。`kubectl auth` はRBAC認可の確認・調整・自己認証情報の確認を提供する。

**機能の利用シーン**：RBACポリシーの検証、権限不足エラーの調査、サービスアカウントの権限確認、RBAC設定のCI/CDパイプラインでの自動適用・調整、動的認証環境でのユーザー属性確認に利用される。

**主要な処理内容**：
1. `can-i`: SelfSubjectAccessReview APIを使用した権限確認
2. `reconcile`: RBAC Role/RoleBinding/ClusterRole/ClusterRoleBindingの調整
3. `whoami`: SelfSubjectReview APIを使用した自身のユーザー属性確認

**関連システム・外部連携**：Authorization API（SelfSubjectAccessReview, SelfSubjectRulesReview）、Authentication API（SelfSubjectReview）、RBAC API

**権限による制御**：can-i自体には特別な権限不要（SelfSubjectAccessReview使用）、reconcileにはRBACリソースの書き込み権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | kubectl auth can-i | 主機能 | 指定されたアクションが許可されているかを確認 |
| 36 | kubectl auth reconcile | 主機能 | RBACルールの調整を実行 |
| 37 | kubectl auth whoami | 主機能 | 現在のユーザー属性を表示 |

## 機能種別

認証・認可確認

## 入力仕様

### 入力パラメータ（can-i）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| VERB | string | Yes（--list時は不要） | APIバーブ（get/list/create等） | resourceVerbs定義済みバーブ |
| TYPE/NAME | string | Yes（--list時は不要） | リソースタイプまたは非リソースURL | / で始まる場合は非リソースURL |
| --list | bool | No | 全許可アクション一覧表示 | --quiet / --all-namespaces / --subresource と排他 |
| --quiet | bool | No | 出力抑制（終了コードのみ） | --list と排他 |
| -A / --all-namespaces | bool | No | 全Namespace対象 | デフォルト: false |
| --subresource | string | No | サブリソース指定 | 非リソースURLと排他 |
| --no-headers | bool | No | ヘッダー非表示 | --list 指定時のみ有効 |

### 入力パラメータ（reconcile）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -f / --filename | string | Yes | RBAC定義ファイル | ファイルまたはKustomize必須 |
| --remove-extra-permissions | bool | No | 余分なパーミッション削除 | デフォルト: false |
| --remove-extra-subjects | bool | No | 余分なサブジェクト削除 | デフォルト: false |
| --dry-run | string | No | ドライラン実行 | client のみ（server不可） |

### 入力パラメータ（whoami）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -o / --output | string | No | 出力形式 | json/yaml等 |

### 入力データソース

- コマンドライン引数
- RBACマニフェストファイル（reconcile用）
- Authorization API / Authentication API

## 出力仕様

### 出力データ（can-i）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 権限結果 | text | "yes" または "no"（+ 理由） |
| 許可一覧 | table | Resources / Non-Resource URLs / Resource Names / Verbs（--list時） |

### 出力データ（reconcile）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 調整結果 | text | 各リソースの調整操作（create/update/recreate）と詳細 |

### 出力データ（whoami）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ATTRIBUTE | string | Username / UID / Groups / Extra |
| VALUE | string | 各属性の値 |

### 出力先

標準出力（stdout）、can-iの場合終了コード1で権限なし

## 処理フロー

### 処理シーケンス（can-i）

```
1. 引数パース（Verb + Resource/NonResourceURL解析）
   ├─ 2引数: Verb + Resource or NonResourceURL
   └─ --list: 引数なし
2. RESTMapperによるリソース解決
3. 権限チェック
   ├─ [--list] SelfSubjectRulesReview API
   │      └─ printStatus（ルール整理・表示）
   └─ [単一チェック] SelfSubjectAccessReview API
          ├─ ResourceAttributes（リソース指定時）
          └─ NonResourceAttributes（非リソースURL指定時）
4. 結果出力
   ├─ "yes" -> exit 0
   └─ "no" (+ reason, evaluationError) -> exit 1
```

### 処理シーケンス（reconcile）

```
1. RBACマニフェスト読み込み
2. 各リソースに対して調整処理
   ├─ Role -> ReconcileRoleOptions.Run()
   ├─ ClusterRole -> ReconcileRoleOptions.Run()
   ├─ RoleBinding -> ReconcileRoleBindingOptions.Run()
   └─ ClusterRoleBinding -> ReconcileRoleBindingOptions.Run()
3. コンフリクト時は最大3回リトライ
4. 結果出力（create/update/recreate + 不足・余剰の詳細）
```

### 処理シーケンス（whoami）

```
1. SelfSubjectReview API呼び出し（v1 -> v1beta1 -> v1alpha1 フォールバック）
2. ユーザー情報（Username, UID, Groups, Extra）の表示
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-401 | 終了コード | can-i: 許可=0、拒否=1 | can-iサブコマンド |
| BR-402 | リソースVerb一覧 | get/list/watch/create/update/patch/delete/deletecollection/use/bind/impersonate/approve/sign/escalate/attest | can-iリソース指定時 |
| BR-403 | 非リソースVerb一覧 | get/put/post/head/options/delete/patch | can-i非リソースURL指定時 |
| BR-404 | APIフォールバック | whoami: v1 -> v1beta1 -> v1alpha1 の順にフォールバック | whoamiサブコマンド |
| BR-405 | reconcile rbac/v1のみ | v1alpha1/v1beta1のRBACリソースはサポートしない | reconcileサブコマンド |
| BR-406 | コンフリクトリトライ | reconcile実行時のコンフリクトは最大3回リトライ | reconcileサブコマンド |
| BR-407 | opt-out保護 | autoupdateアノテーション=falseの場合、調整操作をログに記録するが実行しない | reconcileサブコマンド |

### 計算ロジック

can-i --list: SelfSubjectRulesReview結果をPolicyRuleに変換し、BreakdownRule + CompactRulesで整理してソート表示する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| can-i | Authorization API | SELECT | SelfSubjectAccessReview/SelfSubjectRulesReview |
| whoami | Authentication API | SELECT | SelfSubjectReview |
| reconcile | RBAC API | SELECT/INSERT/UPDATE | Role/ClusterRole/RoleBinding/ClusterRoleBindingの調整 |

### テーブル別操作詳細

reconcileのみデータ変更あり。--dry-run指定で変更を抑制可能。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Exit 1 | 権限なし | can-i で権限が拒否された | 正常系：終了コード1で終了 |
| - | API未対応 | whoami API が利用できない | "the selfsubjectreviews API is not enabled" |
| - | rbac/v1以外 | reconcile で v1beta1/v1alpha1指定 | "only rbac.authorization.k8s.io/v1 is supported" |
| - | server-side dry-run不可 | reconcile で --dry-run=server | "dry-run=server is not supported yet" |
| - | 未知リソース | can-i で未知のリソースタイプ | Warning出力（処理は続行） |
| - | 未知Verb | can-i で未知のバーブ | Warning出力（処理は続行） |

### リトライ仕様

reconcile: conflictBackoff{Steps: 3}でコンフリクト時に最大3回リトライ。

## トランザクション仕様

reconcileの各リソース調整は個別に実行される。全体のトランザクション管理は行わない。コンフリクト時はリトライで対応する。

## パフォーマンス要件

特に定義なし。APIコール数はリソース数に依存する。

## セキュリティ考慮事項

- can-iはSelfSubjectAccessReviewを使用するため、自分自身の権限確認に特別な権限は不要
- --as フラグとの組み合わせで他ユーザーの権限を確認可能（impersonate権限が必要）
- reconcileは RBAC リソースの書き込み権限が必要

## 備考

- whoami は Experimental ステータス
- can-i --list の結果は不完全な場合がある（status.Incomplete = true）
- 非標準リソース名（users, groups）はimpersonateバーブ用としてサーバー未登録でもWarningを抑制する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cani.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/cani.go` | CanIOptions構造体（49-66行目）：権限確認用オプション |
| 1-2 | reconcile.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/reconcile.go` | ReconcileOptions構造体（46-60行目）：RBAC調整用オプション |
| 1-3 | whoami.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/whoami.go` | WhoAmIOptions構造体（109-119行目）：自身情報確認用オプション |

**読解のコツ**: 各サブコマンドが独立した構造体とComplete/Validate/Runパターンを持つ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auth.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/auth.go` | NewCmdAuth関数（27-41行目）：親コマンドと3サブコマンド登録 |

#### Step 3: can-i処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cani.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/cani.go` | NewCmdCanI関数（114-150行目）：コマンド定義とフラグ |
| 3-2 | cani.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/cani.go` | Complete関数（153-207行目）：引数解析とリソース解決 |
| 3-3 | cani.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/cani.go` | RunAccessCheck関数（267-311行目）：SelfSubjectAccessReview実行 |
| 3-4 | cani.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/cani.go` | RunAccessList関数（252-264行目）：SelfSubjectRulesReview実行 |

**主要処理フロー**:
- **168-174行目**: 2引数のパース（Verb + Resource or NonResourceURL）
- **171行目**: "/" で始まる場合は非リソースURL
- **270-291行目**: ResourceAttributes / NonResourceAttributes の構築

#### Step 4: reconcile処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | reconcile.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/reconcile.go` | RunReconcile関数（201-312行目）：RBAC調整メイン処理 |
| 4-2 | reconcile.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/reconcile.go` | **210-254行目**: Role/ClusterRoleの調整ロジック |
| 4-3 | reconcile.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/reconcile.go` | **256-293行目**: RoleBinding/ClusterRoleBindingの調整ロジック |

#### Step 5: whoami処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | whoami.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/whoami.go` | Run関数（169-201行目）：APIバージョンフォールバック |
| 5-2 | whoami.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/whoami.go` | printTableSelfSubjectAccessReview関数（216-262行目）：テーブル表示 |

**主要処理フロー**:
- **175-188行目**: v1 -> v1beta1 -> v1alpha1 のフォールバックチェーン

### プログラム呼び出し階層図

```
NewCmdAuth
    │
    ├─ NewCmdCanI
    │      ├─ CanIOptions.Complete()
    │      │      └─ resourceFor() [RESTMapperによるリソース解決]
    │      ├─ CanIOptions.Validate()
    │      │      ├─ isNamespaced() [Namespace スコープチェック]
    │      │      └─ isKnownResourceVerb() / isKnownNonResourceVerb()
    │      ├─ CanIOptions.RunAccessList() [--list時]
    │      │      ├─ AuthClient.SelfSubjectRulesReviews().Create()
    │      │      └─ printStatus()
    │      │             ├─ convertToPolicyRule()
    │      │             ├─ rbacutil.BreakdownRule()
    │      │             └─ rbacutil.CompactRules()
    │      └─ CanIOptions.RunAccessCheck() [権限チェック時]
    │             └─ AuthClient.SelfSubjectAccessReviews().Create()
    │
    ├─ NewCmdReconcile
    │      ├─ ReconcileOptions.Complete()
    │      ├─ ReconcileOptions.Validate()
    │      └─ ReconcileOptions.RunReconcile()
    │             ├─ reconciliation.ReconcileRoleOptions.Run()
    │             ├─ reconciliation.ReconcileRoleBindingOptions.Run()
    │             └─ printResults()
    │
    └─ NewCmdWhoAmI
           └─ WhoAmIOptions.Run()
                  ├─ authV1Client.SelfSubjectReviews().Create()
                  ├─ [fallback] authV1beta1Client.SelfSubjectReviews().Create()
                  └─ [fallback] authV1alpha1Client.SelfSubjectReviews().Create()
```

### データフロー図

```
[can-i]
コマンドライン引数 ──▶ Complete() ──▶ SelfSubjectAccessReview API ──▶ "yes/no" ──▶ stdout

[can-i --list]
コマンドライン引数 ──▶ Complete() ──▶ SelfSubjectRulesReview API ──▶ テーブル ──▶ stdout

[reconcile]
マニフェストファイル ──▶ Visitor ──▶ reconciliation.Run() ──▶ RBAC API ──▶ 結果出力

[whoami]
（引数なし） ──▶ SelfSubjectReview API ──▶ UserInfo ──▶ テーブル / JSON / YAML
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| auth.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/auth.go` | ソース | 親コマンド定義 |
| cani.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/cani.go` | ソース | can-iサブコマンド |
| reconcile.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/reconcile.go` | ソース | reconcileサブコマンド |
| whoami.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/whoami.go` | ソース | whoamiサブコマンド |
| cani_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/cani_test.go` | テスト | can-iテスト |
| reconcile_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/reconcile_test.go` | テスト | reconcileテスト |
| whoami_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/whoami_test.go` | テスト | whoamiテスト |
