# 機能設計書 106-設定セット（set）

## 概要

本ドキュメントは、`kubectl set` コマンドによるリソース設定変更機能の設計を記述する。既存リソースのイメージ、環境変数、リソース制限、セレクター、サービスアカウント、サブジェクトを宣言的に変更する6つのサブコマンドを提供する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesリソースの特定フィールドを簡潔に変更するためのユーティリティ群。`kubectl edit` や `kubectl apply` によるフルマニフェスト編集ではなく、特定のフィールド（イメージ名、環境変数、リソース制限等）のみをターゲットにした変更操作を提供する。

**機能の利用シーン**：コンテナイメージのバージョンアップ、環境変数の追加・変更、リソースリクエスト/リミットの設定、サービスアカウントの変更、RoleBindingのサブジェクト更新等に利用される。

**主要な処理内容**：
1. `image`: コンテナイメージの更新
2. `env`: 環境変数の追加・変更・削除
3. `resources`: CPU/メモリのリクエスト/リミット設定
4. `selector`: ラベルセレクターの設定
5. `serviceaccount`: サービスアカウントの設定
6. `subject`: RoleBinding/ClusterRoleBindingのサブジェクト更新

**関連システム・外部連携**：API Server（Strategic Merge Patch）

**権限による制御**：対象リソースのpatch権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | kubectl set image | 主機能 | コンテナイメージの更新 |
| 7 | kubectl set env | 主機能 | 環境変数の設定 |
| 8 | kubectl set resources | 主機能 | リソース制限の設定 |

## 機能種別

リソース設定変更

## 入力仕様

### 入力パラメータ（image）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TYPE NAME | string | Yes | リソースタイプと名前 | ファイルまたはリソース名指定必須 |
| CONTAINER=IMAGE | string[] | Yes | コンテナ名=イメージ名のペア | 1つ以上、*=は全コンテナ |
| --all | bool | No | 全リソース対象 | --selector と排他 |
| --local | bool | No | ローカルのみ（API未使用） | デフォルト: false |
| --dry-run | string | No | ドライラン | client/server |
| -l / --selector | string | No | ラベルセレクター | --all と排他 |

### 入力パラメータ（env）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TYPE NAME | string | Yes | リソースタイプと名前 | |
| KEY=VALUE | string[] | No | 環境変数定義 | KEY-で削除指定 |
| --list | bool | No | 環境変数一覧表示 | |
| --from | string | No | ConfigMap/Secretからの読み込み | |
| --prefix | string | No | 変数名プレフィックス | |

### 入力パラメータ（resources）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TYPE NAME | string | Yes | リソースタイプと名前 | |
| --limits | string | No | リソースリミット | cpu=X,memory=Y 形式 |
| --requests | string | No | リソースリクエスト | cpu=X,memory=Y 形式 |
| -c / --containers | string | No | 対象コンテナ指定 | デフォルト: * |

### 入力データソース

- コマンドライン引数
- マニフェストファイル
- ConfigMap / Secret（env --from 用）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 更新結果 | text | "image updated" / "env updated" 等のステータスメッセージ |

### 出力先

標準出力（stdout）

## 処理フロー

### 処理シーケンス（共通パターン）

```
1. 引数パースとバリデーション（Complete）
   ├─ DryRunStrategy設定
   ├─ ResourceBuilder設定
   └─ Printer初期化
2. バリデーション（Validate）
   └─ --all と --selector の排他チェック等
3. パッチ計算（Run）
   ├─ CalculatePatches()で変更差分を計算
   │   └─ UpdatePodSpecForObject()で変更適用
   ├─ [--local or --dry-run=client] ローカル出力
   └─ [server] Strategic Merge Patchの送信
4. 結果出力
```

### フローチャート（image）

```mermaid
flowchart TD
    A[開始] --> B[引数パース]
    B --> C[リソースとイメージペアの分離]
    C --> D[ResourceBuilder でリソース取得]
    D --> E[CalculatePatches]
    E --> F{各パッチに対して}
    F --> G[UpdatePodSpecForObject]
    G --> H[setImage: コンテナイメージ更新]
    H --> I{変更あり?}
    I -->|No| F
    I -->|Yes, local| J[ローカル出力]
    I -->|Yes, server| K[Strategic Merge Patch送信]
    J --> L[PrintObj]
    K --> L
    L --> F
    F -->|完了| M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-601 | ワイルドカードコンテナ | *=imageで全コンテナのイメージを一括変更 | image サブコマンド |
| BR-602 | ワイルドカード排他 | *指定と個別コンテナ指定は同時不可 | image サブコマンド |
| BR-603 | InitContainerも対象 | imageはspec.initContainersも更新対象 | image サブコマンド |
| BR-604 | env削除 | KEY-形式で環境変数を削除 | env サブコマンド |
| BR-605 | リソース0指定で削除 | --limits=cpu=0 でリミットを削除 | resources サブコマンド |
| BR-606 | ローカルモード排他 | --local と --dry-run=server は同時不可 | 全サブコマンド |
| BR-607 | subject対応リソース | RoleBinding と ClusterRoleBinding のみ | subject サブコマンド |

### 計算ロジック

CalculatePatches: 変更前のオブジェクトをエンコードし、変更を適用後に再エンコードし、その差分をパッチとして計算する。パッチが空JSON("{}")の場合は変更なしとしてスキップ。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース取得 | etcd（API Server経由） | SELECT（GET） | 変更対象リソースの取得 |
| リソース更新 | etcd（API Server経由） | UPDATE（PATCH） | Strategic Merge Patchによる部分更新 |

### テーブル別操作詳細

Strategic Merge Patchを使用するため、変更対象フィールドのみが更新される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | --all と --selector の同時指定 | エラーメッセージ |
| - | コンテナ未発見 | 指定コンテナ名が存在しない | "unable to find container named X" |
| - | イメージ未指定 | CONTAINER=IMAGE ペアが0個 | "at least one image update is required" |
| - | パッチ失敗 | API Serverへのパッチ適用失敗 | "failed to patch image update to pod template" |

### リトライ仕様

特にリトライ処理は実装されていない。コンフリクト時はエラーとなる。

## トランザクション仕様

各リソースの更新は個別にパッチされる。複数リソースの原子的更新は保証されない。

## パフォーマンス要件

特に定義なし。リソース数に比例するAPIコール。

## セキュリティ考慮事項

- 対象リソースのpatch権限が必要
- env --from でConfigMap/Secretの読み取り権限が必要
- ローカルモード（--local）はAPI Serverに接続せずに動作するため、権限なしでのプレビューが可能

## 備考

- image対象リソース: pod, replicationcontroller, deployment, daemonset, statefulset, cronjob, replicaset
- env対象リソース: 同上
- resources対象リソース: 同上
- selector対象リソース: 一般的なリソース全般
- serviceaccount対象リソース: replicationcontroller, deployment, daemonset, job, replicaset, statefulset
- subject対象リソース: rolebinding, clusterrolebinding

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | set_image.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_image.go` | SetImageOptions構造体（44-67行目）：imageサブコマンドオプション |
| 1-2 | set_env.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_env.go` | envサブコマンドの変数定義（46-64行目） |
| 1-3 | set_resources.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_resources.go` | SetResourcesOptions構造体（66-80行目） |

#### Step 2: 親コマンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | set.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set.go` | NewCmdSet関数（37-55行目）：6サブコマンドの登録 |

#### Step 3: image処理の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | set_image.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_image.go` | Run関数（233-303行目）：パッチ計算と適用 |
| 3-2 | set_image.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_image.go` | setImage関数（305-315行目）：コンテナイメージ更新ロジック |
| 3-3 | set_image.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_image.go` | **236行目**: CalculatePatches - 変更差分の計算 |
| 3-4 | set_image.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_image.go` | **248-249行目**: initContainers と Containers 両方を対象 |
| 3-5 | set_image.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_image.go` | **288-293行目**: Strategic Merge Patchの送信 |

### プログラム呼び出し階層図

```
NewCmdSet
    │
    ├─ NewCmdImage
    │      ├─ SetImageOptions.Complete()
    │      │      ├─ getResourcesAndImages()
    │      │      └─ Builder.Do().Infos()
    │      ├─ SetImageOptions.Validate()
    │      └─ SetImageOptions.Run()
    │             ├─ CalculatePatches()
    │             │      └─ UpdatePodSpecForObject()
    │             │             └─ setImage()
    │             └─ NewHelper().Patch() [Strategic Merge Patch]
    │
    ├─ NewCmdResources
    ├─ NewCmdSelector
    ├─ NewCmdSubject
    ├─ NewCmdServiceAccount
    └─ NewCmdEnv
```

### データフロー図

```
[入力]                    [処理]                            [出力]

コマンドライン引数 ──▶ Complete() ──▶ ResourceBuilder
                                          │
API Server ◀── GET ◀──────────────────────┘
       │                                   │
       ▼                                   ▼
   現在のリソース ──▶ CalculatePatches() ──▶ パッチ計算
                              │                  │
                              ▼                  ▼
                   UpdatePodSpecForObject   Strategic Merge Patch
                              │                  │
                              ▼                  ▼
                   変更後リソース ──▶ Patch API ──▶ stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| set.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set.go` | ソース | 親コマンド定義 |
| set_image.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_image.go` | ソース | imageサブコマンド |
| set_env.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_env.go` | ソース | envサブコマンド |
| set_resources.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_resources.go` | ソース | resourcesサブコマンド |
| set_selector.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_selector.go` | ソース | selectorサブコマンド |
| set_serviceaccount.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_serviceaccount.go` | ソース | serviceaccountサブコマンド |
| set_subject.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_subject.go` | ソース | subjectサブコマンド |
| helper.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/helper.go` | ソース | CalculatePatches等のヘルパー関数 |
