# 機能設計書 108-クラスター情報（cluster-info）

## 概要

本ドキュメントは、`kubectl cluster-info` コマンドによるクラスター情報表示機能の設計を記述する。コントロールプレーンとクラスターサービスのアドレス表示、およびデバッグ情報のダンプを提供する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesクラスターの管理において、コントロールプレーンやクラスターサービスのエンドポイント情報を迅速に確認することは、接続問題の診断やクラスター構成の把握に不可欠である。`kubectl cluster-info` はクラスターの基本的な接続情報を表示し、`dump` サブコマンドではデバッグ用の包括的な情報収集を行う。

**機能の利用シーン**：クラスターへの接続確認、コントロールプレーンURLの確認、クラスターサービス（DNS、Dashboard等）のURL確認、障害時のデバッグ情報収集に利用される。

**主要な処理内容**：
1. コントロールプレーンのホストアドレス表示
2. `kubernetes.io/cluster-service=true` ラベルを持つサービスのURL表示
3. `dump` サブコマンドによるクラスター全体のデバッグ情報ダンプ

**関連システム・外部連携**：API Server（クラスター情報、サービス情報）、kube-system Namespaceのサービス

**権限による制御**：サービスの読み取り権限。dumpサブコマンドではイベント、Pod、ログ等の広範な読み取り権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | kubectl cluster-info | 主機能 | コントロールプレーンとクラスターサービスのアドレス表示 |
| 31 | kubectl cluster-info dump | 主機能 | デバッグ情報のダンプ |

## 機能種別

情報表示・診断

## 入力仕様

### 入力パラメータ（cluster-info）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --namespace | string | No | 対象Namespace | デフォルト: kube-system |

### 入力パラメータ（cluster-info dump）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --output-directory | string | No | 出力ディレクトリ | 未指定時は stdout |
| --namespaces | string[] | No | ダンプ対象Namespace | デフォルト: kube-system |
| -A / --all-namespaces | bool | No | 全Namespace対象 | デフォルト: false |
| --pod-running-timeout | duration | No | Pod実行待機タイムアウト | デフォルト: 20秒 |
| -o / --output | string | No | 出力形式 | デフォルト: json |

### 入力データソース

- REST Config（コントロールプレーンホスト情報）
- API Server（サービス一覧、Pod/イベント/ログ情報）

## 出力仕様

### 出力データ（cluster-info）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| コントロールプレーン | text | "Kubernetes control plane is running at <URL>" |
| クラスターサービス | text | "<サービス名> is running at <URL>" |

### 出力データ（dump）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| クラスター情報 | JSON | ノード、イベント、Pod、DaemonSet、Deployment、ReplicaSet情報 |
| Podログ | text | 各PodのログデータN |

### 出力先

cluster-info: 標準出力（stdout）。dump: stdout またはディレクトリ。

## 処理フロー

### 処理シーケンス（cluster-info）

```
1. REST Configからホスト情報取得
2. Namespace設定（デフォルト: kube-system）
3. ResourceBuilder でサービス一覧取得
   └─ LabelSelector: "kubernetes.io/cluster-service=true"
4. コントロールプレーンURL出力
5. 各サービスのURL計算と出力
   ├─ LoadBalancer Ingress がある場合: 直接IP:Port
   └─ ない場合: API Serverプロキシ URL
6. "kubectl cluster-info dump" の案内メッセージ
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[REST Config取得]
    B --> C[kube-system Namespace設定]
    C --> D[cluster-service=true サービス取得]
    D --> E[コントロールプレーンURL出力]
    E --> F{各サービスに対して}
    F --> G{LoadBalancer Ingress?}
    G -->|Yes| H[IP:Port URL出力]
    G -->|No| I[API Proxy URL計算]
    I --> J[URL出力]
    H --> F
    J --> F
    F -->|完了| K[案内メッセージ出力]
    K --> L[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-801 | ラベルセレクター | `kubernetes.io/cluster-service=true` でサービスをフィルタ | 常に適用 |
| BR-802 | Namespace デフォルト | 明示的指定がない場合は kube-system | --namespace 未指定時 |
| BR-803 | サービス名解決 | kubernetes.io/name ラベルがあればそれを使用、なければ ObjectMeta.Name | サービス表示時 |
| BR-804 | HTTPS推定 | ポート名が "https" またはポート番号が 443 の場合 scheme を https とする | Proxy URL計算時 |
| BR-805 | dump デフォルト形式 | JSON形式でダンプ | dump サブコマンド |
| BR-806 | Podログタイムアウト | Pod実行待機のデフォルトタイムアウトは20秒 | dump サブコマンド |

### 計算ロジック

Proxy URL計算: `<host>/api/<version>/namespaces/<ns>/services/<scheme:name:port>/proxy`。scheme:name:port はutilnet.JoinSchemeNamePortで結合。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| サービス取得 | etcd（API Server経由） | SELECT（LIST） | クラスターサービス一覧取得 |
| dump | etcd（API Server経由） | SELECT（LIST/GET） | ノード、Pod、イベント等の包括的取得 |

### テーブル別操作詳細

読み取り専用。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 接続エラー | API Serverに接続できない | REST Config接続エラー |
| - | 権限エラー | サービス読み取り権限なし | 403 Forbidden |

### リトライ仕様

特にリトライ処理は実装されていない。

## トランザクション仕様

読み取り専用の参照処理であり、トランザクション管理は不要。

## パフォーマンス要件

dumpサブコマンドではクラスター全体のリソースとログを収集するため、大規模クラスターでは時間がかかる場合がある。

## セキュリティ考慮事項

- dumpサブコマンドはクラスター内の広範な情報を収集するため、出力ファイルの取り扱いに注意が必要
- Podログに機密情報が含まれている可能性がある

## 備考

- クラスターサービスのURLは、LoadBalancer Ingressがあるかどうかで計算方法が異なる
- dump出力にはノード情報、イベント、各NamespaceのPod/DaemonSet/Deployment/ReplicaSet、およびPodログが含まれる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | ClusterInfoOptions構造体（49-56行目） |
| 1-2 | clusterinfo_dump.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go` | ClusterInfoDumpOptions構造体（49-65行目） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | NewCmdClusterInfo関数（58-75行目）：コマンド定義 |

#### Step 3: cluster-info処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | Complete関数（77-92行目）：REST Config + Namespace設定 |
| 3-2 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | Run関数（94-155行目）：サービス取得と表示 |
| 3-3 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | **96-101行目**: LabelSelector設定と ResourceBuilder |
| 3-4 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | **111-141行目**: LoadBalancer / Proxy URL の分岐計算 |
| 3-5 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | **128-129行目**: https推定ロジック |

### プログラム呼び出し階層図

```
NewCmdClusterInfo
    │
    ├─ ClusterInfoOptions.Complete()
    │      ├─ ToRESTConfig()
    │      └─ Namespace設定（デフォルト: kube-system）
    │
    ├─ ClusterInfoOptions.Run()
    │      ├─ Builder.LabelSelectorParam("kubernetes.io/cluster-service=true")
    │      ├─ Visit()
    │      │      ├─ printService("Kubernetes control plane", host)
    │      │      └─ [各サービス] printService(name, link)
    │      └─ "kubectl cluster-info dump" 案内
    │
    └─ NewCmdClusterInfoDump [dumpサブコマンド]
           ├─ ClusterInfoDumpOptions.Complete()
           ├─ ClusterInfoDumpOptions.Run()
           │      ├─ ノード情報取得
           │      ├─ 各NamespaceのPod/Event/DaemonSet/Deployment/ReplicaSet取得
           │      └─ Podログ取得
           └─ 出力（stdout or ディレクトリ）
```

### データフロー図

```
[cluster-info]
REST Config ──▶ Host URL ──▶ "Kubernetes control plane is running at <URL>"
                                │
API Server ──▶ Services (label=cluster-service) ──▶ URL計算 ──▶ "<Name> is running at <URL>"

[dump]
API Server ──▶ Nodes/Events/Pods/DaemonSets/... ──▶ JSON出力 ──▶ stdout / ディレクトリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | ソース | cluster-info表示 |
| clusterinfo_dump.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go` | ソース | dumpサブコマンド |
| clusterinfo_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_test.go` | テスト | ユニットテスト |
