# 機能設計書 112-kuberc設定

## 概要

本ドキュメントは、kubectlのkuberc設定管理機能（`kubectl kuberc`コマンド）の設計を記述する。kubercファイルによるkubectlのエイリアスとデフォルトフラグ値の管理を提供する。

### 本機能の処理概要

**業務上の目的・背景**：kubectlの使用において、特定のコマンドに毎回同じフラグを指定する手間を省き、ユーザー独自のエイリアスを定義することで作業効率を向上させる。kubercファイル（`kubectl.config.k8s.io/v1beta1` Preference）により、ユーザー固有の設定を宣言的に管理できる。

**機能の利用シーン**：`kubectl get`コマンドのデフォルト出力形式をwideに設定したい場合や、頻繁に使うコマンドの組み合わせをエイリアスとして登録したい場合に使用する。

**主要な処理内容**：
1. `kubectl kuberc view` - 現在のkuberc設定を表示する
2. `kubectl kuberc set --section defaults` - コマンドのデフォルトフラグ値を設定する
3. `kubectl kuberc set --section aliases` - コマンドエイリアスを作成・更新する
4. kubercファイルの読み込み・作成・保存

**関連システム・外部連携**：kubercファイル（YAMLファイル）、KUBERC環境変数による無効化サポート

**権限による制御**：特になし（ローカルファイルシステムの読み書き権限のみ必要）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 44 | kubectl kuberc | 主機能 | kubercファイルによるkubectlのエイリアスとデフォルト設定を管理する主処理 |

## 機能種別

設定管理 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --kuberc | string | No | kubercファイルのパス | ファイルパスの妥当性 |
| --section | string | Yes (set) | 設定セクション（defaults/aliases） | "defaults"または"aliases"のみ |
| --command | string | Yes (set) | 対象コマンド | 空でないこと |
| --name | string | aliases時必須 | エイリアス名 | aliasesセクション時は必須 |
| --option | []string | No | フラグ=値のペア | "flag=value"形式 |
| --prependarg | []string | No | 前置引数（aliases時のみ） | defaultsセクション時は使用不可 |
| --appendarg | []string | No | 後置引数（aliases時のみ） | defaultsセクション時は使用不可 |
| --overwrite | bool | No | 既存エントリの上書き許可 | - |
| -o/--output | string | No (view) | 出力フォーマット（yaml/json） | yaml/json |

### 入力データソース

- kubercファイル（デフォルトまたは--kubercフラグで指定）
- KUBERC環境変数（"off"で無効化）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| kuberc設定内容 | Preference | YAML/JSON形式のkuberc設定 |
| 保存確認メッセージ | string | 設定保存の成功メッセージ |

### 出力先

標準出力（設定表示）、kubercファイル（設定保存）

## 処理フロー

### 処理シーケンス

```
[view コマンド]
1. kubercファイルのパスを解決
   └─ kuberc.LoadKuberc()でファイルパスを取得
2. ファイルの読み込み
   └─ os.ReadFile()でファイル内容を取得
3. ファイルが存在しない場合
   └─ デフォルトkuberc生成を提案（対話的）
4. Preferenceオブジェクトへパース
   └─ yaml.Unmarshal()でデシリアライズ
5. 指定形式で出力
   └─ PrintFlags.ToPrinter()で出力

[set コマンド]
1. kubercファイルのパスを解決
2. 既存設定の読み込みまたは新規作成
   └─ loadOrCreatePreference()
3. オプションのパース
   └─ parseOptions()でflag=value形式を解析
4. セクションに応じた設定更新
   ├─ defaults: setDefaults()
   └─ aliases: setAlias()
5. ファイルへの保存
   └─ kuberc.SavePreference()
```

### フローチャート

```mermaid
flowchart TD
    A[kubectl kuberc] --> B{サブコマンド}
    B -->|view| C[kubercファイルパス解決]
    B -->|set| D[kubercファイルパス解決]
    C --> E[ファイル読み込み]
    E --> F{ファイル存在?}
    F -->|Yes| G[YAML/JSONパース]
    F -->|No| H[デフォルト生成提案]
    G --> I[フォーマット出力]
    D --> J[既存設定読み込み/新規作成]
    J --> K[オプション解析]
    K --> L{セクション}
    L -->|defaults| M[デフォルト値設定]
    L -->|aliases| N[エイリアス設定]
    M --> O[ファイル保存]
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-112-01 | KUBERC無効化 | KUBERC=off環境変数でkuberc機能を無効化できる | KUBERC環境変数がoffの場合 |
| BR-112-02 | 上書き保護 | 既存エントリの上書きには--overwriteフラグが必要 | 同名のdefaults/aliasが存在する場合 |
| BR-112-03 | セクション制約 | --prependarg/--appendargはaliasesセクションでのみ使用可能 | --section=defaults時 |
| BR-112-04 | 名前必須 | --nameはaliasesセクションで必須、defaultsセクションでは使用不可 | セクションに応じて |
| BR-112-05 | APIバージョン | kubercファイルは`kubectl.config.k8s.io/v1beta1` Preferenceフォーマット | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（ローカルファイルベースの設定管理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | KUBERC無効 | KUBERC=off環境変数設定時 | エラーメッセージ表示 |
| - | ファイル読み取りエラー | kubercファイルが読み取れない | エラーメッセージ表示 |
| - | YAML解析エラー | kubercファイルの形式不正 | エラーメッセージ表示 |
| - | 重複エントリ | --overwriteなしで既存エントリを上書き | エラーメッセージ表示 |
| - | 不正オプション形式 | --optionがflag=value形式でない | エラーメッセージ表示 |

### リトライ仕様

リトライなし

## トランザクション仕様

ファイル書き込みはアトミックではないため、書き込み中に中断された場合はファイルが不完全になる可能性がある。

## パフォーマンス要件

ローカルファイルの読み書きのみであり、特段のパフォーマンス要件はない。

## セキュリティ考慮事項

- kubercファイルにはコマンドの引数やフラグが含まれるが、認証情報は含まれない
- ファイルのパーミッション管理はOS側に委ねられる

## 備考

- kuberc機能はKubernetes v1.33時点でベータ機能として提供されている
- kubercファイルのデフォルトパスはOS依存（XDG Base Directory Specificationに準拠）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | kuberc.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/kuberc.go` | NewCmdKubeRC関数（45-59行目）でサブコマンド構造を理解 |
| 1-2 | view.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/view.go` | ViewOptions構造体（51-59行目） |
| 1-3 | set.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/set.go` | SetOptions構造体（71-84行目） |

#### Step 2: viewサブコマンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | view.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/view.go` | Complete(89-102行目) -> Validate(105-111行目) -> Run(114-155行目)の流れ |

#### Step 3: setサブコマンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | set.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/set.go` | Run(168-190行目)、setDefaults(239-263行目)、setAlias(266-314行目) |

### プログラム呼び出し階層図

```
NewCmdKubeRC()
    │
    ├─ NewCmdKubeRCView()
    │      ├─ Complete() → kuberc.LoadKuberc()
    │      ├─ Validate()
    │      └─ Run()
    │             ├─ os.ReadFile()
    │             ├─ yaml.Unmarshal()
    │             └─ printer.PrintObj()
    │
    └─ NewCmdKubeRCSet()
           ├─ Complete() → kuberc.LoadKuberc()
           ├─ Validate()
           └─ Run()
                  ├─ loadOrCreatePreference()
                  ├─ parseOptions()
                  ├─ setDefaults() / setAlias()
                  └─ kuberc.SavePreference()
```

### データフロー図

```
[入力]                    [処理]                          [出力]

kubercファイル ─────▶ LoadKuberc()
                         │
                    yaml.Unmarshal()
                         │
              ┌──────────┴──────────┐
              │                     │
         [view]                [set]
              │                     │
         printer.PrintObj()    setDefaults()/setAlias()
              │                     │
              ▼                     ▼
           stdout              SavePreference()
                                    │
                                    ▼
                               kubercファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| kuberc.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/kuberc.go` | ソース | kubercコマンドのルート定義 |
| view.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/view.go` | ソース | view サブコマンドの実装 |
| set.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/set.go` | ソース | set サブコマンドの実装 |
| view_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/view_test.go` | テスト | viewのユニットテスト |
| set_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/set_test.go` | テスト | setのユニットテスト |
