# 機能設計書 113-kubectl-convert

## 概要

本ドキュメントは、kubectl-convertコマンドの設計を記述する。KubernetesリソースマニフェストのAPIバージョン変換を行うスタンドアロンコマンドである。

### 本機能の処理概要

**業務上の目的・背景**：KubernetesのAPIバージョンは進化し続けており、古いAPIバージョンのマニフェストを新しいバージョンに変換する必要がある。kubectl-convertは、YAMLまたはJSON形式のマニフェストファイルを指定したAPIバージョンに変換するツールであり、APIバージョンの移行作業を支援する。

**機能の利用シーン**：Kubernetesのバージョンアップ時に、廃止予定のAPIバージョンで記述されたマニフェストを新しいバージョンに変換する場合に使用する。CIパイプラインでのマニフェスト検証にも活用できる。

**主要な処理内容**：
1. マニフェストファイルの読み込み（ファイル、ディレクトリ、stdin）
2. Kubernetesの内部スキーマを使用したバージョン変換
3. 指定された出力フォーマット（YAML/JSON）での変換結果出力

**関連システム・外部連携**：API Serverへの接続（--local=falseの場合のスキーマ検証）、legacyscheme（内部型変換スキーム）

**権限による制御**：--local=falseの場合、API Serverへのアクセス権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに対応する画面なし |

## 機能種別

データ変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -f/--filename | []string | Yes | 変換対象のファイル/ディレクトリ/URL | 少なくとも1つ必要 |
| --output-version | string | No | 出力APIバージョン（例: apps/v1） | GroupVersion形式 |
| --local | bool | No | ローカルのみで変換（API Server不使用） | デフォルトtrue |
| -o/--output | string | No | 出力フォーマット | デフォルトyaml |
| -R/--recursive | bool | No | ディレクトリの再帰的処理 | - |

### 入力データソース

- マニフェストファイル（YAML/JSON）
- 標準入力
- Kustomizeディレクトリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変換済みマニフェスト | runtime.Object | 指定バージョンに変換されたKubernetesリソース |

### 出力先

標準出力（変換結果）

## 処理フロー

### 処理シーケンス

```
1. ファイル入力のバリデーション
   └─ FilenameOptions.RequireFilenameOrKustomize()
2. リソースビルダーの構築
   └─ WithScheme(legacyscheme)でスキーマを設定
3. マニフェストの読み込みとパース
   └─ FilenameParam()でファイルを指定
4. バージョン変換
   └─ tryConvert()で指定バージョンに変換
5. 結果の出力
   └─ Printer.PrintObj()で出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ファイル入力検証]
    B --> C[リソースビルダー構築]
    C --> D[マニフェスト読み込み]
    D --> E{出力バージョン指定?}
    E -->|Yes| F[指定バージョンに変換]
    E -->|No| G[最新バージョンに変換]
    F --> H[結果出力]
    G --> H
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-113-01 | デフォルトローカル実行 | --localはデフォルトtrueで、API Serverに接続しない | 常時 |
| BR-113-02 | バージョン未指定時 | 出力バージョン未指定時は最新バージョンに変換する | --output-version未指定時 |
| BR-113-03 | 未登録型の処理 | スキーマに未登録の型はJSON Raw形式で出力される | スキーマに登録されていないリソース |
| BR-113-04 | リスト出力 | 複数リソース入力時はList形式で出力される | 入力が複数の場合 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル未指定 | -fフラグが指定されていない | エラーメッセージ表示 |
| - | バージョン解析エラー | --output-versionの形式が不正 | エラーメッセージ表示 |
| - | 変換エラー | 指定バージョンへの変換が不可能 | エラーメッセージ表示 |
| - | 入力なし | 変換対象オブジェクトが0件 | "no objects passed to convert"エラー |

### リトライ仕様

リトライなし

## トランザクション仕様

該当なし

## パフォーマンス要件

ローカル実行時はファイルI/Oのみであり、特段のパフォーマンス要件はない。

## セキュリティ考慮事項

- --local=falseの場合、API Serverへの認証が必要
- 変換処理自体はデータの読み取りと変換のみで、クラスターへの書き込みは行わない

## 備考

- kubectl-convertは独立バイナリとして提供される（kubectl本体からは分離）
- `cmd/kubectl-convert/kubectl-convert.go`がエントリーポイント、実際の変換ロジックは`pkg/kubectl/cmd/convert/convert.go`に実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | kubectl-convert.go | `cmd/kubectl-convert/kubectl-convert.go` | main関数（31-44行目）でFactory生成とコマンド実行 |

#### Step 2: 変換コマンドの構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | convert.go | `pkg/kubectl/cmd/convert/convert.go` | ConvertOptions構造体（65-78行目）、NewCmdConvert（90-112行目） |

#### Step 3: 変換ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | convert.go | `pkg/kubectl/cmd/convert/convert.go` | RunConvert（141-190行目）、asVersionedObject（196-229行目）、tryConvert（284-298行目） |

### プログラム呼び出し階層図

```
main() [cmd/kubectl-convert]
    │
    └─ convert.NewCmdConvert()
           │
           ├─ Complete()
           │      ├─ RequireFilenameOrKustomize()
           │      └─ PrintFlags.ToPrinter()
           │
           └─ RunConvert()
                  ├─ builder.Do()
                  ├─ Infos()
                  ├─ asVersionedObject()
                  │      └─ asVersionedObjects()
                  │             └─ tryConvert()
                  └─ Printer.PrintObj()
```

### データフロー図

```
[入力]                    [処理]                          [出力]

マニフェスト ──────▶ resource.Builder
(YAML/JSON)              │
                    パース・オブジェクト化
                         │
                    tryConvert()
                    (バージョン変換)
                         │
                    Printer.PrintObj() ──────▶ stdout
                                              (YAML/JSON)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| kubectl-convert.go | `cmd/kubectl-convert/kubectl-convert.go` | ソース | エントリーポイント |
| convert.go | `pkg/kubectl/cmd/convert/convert.go` | ソース | 変換コマンドの主要ロジック |
| convert_test.go | `pkg/kubectl/cmd/convert/convert_test.go` | テスト | ユニットテスト |
| import_known_versions.go | `pkg/kubectl/cmd/convert/import_known_versions.go` | ソース | 既知バージョンのインポート |
