# 機能設計書 114-Attach

## 概要

本ドキュメントは、kubectl attachコマンドの設計を記述する。実行中のコンテナの標準入出力にアタッチし、対話的なセッションを提供する。

### 本機能の処理概要

**業務上の目的・背景**：実行中のコンテナプロセスの入出力にリアルタイムでアクセスすることで、デバッグや運用時の対話的操作を可能にする。execコマンドが新しいプロセスを起動するのに対し、attachはコンテナのメインプロセスに直接接続する点が異なる。

**機能の利用シーン**：コンテナ内で実行中のアプリケーションの標準出力をリアルタイムで確認したい場合、対話的なシェルセッションを使用中のコンテナに接続したい場合に使用する。

**主要な処理内容**：
1. 対象Podの特定とAttach可能なPodの解決
2. コンテナの選択（--containerフラグまたはデフォルトコンテナアノテーション）
3. TTY設定の調整（コンテナのTTY設定との整合性確認）
4. SPDY/WebSocket経由でのストリーム接続の確立
5. 端末サイズの監視と同期

**関連システム・外部連携**：API Server（Pod情報取得、Attach API）、Kubelet（Attachエンドポイント）

**権限による制御**：対象PodのNamespaceへのアクセス権限、pods/attachサブリソースへの権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | kubectl attach | 主機能 | 実行中のコンテナの標準入出力にアタッチする主処理 |
| 21 | kubectl attach | API連携 | KubeletのAttachエンドポイントを通じてコンテナに接続する |

## 機能種別

ストリーミング接続 / 対話的操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| POD / TYPE/NAME | string | Yes | アタッチ対象のPodまたはリソース | 1-2個の引数 |
| -c/--container | string | No | コンテナ名 | Pod内に存在するコンテナ名 |
| -i/--stdin | bool | No | stdinをコンテナに渡す | - |
| -t/--tty | bool | No | stdinがTTYであることを示す | - |
| -q/--quiet | bool | No | リモートセッションの出力のみ表示 | - |
| --pod-running-timeout | duration | No | Podが実行状態になるまでの待機時間 | 0より大きい値（デフォルト60秒） |

### 入力データソース

- kubeconfigによるクラスター接続情報
- API ServerからのPod情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| コンテナ出力 | stream | コンテナの標準出力/標準エラー出力 |
| 再アタッチメッセージ | string | セッション終了後の再接続方法案内 |

### 出力先

標準出力（コンテナ出力）、標準エラー出力（警告・ガイダンス）

## 処理フロー

### 処理シーケンス

```
1. Pod情報の取得
   └─ resource.Builderで対象Podを特定
2. Attachable Podの解決
   └─ AttachablePodForObjectFnで実行中のPodを取得
3. Podステータスの確認
   └─ Succeeded/FailedフェーズのPodはエラー
4. コンテナの選択
   └─ FindOrDefaultContainerByName()でコンテナを決定
5. TTY設定の調整
   └─ コンテナのTTY設定との整合性を確認・調整
6. ストリーム接続の確立
   └─ SPDY/WebSocket経由でKubeletに接続
7. 端末サイズの監視開始
   └─ MonitorSize()でサイズ変更を監視
8. セッション終了後のメッセージ表示
   └─ reattachMessage()で再接続方法を案内
```

### フローチャート

```mermaid
flowchart TD
    A[開始: kubectl attach] --> B[Pod情報取得]
    B --> C[Attachable Pod解決]
    C --> D{Pod実行中?}
    D -->|No| E[エラー: 完了済みPod]
    D -->|Yes| F[コンテナ選択]
    F --> G{TTY整合性チェック}
    G -->|不整合| H[TTY設定調整]
    G -->|整合| I[ストリーム接続確立]
    H --> I
    I --> J[端末サイズ監視開始]
    J --> K[セッション実行]
    K --> L[再アタッチメッセージ表示]
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-114-01 | 完了Pod拒否 | Succeeded/FailedフェーズのPodにはアタッチできない | Pod.Status.Phase確認時 |
| BR-114-02 | TTY自動調整 | コンテナがTTYなしで起動された場合、TTYフラグを無効化する | -t指定時かつコンテナTTYなし |
| BR-114-03 | TTY強制有効化 | コンテナがTTY付きで起動された場合、ユーザーが-tを指定していなくてもTTYを有効化する | コンテナTTYありの場合 |
| BR-114-04 | デフォルトコンテナ | kubectl.kubernetes.io/default-containerアノテーションまたは最初のコンテナが選択される | --container未指定時 |
| BR-114-05 | WebSocketフォールバック | WebSocket接続を優先し、失敗時にSPDYにフォールバックする | 常時 |
| BR-114-06 | Raw TTY時のstderr無効化 | Raw TTYモードではstderrストリームを無効化する | Raw TTYモード時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数不正 | 引数が0個または3個以上 | エラーメッセージ表示 |
| - | Pod完了済み | PodがSucceeded/Failedフェーズ | エラーメッセージ表示 |
| - | タイムアウト | --pod-running-timeoutまでにPodが起動しない | タイムアウトエラー |
| - | コンテナ不在 | 指定コンテナがPod内に存在しない | エラーメッセージ表示 |
| - | 接続失敗 | Kubeletへの接続が失敗 | SPDY/WebSocket切り替え |

### リトライ仕様

WebSocket接続失敗時はSPDYへのフォールバックを行う（remotecommand.NewFallbackExecutor）

## トランザクション仕様

該当なし

## パフォーマンス要件

ストリーミング接続のレイテンシはネットワーク環境に依存する。端末サイズの変更はリアルタイムで同期される。

## セキュリティ考慮事項

- セッション内のすべてのコマンドと出力はコンテナログに記録される旨の警告が表示される
- 認証情報や機密情報がコマンドプロンプトを通じて送信される可能性がある

## 備考

- kubectl runの--attachフラグからも内部的に呼び出される
- エフェメラルコンテナへの再アタッチも可能（再起動はされない）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | attach.go | `staging/src/k8s.io/kubectl/pkg/cmd/attach/attach.go` | AttachOptions構造体（72-91行目）、RemoteAttachインターフェース（129-131行目） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | attach.go | `staging/src/k8s.io/kubectl/pkg/cmd/attach/attach.go` | NewCmdAttach（105-126行目）でコマンド構築 |

**主要処理フロー**:
1. **105-126行目**: Cobraコマンド構築、フラグ登録
2. **199-228行目**: Complete()でオプション設定
3. **231-243行目**: Validate()で引数検証
4. **246-324行目**: Run()で実際のAttach処理を実行

#### Step 3: Attach処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | attach.go | `staging/src/k8s.io/kubectl/pkg/cmd/attach/attach.go` | DefaultAttachFunc（134-155行目）でREST APIリクエスト構築、createExecutor（176-196行目）でSPDY/WebSocket接続 |

### プログラム呼び出し階層図

```
NewCmdAttach()
    │
    ├─ Complete()
    │      ├─ f.ToRawKubeConfigLoader().Namespace()
    │      └─ f.ToRESTConfig()
    │
    ├─ Validate()
    │
    └─ Run()
           ├─ Builder.Do().Object()
           ├─ findAttachablePod()
           │      └─ AttachablePodForObjectFn()
           ├─ containerToAttachTo()
           │      └─ FindOrDefaultContainerByName()
           ├─ SetupTTY()
           ├─ MonitorSize()
           └─ AttachFunc()
                  └─ DefaultAttachFunc()
                         ├─ restClient.Post().SubResource("attach")
                         └─ Attach.Attach()
                                └─ createExecutor()
                                       ├─ NewSPDYExecutor()
                                       ├─ NewWebSocketExecutor()
                                       └─ NewFallbackExecutor()
```

### データフロー図

```
[入力]                    [処理]                          [出力]

Pod名/リソース ────▶ resource.Builder
                         │
                    API Server問い合わせ
                         │
                    コンテナ選択
                         │
stdin ─────────▶ SPDY/WebSocket接続 ──────▶ stdout
                    (Kubelet経由)            stderr
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| attach.go | `staging/src/k8s.io/kubectl/pkg/cmd/attach/attach.go` | ソース | Attachコマンドの主要ロジック |
| attach_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/attach/attach_test.go` | テスト | ユニットテスト |
