# 機能設計書 115-イベント表示（events）

## 概要

本ドキュメントは、kubectl eventsコマンドの設計を記述する。Kubernetesクラスター内のイベントリソースを一覧表示・フィルタリング・ウォッチする機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesイベントはクラスター内で発生した重要な出来事（Pod起動、スケジューリング、エラー等）を記録する。これらのイベントを効率的に検索・表示することで、障害調査やクラスター状態の把握を支援する。

**機能の利用シーン**：クラスターで発生した最近のイベントを確認する場合、特定のリソースに関連するイベントをフィルタリングする場合、イベントをリアルタイムで監視する場合に使用する。

**主要な処理内容**：
1. Namespace内またはクラスター全体のイベントの一覧取得
2. `--for`フラグによるリソース固有のイベントフィルタリング
3. `--types`フラグによるイベントタイプ（Normal/Warning）フィルタリング
4. `--watch`フラグによるリアルタイムイベント監視
5. カスタム出力形式（テーブル、YAML、JSON等）でのイベント表示

**関連システム・外部連携**：API Server（イベントリソースのList/Watch API）

**権限による制御**：対象NamespaceのEventsリソースに対するget/list/watch権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | kubectl events | 主機能 | Kubernetesイベントの表示とフィルタリングを行う主処理 |
| 28 | kubectl events | API連携 | イベントリソースの取得リクエストをAPI Serverに送信する |

## 機能種別

データ取得 / 一覧表示 / ストリーミング監視

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --for | string | No | フィルタ対象リソース（TYPE/NAME形式） | resource/name形式 |
| -w/--watch | bool | No | リアルタイム監視モード | - |
| -A/--all-namespaces | bool | No | 全Namespace対象 | - |
| --types | []string | No | イベントタイプフィルタ | "Normal"または"Warning" |
| --no-headers | bool | No | ヘッダー行を非表示 | - |
| -o/--output | string | No | 出力形式 | yaml/json/wide等 |
| --chunk-size | int64 | No | ページネーションのチャンクサイズ | デフォルト500 |

### 入力データソース

- API Server（Events API）
- kubeconfigによるクラスター接続情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| LAST SEEN | string | イベントの最終発生時刻からの経過時間 |
| TYPE | string | イベントタイプ（Normal/Warning） |
| REASON | string | イベント理由 |
| OBJECT | string | 関連オブジェクト（Kind/Name） |
| MESSAGE | string | イベントメッセージ |
| NAMESPACE | string | Namespace名（--all-namespaces時のみ） |

### 出力先

標準出力（イベント一覧）、標準エラー出力（イベント未検出メッセージ）

## 処理フロー

### 処理シーケンス

```
1. オプションの変換
   └─ EventsFlags.ToOptions()でランタイムオプションに変換
2. フィルタの構築
   └─ --forからFieldSelectorを構築
3. イベントの取得
   ├─ 通常モード: FollowContinueでページネーション取得
   └─ ウォッチモード: Watch APIで監視
4. フィルタリング
   └─ filteredEventType()でタイプフィルタ適用
5. ソート
   └─ SortableEventsで時系列ソート
6. 出力
   └─ EventPrinterまたはカスタムPrinterで出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始: kubectl events] --> B[オプション変換]
    B --> C[フィルタ構築]
    C --> D{watchモード?}
    D -->|Yes| E[Watch API接続]
    D -->|No| F[List APIでイベント取得]
    E --> G[イベント受信ループ]
    G --> H{タイプフィルタ通過?}
    H -->|Yes| I[イベント出力]
    H -->|No| G
    F --> J[イベントフィルタリング]
    J --> K[時系列ソート]
    K --> L[一括出力]
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-115-01 | タイプフィルタ | --typesはNormalとWarningのみ有効 | --types指定時 |
| BR-115-02 | 時系列ソート | イベントはSeries.LastObservedTime > LastTimestamp > EventTimeの優先順でソートされる | 通常モード |
| BR-115-03 | 削除イベント非表示 | watchモードでDeleteタイプのイベントは表示しない | watchモード時 |
| BR-115-04 | GVK設定 | GVKが空のイベントにはv1/Eventを設定する | GVKが空の場合 |
| BR-115-05 | ページネーション | チャンクサイズに基づくページネーション取得 | 常時 |

### 計算ロジック

イベント時刻の優先順位：
1. `event.Series.LastObservedTime`
2. `event.LastTimestamp`
3. `event.EventTime`

## データベース操作仕様

該当なし（API Serverへの読み取りのみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 不正タイプ | --typesにNormal/Warning以外を指定 | バリデーションエラー |
| - | イベント未検出 | フィルタ条件に一致するイベントがない | メッセージ表示（エラーではない） |
| - | API接続エラー | API Serverへの接続失敗 | エラーメッセージ表示 |
| - | --for形式不正 | resource/name以外の形式 | "--for must be in resource/name form"エラー |

### リトライ仕様

リトライなし（ただしWatchは接続維持のために内部的にリコネクトする場合がある）

## トランザクション仕様

該当なし

## パフォーマンス要件

ページネーション（ChunkSize=500）による大量イベントの効率的な取得をサポート。

## セキュリティ考慮事項

- イベントにはクラスターの運用情報が含まれるため、適切なRBAC設定が必要

## 備考

- kubectl describeコマンド内でもリソースに関連するイベントが表示される
- イベントはKubernetesにより1時間後に自動削除される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` | EventsFlags構造体（78-89行目）、EventsOptions構造体（103-117行目） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | events.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` | NewCmdEvents（120-139行目）、ToOptions（152-209行目）でFlags→Optionsの変換 |

#### Step 3: イベント取得ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | events.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` | Run（222-292行目）で通常取得、runWatch（294-329行目）でWatch取得 |

#### Step 4: イベント出力を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | event_printer.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/event_printer.go` | EventPrinter（34-39行目）、PrintObj（42-60行目）、getInterval（84-99行目） |

### プログラム呼び出し階層図

```
NewCmdEvents()
    │
    └─ EventsFlags.ToOptions()
           │
           ├─ RESTClientGetter.ToRawKubeConfigLoader()
           ├─ kubernetes.NewForConfig()
           └─ NewEventPrinter() / PrintFlags.ToPrinter()

EventsOptions.Run()
    │
    ├─ [通常モード]
    │      ├─ Events(namespace).List()
    │      │      └─ FollowContinue()
    │      ├─ filteredEventType()
    │      ├─ sort.Sort(SortableEvents)
    │      └─ PrintObj()
    │
    └─ [ウォッチモード]
           └─ runWatch()
                  ├─ Events(namespace).Watch()
                  └─ UntilWithoutRetry()
                         ├─ filteredEventType()
                         └─ PrintObj()
```

### データフロー図

```
[入力]                    [処理]                          [出力]

--for (リソース) ────▶ FieldSelector構築
--types ────────────▶ フィルタ構築
                         │
                    API Server List/Watch
                         │
                    filteredEventType()
                         │
                    SortableEventsソート
                         │
                    EventPrinter ──────────▶ stdout
                                            (テーブル/YAML/JSON)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` | ソース | イベント表示の主要ロジック |
| event_printer.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/event_printer.go` | ソース | イベントのテーブル形式出力 |
| events_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events_test.go` | テスト | ユニットテスト |
| event_printer_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/event_printer_test.go` | テスト | プリンターのテスト |
