# 機能設計書 116-Proxy

## 概要

本ドキュメントは、kubectl proxyコマンドの設計を記述する。ローカルプロキシサーバーを起動してKubernetes API Serverへの認証済みアクセスを提供する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetes API Serverへのアクセスには認証情報が必要であるが、開発・デバッグ時にはcurl等のHTTPクライアントから直接APIにアクセスしたい場合がある。kubectl proxyはkubeconfigの認証情報を使用してAPI Serverへの認証を代行するローカルプロキシを提供し、ブラウザや他のツールからの簡易アクセスを可能にする。

**機能の利用シーン**：Kubernetes APIのエンドポイントをブラウザで確認したい場合、REST APIを直接テストしたい場合、ダッシュボード等のWeb UIにローカルからアクセスしたい場合に使用する。

**主要な処理内容**：
1. kubeconfigに基づくAPI Server接続設定の読み込み
2. リクエストフィルタの構築（パス、ホスト、メソッドのフィルタリング）
3. ローカルHTTPプロキシサーバーの起動
4. 静的ファイルの提供（オプション）
5. リクエストの転送とレスポンスの中継

**関連システム・外部連携**：API Server（全APIエンドポイント）、kubeconfig（認証情報）

**権限による制御**：kubeconfigに設定されたユーザーの権限がそのままプロキシ経由のアクセスに適用される

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | kubectl proxy | 主機能 | ローカルプロキシサーバーを起動しKubernetes APIへのアクセスを提供する主処理 |
| 24 | kubectl proxy | API連携 | プロキシ経由で全てのAPI Serverリクエストを中継する |

## 機能種別

プロキシサーバー / ネットワーク中継

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -p/--port | int | No | プロキシポート（デフォルト8001、0でランダム） | - |
| --address | string | No | リッスンアドレス（デフォルト127.0.0.1） | - |
| -w/--www | string | No | 静的ファイルディレクトリ | ディレクトリの存在確認 |
| -P/--www-prefix | string | No | 静的ファイルのURLプレフィックス | デフォルト/static/ |
| --api-prefix | string | No | APIのURLプレフィックス | デフォルト/ |
| --accept-paths | string | No | 許可パスの正規表現 | 正規表現として有効 |
| --reject-paths | string | No | 拒否パスの正規表現 | 正規表現として有効 |
| --accept-hosts | string | No | 許可ホストの正規表現 | 正規表現として有効 |
| --reject-methods | string | No | 拒否メソッドの正規表現 | 正規表現として有効 |
| --disable-filter | bool | No | リクエストフィルタを無効化 | - |
| -u/--unix-socket | string | No | Unixソケットパス | --portと同時指定不可 |
| --keepalive | duration | No | キープアライブ期間 | - |
| --append-server-path | bool | No | サーバーパスの自動追加 | - |

### 入力データソース

- kubeconfig（クラスター接続情報、認証情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| サーバー開始メッセージ | string | "Starting to serve on <address>" |
| API レスポンス | HTTP Response | API Serverからのレスポンスをそのまま中継 |

### 出力先

標準出力（起動メッセージ）、HTTPレスポンス（プロキシ済みAPIレスポンス）

## 処理フロー

### 処理シーケンス

```
1. REST設定の取得
   └─ Factory.ToRESTConfig()
2. プレフィックスの正規化
   └─ 末尾に/を追加
3. サーバーパスの警告
   └─ --append-server-pathなしでサーバーパスがある場合は警告
4. フィルタの構築
   └─ FilterServerの初期化（またはdisable-filterでnil）
5. プロキシサーバーの作成
   └─ proxy.NewServer()
6. リスナーの起動
   └─ TCP Listen / Unixソケット Listen
7. サーブ開始
   └─ ServeOnListener()
```

### フローチャート

```mermaid
flowchart TD
    A[開始: kubectl proxy] --> B[REST設定取得]
    B --> C[プレフィックス正規化]
    C --> D{フィルタ無効?}
    D -->|Yes| E[フィルタなし警告]
    D -->|No| F[FilterServer構築]
    E --> G[プロキシサーバー作成]
    F --> G
    G --> H{Unixソケット?}
    H -->|Yes| I[Unixソケットリッスン]
    H -->|No| J[TCPリッスン]
    I --> K[サーブ開始]
    J --> K
    K --> L[リクエスト待受ループ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-116-01 | ポート排他制御 | --portと--unix-socketは同時指定不可 | 両方指定時 |
| BR-116-02 | XSRF防護 | --disable-filterはXSRF攻撃のリスクがある旨を警告 | filter無効化時 |
| BR-116-03 | デフォルトフィルタ | パス、ホスト、メソッドの正規表現フィルタがデフォルトで有効 | 常時 |
| BR-116-04 | 拒否パス優先 | reject-pathsはaccept-pathsより優先される | 両方にマッチする場合 |
| BR-116-05 | サーバーパス警告 | kube contextにサーバーパスが含まれる場合は--append-server-pathの使用を促す | サーバーパスが空でない場合 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ポート競合 | 指定ポートが既に使用中 | エラーメッセージ表示 |
| - | 同時指定 | --portと--unix-socket同時指定 | エラーメッセージ表示 |
| - | 静的ディレクトリ不存在 | --wwwディレクトリが存在しない | 警告表示（エラーではない） |
| - | REST設定エラー | kubeconfig読み込み失敗 | エラーメッセージ表示 |

### リトライ仕様

リトライなし

## トランザクション仕様

該当なし

## パフォーマンス要件

プロキシサーバーのスループットはローカルネットワークとAPI Serverの性能に依存する。keepaliveオプションにより接続の効率化が可能。

## セキュリティ考慮事項

- デフォルトではリッスンアドレスが127.0.0.1であり、ローカルアクセスのみ許可
- --disable-filterを使用するとXSRF攻撃に脆弱になる
- Unixソケット使用時はファイルパーミッションによるアクセス制御が必要
- プロキシ経由のアクセスはkubeconfigのユーザー権限で実行される

## 備考

- ポート0を指定するとOSがランダムなポートを割り当て、選択されたポートが標準出力に表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | proxy.go | `staging/src/k8s.io/kubectl/pkg/cmd/proxy/proxy.go` | ProxyOptions構造体（41-62行目）、定数定義（64-69行目） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | proxy.go | `staging/src/k8s.io/kubectl/pkg/cmd/proxy/proxy.go` | NewCmdProxy（118-148行目）でコマンド構築、Complete（151-189行目）→Validate（192-207行目）→RunProxy（210-230行目） |

**主要処理フロー**:
1. **151-189行目**: REST設定取得、プレフィックス正規化、フィルタ構築
2. **192-207行目**: ポート/ソケット排他チェック、静的ディレクトリ存在確認
3. **210-230行目**: プロキシサーバー作成、リッスン、サーブ

### プログラム呼び出し階層図

```
NewCmdProxy()
    │
    ├─ Complete()
    │      ├─ f.ToRESTConfig()
    │      ├─ FilterServer構築
    │      └─ MakeRegexpArrayOrDie()
    │
    ├─ Validate()
    │
    └─ RunProxy()
           ├─ proxy.NewServer()
           ├─ server.Listen() / server.ListenUnix()
           └─ server.ServeOnListener()
```

### データフロー図

```
[入力]                    [処理]                          [出力]

HTTPリクエスト ────▶ FilterServer
(localhost)             │
                   フィルタリング
                        │
                   API Server転送
                        │
                   レスポンス中継 ──────▶ HTTPレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| proxy.go | `staging/src/k8s.io/kubectl/pkg/cmd/proxy/proxy.go` | ソース | プロキシコマンドの主要ロジック |
| proxy/ | `staging/src/k8s.io/kubectl/pkg/proxy/` | ソース | プロキシサーバーの実装（FilterServer、Server） |
