# 機能設計書 117-Config管理

## 概要

本ドキュメントは、kubectl configコマンドの設計を記述する。kubeconfigファイルのコンテキスト、クラスター、ユーザー設定を管理する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesクラスターへの接続に使用するkubeconfigファイルは、複数のクラスター、ユーザー、コンテキストの情報を保持する。kubectl configコマンドは、これらの設定を対話的に管理するためのサブコマンド群を提供し、マルチクラスター環境での運用効率を向上させる。

**機能の利用シーン**：新しいクラスターの接続情報を追加する場合、現在のコンテキストを切り替える場合、認証情報を更新する場合、不要なコンテキスト・クラスター・ユーザー情報を削除する場合に使用する。

**主要な処理内容**：
1. `view` - kubeconfig設定の表示
2. `current-context` - 現在のコンテキスト名の表示
3. `use-context` - コンテキストの切り替え
4. `set-cluster` - クラスター情報の設定
5. `set-credentials` - ユーザー認証情報の設定
6. `set-context` - コンテキスト情報の設定
7. `set` - 任意のプロパティの設定
8. `unset` - プロパティの削除
9. `get-contexts` / `get-clusters` / `get-users` - 設定項目の一覧表示
10. `delete-cluster` / `delete-context` / `delete-user` - 設定項目の削除
11. `rename-context` - コンテキストの名前変更

**関連システム・外部連携**：kubeconfigファイル（$HOME/.kube/config）、KUBECONFIG環境変数

**権限による制御**：ローカルファイルシステムの読み書き権限のみ必要（クラスターへのアクセスは不要）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 38 | kubectl config | 主機能 | kubeconfigファイルのコンテキスト、クラスター、ユーザー設定を管理する主処理 |

## 機能種別

設定管理 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --kubeconfig | string | No | kubeconfigファイルのパス | ファイルパスの妥当性 |
| CONTEXT_NAME | string | サブコマンド依存 | コンテキスト名 | サブコマンドに応じた検証 |
| CLUSTER_NAME | string | サブコマンド依存 | クラスター名 | サブコマンドに応じた検証 |
| PROPERTY_NAME | string | set/unset時 | プロパティ名 | ドット区切りナビゲーションパス |
| PROPERTY_VALUE | string | set時 | プロパティ値 | 型に応じた変換（bool等） |

### 入力データソース

- kubeconfigファイル（ファイルパスはKUBECONFIG環境変数、--kubeconfigフラグ、またはデフォルトパスから決定）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| kubeconfig設定 | Config | YAML形式のkubeconfig設定内容 |
| コンテキスト名 | string | 現在のコンテキスト名 |
| 設定一覧 | table | コンテキスト、クラスター、ユーザーの一覧 |

### 出力先

標準出力（設定表示）、kubeconfigファイル（設定変更時）

## 処理フロー

### 処理シーケンス

```
1. kubeconfigファイルパスの解決
   └─ --kubeconfig > KUBECONFIG環境変数 > デフォルト
2. kubeconfigの読み込み
   └─ PathOptions.LoadingRulesに基づくファイル読み込み
3. サブコマンドに応じた処理
   ├─ view: 設定のYAML表示
   ├─ current-context: CurrentContext表示
   ├─ use-context: CurrentContextの更新
   ├─ set-*: 設定の追加・更新
   ├─ get-*: 設定の一覧表示
   ├─ delete-*: 設定の削除
   ├─ set: 任意プロパティの設定
   ├─ unset: プロパティの削除
   └─ rename-context: コンテキスト名変更
4. 変更の保存
   └─ 変更があった場合のみファイル書き込み
```

### フローチャート

```mermaid
flowchart TD
    A[kubectl config] --> B{サブコマンド}
    B -->|view| C[設定表示]
    B -->|current-context| D[現在コンテキスト表示]
    B -->|use-context| E[コンテキスト切替]
    B -->|set-cluster| F[クラスター設定]
    B -->|set-credentials| G[認証情報設定]
    B -->|set-context| H[コンテキスト設定]
    B -->|get-*| I[一覧表示]
    B -->|delete-*| J[削除処理]
    B -->|rename-context| K[名前変更]
    E --> L[ファイル保存]
    F --> L
    G --> L
    H --> L
    J --> L
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-117-01 | ファイルロード順序 | --kubeconfig > KUBECONFIG環境変数 > $HOME/.kube/config | 常時 |
| BR-117-02 | マージルール | KUBECONFIG環境変数のパスリストは結合される | KUBECONFIG設定時 |
| BR-117-03 | 排他的ファイル | --kubeconfigフラグ指定時はマージなし | フラグ指定時 |
| BR-117-04 | 変更対象ファイル | 値の変更は定義元のファイルに書き込まれる | KUBECONFIG複数ファイル時 |
| BR-117-05 | 新規作成先 | 新規値は最初に存在するファイルに作成、なければリスト最後のファイルに作成 | 新規値作成時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（ローカルファイルベースの設定管理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル読み取りエラー | kubeconfigファイルが読み取れない | エラーメッセージ表示 |
| - | コンテキスト不在 | 指定コンテキストが存在しない | エラーメッセージ表示 |
| - | プロパティ不正 | 不正なプロパティパス | ヘルプ表示 |
| - | 型変換エラー | boolプロパティに不正値 | エラーメッセージ表示 |

### リトライ仕様

リトライなし

## トランザクション仕様

ファイルの読み込み→変更→書き込みはアトミックではないが、kubeconfigの変更は通常単一操作であるため問題は少ない。

## パフォーマンス要件

ローカルファイル操作のみであり、特段のパフォーマンス要件はない。

## セキュリティ考慮事項

- kubeconfigファイルには認証情報（トークン、証明書パス等）が含まれるため、ファイルパーミッションの適切な管理が必要
- set-credentialsで設定する認証情報は平文でファイルに保存される

## 備考

- kubeconfigの詳細な仕様はclient-goのclientcmdパッケージで定義されている
- kubeadm kubeconfigコマンドからも間接的に利用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コマンド構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/config.go` | NewCmdConfig関数（35-76行目）で全サブコマンドの登録を確認 |

**読解のコツ**: 14個のサブコマンドが登録されており、各サブコマンドは独立したファイルに実装されている。

#### Step 2: 各サブコマンドの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | view.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/view.go` | kubeconfig全体の表示 |
| 2-2 | use_context.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/use_context.go` | コンテキスト切り替え |
| 2-3 | current_context.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/current_context.go` | 現在コンテキスト表示 |
| 2-4 | set.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/set.go` | プロパティ設定 |

### プログラム呼び出し階層図

```
NewCmdConfig()
    │
    ├─ NewCmdConfigView()
    ├─ NewCmdConfigSetCluster()
    ├─ NewCmdConfigSetCredentials()
    ├─ NewCmdConfigSetContext()
    ├─ NewCmdConfigSet()
    ├─ NewCmdConfigUnset()
    ├─ NewCmdConfigCurrentContext()
    ├─ NewCmdConfigUseContext()
    ├─ NewCmdConfigGetContexts()
    ├─ NewCmdConfigGetClusters()
    ├─ NewCmdConfigGetUsers()
    ├─ NewCmdConfigDeleteCluster()
    ├─ NewCmdConfigDeleteContext()
    ├─ NewCmdConfigDeleteUser()
    └─ NewCmdConfigRenameContext()
```

### データフロー図

```
[入力]                    [処理]                          [出力]

kubeconfigファイル ──▶ PathOptions.LoadingRules
                         │
                    clientcmd.Load()
                         │
                    サブコマンド処理
                         │
              ┌──────────┴──────────┐
              │                     │
        [読み取り系]            [書き込み系]
              │                     │
              ▼                     ▼
           stdout              kubeconfigファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| config.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/config.go` | ソース | configコマンドのルートとサブコマンド登録 |
| view.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/view.go` | ソース | kubeconfig表示 |
| use_context.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/use_context.go` | ソース | コンテキスト切り替え |
| current_context.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/current_context.go` | ソース | 現在コンテキスト表示 |
| set.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/set.go` | ソース | プロパティ設定 |
| set_cluster.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/set_cluster.go` | ソース | クラスター設定 |
| set_credentials.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/set_credentials.go` | ソース | 認証情報設定 |
| set_context.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/set_context.go` | ソース | コンテキスト設定 |
| get_contexts.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/get_contexts.go` | ソース | コンテキスト一覧 |
| get_clusters.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/get_clusters.go` | ソース | クラスター一覧 |
| get_users.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/get_users.go` | ソース | ユーザー一覧 |
| delete_cluster.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/delete_cluster.go` | ソース | クラスター削除 |
| delete_context.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/delete_context.go` | ソース | コンテキスト削除 |
| delete_user.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/delete_user.go` | ソース | ユーザー削除 |
| rename_context.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/rename_context.go` | ソース | コンテキスト名変更 |
| unset.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/unset.go` | ソース | プロパティ削除 |
| navigation_step_parser.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/navigation_step_parser.go` | ソース | プロパティパスのパーサー |
