# 機能設計書 118-クラスター初期化（init）

## 概要

本ドキュメントは、kubeadm initコマンドの設計を記述する。Kubernetesコントロールプレーンの初期セットアップを行い、クラスターを構築する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesクラスターの構築において、コントロールプレーンの初期化は最初のステップである。kubeadm initは証明書の生成、Static Podマニフェストの作成、etcdの初期化、コントロールプレーンコンポーネントの起動、アドオンのインストールまでを自動化し、本番レベルのクラスターセットアップを簡素化する。

**機能の利用シーン**：新しいKubernetesクラスターを構築する場合の最初のステップとして使用する。HAクラスター構成の最初のコントロールプレーンノードをセットアップする場合にも使用される。

**主要な処理内容**：
1. **Preflight** - システム要件の事前チェック
2. **Certs** - CA証明書とコンポーネント証明書の生成
3. **KubeConfig** - kubeconfigファイルの生成（admin.conf、controller-manager.conf等）
4. **Etcd** - etcd Static Podマニフェストの生成
5. **ControlPlane** - API Server、Controller Manager、SchedulerのStatic Podマニフェスト生成
6. **KubeletStart** - kubeletの設定と起動
7. **WaitControlPlane** - コントロールプレーンの起動完了待機
8. **UploadConfig** - kubeadm設定のConfigMapへのアップロード
9. **UploadCerts** - 証明書のSecret暗号化アップロード（オプション）
10. **MarkControlPlane** - ノードへのコントロールプレーンラベル/テイント付与
11. **BootstrapToken** - ブートストラップトークンの作成
12. **KubeletFinalize** - kubelet設定のファイナライズ
13. **Addon** - CoreDNSとkube-proxyのインストール
14. **ShowJoinCommand** - joinコマンドの表示

**関連システム・外部連携**：kubelet、etcd、Container Runtime Interface（CRI）、PKI（証明書管理）

**権限による制御**：root権限が必要（システムディレクトリへの書き込み、kubelet操作等）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CLIコマンドのため画面なし |

## 機能種別

クラスター構築 / ワークフロー実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --apiserver-advertise-address | string | No | API Serverの広告アドレス | IPアドレス |
| --apiserver-bind-port | int32 | No | API Serverバインドポート | デフォルト6443 |
| --pod-network-cidr | string | No | PodネットワークCIDR | CIDR形式 |
| --service-cidr | string | No | ServiceネットワークCIDR | CIDR形式 |
| --service-dns-domain | string | No | ServiceのDNSドメイン | デフォルトcluster.local |
| --kubernetes-version | string | No | Kubernetesバージョン | セマンティックバージョン |
| --control-plane-endpoint | string | No | コントロールプレーンエンドポイント | IP:Port形式 |
| --upload-certs | bool | No | 証明書をSecretにアップロード | - |
| --config | string | No | 設定ファイルパス | ファイルの存在 |
| --node-name | string | No | ノード名 | - |
| --cri-socket | string | No | CRIソケットパス | ソケットファイル |
| --certificate-key | string | No | 証明書暗号化キー | AES 32バイトキー |
| --skip-token-print | bool | No | トークン表示をスキップ | - |
| --dry-run | bool | No | ドライラン | - |
| --ignore-preflight-errors | []string | No | 無視するプレフライトエラー | - |
| --feature-gates | string | No | フィーチャーゲート | key=value形式 |
| --patches | string | No | パッチディレクトリ | ディレクトリパス |
| --image-repository | string | No | イメージリポジトリ | - |
| --skip-phases | []string | No | スキップするフェーズ | 有効なフェーズ名 |

### 入力データソース

- 設定ファイル（InitConfiguration + ClusterConfiguration）
- ホストシステム情報（ネットワークインターフェース、CRI等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 証明書ファイル | []file | CA証明書・キー、コンポーネント証明書 |
| kubeconfigファイル | []file | admin.conf、controller-manager.conf等 |
| Static Podマニフェスト | []file | etcd、api-server、controller-manager、scheduler |
| joinコマンド | string | ワーカーノード参加用コマンド |
| 進捗メッセージ | string | 各フェーズの実行状況 |

### 出力先

/etc/kubernetes/（証明書、kubeconfig、マニフェスト）、標準出力（進捗、joinコマンド）

## 処理フロー

### 処理シーケンス

```
1. initOptionsの構築
   └─ newInitOptions()でデフォルト値設定
2. 設定の読み込みと検証
   └─ newInitData()で設定のロード・検証
3. ワークフロー実行（14フェーズ）
   └─ initRunner.Run()で順次実行
      ├─ Preflight: システムチェック
      ├─ Certs: 証明書生成
      ├─ KubeConfig: kubeconfigファイル生成
      ├─ Etcd: etcd Static Pod生成
      ├─ ControlPlane: コントロールプレーンStatic Pod生成
      ├─ KubeletStart: kubelet起動
      ├─ WaitControlPlane: 起動完了待機
      ├─ UploadConfig: ConfigMapアップロード
      ├─ UploadCerts: 証明書アップロード（オプション）
      ├─ MarkControlPlane: ラベル/テイント付与
      ├─ BootstrapToken: トークン作成
      ├─ KubeletFinalize: kubeletファイナライズ
      ├─ Addon: CoreDNS/kube-proxy
      └─ ShowJoinCommand: joinコマンド表示
```

### フローチャート

```mermaid
flowchart TD
    A[kubeadm init] --> B[設定読み込み・検証]
    B --> C[Preflight チェック]
    C --> D[証明書生成]
    D --> E[kubeconfig生成]
    E --> F[etcd Static Pod]
    F --> G[ControlPlane Static Pod]
    G --> H[kubelet起動]
    H --> I[コントロールプレーン起動待機]
    I --> J[設定アップロード]
    J --> K{upload-certs?}
    K -->|Yes| L[証明書アップロード]
    K -->|No| M[ノードマーキング]
    L --> M
    M --> N[BootstrapToken作成]
    N --> O[kubeletファイナライズ]
    O --> P[Addon インストール]
    P --> Q[joinコマンド表示]
    Q --> R[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-118-01 | 外部CA対応 | CA証明書が存在しCAキーがない場合は外部CA使用と判定 | 証明書チェック時 |
| BR-118-02 | upload-certs制約 | 外部CAまたは外部FrontProxy CA使用時はupload-certs不可 | --upload-certs指定時 |
| BR-118-03 | ドライラン | ドライラン時は一時ディレクトリに出力 | --dry-run時 |
| BR-118-04 | アドオンスキップ同期 | DNS/Proxy無効化設定とフェーズスキップは自動同期される | manageSkippedAddons() |
| BR-118-05 | 設定混合制約 | --configと個別フラグの混合使用は検証される | ValidateMixedArguments() |
| BR-118-06 | フェーズ単位実行 | 各フェーズを個別に実行可能 | --skip-phasesまたはサブコマンド |
| BR-118-07 | Kubernetesバージョン表示 | 実行前に使用するKubernetesバージョンを表示 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | リソース | 説明 |
|------|---------|------|
| Create | ConfigMap (kubeadm-config) | クラスター設定をkube-systemに保存 |
| Create | Secret (kubeadm-certs) | 暗号化証明書を保存（upload-certs時） |
| Create | BootstrapToken | TLS Bootstrap用トークンを作成 |
| Create | DaemonSet (kube-proxy) | kube-proxyのデプロイ |
| Create | Deployment (coredns) | CoreDNSのデプロイ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | PreflightError | システム要件を満たさない | --ignore-preflight-errorsで無視可能 |
| - | 外部CA不完全 | 外部CA使用時に必要な証明書が不足 | 不足証明書の提供 |
| - | APIServerバインドエラー | AdvertiseAddressが無効 | 正しいIPアドレスを指定 |
| - | 設定混合エラー | --configと個別フラグの不正な混合 | 設定ファイルまたはフラグのみ使用 |
| - | フィーチャーゲートエラー | 無効なフィーチャーゲート指定 | 有効なフィーチャーゲートを確認 |

### リトライ仕様

リトライなし（フェーズ単位での再実行が可能）

## トランザクション仕様

各フェーズは順序的に実行され、途中で失敗した場合は`kubeadm reset`で環境をクリーンアップ後に再実行する。

## パフォーマンス要件

クラスター初期化は数分程度を要する。コントロールプレーン起動待機フェーズではヘルスチェックのポーリングが行われる。

## セキュリティ考慮事項

- 証明書と秘密鍵はファイルシステムのパーミッションで保護される
- BootstrapTokenにはTTLが設定される
- upload-certs使用時は証明書がAES暗号化される
- admin.confは管理者権限を持つため、適切なアクセス制御が必要

## 備考

- kubeadm initはコントロールプレーンの1ノード目のセットアップのみ行う
- HA構成の追加コントロールプレーンノードはkubeadm join --control-planeで追加する
- 設定はv1beta4 APIバージョンで定義される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | init.go | `cmd/kubeadm/app/cmd/init.go` | initOptions構造体（58-73行目）、initData構造体（91-108行目） |

**読解のコツ**: initOptionsは外部APIから受け取るフラグ値を保持し、initDataはワークフロー実行時のランタイムデータを保持する。initDataはphases.InitDataインターフェースを実装する（87行目のコンパイル時アサート）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | init.go | `cmd/kubeadm/app/cmd/init.go` | newCmdInit（113-199行目）でフェーズ登録とRunner構築 |

**主要処理フロー**:
1. **117行目**: ワークフローRunnerの作成
2. **142-147行目**: フラグの登録
3. **158-171行目**: 14フェーズの登録（Preflight→...→ShowJoinCommand）
4. **175-192行目**: DataInitializerの設定（newInitData呼び出し）
5. **196行目**: RunnerをCobraコマンドにバインド

#### Step 3: 設定の読み込みと検証を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | init.go | `cmd/kubeadm/app/cmd/init.go` | newInitData（308-410行目）で設定のロード・検証・変換 |

**主要処理フロー**:
- **316-318行目**: フィーチャーゲートの解析
- **320-322行目**: 混合引数の検証
- **330-335行目**: 設定ファイルのロードまたはデフォルト設定の生成
- **365-379行目**: 外部CA/外部FrontProxy CAの検出
- **391-393行目**: upload-certsと外部CAの排他チェック

#### Step 4: フェーズ管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | init.go | `cmd/kubeadm/app/cmd/init.go` | manageSkippedAddons（620-648行目）でアドオンスキップの同期 |

### プログラム呼び出し階層図

```
newCmdInit()
    │
    └─ workflow.NewRunner()
           │
           ├─ AppendPhase(PreflightPhase)
           ├─ AppendPhase(CertsPhase)
           ├─ AppendPhase(KubeConfigPhase)
           ├─ AppendPhase(EtcdPhase)
           ├─ AppendPhase(ControlPlanePhase)
           ├─ AppendPhase(KubeletStartPhase)
           ├─ AppendPhase(WaitControlPlanePhase)
           ├─ AppendPhase(UploadConfigPhase)
           ├─ AppendPhase(UploadCertsPhase)
           ├─ AppendPhase(MarkControlPlanePhase)
           ├─ AppendPhase(BootstrapTokenPhase)
           ├─ AppendPhase(KubeletFinalizePhase)
           ├─ AppendPhase(AddonPhase)
           └─ AppendPhase(ShowJoinCommandPhase)

newInitData()
    ├─ features.NewFeatureGate()
    ├─ validation.ValidateMixedArguments()
    ├─ configutil.LoadOrDefaultInitConfiguration()
    ├─ certsphase.UsingExternalCA()
    └─ certsphase.UsingExternalFrontProxyCA()
```

### データフロー図

```
[入力]                    [処理]                          [出力]

設定ファイル / フラグ ──▶ newInitData()
                            │
                    設定検証・変換
                            │
                    14フェーズ順次実行
                            │
              ┌─────────────┼─────────────┐
              │             │             │
        /etc/kubernetes/  ConfigMap    stdout
        (証明書, kubeconfig,  (kubeadm-config)  (進捗, joinコマンド)
         Static Pod)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| init.go | `cmd/kubeadm/app/cmd/init.go` | ソース | initコマンドの主要ロジック |
| phases/init/ | `cmd/kubeadm/app/cmd/phases/init/` | ソース | 各フェーズの実装 |
| workflow/ | `cmd/kubeadm/app/cmd/phases/workflow/` | ソース | ワークフローRunner |
| options/ | `cmd/kubeadm/app/cmd/options/` | ソース | フラグ定義 |
| constants/ | `cmd/kubeadm/app/constants/` | ソース | 定数定義 |
| apis/kubeadm/ | `cmd/kubeadm/app/apis/kubeadm/` | ソース | 内部API型定義 |
| apis/kubeadm/v1beta4/ | `cmd/kubeadm/app/apis/kubeadm/v1beta4/` | ソース | 外部API型定義 |
| phases/certs/ | `cmd/kubeadm/app/phases/certs/` | ソース | 証明書生成ロジック |
| phases/kubeconfig/ | `cmd/kubeadm/app/phases/kubeconfig/` | ソース | kubeconfig生成ロジック |
| util/config/ | `cmd/kubeadm/app/util/config/` | ソース | 設定ユーティリティ |
