# 機能設計書 120-クラスターアップグレード

## 概要

本ドキュメントは、kubeadm upgradeコマンドの設計を記述する。既存のKubernetesクラスターを新しいバージョンにアップグレードする。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesクラスターのバージョンアップは、セキュリティパッチの適用や新機能の利用に不可欠である。kubeadm upgradeは、コントロールプレーンコンポーネント、etcd、アドオンのバージョンを安全にアップグレードするワークフローを提供し、ダウンタイムを最小化した更新を実現する。

**機能の利用シーン**：Kubernetesのマイナー/パッチバージョンアップを行う場合に使用する。事前にupgrade planで影響範囲を確認し、upgrade applyで実際のアップグレードを実行する。

**主要な処理内容**：
1. `upgrade plan` - アップグレード可能なバージョンの確認と影響分析
2. `upgrade apply` - コントロールプレーンのアップグレード実行
3. `upgrade diff` - アップグレード前後の差分確認
4. `upgrade node` - ワーカーノードのアップグレード

**関連システム・外部連携**：API Server、etcd、kubelet、コンテナランタイム、dl.k8s.io（バージョン情報取得）

**権限による制御**：root権限が必要。API Serverへのadminアクセスが必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CLIコマンドのため画面なし |

## 機能種別

クラスターアップグレード / ワークフロー実行

## 入力仕様

### 入力パラメータ（upgrade apply）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| [version] | string | Yes* | アップグレード先バージョン | セマンティックバージョン（設定ファイルで指定可） |
| --config | string | No | 設定ファイルパス | ファイルの存在 |
| --kubeconfig | string | No | kubeconfigパス | デフォルト/etc/kubernetes/admin.conf |
| -y/--yes | bool | No | 非対話モード | - |
| -f/--force | bool | No | 強制アップグレード | - |
| --dry-run | bool | No | ドライラン | - |
| --certificate-renewal | bool | No | 証明書更新 | デフォルトtrue |
| --etcd-upgrade | bool | No | etcdアップグレード | デフォルトtrue |
| --allow-experimental-upgrades | bool | No | 実験的バージョンへのアップグレード許可 | - |
| --allow-release-candidate-upgrades | bool | No | RCバージョンへのアップグレード許可 | - |
| --print-config | bool | No | 設定の表示 | - |
| --ignore-preflight-errors | []string | No | 無視するプレフライトエラー | - |
| --patches | string | No | パッチディレクトリ | - |

### 入力パラメータ（upgrade plan）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| [version] | string | No | 確認対象バージョン | セマンティックバージョン |
| -o/--output | string | No | 出力形式（text/json/yaml） | - |
| 共通フラグ | - | - | apply と共通のフラグ | - |

### 入力データソース

- API Server（クラスター現在の状態、kubeadm-config ConfigMap）
- dl.k8s.io（利用可能なバージョン情報）
- 設定ファイル（UpgradeConfiguration）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| アップグレードプラン | UpgradePlan | 利用可能なアップグレードの詳細 |
| コンポーネント一覧 | table | 各コンポーネントの現在/ターゲットバージョン |
| ComponentConfig状態 | table | コンポーネント設定のバージョン状態 |
| 成功メッセージ | string | アップグレード完了メッセージ |

### 出力先

標準出力（プラン/メッセージ）

## 処理フロー

### 処理シーケンス

```
[upgrade plan]
1. クラスター接続・設定取得
   └─ enforceRequirements()
2. 利用可能なアップグレード計算
   └─ upgrade.GetAvailableUpgrades()
3. ComponentConfig状態取得
   └─ componentconfigs.GetVersionStates()
4. プラン生成・出力
   └─ genUpgradePlan() → printer.PrintObj()

[upgrade apply]
1. 設定読み込み・クライアント作成
   └─ newApplyData()
2. フェーズ実行
   ├─ Preflight: 事前チェック
   ├─ ControlPlane: API Server等のアップグレード
   ├─ UploadConfig: 設定更新アップロード
   ├─ Kubeconfig: kubeconfig更新
   ├─ KubeletConfig: kubelet設定更新
   ├─ BootstrapToken: トークン更新
   ├─ Addon: CoreDNS/kube-proxy更新
   └─ PostUpgrade: アップグレード後処理
3. 成功メッセージ出力
```

### フローチャート

```mermaid
flowchart TD
    A[kubeadm upgrade] --> B{サブコマンド}
    B -->|plan| C[クラスター状態取得]
    B -->|apply| D[設定読み込み]
    B -->|diff| E[差分表示]
    B -->|node| F[ノードアップグレード]
    C --> G[利用可能バージョン計算]
    G --> H[ComponentConfig状態取得]
    H --> I[プラン出力]
    D --> J[Preflight]
    J --> K[ControlPlaneアップグレード]
    K --> L[設定/kubeconfigアップロード]
    L --> M[KubeletConfig更新]
    M --> N[Addonアップグレード]
    N --> O[PostUpgrade]
    O --> P[成功メッセージ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-120-01 | バージョン引数 | apply時のバージョン引数は必須（設定ファイルでの指定も可） | upgrade apply |
| BR-120-02 | バージョン上書き | 引数とconfigファイル両方でバージョン指定時は引数が優先 | 両方指定時 |
| BR-120-03 | 対話モード | --yes/--force/--dry-runがないときは対話的確認が必要 | upgrade apply |
| BR-120-04 | 証明書更新デフォルト | --certificate-renewalはデフォルトtrue | upgrade apply |
| BR-120-05 | etcdアップグレードデフォルト | --etcd-upgradeはデフォルトtrue | upgrade apply |
| BR-120-06 | 実験的バージョン | alpha/beta/rcバージョンは明示的な許可フラグが必要 | 不安定バージョン |
| BR-120-07 | kubeadm事前更新 | kubeadmバイナリ自体を先にアップグレードする必要がある | kubeadmバージョン < ターゲットバージョン |
| BR-120-08 | ConfigMap必須 | kubeadm-config ConfigMapが存在しない場合はアップグレード不可 | upgrade apply |

### 計算ロジック

アップグレードプラン生成: `genUpgradePlan()`が各コンポーネント（kubelet、kube-apiserver、kube-controller-manager、kube-scheduler、kube-proxy、CoreDNS、etcd、kubeadm）の現在バージョンとターゲットバージョンを比較してプランを生成する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | リソース | 説明 |
|------|---------|------|
| Read | ConfigMap (kubeadm-config) | 現在のクラスター設定取得 |
| Update | ConfigMap (kubeadm-config) | アップグレード後の設定更新 |
| Update | DaemonSet (kube-proxy) | kube-proxyのバージョン更新 |
| Update | Deployment (coredns) | CoreDNSのバージョン更新 |
| Read | Node | ノード情報の取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バージョン未指定 | apply時にバージョン引数も設定もない | バージョン引数の指定 |
| - | ConfigMap不在 | kubeadm-config ConfigMapが存在しない | upload-config phaseで再作成 |
| - | バージョン解析エラー | 不正なバージョン文字列 | 正しいセマンティックバージョンの指定 |
| - | kubeadm未更新 | kubeadmバイナリがターゲットバージョンより古い | kubeadmの事前更新 |
| - | 混合引数エラー | --configと個別フラグの不正な混合 | 設定ファイルまたはフラグのみ使用 |

### リトライ仕様

リトライなし（フェーズ単位での再実行が可能）

## トランザクション仕様

各フェーズは順序的に実行される。Static Podの更新はkubeletのファイル監視によりトリガーされ、ローリングで適用される。

## パフォーマンス要件

アップグレードは数分程度を要する。特にetcdアップグレードとコントロールプレーンの再起動に時間がかかる。ドライランモードにより事前に影響を確認可能。

## セキュリティ考慮事項

- アップグレード中はクラスターの可用性が一時的に低下する可能性がある
- --certificate-renewalにより証明書が自動更新される
- アップグレード先バージョンの信頼性を確認すること（特に--allow-experimental-upgrades使用時）

## 備考

- コントロールプレーンのアップグレード後、各ワーカーノードで`kubeadm upgrade node` + kubelet再起動が必要
- 1マイナーバージョンずつのアップグレードが推奨される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コマンド構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | upgrade.go | `cmd/kubeadm/app/cmd/upgrade/upgrade.go` | NewCmdUpgrade（44-67行目）で4サブコマンドの登録、applyPlanFlags（31-41行目）の共通フラグ |

#### Step 2: upgrade planを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | plan.go | `cmd/kubeadm/app/cmd/upgrade/plan.go` | newCmdPlan（58-87行目）、runPlan（100-148行目）でプラン生成 |
| 2-2 | plan.go | `cmd/kubeadm/app/cmd/upgrade/plan.go` | genUpgradePlan（151-157行目）、genAvailableUpgrade（183-233行目） |

#### Step 3: upgrade applyを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | apply.go | `cmd/kubeadm/app/cmd/upgrade/apply.go` | applyData構造体（62-78行目）、newCmdApply（81-160行目） |
| 3-2 | apply.go | `cmd/kubeadm/app/cmd/upgrade/apply.go` | newApplyData（163-298行目）で設定読み込み・検証 |

**読解のコツ**: apply.goの`cmdutil.ValueFromFlagsOrConfig()`パターンは、コマンドフラグと設定ファイルの値を統合するための重要なユーティリティ。フラグが明示的に設定されていればフラグ値を使用し、そうでなければ設定ファイルの値にフォールバックする。

#### Step 4: 出力フォーマッタを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | plan.go | `cmd/kubeadm/app/cmd/upgrade/plan.go` | upgradePlanTextPrinter（257-259行目）、printAvailableUpgrade（278-341行目）でテキスト出力 |

### プログラム呼び出し階層図

```
NewCmdUpgrade()
    │
    ├─ newCmdApply()
    │      │
    │      └─ workflow.NewRunner()
    │             ├─ PreflightPhase
    │             ├─ ControlPlanePhase
    │             ├─ UploadConfigPhase
    │             ├─ KubeconfigPhase
    │             ├─ KubeletConfigPhase
    │             ├─ BootstrapTokenPhase
    │             ├─ AddonPhase
    │             └─ PostUpgradePhase
    │
    ├─ newCmdPlan()
    │      └─ runPlan()
    │             ├─ enforceRequirements()
    │             ├─ upgrade.GetAvailableUpgrades()
    │             ├─ componentconfigs.GetVersionStates()
    │             └─ genUpgradePlan()
    │
    ├─ newCmdDiff()
    └─ newCmdNode()
```

### データフロー図

```
[入力]                    [処理]                          [出力]

ターゲットバージョン ──▶ enforceRequirements()
                            │
                    クラスター現在状態取得
                            │
              ┌─────────────┼──────────────┐
              │                            │
        [plan]                        [apply]
              │                            │
    GetAvailableUpgrades()         フェーズ順次実行
              │                            │
    genUpgradePlan()              Static Pod更新
              │                   Config更新
              │                   Addon更新
              ▼                            ▼
         stdout                    stdout (成功メッセージ)
    (アップグレードプラン)        /etc/kubernetes/ (更新ファイル)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| upgrade.go | `cmd/kubeadm/app/cmd/upgrade/upgrade.go` | ソース | upgradeコマンドのルートと共通フラグ |
| apply.go | `cmd/kubeadm/app/cmd/upgrade/apply.go` | ソース | upgrade apply の実装 |
| plan.go | `cmd/kubeadm/app/cmd/upgrade/plan.go` | ソース | upgrade plan の実装 |
| diff.go | `cmd/kubeadm/app/cmd/upgrade/diff.go` | ソース | upgrade diff の実装 |
| node.go | `cmd/kubeadm/app/cmd/upgrade/node.go` | ソース | upgrade node の実装 |
| common.go | `cmd/kubeadm/app/cmd/upgrade/common.go` | ソース | 共通ユーティリティ |
| phases/upgrade/ | `cmd/kubeadm/app/cmd/phases/upgrade/` | ソース | 各フェーズの実装 |
| phases/upgrade/apply/ | `cmd/kubeadm/app/cmd/phases/upgrade/apply/` | ソース | apply用フェーズ |
| phases/upgrade/ | `cmd/kubeadm/app/phases/upgrade/` | ソース | アップグレード処理の実装 |
