# 機能設計書 122-CSIボリューム

## 概要

本ドキュメントは、Container Storage Interface（CSI）ボリュームプラグインの設計を記述する。CSIは、コンテナオーケストレーションシステムにおけるストレージシステムとの標準インターフェースであり、外部ストレージドライバーをKubernetesに統合するためのプラグイン機構を提供する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesのストレージエコシステムを拡張性のある標準インターフェースで統一し、サードパーティのストレージプロバイダーがin-treeプラグインを必要とせずにKubernetesと連携できるようにする。

**機能の利用シーン**：PodがPersistentVolumeまたはCSI Ephemeralボリュームを使用してストレージをマウントする際に、kubeletがCSIドライバーとのgRPC通信を介してボリュームの公開・マウント・アンマウントを実行する。

**主要な処理内容**：
1. CSIドライバーの登録と管理（プラグインレジストリ）
2. NodePublishVolume（ボリュームのPodへの公開）
3. NodeUnpublishVolume（ボリュームのPodからの公開解除）
4. NodeStageVolume / NodeUnstageVolume（ブロックレベルのマウント/アンマウント）
5. ボリュームメタデータの永続化（vol_data.json）
6. FSGroup適用（ドライバーサポートまたはkubelet側での適用）

**関連システム・外部連携**：CSIドライバー（gRPC通信）、StorageClass、CSIDriver、CSINode、VolumeAttachmentリソース、ServiceAccountトークン。

**権限による制御**：CSIドライバーはノードのUNIXソケット経由で通信し、NodePublishSecretRef/NodeStageSecretRefによるシークレット参照で認証情報を渡す。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CSIボリュームはCLI画面を持たないkubelet内部処理 |

## 機能種別

ボリュームプラグイン / ストレージ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| driver | string | Yes | CSIドライバー名 | CSIDriverオブジェクトとの整合性確認 |
| volumeHandle | string | Yes | ボリュームの一意識別子（PV）/ CSIEphemeralではPodUID+名前のSHA256 | 空文字チェック |
| readOnly | bool | No | 読み取り専用フラグ | - |
| fsType | string | No | ファイルシステムタイプ | - |
| volumeAttributes | map[string]string | No | ボリューム属性 | - |
| nodePublishSecretRef | SecretReference | No | ノードパブリッシュ用シークレット参照 | Secret存在チェック |
| volumeLifecycleMode | VolumeLifecycleMode | Yes | Persistent/Ephemeral | CSIDriverのVolumeLifecycleModesとの整合性確認 |

### 入力データソース

- Pod Spec（Volume定義）
- PersistentVolume Spec（CSI ソース）
- CSIDriver オブジェクト（ドライバー機能情報）
- VolumeAttachment オブジェクト（PublishContext）
- Secret（認証情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| マウントポイント | ディレクトリ | Podのボリュームディレクトリ配下にマウントされたボリューム |
| vol_data.json | JSON | ボリュームメタデータ（specVolID、volumeHandle、driverName、nodeName、attachmentID、volumeLifecycleMode） |

### 出力先

- Pod内のボリュームマウントパス（`/var/lib/kubelet/pods/<podUID>/volumes/kubernetes.io~csi/<volumeName>/mount`）
- ボリュームメタデータ（同ディレクトリ配下の`vol_data.json`）

## 処理フロー

### 処理シーケンス（SetUpAt）

```
1. CSIクライアント取得（gRPC接続）
2. ボリュームソース判定（Ephemeral / Persistent）
3. VolumeLifecycleMode検証
4. FSGroupPolicy取得
5. [Persistent] STAGE_UNSTAGE_VOLUME capability確認
6. [Persistent] deviceMountPath構築
7. [Persistent] publishContext取得（VolumeAttachment経由）
8. ターゲットディレクトリ作成
9. NodePublishSecretRefからシークレット取得
10. Pod情報のvolume_attributesへの注入（podInfoEnabled時）
11. ServiceAccountトークン取得と注入
12. SELinux マウントオプション設定
13. vol_data.json保存
14. NodePublishVolume gRPC呼び出し
15. FSGroup適用（ドライバー非対応時）
```

### フローチャート

```mermaid
flowchart TD
    A[SetUpAt開始] --> B[CSIクライアント取得]
    B --> C{ボリュームソース?}
    C -->|Ephemeral| D[CSIVolumeSourceから設定取得]
    C -->|Persistent| E[PV CSISourceから設定取得]
    E --> F[STAGE_UNSTAGE確認]
    F --> G[publishContext取得]
    D --> H[ターゲットディレクトリ作成]
    G --> H
    H --> I[Secret取得]
    I --> J[Pod情報注入]
    J --> K[SAトークン取得]
    K --> L[vol_data.json保存]
    L --> M[NodePublishVolume RPC]
    M --> N{成功?}
    N -->|No| O[マウントディレクトリ削除]
    N -->|Yes| P{FSGroup適用必要?}
    P -->|Yes| Q[ChangePermissions実行]
    P -->|No| R[完了]
    Q --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-122-1 | VolumeLifecycleMode検証 | CSIDriverのVolumeLifecycleModesにモードが含まれていること | SetUp時 |
| BR-122-2 | FSGroupPolicy | CSIDriverのFSGroupPolicyに従いFSGroup適用方法を決定 | SetUp時 |
| BR-122-3 | VOLUME_MOUNT_GROUP | ドライバーがcapabilityを持つ場合はNodePublishにFSGroupを渡す | SetUp時 |
| BR-122-4 | エフェメラルVolumeHandle生成 | sha256(podUID + volSourceSpecName)でハンドルを生成 | Ephemeral SetUp時 |
| BR-122-5 | TransientOperationFailure | CSIドライバー不在時は一時的エラーとして扱う | SetUp/TearDown時 |
| BR-122-6 | SELinuxマウントオプション | SELinuxMountReadWriteOncePod有効時にマウントオプションにSELinuxラベルを追加 | SetUp時 |
| BR-122-7 | ServiceAccountTokenInSecrets | CSIDriverの設定によりSAトークンをシークレットに注入 | SetUp時 |

### 計算ロジック

- EphemeralボリュームのvolumeHandle: `csi-<sha256(podUID + volSourceSpecName)>`（`csi_mounter.go` 612-615行目）
- マウントパス: `<kubeletDir>/pods/<podUID>/volumes/kubernetes.io~csi/<specVolID>/mount`

## データベース操作仕様

| 操作 | 対象リソース | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ドライバー情報取得 | CSIDriver | SELECT | VolumeLifecycleModes、FSGroupPolicy確認 |
| アタッチ情報取得 | VolumeAttachment | SELECT | publishContext取得 |
| シークレット取得 | Secret | SELECT | NodePublishSecretRef |
| ノード情報取得 | CSINode | SELECT | トポロジー情報 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | TransientOperationFailure | CSIドライバーが一時的に利用不可 | kubeletが自動リトライ |
| - | UncertainProgressError | FSGroup適用失敗（マウントは成功） | 不確定状態として記録、Pod削除時にクリーンアップ |
| - | OperationFinishedError | NodePublishVolume RPCが永続的失敗 | マウントディレクトリを削除 |
| - | VolumeMode不一致 | CSIDriverがモードをサポートしない | エラーメッセージで使用可能モードを提示 |

### リトライ仕様

TransientOperationFailureとして返されたエラーはkubeletのvolume managerにより自動リトライされる。UncertainProgressErrorはPod削除時のクリーンアップで解消される。

## トランザクション仕様

vol_data.jsonの書き込みとNodePublishVolume RPCは個別に実行される。vol_data.json書き込み後にRPCが失敗した場合はマウントディレクトリ全体を削除することで一貫性を保つ。

## パフォーマンス要件

CSI RPCのタイムアウトはcsiTimeoutで制御される。ボリュームの公開/公開解除の速度はCSIドライバーの実装に依存する。

## セキュリティ考慮事項

- NodePublishSecretRef/NodeStageSecretRefによるシークレットの安全な受け渡し
- ServiceAccountトークンのBound Object Referenceによるスコープ制限
- SELinuxマウントオプションによるコンテナ間のアクセス制御
- vol_data.jsonにはノード名やドライバー名等のメタデータのみを保存（機密情報は含まない）

## 備考

- CSI仕様のバージョンにより利用可能なRPCが異なる場合がある
- Inline CSI Ephemeral Volumeは全てのCSIドライバーでサポートされるわけではない（CSIDriverのVolumeLifecycleModesで制御）

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | csi_mounter.go | `pkg/volume/csi/csi_mounter.go` | csiMountMgr構造体（63-79行目）: マウント管理の中心的データ構造 |
| 1-2 | csi_mounter.go | `pkg/volume/csi/csi_mounter.go` | volDataKey変数（44-61行目）: vol_data.jsonのキー定義 |
| 1-3 | csi_plugin.go | `pkg/volume/csi/csi_plugin.go` | csiPlugin構造体: プラグイン全体の管理構造体 |

**読解のコツ**: csiMountMgrがvolume.Mouneterとvolume.Unmounterの両方を実装している。csiClientGetterは埋め込みフィールドでCSIドライバーへのgRPC接続を取得する。

#### Step 2: プラグイン登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | csi_plugin.go | `pkg/volume/csi/csi_plugin.go` | Init()メソッド: ドライバー検出とレジストリ登録 |
| 2-2 | csi_plugin.go | `pkg/volume/csi/csi_plugin.go` | NewMounter()/NewUnmounter(): Mounter/Unmounterの生成 |
| 2-3 | csi_plugin.go | `pkg/volume/csi/csi_plugin.go` | CanSupport(): ボリュームスペックのCSIサポート判定 |

#### Step 3: マウント処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | csi_mounter.go | `pkg/volume/csi/csi_mounter.go` | SetUpAt()（102-356行目）: メインのマウント処理 |
| 3-2 | csi_mounter.go | `pkg/volume/csi/csi_mounter.go` | **102-118行目**: CSIクライアント取得とボリュームソース判定 |
| 3-3 | csi_mounter.go | `pkg/volume/csi/csi_mounter.go` | **146-208行目**: Ephemeral/Persistentの分岐処理 |
| 3-4 | csi_mounter.go | `pkg/volume/csi/csi_mounter.go` | **274-298行目**: vol_data.json保存 |
| 3-5 | csi_mounter.go | `pkg/volume/csi/csi_mounter.go` | **300-313行目**: NodePublishVolume RPC呼び出し |
| 3-6 | csi_mounter.go | `pkg/volume/csi/csi_mounter.go` | **333-352行目**: FSGroup適用 |

#### Step 4: アンマウント処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | csi_mounter.go | `pkg/volume/csi/csi_mounter.go` | TearDownAt()（432-467行目）: アンマウント処理 |
| 4-2 | csi_mounter.go | `pkg/volume/csi/csi_mounter.go` | removeMountDir()（583-609行目）: マウントディレクトリとメタデータのクリーンアップ |

### プログラム呼び出し階層図

```
kubelet volume manager
    |
    ├─ csiPlugin.NewMounter()
    |      └─ csiMountMgr{} 構築
    |
    ├─ csiMountMgr.SetUp()
    |      └─ SetUpAt()
    |             ├─ csiClientGetter.Get()  [gRPC接続]
    |             ├─ getSourceFromSpec()
    |             ├─ supportsVolumeLifecycleMode()
    |             ├─ getFSGroupPolicy()
    |             ├─ [Persistent] csi.NodeSupportsStageUnstage()
    |             ├─ [Persistent] getPublishContext()
    |             ├─ getCredentialsFromSecret()
    |             ├─ podServiceAccountTokenAttrs()
    |             ├─ saveVolumeData()  [vol_data.json]
    |             ├─ csi.NodePublishVolume()  [gRPC RPC]
    |             └─ volume.NewVolumeOwnership().ChangePermissions()
    |
    └─ csiMountMgr.TearDown()
           └─ TearDownAt()
                  ├─ csi.NodeUnpublishVolume()  [gRPC RPC]
                  └─ removeMountDir()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Pod Spec ──────────────▶ csiPlugin.NewMounter() ────────▶ csiMountMgr
PersistentVolume ──────▶     │
CSIDriver ─────────────▶     │
VolumeAttachment ──────▶     │
Secret ────────────────▶     │
                              │
csiMountMgr ───────────▶ SetUpAt()
                              │
                              ├──▶ vol_data.json (メタデータ)
                              ├──▶ NodePublishVolume gRPC
                              └──▶ マウントポイント (Pod内ディレクトリ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| csi_plugin.go | `pkg/volume/csi/csi_plugin.go` | ソース | CSIプラグイン登録・管理 |
| csi_mounter.go | `pkg/volume/csi/csi_mounter.go` | ソース | ボリュームのマウント/アンマウント |
| csi_attacher.go | `pkg/volume/csi/csi_attacher.go` | ソース | ボリュームのアタッチ/デタッチ |
| csi_client.go | `pkg/volume/csi/csi_client.go` | ソース | CSIドライバーへのgRPCクライアント |
| csi_util.go | `pkg/volume/csi/csi_util.go` | ソース | ユーティリティ関数 |
| csi_block.go | `pkg/volume/csi/csi_block.go` | ソース | ブロックデバイスサポート |
| csi_metrics.go | `pkg/volume/csi/csi_metrics.go` | ソース | メトリクス収集 |
| nodeinfomanager/ | `pkg/volume/csi/nodeinfomanager/` | ソース | CSINode情報管理 |
