# 機能設計書 127-Secretボリューム

## 概要

本ドキュメントは、Secretボリュームプラグインの設計を記述する。SecretボリュームはKubernetes Secretリソースのデータをファイルとしてtmpfs上のPod内にマウントする機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：機密情報（パスワード、トークン、TLS証明書等）をSecretとして管理し、ファイルシステム経由でコンテナに安全に提供する。ConfigMapと異なり、tmpfs（メモリ）上にマウントされるため、ディスク上に機密データが残留しない。

**機能の利用シーン**：Pod SpecでSecretボリュームを定義し、コンテナのvolumeMountsでマウントする。TLS証明書の配置、データベース接続情報の配置など。

**主要な処理内容**：
1. API ServerからSecretデータの取得
2. ペイロード（ファイル投影）の生成（MakePayload）
3. EmptyDir（Memory medium/tmpfs）を内部ラッパーとしたディレクトリセットアップ
4. AtomicWriterによるアトミックなファイル書き込み
5. FSGroup権限の適用
6. 定期的な再マウントによるSecret更新の反映

**関連システム・外部連携**：Kubernetes API Server（Secret取得）、EmptyDirプラグイン（Memory mediumラッパー）、AtomicWriter。

**権限による制御**：SecretのRBACによるアクセス制御。ファイルモードはdefaultModeまたはitems[].modeで個別指定可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | SecretボリュームはCLI画面を持たないkubelet内部処理 |

## 機能種別

ボリュームプラグイン / 機密データ投影

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| secretName | string | Yes | Secret名 | Secret存在チェック（optional=false時） |
| items | []KeyToPath | No | キーとパスのマッピング | 指定時はキー存在チェック |
| defaultMode | *int32 | No | デフォルトファイルパーミッション | nilでないこと |
| optional | *bool | No | Secret不在時にエラーとしない | - |

### 入力データソース

- Pod Spec（volumes[].secret）
- Secret API（namespace/secretName）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| データファイル | ファイル群 | Secretのdata各キーをファイル名、値（バイナリ）をファイル内容として配置 |
| シンボリックリンク | リンク | AtomicWriterによるアトミック更新用のシンボリックリンク構造 |

### 出力先

- `<kubeletDir>/pods/<podUID>/volumes/kubernetes.io~secret/<volumeName>/` (tmpfs上)

## 処理フロー

### 処理シーケンス（SetUpAt）

```
1. EmptyDirラッパーのセットアップ（Memory medium → tmpfsマウント）
2. Secret取得（getSecret API呼び出し）
   └─ optional=true時: NotFoundでも空Secretで継続
3. MakePayload: Secret data → FileProjection変換
   ├─ items未指定: 全キーをファイル名としてマッピング
   └─ items指定: 指定キーのみマッピング
4. wrappedのSetUpAtでtmpfsディレクトリ準備
5. MakeNestedMountpoints
6. AtomicWriter.Write: アトミックなファイル書き込み
7. FSGroup権限適用
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-127-1 | 読み取り専用 | Secretボリュームは常にReadOnly=true | 常時 |
| BR-127-2 | tmpfs使用 | wrappedVolumeSpecでStorageMediumMemoryを指定 | 常時 |
| BR-127-3 | 再マウント必須 | RequiresRemount=trueで定期更新をサポート | 常時 |
| BR-127-4 | optional対応 | optional=trueの場合、Secret不在でも空ファイルセットで継続 | optional指定時 |
| BR-127-5 | items未指定時 | Secretの全dataキーをファイルとして展開 | items未指定 |
| BR-127-6 | items指定時 | 指定されたキーのみ展開 | items指定 |
| BR-127-7 | セットアップ失敗時クリーンアップ | SetUp失敗時にdeferでTearDownを実行 | 失敗時 |

## データベース操作仕様

| 操作 | 対象リソース | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Secret取得 | Secret | SELECT | namespace/secretNameでSecret取得（キャッシュ経由） |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Secret不在 | optional=falseでSecretが存在しない | Secretの作成 |
| - | キー不在 | items指定でキーが存在しない（optional=false） | Secretにキーを追加 |
| - | defaultMode未指定 | defaultModeがnil | Pod Specの修正 |

### リトライ仕様

RequiresRemount=trueによるkubelet sync loop経由でのリトライ。

## トランザクション仕様

AtomicWriterによるアトミック更新を保証。

## パフォーマンス要件

Secret取得はkubeletのキャッシュを経由。tmpfs上のファイル操作のためI/Oは高速。

## セキュリティ考慮事項

- Secretデータはtmpfs（メモリ）上に保存され、ディスクには書き込まれない
- SecretのRBACによるアクセス制御が適用される
- ファイルパーミッションはdefaultMode/items[].modeで制御
- EncryptionConfiguration によるetcd内のSecret暗号化が推奨される

## 備考

- SecretボリュームとConfigMapボリュームは内部実装がほぼ同一（EmptyDirラッパー + AtomicWriter）
- 主な違いはWrappedVolumeSpecでのStorageMedium（Secret=Memory、ConfigMap=Default）
- MakePayload関数はProjectedボリュームからも呼び出される（エクスポート済み）

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | secret.go | `pkg/volume/secret/secret.go` | secretPlugin構造体（45-48行目）: host、getSecret |
| 1-2 | secret.go | `pkg/volume/secret/secret.go` | secretVolume構造体（138-144行目）: volName、podUID、plugin |
| 1-3 | secret.go | `pkg/volume/secret/secret.go` | secretVolumeMounter構造体（154-159行目）: source、pod、getSecret |
| 1-4 | secret.go | `pkg/volume/secret/secret.go` | wrappedVolumeSpec()（52-56行目）: **StorageMediumMemory指定**（ConfigMapとの重要な差異） |

#### Step 2: セットアップ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | secret.go | `pkg/volume/secret/secret.go` | SetUpAt()（176-256行目）: メインセットアップ（ConfigMapとほぼ同一構造） |
| 2-2 | secret.go | `pkg/volume/secret/secret.go` | **185-198行目**: Secret取得とoptional処理 |
| 2-3 | secret.go | `pkg/volume/secret/secret.go` | **207行目**: MakePayload呼び出し |
| 2-4 | secret.go | `pkg/volume/secret/secret.go` | **235-240行目**: AtomicWriter作成と書き込み |

#### Step 3: ペイロード生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | secret.go | `pkg/volume/secret/secret.go` | MakePayload()（259-295行目）: ファイル投影の生成 |
| 3-2 | secret.go | `pkg/volume/secret/secret.go` | **267-272行目**: items未指定時のdata全展開 |
| 3-3 | secret.go | `pkg/volume/secret/secret.go` | **273-293行目**: items指定時のキーマッピング |

### プログラム呼び出し階層図

```
kubelet volume manager
    |
    ├─ secretPlugin.NewMounter(spec, pod)
    |      └─ secretVolumeMounter{} 構築
    |
    ├─ secretVolumeMounter.SetUp()
    |      └─ SetUpAt(dir)
    |             ├─ host.NewWrapperMounter()  [EmptyDir(Memory)ラッパー]
    |             ├─ getSecret(namespace, secretName)  [API呼び出し]
    |             ├─ MakePayload(items, secret, defaultMode, optional)
    |             ├─ wrapped.SetUpAt()  [tmpfsセットアップ]
    |             ├─ volumeutil.MakeNestedMountpoints()
    |             ├─ volumeutil.NewAtomicWriter()
    |             └─ writer.Write(payload, setPerms)
    |
    └─ secretVolumeUnmounter.TearDown()
           └─ TearDownAt()
                  └─ volumeutil.UnmountViaEmptyDir()
```

### データフロー図

```
[入力]                          [処理]                       [出力]

SecretVolumeSource ─────▶ NewMounter() ────────▶ secretVolumeMounter
  secretName ───────────▶    │
  items ────────────────▶    │
  defaultMode ──────────▶    │
                              │
Secret API ─────────────▶ SetUpAt()
  data (map[string][]byte) ──▶  ├──▶ ファイル群（tmpfs上）
                                 └──▶ シンボリックリンク構造
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| secret.go | `pkg/volume/secret/secret.go` | ソース | メイン実装 |
| util/atomic_writer.go | `pkg/volume/util/atomic_writer.go` | ソース | アトミックファイル書き込み |
| emptydir/empty_dir.go | `pkg/volume/emptydir/empty_dir.go` | ソース | tmpfsラッパー |
