# 機能設計書 128-Projectedボリューム

## 概要

本ドキュメントは、Projectedボリュームプラグインの設計を記述する。Projectedボリュームは、複数のボリュームソース（Secret、ConfigMap、DownwardAPI、ServiceAccountToken、ClusterTrustBundle、PodCertificate）を単一のボリュームに統合してマウントする機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：アプリケーションが必要とする複数の設定ソースを、個別のボリュームではなく単一のマウントポイントにまとめて提供する。ServiceAccountトークンの自動マウント、信頼バンドルの配布、Pod証明書の提供等を統合的に管理する。

**機能の利用シーン**：Podのdefault ServiceAccountトークンの自動マウント（kubeletが自動的にProjectedボリュームを生成）、複数のConfigMap/Secretの統合マウント、ServiceAccountトークンの明示的なオーディエンス指定、ClusterTrustBundleの配布。

**主要な処理内容**：
1. 各ソースからのデータ収集（collectData）
   - Secret: secret.MakePayload呼び出し
   - ConfigMap: configmap.MakePayload呼び出し
   - DownwardAPI: downwardapi.CollectData呼び出し
   - ServiceAccountToken: TokenRequest API呼び出し
   - ClusterTrustBundle: 信頼アンカーの取得
   - PodCertificate: Pod証明書バンドルの取得
2. EmptyDir（Memory medium/tmpfs）ラッパーセットアップ
3. AtomicWriterによるアトミック書き込み
4. FSGroup権限適用
5. ティアダウン時のServiceAccountトークン削除

**関連システム・外部連携**：Secret API、ConfigMap API、TokenRequest API、ClusterTrustBundle API、PodCertificate API、DownwardAPI（fieldPath/resourceFieldRef）。

**権限による制御**：各ソースのRBACが適用される。ServiceAccountトークンのBoundObjectReferenceでPodへのスコープを制限。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | ProjectedボリュームはCLI画面を持たないkubelet内部処理 |

## 機能種別

ボリュームプラグイン / 統合データ投影

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sources | []VolumeProjection | Yes | 投影ソースリスト | 少なくとも1つのソースが必要 |
| defaultMode | *int32 | Yes | デフォルトファイルパーミッション | nilでないこと |

### VolumeProjectionソースタイプ

| ソースタイプ | 説明 |
|-------------|------|
| Secret | Secret参照（name、items、optional） |
| ConfigMap | ConfigMap参照（name、items、optional） |
| DownwardAPI | Downward API参照（items: fieldRef/resourceFieldRef） |
| ServiceAccountToken | SAトークン（audience、expirationSeconds、path） |
| ClusterTrustBundle | 信頼バンドル（name/signerName、labelSelector、optional、path） |
| PodCertificate | Pod証明書（credentialBundlePath、keyPath、certificateChainPath） |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| データファイル | ファイル群 | 全ソースのデータを統合したファイル群 |
| シンボリックリンク | リンク | AtomicWriterによるアトミック更新構造 |

### 出力先

- `<kubeletDir>/pods/<podUID>/volumes/kubernetes.io~projected/<volumeName>/` (tmpfs上)

## 処理フロー

### 処理シーケンス（SetUpAt）

```
1. EmptyDirラッパー（Memory medium）セットアップ
2. collectData: 全ソースからデータ収集
   ├─ Secret: getSecret → secret.MakePayload
   ├─ ConfigMap: getConfigMap → configmap.MakePayload
   ├─ DownwardAPI: downwardapi.CollectData
   ├─ ServiceAccountToken: getServiceAccountToken → TokenRequest
   ├─ ClusterTrustBundle: GetTrustAnchorsByName/BySigner
   └─ PodCertificate: GetPodCertificateCredentialBundle
3. wrappedのSetUpAt
4. MakeNestedMountpoints
5. AtomicWriter.Write
6. FSGroup権限適用
```

### フローチャート

```mermaid
flowchart TD
    A[SetUpAt開始] --> B[EmptyDirラッパーSetUp]
    B --> C[collectData]
    C --> D{ソースごとにループ}
    D -->|Secret| E[getSecret → MakePayload]
    D -->|ConfigMap| F[getConfigMap → MakePayload]
    D -->|DownwardAPI| G[CollectData]
    D -->|ServiceAccountToken| H[TokenRequest API]
    D -->|ClusterTrustBundle| I[GetTrustAnchors]
    D -->|PodCertificate| J[GetPodCertificateCredentialBundle]
    E --> K[payloadマージ]
    F --> K
    G --> K
    H --> K
    I --> K
    J --> K
    K --> L[wrappedSetUpAt]
    L --> M[AtomicWriter.Write]
    M --> N[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-128-1 | 読み取り専用 | Projectedボリュームは常にReadOnly=true | 常時 |
| BR-128-2 | tmpfs使用 | wrappedVolumeSpecでStorageMediumMemoryを指定 | 常時 |
| BR-128-3 | 再マウント必須 | RequiresRemount=trueで定期更新をサポート | 常時 |
| BR-128-4 | ペイロードマージ | 全ソースのペイロードを単一mapにマージ（後勝ち） | 常時 |
| BR-128-5 | SAトークンパーミッション | FsUser/FsGroupが設定されている場合、SAトークンは0600で作成 | SAトークンソース |
| BR-128-6 | エラー集約 | 複数ソースのエラーをutilerrors.NewAggregateで集約 | 常時 |
| BR-128-7 | ティアダウン時SAトークン削除 | TearDown時にdeleteServiceAccountTokenを呼び出し | ティアダウン時 |
| BR-128-8 | ClusterTrustBundle optional | optional=trueの場合、バンドル不在でも空コンテンツで継続 | CTBソース |
| BR-128-9 | PodCertificate出力パス | credentialBundlePath、keyPath、certificateChainPathを個別指定可能 | PodCertificateソース |

## データベース操作仕様

| 操作 | 対象リソース | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Secret取得 | Secret | SELECT | namespace/nameでSecret取得 |
| ConfigMap取得 | ConfigMap | SELECT | namespace/nameでConfigMap取得 |
| SAトークン取得 | TokenRequest | CREATE | ServiceAccountのトークン生成 |
| 信頼バンドル取得 | ClusterTrustBundle | SELECT | 名前またはsignerNameで取得 |
| Pod証明書取得 | PodCertificate | SELECT | Pod証明書バンドル取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Secret不在 | optional=falseでSecret不在 | Secretの作成 |
| - | ConfigMap不在 | optional=falseでConfigMap不在 | ConfigMapの作成 |
| - | TokenRequest失敗 | SAトークン生成エラー | ServiceAccount設定の確認 |
| - | CTB未設定 | nameもsignerNameも未設定 | VolumeProjection設定の修正 |
| - | defaultMode未指定 | defaultModeがnil | Pod Specの修正 |
| - | kubeClient不在 | kubeClientが設定されていない | kubelet設定の確認 |

### リトライ仕様

RequiresRemount=trueによるkubelet sync loop経由でのリトライ。個別ソースのエラーは集約されて返却される。

## トランザクション仕様

AtomicWriterによるアトミック更新を保証。セットアップ失敗時にdeferでTearDownを実行しクリーンアップ。

## パフォーマンス要件

複数のAPI呼び出しを含むため、ソース数に比例してセットアップ時間が増加する。kubeletキャッシュの活用で軽減される。

## セキュリティ考慮事項

- ServiceAccountトークンはBoundObjectReferenceでPodにスコープされる
- SAトークンとClusterTrustBundleのパーミッションは、FsUser/FsGroup設定時に0600に制限される
- 全データはtmpfs上に保存されディスクに残留しない
- PodCertificateの秘密鍵は安全にメモリ上で管理される

## 備考

- ServiceAccountトークンの自動マウントはkubeletがProjectedボリュームを自動生成することで実現される
- MakePayload関数はsecretパッケージおよびconfigmapパッケージのものを再利用
- CollectData関数はdownwardapiパッケージのものを再利用

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | projected.go | `pkg/volume/projected/projected.go` | projectedPlugin構造体（48-55行目）: 各種getter関数を保持 |
| 1-2 | projected.go | `pkg/volume/projected/projected.go` | projectedVolume構造体（150-156行目）: volName、sources、podUID |
| 1-3 | projected.go | `pkg/volume/projected/projected.go` | projectedVolumeMounter構造体（164-169行目）: source、pod |

#### Step 2: データ収集処理を理解する（最重要）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | projected.go | `pkg/volume/projected/projected.go` | collectData()（247-431行目）: 全ソースからのデータ収集 |
| 2-2 | projected.go | `pkg/volume/projected/projected.go` | **261-285行目**: Secretソース処理（secret.MakePayload呼び出し） |
| 2-3 | projected.go | `pkg/volume/projected/projected.go` | **286-310行目**: ConfigMapソース処理（configmap.MakePayload呼び出し） |
| 2-4 | projected.go | `pkg/volume/projected/projected.go` | **311-319行目**: DownwardAPIソース処理（downwardapi.CollectData呼び出し） |
| 2-5 | projected.go | `pkg/volume/projected/projected.go` | **320-354行目**: ServiceAccountTokenソース処理（TokenRequest API） |
| 2-6 | projected.go | `pkg/volume/projected/projected.go` | **355-390行目**: ClusterTrustBundleソース処理 |
| 2-7 | projected.go | `pkg/volume/projected/projected.go` | **391-427行目**: PodCertificateソース処理 |

**読解のコツ**: collectDataメソッドは大きなswitch文で構成されている。各caseが1つのソースタイプに対応し、それぞれのパッケージのMakePayload/CollectData関数を呼び出す。エラーは個別に集約リストに追加され、全ソース処理後にNewAggregateで返却される。

#### Step 3: セットアップ/ティアダウンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | projected.go | `pkg/volume/projected/projected.go` | SetUpAt()（186-245行目）: collectData → AtomicWriter.Write |
| 3-2 | projected.go | `pkg/volume/projected/projected.go` | TearDownAt()（443-457行目）: ラッパーTearDown + **deleteServiceAccountToken呼び出し** |

### プログラム呼び出し階層図

```
kubelet volume manager
    |
    ├─ projectedPlugin.NewMounter(spec, pod)
    |      └─ projectedVolumeMounter{} 構築
    |
    ├─ projectedVolumeMounter.SetUp()
    |      └─ SetUpAt(dir)
    |             ├─ host.NewWrapperMounter()  [EmptyDir(Memory)ラッパー]
    |             ├─ collectData(mounterArgs)
    |             |      ├─ [Secret] plugin.getSecret() → secret.MakePayload()
    |             |      ├─ [ConfigMap] plugin.getConfigMap() → configmap.MakePayload()
    |             |      ├─ [DownwardAPI] downwardapi.CollectData()
    |             |      ├─ [SAToken] plugin.getServiceAccountToken()
    |             |      ├─ [CTB] kvHost.GetTrustAnchorsByName/BySigner()
    |             |      └─ [PodCert] kvHost.GetPodCertificateCredentialBundle()
    |             ├─ wrapped.SetUpAt()
    |             ├─ volumeutil.MakeNestedMountpoints()
    |             ├─ volumeutil.NewAtomicWriter()
    |             └─ writer.Write(data, setPerms)
    |
    └─ projectedVolumeUnmounter.TearDown()
           └─ TearDownAt(dir)
                  ├─ host.NewWrapperUnmounter() → wrapped.TearDownAt()
                  └─ plugin.deleteServiceAccountToken(podUID)
```

### データフロー図

```
[入力]                               [処理]                      [出力]

ProjectedVolumeSource ──────▶ NewMounter()
  sources[] ────────────────▶    │
  defaultMode ──────────────▶    │
                                  │
Secret API ─────────────────▶ collectData()
ConfigMap API ──────────────▶    │
Pod Spec (DownwardAPI) ─────▶    │
TokenRequest API ───────────▶    │
ClusterTrustBundle API ─────▶    │
PodCertificate API ─────────▶    │
                                  ├──▶ 統合ペイロード (map[string]FileProjection)
                                  │
                              SetUpAt()
                                  ├──▶ ファイル群（tmpfs上）
                                  └──▶ シンボリックリンク構造
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| projected.go | `pkg/volume/projected/projected.go` | ソース | メイン実装（データ収集・統合マウント） |
| secret/secret.go | `pkg/volume/secret/secret.go` | ソース | Secret MakePayload |
| configmap/configmap.go | `pkg/volume/configmap/configmap.go` | ソース | ConfigMap MakePayload |
| downwardapi/downwardapi.go | `pkg/volume/downwardapi/downwardapi.go` | ソース | DownwardAPI CollectData |
| util/atomic_writer.go | `pkg/volume/util/atomic_writer.go` | ソース | アトミックファイル書き込み |
| emptydir/empty_dir.go | `pkg/volume/emptydir/empty_dir.go` | ソース | tmpfsラッパー |
