# 機能設計書 13-Namespaceコントローラー

## 概要

本ドキュメントは、Kubernetes Namespaceコントローラーの機能設計を記述する。Namespaceコントローラーは、Namespaceの削除時に関連リソースの一括削除（カスケード削除）を行う。

### 本機能の処理概要

**業務上の目的・背景**：KubernetesクラスタではリソースをNamespaceで論理的に分離する。Namespace削除時に、そこに属する全リソース（Pod、Service、ConfigMap、Secret等）を確実にクリーンアップしないと、孤立リソースが残りクラスタの状態が不整合になる。Namespaceコントローラーはこの一括削除を自動化し、Namespaceの完全な削除を保証する。

**機能の利用シーン**：テスト環境のクリーンアップ、テナント削除、不要リソースの一括削除など、Namespace単位でリソースを完全に削除する場面。

**主要な処理内容**：
1. DeletionTimestampが設定されたNamespaceの検出
2. Namespaceに属する全APIリソースのディスカバリー
3. 全リソースの一括削除実行
4. ファイナライザの除去によるNamespace削除の完了

**関連システム・外部連携**：API Server（リソースディスカバリーと削除操作）、etcd（リソース永続化）

**権限による制御**：Namespace削除権限はRBACで制御される。コントローラーはMetadata ClientおよびKubeClientを使用して全リソースタイプにアクセスする。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | Namespaceコントローラーは直接の画面を持たない |

## 機能種別

コントローラー（Reconciliation Loop） / カスケード削除

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| metadata.deletionTimestamp | *metav1.Time | - | 削除リクエスト時刻 | 設定されていればコントローラーが処理対象とする |
| spec.finalizers | []FinalizerName | - | Namespaceファイナライザ | kubernetes/kubernetesが標準 |

### 入力データソース

- Kubernetes API Server: Namespace Informer（Namespace変更通知）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| status.phase | NamespacePhase | Active -> Terminating |
| status.conditions | []NamespaceCondition | 削除進行状況 |

### 出力先

- Kubernetes API Server: Namespace内全リソースの削除、Namespaceステータス更新

## 処理フロー

### 処理シーケンス

```
1. Namespace Add/Updateイベント受信
   └─ DeletionTimestampが設定されている場合のみエンキュー（5秒遅延）
2. workerがデキューしsyncNamespaceFromKeyを実行
   └─ NamespaceListerからNamespace取得
3. namespacedResourcesDeleter.Delete実行
   └─ Namespace内全リソースの一括削除
4. 削除完了の場合
   └─ ファイナライザ除去によりNamespaceが完全削除される
5. リソースが残存する場合
   └─ ResourcesRemainingErrorの推定時間/2+1秒後にrequeue
```

### フローチャート

```mermaid
flowchart TD
    A[Namespace Informerイベント] --> B{DeletionTimestamp設定?}
    B -->|No| C[何もしない]
    B -->|Yes| D[5秒後にqueue追加]
    D --> E[syncNamespaceFromKey]
    E --> F{Namespace存在?}
    F -->|No| G[処理終了]
    F -->|Yes| H[namespacedResourcesDeleter.Delete]
    H --> I{全リソース削除完了?}
    I -->|Yes| J[ファイナライザ除去 → Namespace完全削除]
    I -->|No| K{ResourcesRemainingError?}
    K -->|Yes| L[推定時間/2+1秒後にrequeue]
    K -->|No| M[RateLimited requeue]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 削除遅延 | Namespaceイベントの処理を5秒遅延させる | 常時 |
| BR-02 | カスケード削除 | Namespace内の全APIリソースを検出・削除 | DeletionTimestamp設定時 |
| BR-03 | ファイナライザ除去 | 全リソース削除後にファイナライザを除去 | 削除完了時 |
| BR-04 | リトライ戦略 | リソース残存時は推定削除時間の半分+1秒後にリトライ | 削除未完了時 |

### 計算ロジック

- 削除遅延: namespaceDeletionGracePeriod = 5秒（HAセットアップでのアドミッション制御の伝播時間を考慮）
- リトライ間隔: estimate/2 + 1秒
- RateLimiter: 5ms～60秒のexponential backoff、全体で10qps/100バケット

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース削除 | 全Namespaced リソース (etcd) | DELETE | Namespace内の全リソースを削除 |
| ステータス更新 | Namespaces (etcd) | UPDATE | 削除条件の更新 |
| ファイナライザ除去 | Namespaces (etcd) | UPDATE | 削除完了後のファイナライザ除去 |

### テーブル別操作詳細

#### Namespaces (etcd)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | spec.finalizers | [] (空) | 全リソース削除完了時 |
| UPDATE | status.conditions | 削除進行状況 | 削除処理中に更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ResourcesRemainingError | 削除対象リソースが残存 | 推定時間後にリトライ |
| - | API Server通信エラー | リソース削除時のAPI呼び出し失敗 | RateLimited requeue |
| - | Discovery失敗 | APIリソースリストの取得失敗 | エラーとしてrequeue |

### リトライ仕様

- ResourcesRemainingError: estimate/2 + 1秒後にrequeue
- その他エラー: RateLimited requeue（5ms～60秒exponential backoff）

## トランザクション仕様

リソース削除は各リソースタイプごとに順次実行される。一部のリソース削除が失敗しても他のリソースの削除は継続される。全リソースの削除が完了した時点でファイナライザが除去される。

## パフォーマンス要件

- namespaceDeletionGracePeriod: 5秒（HAクラスタでの整合性確保）
- RateLimiter: 最大60秒のバックオフ、全体10qps

## セキュリティ考慮事項

- Metadata Clientを使用してリソースを削除するため、コントローラーは広範な削除権限を保有
- Namespace削除は監査ログに記録される

## 備考

- 5秒の遅延はHAクラスタでの整合性のため: 複数のAPIサーバーがNamespace削除を認識し、新規リソース作成をブロックする時間を確保
- namespacedResourcesDeleterの実装はdeletionサブパッケージにある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | namespace_controller.go | `pkg/controller/namespace/namespace_controller.go` | NamespaceController構造体（54-63行目） |

**読解のコツ**: namespacedResourcesDeleterインターフェースが実際の削除処理を担当。コントローラー本体はキュー管理とイベント処理に専念している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | namespace_controller.go | `pkg/controller/namespace/namespace_controller.go` | NewNamespaceController（66-104行目） |
| 2-2 | namespace_controller.go | `pkg/controller/namespace/namespace_controller.go` | Run（198-223行目） |

**主要処理フロー**:
1. **66-104行目**: NewNamespaceController: 初期化、Informerハンドラ登録
2. **120-136行目**: enqueueNamespace: DeletionTimestamp確認、5秒後にエンキュー
3. **142-175行目**: worker: デキューしてsyncNamespaceFromKeyを呼び出し
4. **178-195行目**: syncNamespaceFromKey: namespacedResourcesDeleter.Delete呼び出し
5. **198-223行目**: Run: キャッシュ同期後にワーカー起動

#### Step 3: 削除ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | deletion/ | `pkg/controller/namespace/deletion/` | NamespacedResourcesDeleterの実装 |

### プログラム呼び出し階層図

```
NewNamespaceController (初期化)
    |
    +-- Run (ワーカー起動)
        |
        +-- worker -> syncNamespaceFromKey
                |
                +-- namespacedResourcesDeleter.Delete
                        +-- discoverResourcesFn (APIリソースディスカバリー)
                        +-- deleteAllContentForGroupVersionResource (各リソース削除)
                        +-- updateNamespaceStatusFunc (ステータス更新)
                        +-- retryOnConflictError (conflict時リトライ)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

Namespace Informer --> enqueueNamespace --> syncNamespaceFromKey
                        (5秒遅延)              |
                                               +-- discoverResourcesFn --> APIリソースリスト取得
                                               +-- Delete(全リソース) --> 各リソース削除 (API Server)
                                               +-- ファイナライザ除去 --> Namespace削除完了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| namespace_controller.go | `pkg/controller/namespace/namespace_controller.go` | ソース | メインコントローラーロジック |
| deletion/ | `pkg/controller/namespace/deletion/` | ソース | Namespace内リソース削除の実装 |
| config/ | `pkg/controller/namespace/config/` | 設定 | コントローラー設定構造体 |
