# 機能設計書 135-Imageボリューム

## 概要

本ドキュメントは、Kubernetes における Image ボリュームプラグインの機能設計を記述する。Image ボリュームは、コンテナイメージの内容を読み取り専用ボリュームとして Pod にマウントする機能のスタブプラグインである。

### 本機能の処理概要

**業務上の目的・背景**：アプリケーションの設定ファイルやデータをコンテナイメージとしてパッケージ化し、Pod のボリュームとしてマウントする機能を提供する。これにより、イメージレジストリを通じた設定データの配布やバージョン管理が容易になる。KEP-4639 に基づく機能である。

**機能の利用シーン**：コンテナイメージに含まれるデータファイル（設定ファイル、モデルデータ等）を複数の Pod から参照する場合や、イメージのバージョン管理を活用してデータの配布を行う場合に使用される。

**主要な処理内容**：
1. ボリュームマネージャーが期待するインターフェースのスタブ実装を提供
2. 実際のマウント処理は kubelet 本体の ImageVolume 機能（フィーチャーゲート制御）で実行

**関連システム・外部連携**：コンテナランタイム（イメージの Pull とマウント）、イメージレジストリ

**権限による制御**：イメージの Pull 権限はコンテナランタイムの設定に依存する。ボリュームは常に読み取り専用。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は Pod 定義を通じて Kubelet が自動的に実行する |

## 機能種別

ボリュームプラグインスタブ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| reference | string | Yes | コンテナイメージの参照（例: myregistry/myimage:tag） | 有効なイメージ参照 |

### 入力データソース

- Volume の `.image` フィールド

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| - | - | スタブプラグインのため直接的な出力なし |

### 出力先

- 実際のマウント処理は kubelet 本体で行われる

## 処理フロー

### 処理シーケンス

```
1. プラグイン登録
   └─ ProbeVolumePlugins() で imagePlugin インスタンスを返却
2. CanSupport 判定
   └─ spec.Volume.Image が nil でないことを確認
3. GetVolumeName
   └─ ImageVolumeSource.Reference をボリューム名として返却
4. NewMounter / NewUnmounter
   └─ 自身（imagePlugin）をそのまま返却（全操作が no-op）
```

### フローチャート

```mermaid
flowchart TD
    A[Pod 定義に image ボリューム指定] --> B[CanSupport: spec.Volume.Image != nil]
    B --> C{サポート可能?}
    C -->|Yes| D[NewMounter: self を返却]
    C -->|No| E[他のプラグインに委譲]
    D --> F[SetUp/SetUpAt: no-op]
    F --> G[kubelet本体がImageVolume機能で実際のマウントを実行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-135-01 | 常に読み取り専用 | Image ボリュームは常に ReadOnly=true | 常時 |
| BR-135-02 | Managed=false | kubelet 本体で管理されるため、プラグインは管理しない | 常時 |
| BR-135-03 | PVのみでない | インラインボリュームとしてのみ使用可能（PV 経由ではない） | 常時 |
| BR-135-04 | SELinux 非対応 | SELinux コンテキストマウントは非サポート | 常時 |

## データベース操作仕様

本機能にはデータベース操作はない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | spec 不正 | volume.Image が nil | エラー返却（CanSupport で false を返す） |

### リトライ仕様

スタブプラグインのためリトライ機構はない。

## トランザクション仕様

該当なし。

## パフォーマンス要件

スタブプラグインのため、全操作は即時完了する。実際のイメージ Pull やマウントのパフォーマンスは kubelet 本体の実装に依存する。

## セキュリティ考慮事項

- 常に読み取り専用でマウントされるため、データの改ざんリスクはない
- イメージの Pull 認証はコンテナランタイムの設定に従う
- ImageVolume フィーチャーゲートにより機能の有効/無効を制御可能

## 備考

- プラグイン名: `kubernetes.io/image`
- KEP-4639 に基づく機能
- フィーチャーゲート: `ImageVolume`
- 本プラグインはスタブであり、実際のマウント処理は kubelet コードで実装される
- SupportsMountOption: false
- RequiresFSResize: false

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: スタブプラグインの全体構造

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | image.go | `pkg/volume/image/image.go` | imagePlugin 構造体（32-34行目）: MetricsNil を埋め込んだ最小構造 |
| 1-2 | image.go | `pkg/volume/image/image.go` | インターフェース実装宣言（36-39行目）: VolumePlugin, Mounter, Unmounter, Volume を実装 |
| 1-3 | image.go | `pkg/volume/image/image.go` | 全メソッドが no-op（86-91行目）: SetUp, TearDown 等が何もしない |

**読解のコツ**: このプラグインはスタブパターン。実際のロジックは kubelet 本体にあるため、このファイル単体では処理内容を理解できない。kubelet の ImageVolume 実装と合わせて読む必要がある。

#### Step 2: ボリューム識別

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | image.go | `pkg/volume/image/image.go` | GetVolumeName()（50-57行目）: ImageVolumeSource.Reference を名前として使用 |
| 2-2 | image.go | `pkg/volume/image/image.go` | CanSupport()（59-61行目）: spec.Volume.Image が非 nil であることを確認 |
| 2-3 | image.go | `pkg/volume/image/image.go` | getVolumeSource()（93-98行目）: spec から ImageVolumeSource を抽出 |

#### Step 3: GetAttributes の重要性

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | image.go | `pkg/volume/image/image.go` | GetAttributes()（75-81行目）: ReadOnly=true, Managed=false, SELinuxRelabel=false |

**主要処理フロー**:
- **75-81行目**: ReadOnly=true で常に読み取り専用。Managed=false で kubelet 本体に管理を委譲。

### プログラム呼び出し階層図

```
ProbeVolumePlugins() → imagePlugin
    │
    ├─ CanSupport() → spec.Volume.Image != nil
    │
    ├─ GetVolumeName() → ImageVolumeSource.Reference
    │
    ├─ NewMounter() → imagePlugin (self)
    │      ├─ SetUp() → no-op
    │      └─ SetUpAt() → no-op
    │
    └─ NewUnmounter() → imagePlugin (self)
           ├─ TearDown() → no-op
           └─ TearDownAt() → no-op
```

### データフロー図

```
[入力]                    [処理]                       [出力]

Volume Spec         ──▶ getVolumeSource()         ──▶ *ImageVolumeSource
  (image.reference)

ImageVolumeSource   ──▶ GetVolumeName()           ──▶ reference (string)

(actual mount is performed by kubelet core, not this plugin)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| image.go | `pkg/volume/image/image.go` | ソース | プラグインスタブの全実装 |
| image_test.go | `pkg/volume/image/image_test.go` | テスト | ユニットテスト |
