# 機能設計書 137-LimitRange管理

## 概要

本ドキュメントは、Kubernetes における LimitRange 管理機能の設計を記述する。Namespace ごとのデフォルトリソースリクエスト/リミット設定の管理を行う機能である。

### 本機能の処理概要

**業務上の目的・背景**：Pod やコンテナに対してリソースリクエスト/リミットのデフォルト値、最小値、最大値を設定し、リソース使用量の一貫した管理を実現する。開発者がリソース設定を省略した場合にもデフォルト値が適用されることで、リソース管理の抜け漏れを防止する。

**機能の利用シーン**：クラスター管理者が Namespace ごとにリソースの制約を設けて、Pod やコンテナのリソース消費を制御する場合に使用される。

**主要な処理内容**：
1. LimitRange オブジェクトの CRUD 操作（REST API）
2. 作成時の名前自動生成（名前が空の場合に UUID を自動付与）
3. 作成・更新時のバリデーション
4. Admission Controller との連携によるデフォルト値の適用と制限の強制

**関連システム・外部連携**：kube-apiserver（REST API）、etcd（永続化）、LimitRanger Admission Controller

**権限による制御**：RBAC により LimitRange オブジェクトの作成・更新・削除・参照が制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | kubectl や API を通じて操作 |

## 機能種別

リソース管理（API リソースの CRUD）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| metadata.name | string | No | LimitRange 名。未指定時は UUID 自動生成 | DNS サブドメイン準拠 |
| metadata.namespace | string | Yes | 対象 Namespace | 有効な Namespace 名 |
| spec.limits | []LimitRangeItem | Yes | リソース制限の定義リスト | 各アイテムの type, default, defaultRequest, min, max, maxLimitRequestRatio |

### 入力データソース

- Kubernetes REST API

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| spec.limits | []LimitRangeItem | 設定されたリソース制限 |

### 出力先

- etcd（永続化）
- REST API レスポンス

## 処理フロー

### 処理シーケンス

```
1. Create リクエスト受信
   └─ PrepareForCreate: 名前が空の場合に UUID を自動生成
2. バリデーション
   └─ ValidateLimitRange: Spec の妥当性検証
3. etcd への永続化
   └─ genericregistry.Store を通じて保存
```

### フローチャート

```mermaid
flowchart TD
    A[Create リクエスト] --> B{名前が空?}
    B -->|Yes| C[UUID を自動生成]
    B -->|No| D[バリデーション]
    C --> D
    D --> E{バリデーション OK?}
    E -->|Yes| F[etcd に保存]
    E -->|No| G[エラー返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-137-01 | Namespace スコープ | LimitRange は Namespace スコープのリソース | 常時 |
| BR-137-02 | 名前自動生成 | 名前が空の場合は UUID を自動付与 | Create 時に名前が空 |
| BR-137-03 | AllowCreateOnUpdate | true - Update で新規作成を許可 | Update 時 |
| BR-137-04 | AllowUnconditionalUpdate | true - 無条件更新を許可 | Update 時 |
| BR-137-05 | 更新バリデーション | Update 時もCreate時と同じバリデーション（ValidateLimitRange）を実行 | Update 時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象リソース | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Create | LimitRange | INSERT | 新規 LimitRange の作成 |
| Update | LimitRange | UPDATE | LimitRange の更新 |
| Delete | LimitRange | DELETE | LimitRange の削除 |
| Get/List | LimitRange | SELECT | LimitRange の取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | BadRequest | バリデーションエラー | エラーメッセージと共に拒否 |
| 422 | UnprocessableEntity | 不正なリソース制限定義 | エラーメッセージと共に拒否 |

## トランザクション仕様

etcd のトランザクション機構に依存。楽観的ロック（ResourceVersion）による更新競合検出。

## パフォーマンス要件

通常の Kubernetes API オブジェクト操作と同等。

## セキュリティ考慮事項

- RBAC により LimitRange の管理権限を制御
- ショートネーム `limits` でアクセス可能
- Status サブリソースは存在しない（ResourceQuota とは異なる）

## 備考

- ショートネーム: `limits`
- LimitRange には Status サブリソースがない（Strategy のみで Status Strategy は不要）
- PrepareForUpdate は no-op

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: Strategy パターンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | strategy.go | `pkg/registry/core/limitrange/strategy.go` | limitrangeStrategy 構造体（31-34行目）: ObjectTyper と NameGenerator を埋め込み |
| 1-2 | strategy.go | `pkg/registry/core/limitrange/strategy.go` | PrepareForCreate()（44-49行目）: 名前が空の場合にUUIDを自動生成。**これは他のリソースでは珍しいパターン** |
| 1-3 | strategy.go | `pkg/registry/core/limitrange/strategy.go` | PrepareForUpdate()（51-52行目）: no-op（何もしない） |
| 1-4 | strategy.go | `pkg/registry/core/limitrange/strategy.go` | ValidateUpdate()（72-75行目）: Create時と同じ ValidateLimitRange を使用 |

**読解のコツ**: LimitRange は ResourceQuota と比較してシンプルな構造。Status サブリソースがなく、Strategy も1つのみ。

#### Step 2: Storage レイヤー

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | storage.go | `pkg/registry/core/limitrange/storage/storage.go` | NewREST()（34-53行目）: Store の初期化。StatusREST は存在しない |
| 2-2 | storage.go | `pkg/registry/core/limitrange/storage/storage.go` | ShortNames()（59-61行目）: "limits" ショートネーム |

### プログラム呼び出し階層図

```
REST API リクエスト
    │
    ├─ Create → genericregistry.Store
    │      ├─ Strategy.PrepareForCreate() [名前空ならUUID生成]
    │      ├─ Strategy.Validate() → validation.ValidateLimitRange()
    │      └─ Strategy.WarningsOnCreate() → nil
    │
    └─ Update → genericregistry.Store
           ├─ Strategy.PrepareForUpdate() [no-op]
           └─ Strategy.ValidateUpdate() → validation.ValidateLimitRange()
```

### データフロー図

```
[入力]                    [処理]                       [出力]

API Request         ──▶ PrepareForCreate()        ──▶ LimitRange (with name)
  (LimitRange)           名前未設定ならUUID付与

LimitRange          ──▶ ValidateLimitRange()       ──▶ field.ErrorList
                         min <= default <= max 等

validated object    ──▶ etcd store                 ──▶ persisted LimitRange
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| strategy.go | `pkg/registry/core/limitrange/strategy.go` | ソース | Create/Update 戦略定義 |
| storage/storage.go | `pkg/registry/core/limitrange/storage/storage.go` | ソース | REST ストレージ実装 |
| validation.go | `pkg/apis/core/validation/validation.go` | ソース | バリデーションロジック |
