# 機能設計書 14-ServiceAccountコントローラー

## 概要

本ドキュメントは、Kubernetes ServiceAccountコントローラーの機能設計を記述する。各Namespaceにデフォルトサービスアカウントを自動作成し、トークンの管理を行う。

### 本機能の処理概要

**業務上の目的・背景**：KubernetesではPodがAPI Serverにアクセスする際にServiceAccountを使用する。全Namespaceに「default」ServiceAccountが存在することを保証し、Podがデフォルトの認証情報で動作できるようにする必要がある。

**機能の利用シーン**：Namespace作成時のdefault ServiceAccount自動作成、ServiceAccount削除時の自動再作成、新規Namespaceでのワークロード実行開始時。

**主要な処理内容**：
1. Namespace作成イベントの検出とdefault ServiceAccountの自動作成
2. ServiceAccount削除イベントの検出と必要に応じた再作成
3. Namespace更新時のServiceAccount存在確認

**関連システム・外部連携**：API Server（ServiceAccountリソースの作成）、認証システム（ServiceAccountトークン）

**権限による制御**：コントローラーはServiceAccountの作成権限を持つ。各NamespaceのServiceAccountはRBACバインディングの対象となる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | ServiceAccountコントローラーは直接の画面を持たない |

## 機能種別

コントローラー（Reconciliation Loop） / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ServiceAccountsToEnsure | []v1.ServiceAccount | Yes | 各Namespaceで保証するServiceAccountリスト | デフォルト: [{Name: "default"}] |
| ServiceAccountResync | time.Duration | No | ServiceAccount再同期間隔 | - |
| NamespaceResync | time.Duration | No | Namespace再同期間隔 | - |

### 入力データソース

- Kubernetes API Server: ServiceAccount Informer
- Kubernetes API Server: Namespace Informer

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ServiceAccount | v1.ServiceAccount | 作成されたServiceAccount（Name: "default"） |

### 出力先

- Kubernetes API Server: ServiceAccountリソースの作成

## 処理フロー

### 処理シーケンス

```
1. イベント受信（Namespace Add/Update、ServiceAccount Delete）
   └─ Namespace名をworkqueueにエンキュー
2. workerがデキューしsyncNamespaceを実行
3. Namespaceの状態確認
   └─ NotFound: 処理スキップ / Activeでない: 処理スキップ
4. serviceAccountsToEnsureリストの各SAについて
   a. SAListerで存在確認
   b. 存在しない場合: API Serverに作成リクエスト
   c. AlreadyExists: スキップ（正常）
   d. NamespaceTerminating: スキップ
```

### フローチャート

```mermaid
flowchart TD
    A[Namespace Add/Update or SA Delete] --> B[Namespace名をエンキュー]
    B --> C[syncNamespace実行]
    C --> D{Namespace Active?}
    D -->|No| E[処理終了]
    D -->|Yes| F[serviceAccountsToEnsureをループ]
    F --> G{SA存在?}
    G -->|Yes| H[スキップ]
    G -->|No| I[SA作成]
    I --> J{作成成功?}
    J -->|Yes| K[次のSA]
    J -->|AlreadyExists| K
    J -->|Error| L[エラー集約]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | default SA保証 | 全ActiveなNamespaceにdefault SAを保証 | 常時 |
| BR-02 | 非Active Namespace | Active以外のNamespaceでは作成しない | Namespace.Status.Phase != Active |
| BR-03 | 冪等性 | AlreadyExistsの場合はエラーとしない | SA作成時 |
| BR-04 | Terminating除外 | NamespaceTerminatingエラーは無視 | SA作成時 |

### 計算ロジック

特に計算ロジックはない。ServiceAccountの存在確認と作成のみ。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| SA存在確認 | ServiceAccounts (etcd) | SELECT | Listerキャッシュから確認 |
| SA作成 | ServiceAccounts (etcd) | INSERT | default SA作成 |

### テーブル別操作詳細

#### ServiceAccounts (etcd)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | metadata.name | "default" | デフォルト設定 |
| INSERT | metadata.namespace | {Namespace名} | 対象Namespace |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | AlreadyExists | SA既存 | 正常として処理続行 |
| - | NamespaceTerminating | Namespace削除中 | 無視して処理続行 |
| - | API通信エラー | SA作成失敗 | エラー集約してRateLimited requeue |

### リトライ仕様

- syncNamespace失敗時: RateLimited requeue

## トランザクション仕様

各ServiceAccountは個別にAPI Serverに作成リクエストを送信する。一部の作成が失敗した場合もエラーを集約し、全体としてリトライする。

## パフォーマンス要件

- 特になし。Namespace数に比例する処理量だが、通常は低頻度の操作。

## セキュリティ考慮事項

- default ServiceAccountは最小権限で作成される
- 追加の権限はRoleBindingで明示的に付与する必要がある

## 備考

- ServiceAccountsControllerOptionsで保証するSAリストをカスタマイズ可能（デフォルトは"default"のみ）
- tokens_controller.goにはSA用トークンの管理ロジックが含まれるが、本コントローラーとは別のコントローラーとして動作
- legacy_serviceaccount_token_cleaner.goにはレガシートークンのクリーンアップロジックが含まれる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | serviceaccounts_controller.go | `pkg/controller/serviceaccount/serviceaccounts_controller.go` | ServiceAccountsControllerOptions（40-53行目）とServiceAccountsController構造体（96-110行目） |

**読解のコツ**: このコントローラーは非常にシンプル。syncHandlerフィールドで同期ハンドラを差し替え可能にしてテスタビリティを確保している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | serviceaccounts_controller.go | `pkg/controller/serviceaccount/serviceaccounts_controller.go` | NewServiceAccountsController（65-93行目） |
| 2-2 | serviceaccounts_controller.go | `pkg/controller/serviceaccount/serviceaccounts_controller.go` | Run（113-136行目） |

**主要処理フロー**:
1. **65-93行目**: Informerハンドラ登録（SA削除、NS追加/更新）
2. **113-136行目**: キャッシュ同期後にワーカー起動
3. **192-232行目**: syncNamespace: SA存在確認と作成

#### Step 3: 同期処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | serviceaccounts_controller.go | `pkg/controller/serviceaccount/serviceaccounts_controller.go` | syncNamespace（192-232行目）: メインの同期ロジック |

### プログラム呼び出し階層図

```
NewServiceAccountsController (初期化)
    |
    +-- Run (ワーカー起動)
        |
        +-- runWorker -> processNextWorkItem -> syncHandler (= syncNamespace)
                |
                +-- nsLister.Get (Namespace取得)
                +-- saLister.ServiceAccounts(ns).Get (SA存在確認)
                +-- client.CoreV1().ServiceAccounts(ns).Create (SA作成)
```

### データフロー図

```
[入力]                         [処理]                    [出力]

Namespace Informer ---+
                      |--> queue --> syncNamespace --> ServiceAccount作成 (API Server)
ServiceAccount Informer (Delete) -+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| serviceaccounts_controller.go | `pkg/controller/serviceaccount/serviceaccounts_controller.go` | ソース | SA自動作成コントローラー |
| tokens_controller.go | `pkg/controller/serviceaccount/tokens_controller.go` | ソース | SAトークン管理（別コントローラー） |
| legacy_serviceaccount_token_cleaner.go | `pkg/controller/serviceaccount/legacy_serviceaccount_token_cleaner.go` | ソース | レガシートークンクリーンアップ |
| tokengetter.go | `pkg/controller/serviceaccount/tokengetter.go` | ソース | トークン取得ユーティリティ |
| config/ | `pkg/controller/serviceaccount/config/` | 設定 | コントローラー設定構造体 |
