# 機能設計書 144-client-go

## 概要

本ドキュメントは、Kubernetes Goクライアントライブラリ（client-go）の設計について記述する。client-goはKubernetes APIとのREST通信、型付きクライアント（clientset）、Informer/Listerによるキャッシュ機構、動的クライアント等の機能を提供する基盤ライブラリである。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesの全コンポーネント（コントローラー、スケジューラー、kubeletなど）およびユーザーアプリケーションがAPI Serverと通信するための統一されたクライアントライブラリが必要である。client-goはこのニーズを満たし、Go言語でKubernetes APIを操作するための包括的なツールキットを提供する。

**機能の利用シーン**：カスタムコントローラー開発、オペレーター開発、CLI ツール開発、Kubernetesコア内部コンポーネントでのAPI通信、Informerによるリソース監視とキャッシュ。

**主要な処理内容**：
1. REST通信基盤: HTTP/HTTPS通信、認証・認可ヘッダー付与、レートリミット
2. clientset: 全APIグループ/バージョンの型付きクライアントを提供
3. Informer: Watch APIによるリソース変更の監視とローカルキャッシュの維持
4. Lister: Informerキャッシュからのリソース取得
5. Dynamic Client: 型なしのUnstructuredオブジェクトによるAPIアクセス
6. Discovery: APIリソースの動的検出
7. Scale Client: Deployment等のスケーリング操作

**関連システム・外部連携**：API Server、kubeconfig、ServiceAccountトークン、各種認証プラグイン

**権限による制御**：kubeconfigまたはServiceAccountの認証情報に基づき、RBAC等で認可されたリソースのみアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 全kubectlコマンド | 基盤ライブラリ | kubectlの全APIアクセスでclient-goが使用される |

## 機能種別

ライブラリ / API通信基盤

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| rest.Config.Host | string | Yes | API Serverのホスト/URL | 有効なURL形式 |
| rest.Config.BearerToken | string | No | Bearerトークン | 有効なトークン文字列 |
| rest.Config.TLSClientConfig | TLSClientConfig | No | TLSクライアント設定 | 有効な証明書/鍵 |
| rest.Config.QPS | float32 | No | レートリミットQPS（デフォルト5.0） | 正の値 |
| rest.Config.Burst | int | No | レートリミットバースト（デフォルト10） | 正の整数 |

### 入力データソース

- kubeconfigファイル（~/.kube/config）
- インクラスター設定（ServiceAccountトークン + 環境変数）
- 明示的なrest.Config構造体

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| REST応答 | runtime.Object | APIリソースオブジェクト |
| Watch Event | watch.Event | リソース変更イベント（Added/Modified/Deleted） |
| Informer Cache | Store | ローカルキャッシュのリソース一覧 |
| Discovery Info | APIResourceList | 利用可能なAPIリソース情報 |

### 出力先

呼び出し元のGoアプリケーション。

## 処理フロー

### 処理シーケンス

```
1. 設定の読み込み
   └─ kubeconfigまたはインクラスター設定からrest.Configを構築
2. HTTP Clientの構築
   └─ TLS設定、認証プラグイン、レートリミッターの設定
3. Clientset/DynamicClient/DiscoveryClientの初期化
   └─ rest.Configを基にAPIグループごとのクライアントを作成
4. API呼び出し
   └─ Request構築 -> レートリミット -> HTTP送信 -> レスポンスデシリアライズ
5. Informer起動（オプション）
   └─ List + Watch → ローカルキャッシュ同期 → EventHandlerコールバック
```

### フローチャート

```mermaid
flowchart TD
    A[rest.Config構築] --> B[HTTP Client生成]
    B --> C{クライアント種別}
    C -->|clientset| D[Typed Client]
    C -->|dynamic| E[Dynamic Client]
    C -->|discovery| F[Discovery Client]
    D --> G[Request構築]
    G --> H[Rate Limiter]
    H --> I[HTTP送信]
    I --> J[レスポンスデシリアライズ]
    D --> K[Informer起動]
    K --> L[List初回取得]
    L --> M[Watch開始]
    M --> N[Event Handler呼び出し]
    N --> O[ローカルキャッシュ更新]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-144-01 | デフォルトQPS/Burst | QPS=5.0, Burst=10がデフォルト値 | rest.Config未指定時 |
| BR-144-02 | インクラスター検出 | KUBERNETES_SERVICE_HOSTとKUBERNETES_SERVICE_PORT環境変数が必須 | InClusterConfig使用時 |
| BR-144-03 | Informer再同期 | List + Watchパターンでキャッシュを維持し、Watch切断時は自動再接続 | Informer使用時 |
| BR-144-04 | スロットリングログ | 50ms以上のスロットリングはログ出力 | レートリミット適用時 |

### 計算ロジック

レートリミット: トークンバケットアルゴリズムにより、QPSとBurst値に基づきリクエスト頻度を制御する。

## データベース操作仕様

本機能はクライアントライブラリであり、直接的なデータベース操作は行わない。API Server経由でetcdに永続化される。

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| API呼び出し | API Server経由etcd | CRUD | 全リソースに対するCRUD操作をAPI Server経由で実行 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ErrNotInCluster | インクラスター設定の環境変数が未定義 | kubeconfigを明示的に指定 |
| 401 | Unauthorized | 認証失敗 | 認証情報を確認 |
| 403 | Forbidden | 認可失敗 | RBACを確認 |
| 429 | TooManyRequests | API Serverのレートリミット | バックオフして再試行 |
| 504 | Timeout | リクエストタイムアウト | タイムアウト値を調整 |

### リトライ仕様

APIレスポンスのRetry-Afterヘッダーに基づくリトライ、指数バックオフによる自動再試行をサポート。

## トランザクション仕様

client-go自体はトランザクション機能を持たない。楽観的並行制御はresourceVersionフィールドによりAPI Server側で実現される。

## パフォーマンス要件

- Informerキャッシュにより、リスト取得はローカルメモリから実行され、API Server負荷を軽減
- デフォルトのQPS/Burst値は小規模環境向け。大規模環境では値を増加させる必要がある

## セキュリティ考慮事項

- BearerTokenやClientCertificateは機密情報として扱い、rest.Config構造体での取り扱いに注意
- TLS検証はデフォルトで有効。Insecure=trueの設定は本番環境では非推奨
- ServiceAccountトークンのファイルは定期的に読み込み直される（BearerTokenFile）

## 備考

- client-goはKubernetesリポジトリの`staging/src/k8s.io/client-go`に格納され、独立したGoモジュールとして公開される
- gentype パッケージにより、型付きクライアントの生成が自動化されている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config.go | `staging/src/k8s.io/client-go/rest/config.go` | rest.Config構造体 -- API Server接続設定の全フィールド |

**読解のコツ**: Config構造体はclient-goの中核であり、Host、認証情報（BearerToken、TLS）、QPS/Burst等を保持する。`datapolicy`タグは機密情報のマーキングに使用される。

**主要処理フロー**:
- **46-49行目**: DefaultQPS=5.0, DefaultBurst=10の定数定義
- **51行目**: ErrNotInCluster -- インクラスター設定エラー
- **55-80行目**: Config構造体定義 -- Host, APIPath, 認証情報, TLS設定等

#### Step 2: リクエスト処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | request.go | `staging/src/k8s.io/client-go/rest/request.go` | REST APIリクエストの構築と送信 |

**主要処理フロー**:
- **53-61行目**: スロットリングの閾値定義（50ms/1s）
- **64-66行目**: HTTPClientインターフェース
- **70-73行目**: ResponseWrapperインターフェース -- DoRaw, Stream

#### Step 3: clientsetを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | clientset.go | `staging/src/k8s.io/client-go/kubernetes/clientset.go` | 型付きクライアントのエントリーポイント |

#### Step 4: Informer/Listerを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | factory.go | `staging/src/k8s.io/client-go/informers/factory.go` | SharedInformerFactoryの生成 |

### プログラム呼び出し階層図

```
ユーザーアプリケーション / Kubernetesコンポーネント
    |
    +-- rest.Config (接続設定)
    |       +-- InClusterConfig() / BuildConfigFromFlags()
    |
    +-- kubernetes.NewForConfig(config) → Clientset
    |       +-- CoreV1Client
    |       |       +-- Pods(), Services(), Nodes() ...
    |       +-- AppsV1Client
    |       |       +-- Deployments(), StatefulSets() ...
    |       +-- (各APIグループClient)
    |
    +-- dynamic.NewForConfig(config) → DynamicClient
    |       +-- Resource(gvr).Namespace(ns).Get/List/Create/Update/Delete
    |
    +-- informers.NewSharedInformerFactory(clientset, resync)
    |       +-- Core().V1().Pods().Informer() → SharedInformer
    |       |       +-- AddEventHandler()
    |       |       +-- Lister()
    |       +-- Start() → Watch開始
    |
    +-- rest.RESTClientFor(config) → RESTClient
            +-- Get/Post/Put/Delete/Patch
                    +-- flowcontrol.RateLimiter
                    +-- HTTP Transport (TLS, Auth)
                    +-- API Server
```

### データフロー図

```
[入力]                     [処理]                          [出力]

kubeconfig ──────> rest.Config ──────> RESTClient ──────> API Server
  or                                       |
ServiceAccount               Informer ←── Watch Event ←── API Server
  token                          |
                            Local Cache ──> Lister ──────> アプリケーション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| config.go | `staging/src/k8s.io/client-go/rest/config.go` | ソース | REST Config構造体定義 |
| request.go | `staging/src/k8s.io/client-go/rest/request.go` | ソース | RESTリクエスト構築・送信 |
| transport.go | `staging/src/k8s.io/client-go/rest/transport.go` | ソース | HTTPトランスポート設定 |
| clientset.go | `staging/src/k8s.io/client-go/kubernetes/clientset.go` | ソース | 型付きクライアントセット |
| factory.go | `staging/src/k8s.io/client-go/informers/factory.go` | ソース | Informerファクトリー |
| dynamic/ | `staging/src/k8s.io/client-go/dynamic/` | ソース | 動的クライアント |
| discovery/ | `staging/src/k8s.io/client-go/discovery/` | ソース | APIディスカバリー |
| scale/ | `staging/src/k8s.io/client-go/scale/` | ソース | スケールクライアント |
| plugin/ | `staging/src/k8s.io/client-go/plugin/` | ソース | 認証プラグイン |
| features/ | `staging/src/k8s.io/client-go/features/` | ソース | フィーチャーゲート |
