# 機能設計書 145-apimachinery

## 概要

本ドキュメントは、Kubernetes apimachineryライブラリの設計について記述する。apimachineryはAPIオブジェクトの型定義、スキーマ管理、シリアライズ/デシリアライズ、バージョン変換等の基盤機能を提供するライブラリである。

### 本機能の処理概要

**業務上の目的・背景**：KubernetesのAPIオブジェクトは複数のバージョン（v1, v1beta1等）を持ち、内部表現と外部表現の間で変換が必要である。apimachineryはこのバージョニングシステムの基盤を提供し、全APIオブジェクトの型登録、シリアライズ、バリデーション、デフォルティング等の共通処理を統一的に扱えるようにする。

**機能の利用シーン**：API Serverでのリクエスト処理（デシリアライズ、バージョン変換）、client-goでのオブジェクトエンコード/デコード、カスタムリソース定義、全Kubernetesコンポーネントでの型操作。

**主要な処理内容**：
1. Schemeによる型登録とGVK（Group/Version/Kind）マッピング
2. JSON/YAML/Protobuf/CBORフォーマットでのシリアライズ/デシリアライズ
3. バージョン間のオブジェクト変換（Conversion）
4. デフォルト値の設定（Defaulting）
5. バリデーション基盤の提供
6. FieldLabelConversionによるフィールドラベル変換
7. ObjectMeta、TypeMeta等の共通メタデータ型の定義

**関連システム・外部連携**：API Server、client-go、kubectl、全Kubernetesコンポーネント

**権限による制御**：ライブラリのため権限制御は不要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 全kubectlコマンド | 基盤ライブラリ | オブジェクトのシリアライズ/デシリアライズで使用 |

## 機能種別

ライブラリ / 型システム基盤

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| GroupVersionKind | schema.GroupVersionKind | Yes | APIオブジェクトのグループ・バージョン・種別 | 登録済みGVK |
| runtime.Object | interface | Yes | APIオブジェクトインターフェース | Schemeに登録済みの型 |
| []byte | バイト列 | Yes (デシリアライズ時) | シリアライズされたオブジェクトデータ | 有効なJSON/YAML/Protobuf |

### 入力データソース

APIリクエスト/レスポンスのバイト列、Goの構造体。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| runtime.Object | interface | デシリアライズ/変換後のAPIオブジェクト |
| []byte | バイト列 | シリアライズされたオブジェクトデータ |
| schema.GroupVersionKind | GVK | オブジェクトの型情報 |
| field.ErrorList | エラーリスト | バリデーション結果 |

### 出力先

呼び出し元のGoアプリケーション。

## 処理フロー

### 処理シーケンス

```
1. Scheme初期化
   └─ AddKnownTypes()で型をGVKにマッピングして登録
2. デフォルティング関数登録
   └─ AddTypeDefaultingFunc()でデフォルト値設定関数を登録
3. バリデーション関数登録
   └─ AddValidationFunc()でバリデーション関数を登録
4. 変換関数登録
   └─ conversion.Converterに変換関数を登録
5. シリアライズ/デシリアライズ
   └─ CodecFactoryを通じてEncoder/Decoderを取得し、オブジェクトを変換
```

### フローチャート

```mermaid
flowchart TD
    A[バイト列入力] --> B[Codec.Decode]
    B --> C[GVK判定]
    C --> D[型のインスタンス化]
    D --> E[デシリアライズ]
    E --> F{バージョン変換必要?}
    F -->|Yes| G[Conversion実行]
    F -->|No| H[デフォルティング]
    G --> H
    H --> I[runtime.Object出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-145-01 | 型登録必須 | 全APIオブジェクトはSchemeに事前登録が必要 | 常時 |
| BR-145-02 | GVK一意性 | 1つのGVKは1つのGo型にマッピングされる | 常時 |
| BR-145-03 | 内部型ハブ | バージョン変換は内部型（Hub）を経由して行われる | バージョン変換時 |
| BR-145-04 | スレッド安全性 | Schemeは登録完了後はスレッドセーフ（読み取り専用） | ランタイム |

### 計算ロジック

バージョン変換: Source GVK → 内部型 → Target GVK の2段階変換パターン。

## データベース操作仕様

本機能はライブラリであり、データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | UnknownType | 未登録のGVKのオブジェクトを操作 | Schemeへの型登録を確認 |
| - | ConversionError | バージョン変換に失敗 | 変換関数の登録を確認 |
| - | DecodeError | 不正なバイト列のデシリアライズ | 入力データの形式を確認 |

### リトライ仕様

ライブラリのためリトライ機構は提供しない。

## トランザクション仕様

該当なし（ライブラリ）。

## パフォーマンス要件

API Serverの全リクエスト処理で使用されるため、シリアライズ/デシリアライズの高性能が求められる。Protobufフォーマットにより高速なシリアライズを実現。

## セキュリティ考慮事項

- デシリアライズ時のインプットバリデーションが重要（不正なバイト列による攻撃防止）
- 未知のフィールドの扱い（StrictDecoding）によるセキュリティ強化

## 備考

- apimachineryは`staging/src/k8s.io/apimachinery`に格納され、独立したGoモジュールとして公開
- Schemeパターンは「登録フェーズ」と「使用フェーズ」の2段階で設計されている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | scheme.go | `staging/src/k8s.io/apimachinery/pkg/runtime/scheme.go` | Scheme構造体 -- 型登録の中核 |
| 1-2 | types.go | `staging/src/k8s.io/apimachinery/pkg/runtime/types.go` | runtime.Object, TypeMeta等の基本型 |
| 1-3 | schema.go | `staging/src/k8s.io/apimachinery/pkg/runtime/schema/group_version.go` | GroupVersionKind構造体 |

**読解のコツ**: Scheme構造体の各マップフィールドの役割を理解することが重要。gvkToTypeとtypeToGVKは逆引き関係にあり、型とGVKの双方向マッピングを提供する。

**主要処理フロー（scheme.go）**:
- **50-80行目**: Scheme構造体定義 -- gvkToType, typeToGVK, defaulterFuncs, validationFuncs等のマップ

#### Step 2: シリアライズを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | codec_factory.go | `staging/src/k8s.io/apimachinery/pkg/runtime/serializer/codec_factory.go` | CodecFactory -- Encoder/Decoderのファクトリー |

#### Step 3: バージョン変換を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | converter.go | `staging/src/k8s.io/apimachinery/pkg/conversion/converter.go` | バージョン変換の基盤 |

### プログラム呼び出し階層図

```
runtime.Scheme
    |
    +-- AddKnownTypes(gv, types...) -- 型登録
    +-- AddTypeDefaultingFunc(type, func) -- デフォルティング登録
    +-- AddValidationFunc(type, func) -- バリデーション登録
    |
    +-- ObjectKinds(obj) → []GVK -- オブジェクトのGVK取得
    +-- New(gvk) → Object -- GVKからオブジェクト生成
    +-- Default(obj) -- デフォルト値適用
    +-- Convert(in, out, ctx) -- バージョン変換
    |
    +-- serializer.CodecFactory
            +-- EncoderForVersion() → Encoder
            +-- DecoderToVersion() → Decoder
            |
            +-- JSON Serializer
            +-- YAML Serializer
            +-- Protobuf Serializer
            +-- CBOR Serializer
```

### データフロー図

```
[入力]                    [処理]                              [出力]

バイト列(JSON) ──> Decoder ──> GVK判定 ──> 型インスタンス化 ──> runtime.Object
                                              |
                               バージョン変換(optional)
                                              |
runtime.Object ──> Encoder ──> シリアライズ ──────────────> バイト列(JSON/Protobuf)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| scheme.go | `staging/src/k8s.io/apimachinery/pkg/runtime/scheme.go` | ソース | Scheme構造体（型登録・変換の中核） |
| types.go | `staging/src/k8s.io/apimachinery/pkg/runtime/types.go` | ソース | runtime.Object等の基本型 |
| interfaces.go | `staging/src/k8s.io/apimachinery/pkg/runtime/interfaces.go` | ソース | Encoder/Decoder等のインターフェース |
| group_version.go | `staging/src/k8s.io/apimachinery/pkg/runtime/schema/group_version.go` | ソース | GVK型定義 |
| codec_factory.go | `staging/src/k8s.io/apimachinery/pkg/runtime/serializer/codec_factory.go` | ソース | CodecFactory |
| converter.go | `staging/src/k8s.io/apimachinery/pkg/conversion/converter.go` | ソース | バージョン変換基盤 |
| objectmeta.go | `staging/src/k8s.io/apimachinery/pkg/apis/meta/v1/types.go` | ソース | ObjectMeta型定義 |
| field/ | `staging/src/k8s.io/apimachinery/pkg/util/validation/field/` | ソース | バリデーションフィールドエラー |
