# 機能設計書 146-component-base

## 概要

本ドキュメントは、Kubernetes component-baseライブラリの設計について記述する。component-baseは全コンポーネント共通の基盤機能（CLI引数解析、フィーチャーゲート、メトリクス、ログ、トレーシング等）を提供するライブラリである。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesの各コンポーネント（API Server、Controller Manager、Scheduler、Kubelet等）には共通の基盤機能が必要である。component-baseはこれらの共通機能を統一的に提供し、各コンポーネントの実装コストを削減するとともに、一貫した動作と設定インターフェースを保証する。

**機能の利用シーン**：全Kubernetesコンポーネントの起動時の初期化処理、フィーチャーゲートによる機能の有効/無効制御、Prometheusメトリクスの公開、構造化ログの出力、OpenTelemetryトレーシング。

**主要な処理内容**：
1. フィーチャーゲート: Alpha/Beta/GA機能の有効/無効制御
2. CLIフラグ解析: pflagベースのコマンドライン引数処理
3. メトリクス: Prometheus互換メトリクスの登録・公開
4. ログ: klogベースの構造化ログ出力
5. トレーシング: OpenTelemetryベースの分散トレーシング
6. バージョン情報: ビルドバージョン/Git情報の管理
7. コーデック: 設定ファイルのシリアライズ/デシリアライズ

**関連システム・外部連携**：Prometheus（メトリクス収集）、OpenTelemetry（トレーシング）、klog（ログ出力）

**権限による制御**：ライブラリのため権限制御は不要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 全Kubernetesコンポーネント | 基盤ライブラリ | 各コンポーネントの初期化と実行で使用 |

## 機能種別

ライブラリ / コンポーネント基盤

## 入力仕様

### 入力パラメータ（フィーチャーゲート）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --feature-gates | string | No | フィーチャーゲート設定（Key=Value,...形式） | 登録済みフィーチャー名 |
| Feature | string | Yes (登録時) | フィーチャー名 | 一意の文字列 |
| FeatureSpec.Default | bool | Yes | デフォルトの有効/無効状態 | true/false |
| FeatureSpec.PreRelease | prerelease | Yes | プレリリース段階（Alpha/Beta/GA/Deprecated） | 有効な段階値 |

### 入力データソース

コマンドライン引数、環境変数、設定ファイル。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Feature有効状態 | bool | 指定フィーチャーの有効/無効状態 |
| メトリクス | Prometheus metrics | 各種メトリクスデータ |
| ログ出力 | text/JSON | 構造化ログ |
| トレーススパン | OTLP | OpenTelemetryトレースデータ |

### 出力先

標準出力/標準エラー（ログ）、Prometheusエンドポイント（メトリクス）、OTLPエンドポイント（トレーシング）。

## 処理フロー

### 処理シーケンス

```
1. コンポーネント起動
   └─ CLI引数解析、設定ファイル読み込み
2. フィーチャーゲート初期化
   └─ デフォルトフィーチャーの登録、CLI引数によるオーバーライド
3. メトリクス初期化
   └─ Prometheusメトリクスの登録
4. ログ初期化
   └─ klog設定、ログフォーマット設定
5. トレーシング初期化（オプション）
   └─ OpenTelemetry TracerProviderの設定
6. コンポーネント固有の初期化と実行
```

### フローチャート

```mermaid
flowchart TD
    A[コンポーネント起動] --> B[CLI引数解析]
    B --> C[フィーチャーゲート初期化]
    C --> D[AllAlpha/AllBeta処理]
    D --> E[個別フィーチャーオーバーライド]
    E --> F[メトリクス登録]
    F --> G[ログ初期化]
    G --> H[トレーシング初期化]
    H --> I[コンポーネント実行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-146-01 | AllAlpha/AllBeta | AllAlpha=true/AllBeta=trueで全Alpha/Beta機能を一括有効化 | フィーチャーゲート設定時 |
| BR-146-02 | 個別オーバーライド優先 | AllAlpha/AllBeta設定より個別フィーチャー指定が優先される | フィーチャーゲート設定時 |
| BR-146-03 | LockToDefault | LockToDefault=trueのフィーチャーはユーザーが変更不可 | GA機能 |
| BR-146-04 | バージョン対応 | フィーチャーはVersionedSpecsにより各バージョンで異なる状態を持てる | エミュレーションバージョン使用時 |

### 計算ロジック

フィーチャーゲート解決:
1. デフォルト値（FeatureSpec.Default）を適用
2. AllAlpha/AllBeta設定を適用（対象のPreRelease段階のみ）
3. 個別フィーチャー指定でオーバーライド

## データベース操作仕様

本機能はライブラリであり、データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | UnknownFeature | 未登録のフィーチャー名を指定 | 有効なフィーチャー名を使用 |
| - | LockedFeature | LockToDefault=trueのフィーチャーを変更しようとした | 変更不可の旨を確認 |
| - | InvalidFlag | 無効なCLIフラグ形式 | フラグ形式を修正 |

### リトライ仕様

該当なし（ライブラリ）。

## トランザクション仕様

該当なし（ライブラリ）。

## パフォーマンス要件

フィーチャーゲートの判定はatom的な読み取りで実装され、オーバーヘッドは極めて小さい。メトリクス収集もプロセス内のメモリ操作であり、高速。

## セキュリティ考慮事項

- フィーチャーゲートの設定はコンポーネント起動時のみ変更可能（ランタイム変更不可）
- メトリクスエンドポイントには機密情報が含まれる可能性があるため、適切なアクセス制御が必要

## 備考

- component-baseは`staging/src/k8s.io/component-base`に格納
- フィーチャーゲートにはバージョンベースの管理（VersionedSpecs）が導入されており、エミュレーションバージョンに応じたフィーチャー状態の制御が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | feature_gate.go | `staging/src/k8s.io/component-base/featuregate/feature_gate.go` | Feature型、FeatureSpec構造体、FeatureGateインターフェース |

**読解のコツ**: Feature型はstringのエイリアス。allAlphaGateとallBetaGateは特殊なフィーチャーであり、specialFeaturesマップで専用のハンドラーが登録されている。

**主要処理フロー**:
- **42行目**: Feature型定義（string）
- **44-58行目**: allAlphaGate, allBetaGate定数定義
- **60-72行目**: defaultFeaturesとspecialFeaturesマップ
- **74-80行目**: FeatureSpec構造体 -- Default, LockToDefault, PreRelease, Version

#### Step 2: メトリクスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | metrics/ | `staging/src/k8s.io/component-base/metrics/` | Prometheusメトリクス基盤 |

#### Step 3: ログを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logs/ | `staging/src/k8s.io/component-base/logs/` | ログ設定基盤 |

#### Step 4: CLIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cli/ | `staging/src/k8s.io/component-base/cli/` | CLI基盤 |

### プログラム呼び出し階層図

```
Kubernetesコンポーネント (kube-apiserver, kube-scheduler, etc.)
    |
    +-- cli.Run(command) -- コマンド実行
    |       +-- pflag.Parse() -- CLI引数解析
    |
    +-- featuregate.NewFeatureGate()
    |       +-- Add(features) -- フィーチャー登録
    |       +-- SetFromMap(map) -- フィーチャー設定
    |       +-- Enabled(feature) → bool -- フィーチャー判定
    |               +-- allAlpha/allBeta処理
    |               +-- 個別オーバーライド
    |
    +-- metrics.Register(collectors...) -- メトリクス登録
    |       +-- prometheus.MustRegister()
    |
    +-- logs.InitLogs() -- ログ初期化
    |       +-- klog設定
    |
    +-- tracing.NewProvider() -- トレーシング初期化
    |
    +-- version.Get() -- バージョン情報取得
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CLI引数 ──────> pflag解析 ──> FeatureGate設定 ──> Enabled()判定結果
                                                          |
                              メトリクス登録 ──> /metricsエンドポイント
                              ログ設定 ──────> stdout/stderrログ出力
                              トレーシング設定 ─> OTLPエクスポーター
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| feature_gate.go | `staging/src/k8s.io/component-base/featuregate/feature_gate.go` | ソース | フィーチャーゲート実装 |
| cli/ | `staging/src/k8s.io/component-base/cli/` | ソース | CLIフレームワーク |
| metrics/ | `staging/src/k8s.io/component-base/metrics/` | ソース | Prometheusメトリクス基盤 |
| logs/ | `staging/src/k8s.io/component-base/logs/` | ソース | ログ基盤 |
| tracing/ | `staging/src/k8s.io/component-base/tracing/` | ソース | トレーシング基盤 |
| version/ | `staging/src/k8s.io/component-base/version/` | ソース | バージョン情報管理 |
| config/ | `staging/src/k8s.io/component-base/config/` | ソース | 設定型定義 |
| codec/ | `staging/src/k8s.io/component-base/codec/` | ソース | 設定コーデック |
| term/ | `staging/src/k8s.io/component-base/term/` | ソース | ターミナルユーティリティ |
