# 機能設計書 150-SecurityContext管理

## 概要

本ドキュメントは、KubernetesにおけるPod/コンテナのSecurityContext管理機能について記述する。SecurityContextはコンテナのセキュリティ設定（UID、SELinux、AppArmor、Seccomp、Capabilities等）を定義し、適用するための仕組みを提供する。

### 本機能の処理概要

**業務上の目的・背景**：コンテナ環境のセキュリティを確保するために、各コンテナの実行ユーザー、権限、セキュリティプロファイルを適切に設定する必要がある。SecurityContextはPodレベルとコンテナレベルの2階層でセキュリティ設定を管理し、コンテナレベルの設定がPodレベルの設定をオーバーライドする仕組みを提供する。

**機能の利用シーン**：非rootユーザーでのコンテナ実行、SELinuxラベルの設定、Seccompプロファイルの適用、Linuxケーパビリティの追加/削除、特権コンテナの設定、読み取り専用ルートファイルシステムの設定、Windows HostProcessコンテナの管理。

**主要な処理内容**：
1. PodSecurityContextのアクセサー/ミューテーター提供
2. ContainerSecurityContextのアクセサー/ミューテーター提供
3. 有効なSecurityContextの計算（Pod設定 + コンテナ設定のマージ）
4. ProcMountタイプに基づくマスクパス/読み取り専用パスの変換
5. AllowPrivilegeEscalation（no_new_privs）の判定
6. Windows HostProcess要求の判定
7. 有効なRunAsUserの決定

**関連システム・外部連携**：Kubelet（コンテナ起動時のセキュリティ設定適用）、CRI（SecurityContextをランタイムに伝達）、Pod Security Admission（セキュリティポリシーの検証）

**権限による制御**：SecurityContextの設定はPod定義の一部であり、Pod作成権限を持つユーザーが設定可能。ただしPod Security Admissionにより特定の設定（privileged等）は制限される場合がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | kubectl describe pod | 参照画面 | PodのSecurityContext設定の確認 |
| - | kubectl create/apply | 操作画面 | SecurityContextを含むPod作成 |

## 機能種別

セキュリティ設定 / ライブラリ

## 入力仕様

### 入力パラメータ（PodSecurityContext）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| runAsUser | *int64 | No | 実行ユーザーID | 0以上 |
| runAsGroup | *int64 | No | 実行グループID | 0以上 |
| runAsNonRoot | *bool | No | 非rootでの実行を強制 | true/false |
| seLinuxOptions | *SELinuxOptions | No | SELinuxラベル設定 | 有効なSELinuxコンテキスト |
| seccompProfile | *SeccompProfile | No | Seccompプロファイル | 有効なプロファイル |
| supplementalGroups | []int64 | No | 追加グループID | 有効なGID |
| fsGroup | *int64 | No | FSグループID | 0以上 |
| fsGroupChangePolicy | *PodFSGroupChangePolicy | No | FSGroupの変更ポリシー | OnRootMismatch/Always |
| hostNetwork | bool | No | ホストネットワークの使用 | true/false |
| hostPID | bool | No | ホストPID名前空間の使用 | true/false |
| hostIPC | bool | No | ホストIPC名前空間の使用 | true/false |
| hostUsers | *bool | No | ホストユーザー名前空間の使用 | true/false |

### 入力パラメータ（ContainerSecurityContext）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| capabilities | *Capabilities | No | 追加/削除するケーパビリティ | 有効なケーパビリティ名 |
| privileged | *bool | No | 特権モード | true/false |
| procMount | *ProcMountType | No | /procのマウントタイプ | Default/Unmasked |
| seLinuxOptions | *SELinuxOptions | No | SELinuxラベル設定 | 有効なSELinuxコンテキスト |
| runAsUser | *int64 | No | 実行ユーザーID | 0以上 |
| runAsGroup | *int64 | No | 実行グループID | 0以上 |
| runAsNonRoot | *bool | No | 非rootでの実行を強制 | true/false |
| readOnlyRootFilesystem | *bool | No | 読み取り専用ルートFS | true/false |
| seccompProfile | *SeccompProfile | No | Seccompプロファイル | 有効なプロファイル |
| allowPrivilegeEscalation | *bool | No | 権限昇格の許可 | true/false |
| windowsOptions | *WindowsSecurityContextOptions | No | Windows固有設定 | 有効なWindows設定 |

### 入力データソース

Pod Specに含まれるsecurityContextフィールド。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| EffectiveSecurityContext | *SecurityContext | Pod+コンテナの有効なセキュリティ設定 |
| MaskedPaths | []string | /procのマスクパスリスト |
| ReadonlyPaths | []string | /procの読み取り専用パスリスト |
| NoNewPrivileges | bool | no_new_privsフラグ |

### 出力先

Kubelet（CRIへのコンテナ設定伝達）。

## 処理フロー

### 処理シーケンス

```
1. Pod定義からPodSecurityContextとContainerSecurityContextを取得
2. 有効なSecurityContextの計算
   └─ Pod設定をベースにコンテナ設定でオーバーライド
3. ProcMountタイプに基づくパス変換
   └─ Default: マスクパスと読み取り専用パスを設定
   └─ Unmasked: パスなし（フルアクセス）
4. AllowPrivilegeEscalation判定
   └─ falseの場合はno_new_privsフラグを有効化
5. CRIへのセキュリティ設定伝達
   └─ ContainerConfig.Linux.SecurityContextに設定
```

### フローチャート

```mermaid
flowchart TD
    A[Pod Spec読み込み] --> B[PodSecurityContext取得]
    B --> C[ContainerSecurityContext取得]
    C --> D[DetermineEffectiveSecurityContext]
    D --> E{各フィールドのマージ}
    E --> F[SELinuxOptions: コンテナ優先]
    E --> G[RunAsUser: コンテナ優先]
    E --> H[RunAsGroup: コンテナ優先]
    E --> I[Capabilities: コンテナのみ]
    E --> J[Privileged: コンテナのみ]
    F --> K[有効SecurityContext]
    G --> K
    H --> K
    I --> K
    J --> K
    K --> L[ConvertToRuntimeMaskedPaths]
    K --> M[AddNoNewPrivileges判定]
    L --> N[CRI SecurityContext設定]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-150-01 | コンテナ優先 | ContainerSecurityContextの設定がPodSecurityContextの設定をオーバーライドする | 両方が設定されている場合 |
| BR-150-02 | Podのみの設定 | HostNetwork、HostPID、HostIPC、FSGroup、SupplementalGroupsはPodレベルのみ | 常時 |
| BR-150-03 | コンテナのみの設定 | Capabilities、Privileged、ReadOnlyRootFilesystem、ProcMountはコンテナレベルのみ | 常時 |
| BR-150-04 | マスクパス | DefaultProcMountの場合、/proc/asound, /proc/kcore等がマスクされる | ProcMount=Default時 |
| BR-150-05 | Unmaskパス | UnmaskedProcMountの場合、マスクパスも読み取り専用パスも空 | ProcMount=Unmasked時 |
| BR-150-06 | NoNewPrivs | AllowPrivilegeEscalation=falseの場合、no_new_privsが有効化される | AllowPrivilegeEscalation設定時 |
| BR-150-07 | WindowsOptions部分オーバーライド | WindowsOptionsはフィールド単位でオーバーライド（全体置換ではない） | Windows設定時 |
| BR-150-08 | CPUサーマルスロットルパス | /sys/devices/system/cpu/cpuN/thermal_throttleが存在する場合マスクパスに追加 | DefaultProcMount + CPUパス存在時 |

### 計算ロジック

有効なRunAsUserの決定:
1. Container.SecurityContext.RunAsUserが設定されている場合: そちらを使用
2. そうでなければPod.Spec.SecurityContext.RunAsUserを使用
3. どちらも未設定の場合: nilを返す

## データベース操作仕様

本機能はライブラリであり、直接的なデータベース操作は行わない。SecurityContextはPod Specの一部としてetcdに保存される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | 不正なSecurityContext設定 | 設定値を確認 |
| - | PodSecurityAdmission拒否 | セキュリティポリシー違反 | ポリシーに準拠した設定に修正 |

### リトライ仕様

該当なし（設定の検証はPod作成/更新時に同期的に行われる）。

## トランザクション仕様

該当なし（Pod Specの一部として永続化される）。

## パフォーマンス要件

SecurityContextの解決はコンテナ起動時にメモリ内で行われるため、パフォーマンスへの影響は最小。

## セキュリティ考慮事項

- privileged=trueの設定はホストへの完全アクセスを許可するため、Pod Security Admissionで制限すべき
- runAsNonRoot=trueの設定によりrootでの実行を防止可能
- AllowPrivilegeEscalation=falseによりsetuid/setgidビットの悪用を防止
- SELinuxOptioinsによりMandatory Access Controlを適用可能
- SeccompProfileによりシステムコールを制限可能

## 備考

- SecurityContextのアクセサー/ミューテーターパターンにより、nil安全なフィールドアクセスを提供
- effectiveContainerSecurityContextWrapperは、Podレベルとコンテナレベルの設定を統合する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | accessors.go | `pkg/securitycontext/accessors.go` | PodSecurityContextAccessor/Mutator、ContainerSecurityContextAccessor/Mutatorインターフェース |

**読解のコツ**: Accessor（読み取り専用）とMutator（読み書き可能）の2段階インターフェース設計に注目。podSecurityContextWrapperはnil安全な設計で、podSCがnilの場合でもパニックせずにデフォルト値を返す。

**主要処理フロー**:
- **26-39行目**: PodSecurityContextAccessorインターフェース -- 12個の読み取りメソッド
- **42-60行目**: PodSecurityContextMutatorインターフェース -- 12個のSetメソッド + PodSecurityContext()
- **74-76行目**: podSecurityContextWrapper構造体
- **82-86行目**: ensurePodSC() -- 遅延初期化パターン
- **253-265行目**: ContainerSecurityContextAccessorインターフェース -- 10個の読み取りメソッド
- **267-282行目**: ContainerSecurityContextMutatorインターフェース
- **439-547行目**: effectiveContainerSecurityContextWrapper -- Pod+コンテナの有効値を統合

#### Step 2: ユーティリティ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | util.go | `pkg/securitycontext/util.go` | DetermineEffectiveSecurityContext、AddNoNewPrivileges、マスクパス変換 |

**主要処理フロー**:
- **29-39行目**: HasWindowsHostProcessRequest -- WindowsHostProcess判定
- **44-122行目**: DetermineEffectiveSecurityContext -- Pod設定+コンテナ設定のマージ
- **48-56行目**: nil安全な分岐処理
- **58-79行目**: WindowsOptions部分オーバーライドロジック
- **86-119行目**: 各フィールドのコンテナレベルオーバーライド
- **127-141行目**: DetermineEffectiveRunAsUser -- 有効なRunAsUserの決定
- **143-176行目**: securityContextFromPodSecurityContext -- PodSCからの合成SecurityContext生成
- **179-191行目**: AddNoNewPrivileges -- AllowPrivilegeEscalationの判定
- **196-220行目**: defaultMaskedPaths -- デフォルトマスクパス（sync.OnceValue使用）
- **232-252行目**: ConvertToRuntimeMaskedPaths/ConvertToRuntimeReadonlyPaths

#### Step 3: AppArmor連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | apparmor/ | `pkg/security/apparmor/` | AppArmorプロファイル管理 |

### プログラム呼び出し階層図

```
Kubelet (コンテナ起動時)
    |
    +-- DetermineEffectiveSecurityContext(pod, container)
    |       +-- securityContextFromPodSecurityContext(pod)
    |       +-- コンテナSCフィールドのオーバーライド
    |               +-- SELinuxOptions
    |               +-- WindowsOptions (部分オーバーライド)
    |               +-- Capabilities
    |               +-- Privileged
    |               +-- RunAsUser / RunAsGroup / RunAsNonRoot
    |               +-- ReadOnlyRootFilesystem
    |               +-- ProcMount
    |
    +-- AddNoNewPrivileges(sc) → bool
    |
    +-- ConvertToRuntimeMaskedPaths(procMount)
    |       +-- defaultMaskedPaths() (sync.OnceValue)
    |               +-- possibleCPUs() + /sys/devices/system/cpu/cpuN/thermal_throttle
    |
    +-- ConvertToRuntimeReadonlyPaths(procMount)
    |
    +-- HasWindowsHostProcessRequest(pod, container)
    |
    +-- NewEffectiveContainerSecurityContextAccessor(podSC, containerSC)
            +-- effectiveContainerSecurityContextWrapper
                    +-- コンテナ設定がnil -> Pod設定にフォールバック
```

### データフロー図

```
[入力]                         [処理]                                [出力]

Pod.Spec.SecurityContext ──> securityContextFromPodSecurityContext ──> ベースSC
                                    |
Container.SecurityContext ──> DetermineEffectiveSecurityContext ──> 有効SC
                                    |
ProcMount設定 ──────────> ConvertToRuntimeMaskedPaths ──────────> マスクパス
                          ConvertToRuntimeReadonlyPaths ─────────> 読み取り専用パス
                                    |
AllowPrivilegeEscalation ──> AddNoNewPrivileges ──────────────> no_new_privsフラグ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| accessors.go | `pkg/securitycontext/accessors.go` | ソース | Accessor/Mutatorインターフェースと実装 |
| util.go | `pkg/securitycontext/util.go` | ソース | 有効SC計算、マスクパス変換等のユーティリティ |
| fake.go | `pkg/securitycontext/fake.go` | テスト | テスト用フェイク実装 |
| accessors_test.go | `pkg/securitycontext/accessors_test.go` | テスト | アクセサーのテスト |
| util_test.go | `pkg/securitycontext/util_test.go` | テスト | ユーティリティのテスト |
| util_linux.go | `pkg/securitycontext/util_linux.go` | ソース | Linux固有のユーティリティ |
| util_darwin.go | `pkg/securitycontext/util_darwin.go` | ソース | macOS固有のユーティリティ |
| util_windows.go | `pkg/securitycontext/util_windows.go` | ソース | Windows固有のユーティリティ |
| doc.go | `pkg/securitycontext/doc.go` | ソース | パッケージドキュメント |
| apparmor/ | `pkg/security/apparmor/` | ソース | AppArmorプロファイル管理 |
