# 機能設計書 152-code-generator

## 概要

本ドキュメントは、Kubernetes APIリソース向けのclientset、informer、lister等のコードを自動生成する「code-generator」機能の設計について記述する。

### 本機能の処理概要

**業務上の目的・背景**：KubernetesのAPIリソースを定義する際、型定義に対応するクライアントコード（clientset、informer、lister）やユーティリティコード（deepcopy、conversion、defaulter）を手動で記述することは非効率であり、バグの温床となる。code-generatorは、Goの型定義に付与されたマーカーコメント（タグ）を解析し、これらのボイラープレートコードを自動生成することで、開発効率とコード品質を向上させる。

**機能の利用シーン**：新しいAPIリソースを定義した際、CRD（CustomResourceDefinition）用のクライアントコードを生成する際、既存APIの型定義を変更した際にコードを再生成する場合に利用される。Kubernetesプロジェクト内部および外部プロジェクトの両方で使用される。

**主要な処理内容**：
1. deepcopy-gen：`+k8s:deepcopy-gen`タグに基づくDeepCopyメソッドの生成
2. client-gen：`+genclient`タグに基づくclientsetコードの生成
3. informer-gen：Informerコードの生成
4. lister-gen：Listerコードの生成
5. conversion-gen：APIバージョン間の変換コードの生成
6. defaulter-gen：デフォルト値設定コードの生成
7. register-gen：APIグループ登録コードの生成
8. applyconfiguration-gen：Server-Side Apply用の設定型の生成
9. validation-gen：バリデーションコードの生成
10. prerelease-lifecycle-gen：プレリリースライフサイクルコードの生成
11. go-to-protobuf：GoからProtocol Buffers定義の生成

**関連システム・外部連携**：gengoコード生成フレームワーク、Go AST解析、Protocol Buffers。Kubernetesビルドシステム（hack/update-codegen.sh）から呼び出される。

**権限による制御**：開発時ツールのため、ランタイムでの権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CLIツールのため関連画面なし |

## 機能種別

コード生成 / 開発支援ツール

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input-dir | string | Yes | 入力Goパッケージのルートディレクトリ | 有効なディレクトリパス |
| output-dir | string | Yes | 生成コードの出力先ディレクトリ | 有効なディレクトリパス |
| boilerplate | string | No | 生成ファイルに挿入するヘッダーファイル | 有効なファイルパス |
| go-header-file | string | No | Goファイルのヘッダーテンプレート | 有効なファイルパス |
| extra-peer-dir | string | No | 追加のピアディレクトリ | 有効なディレクトリパス |

### 入力データソース

Goソースコードファイル（マーカーコメント付き型定義）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| zz_generated.deepcopy.go | Goソース | DeepCopy/DeepCopyInto/DeepCopyObjectメソッド |
| clientset.go | Goソース | 型付きクライアントセット |
| informers/ | Goソース | SharedInformerFactory + 各リソースのInformer |
| listers/ | Goソース | 各リソースのLister |
| zz_generated.conversion.go | Goソース | バージョン間変換関数 |
| zz_generated.defaults.go | Goソース | デフォルト値設定関数 |

### 出力先

指定された出力ディレクトリ配下に生成されたGoソースファイルを書き出す

## 処理フロー

### 処理シーケンス

```
1. kube_codegen.sh が呼び出される
   └─ 各ジェネレーターを順番に実行
2. Goソースファイルの解析
   └─ マーカーコメント（+k8s:deepcopy-gen等）の検出
3. コード生成テンプレートの適用
   └─ 入力型情報に基づくコード生成
4. 生成ファイルの出力
   └─ zz_generated.*.go ファイルとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[kube_codegen.sh 実行] --> B[gen_helpers: deepcopy/conversion/defaults生成]
    B --> C[gen_client: clientset生成]
    C --> D[gen_informer: informer生成]
    D --> E[gen_lister: lister生成]
    E --> F[生成完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-152-1 | マーカータグ必須 | コード生成対象の型には適切なマーカーコメントが必要 | 全生成対象 |
| BR-152-2 | パッケージ構造 | 入力パッケージは$root/$group/$versionの構造に従う必要がある | API型定義 |
| BR-152-3 | ボイラープレート | 生成ファイルにはライセンスヘッダーが自動挿入される | 全生成ファイル |
| BR-152-4 | DO NOT EDIT | 生成ファイルには「Code generated ... DO NOT EDIT.」コメントが挿入される | 全生成ファイル |

### 計算ロジック

特になし。テンプレートベースのコード生成。

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。ファイルシステムへの読み書きのみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | パース失敗 | 入力Goファイルの構文エラー | ソースコードを修正 |
| - | マーカー不正 | 認識できないマーカーコメント | マーカー構文を確認 |
| - | 出力先エラー | 出力ディレクトリの書き込み権限なし | パーミッション確認 |

### リトライ仕様

コード生成ツールのため、リトライ機構はない。エラー発生時は修正後に再実行する。

## トランザクション仕様

ファイルシステム操作のため、トランザクション管理はない。

## パフォーマンス要件

大規模なKubernetesプロジェクトで数百の型定義に対してコード生成を実行する。通常数分以内で完了する。

## セキュリティ考慮事項

- 開発時ツールのためランタイムセキュリティは該当しない
- 生成されるコードの安全性は入力型定義とジェネレーターの実装に依存する

## 備考

- `hack/update-codegen.sh` から呼び出されるのが一般的
- 外部プロジェクトでは `kube_codegen.sh` をsourceして使用する
- 生成ファイルの接頭辞 `zz_generated.` は生成コードの慣例

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントのスクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | kube_codegen.sh | `staging/src/k8s.io/code-generator/kube_codegen.sh` | 各コード生成関数の定義とフロー |
| 1-2 | generate-groups.sh | `staging/src/k8s.io/code-generator/generate-groups.sh` | レガシーなグループ別生成スクリプト |

**読解のコツ**: kube_codegen.shは複数の`kube::codegen::`プレフィックスの関数を定義している。**49-54行目**で内部ヘルパー関数`findz`を定義し、**65-80行目**で`gen_helpers`関数の使い方を記述している。

#### Step 2: 各ジェネレーターのエントリーポイント

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.go (deepcopy-gen) | `staging/src/k8s.io/code-generator/cmd/deepcopy-gen/` | DeepCopyコード生成のmain |
| 2-2 | main.go (client-gen) | `staging/src/k8s.io/code-generator/cmd/client-gen/` | Clientsetコード生成のmain |
| 2-3 | main.go (informer-gen) | `staging/src/k8s.io/code-generator/cmd/informer-gen/` | Informerコード生成のmain |
| 2-4 | main.go (lister-gen) | `staging/src/k8s.io/code-generator/cmd/lister-gen/` | Listerコード生成のmain |

#### Step 3: 共通ユーティリティ

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | namer/ | `staging/src/k8s.io/code-generator/pkg/namer/` | 型名・パッケージ名の命名規則 |
| 3-2 | util/ | `staging/src/k8s.io/code-generator/pkg/util/` | 共通ユーティリティ関数 |

### プログラム呼び出し階層図

```
kube_codegen.sh
    |
    +-- kube::codegen::gen_helpers()
    |      +-- deepcopy-gen
    |      +-- conversion-gen
    |      +-- defaulter-gen
    |      +-- validation-gen
    |
    +-- kube::codegen::gen_client()
    |      +-- applyconfiguration-gen
    |      +-- client-gen
    |      +-- lister-gen
    |      +-- informer-gen
    |
    +-- kube::codegen::gen_openapi()
           +-- openapi-gen
```

### データフロー図

```
[入力]                          [処理]                    [出力]

Go型定義ファイル ──────> マーカーコメント解析 ──> zz_generated.deepcopy.go
(+k8s:deepcopy-gen)     (gengoフレームワーク)     zz_generated.conversion.go
(+genclient)                                     zz_generated.defaults.go
(+k8s:conversion-gen)                            clientset/
                                                 informers/
                                                 listers/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| kube_codegen.sh | `staging/src/k8s.io/code-generator/kube_codegen.sh` | スクリプト | メインのコード生成スクリプト |
| generate-groups.sh | `staging/src/k8s.io/code-generator/generate-groups.sh` | スクリプト | レガシーグループ別生成 |
| deepcopy-gen/ | `staging/src/k8s.io/code-generator/cmd/deepcopy-gen/` | ソース | DeepCopy生成ツール |
| client-gen/ | `staging/src/k8s.io/code-generator/cmd/client-gen/` | ソース | Clientset生成ツール |
| informer-gen/ | `staging/src/k8s.io/code-generator/cmd/informer-gen/` | ソース | Informer生成ツール |
| lister-gen/ | `staging/src/k8s.io/code-generator/cmd/lister-gen/` | ソース | Lister生成ツール |
| conversion-gen/ | `staging/src/k8s.io/code-generator/cmd/conversion-gen/` | ソース | 変換コード生成ツール |
| defaulter-gen/ | `staging/src/k8s.io/code-generator/cmd/defaulter-gen/` | ソース | デフォルト値生成ツール |
| applyconfiguration-gen/ | `staging/src/k8s.io/code-generator/cmd/applyconfiguration-gen/` | ソース | Apply設定型生成ツール |
| validation-gen/ | `staging/src/k8s.io/code-generator/cmd/validation-gen/` | ソース | バリデーション生成ツール |
| go-to-protobuf/ | `staging/src/k8s.io/code-generator/cmd/go-to-protobuf/` | ソース | Protobuf生成ツール |
| namer/ | `staging/src/k8s.io/code-generator/pkg/namer/` | ソース | 命名規則ユーティリティ |
