# 機能設計書 153-E2Eテストフレームワーク

## 概要

本ドキュメントは、Kubernetesの統合テスト・エンドツーエンドテストのフレームワークとユーティリティを提供する「E2Eテストフレームワーク」機能の設計について記述する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesは大規模で複雑な分散システムであり、各コンポーネントの統合動作を検証するためにE2E（End-to-End）テストが不可欠である。本フレームワークは、テストの記述・実行・レポーティングを効率化するための基盤を提供し、クラスターの品質保証を支える。

**機能の利用シーン**：新機能の開発後にクラスター全体での動作検証を行う際、リリース前のリグレッションテスト実行時、コンフォーマンステスト（適合性テスト）によるKubernetesディストリビューションの互換性検証時に利用される。

**主要な処理内容**：
1. Ginkgo/Gomegaベースのテストフレームワーク提供
2. テストフィクスチャとヘルパーユーティリティの提供（Namespace作成、Pod待機等）
3. コンフォーマンステストの定義と実行
4. E2Eノードテスト（Kubelet単体テスト）のフレームワーク
5. DRA（Dynamic Resource Allocation）E2Eテスト
6. kubeadm E2Eテスト
7. テストイメージの管理とビルド
8. テスト用ユーティリティ（wait条件、リソース作成ヘルパー等）

**関連システム・外部連携**：Ginkgoテストフレームワーク、Gomegaアサーションライブラリ、KubernetesクラスターAPI。テスト実行にはアクセス可能なKubernetesクラスターが必要。

**権限による制御**：テスト実行にはクラスター管理者相当の権限が必要。テスト内でNamespaceの作成・削除、リソースの操作を行うため。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | テストフレームワークのため関連画面なし |

## 機能種別

テスト支援 / フレームワーク

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| kubeconfig | string | Yes | テスト対象クラスターへの接続情報 | 有効なkubeconfigパス |
| ginkgo.focus | string | No | 実行するテストのフィルター（正規表現） | 有効な正規表現 |
| ginkgo.skip | string | No | スキップするテストのフィルター | 有効な正規表現 |
| provider | string | No | クラウドプロバイダー種別 | gce/aws/azure等 |
| num-nodes | int | No | テスト対象のノード数 | 正の整数 |

### 入力データソース

テスト対象のKubernetesクラスター（kubeconfig経由）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| テスト結果 | JUnit XML | テスト実行結果のXMLレポート |
| テストログ | テキスト | テスト実行時の詳細ログ |
| コンフォーマンス結果 | YAML | 適合性テストの合否結果 |

### 出力先

標準出力、指定されたレポートディレクトリ

## 処理フロー

### 処理シーケンス

```
1. テスト環境のセットアップ
   └─ クラスター接続確認、テスト用Namespace作成
2. テストスイートの実行
   └─ Ginkgoによるテストケースの順次/並列実行
3. テスト用リソースの作成と検証
   └─ Pod、Service等のリソースを作成し動作を検証
4. クリーンアップ
   └─ テスト用Namespace・リソースの削除
5. レポート生成
   └─ JUnit XML等のテスト結果レポートを出力
```

### フローチャート

```mermaid
flowchart TD
    A[テスト開始] --> B[クラスター接続確認]
    B --> C[テストNamespace作成]
    C --> D[テストケース実行]
    D --> E{全テスト完了?}
    E -->|No| D
    E -->|Yes| F[クリーンアップ]
    F --> G[レポート生成]
    G --> H[テスト終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-153-1 | テスト分離 | 各テストケースは独立したNamespaceで実行される | 全E2Eテスト |
| BR-153-2 | クリーンアップ保証 | テスト完了後、作成したリソースは必ず削除される | AfterEach/AfterSuite |
| BR-153-3 | コンフォーマンス | [Conformance]タグ付きテストはKubernetes適合性テストスイートを構成する | コンフォーマンステスト実行時 |
| BR-153-4 | シリアル実行 | [Serial]タグ付きテストは並列実行されない | タグ付きテストケース |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。KubernetesのAPI Server経由でリソースを操作する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 接続エラー | クラスターに接続できない | kubeconfigを確認 |
| - | タイムアウト | リソースが期待状態に到達しない | タイムアウト値の調整、クラスター状態確認 |
| - | テスト失敗 | アサーション条件不一致 | テストログを確認し原因調査 |

### リトライ仕様

フレームワークレベルでのリトライはGinkgoのflakyAttempts設定で制御可能。個別のリソース待機にはExponential Backoffが使用される。

## トランザクション仕様

テストフレームワークのため、トランザクション管理は対象外。

## パフォーマンス要件

フルE2Eテストスイートの実行は数時間を要する。コンフォーマンステストは通常1-2時間で完了する。

## セキュリティ考慮事項

- テスト実行にはクラスター管理者権限が必要
- テストで作成されるリソースは一時的なものであり、テスト完了後に削除される
- テスト用の機密情報（Secret等）はテスト内で生成・消費される

## 備考

- `test/e2e/` ディレクトリがメインのE2Eテストスイート
- `test/e2e_node/` はKubelet単体のE2Eテスト
- `test/conformance/` は適合性テスト関連

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ディレクトリ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | test/ | `test/` | テスト全体のディレクトリ構造 |
| 1-2 | e2e/ | `test/e2e/` | メインのE2Eテストスイート |
| 1-3 | e2e_node/ | `test/e2e_node/` | Kubeletノードテスト |

**読解のコツ**: Kubernetesのテストは非常に大規模であり、`test/e2e/`配下はSIG（Special Interest Group）ごとにサブディレクトリが分かれている。まず`test/e2e/e2e_test.go`がGinkgoテストのエントリーポイントとなる。

#### Step 2: テストフレームワークのユーティリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | utils/ | `test/utils/` | テスト用ユーティリティ関数群 |
| 2-2 | cmd/ | `test/cmd/` | テスト用コマンド |

#### Step 3: テスト実行スクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ginkgo-e2e.sh | `hack/ginkgo-e2e.sh` | E2Eテスト実行スクリプト |
| 3-2 | e2e-node-test.sh | `hack/e2e-node-test.sh` | ノードE2Eテスト実行スクリプト |

### プログラム呼び出し階層図

```
hack/ginkgo-e2e.sh
    |
    +-- ginkgo (テストランナー)
           |
           +-- test/e2e/e2e_test.go (エントリーポイント)
                  |
                  +-- test/e2e/apps/ (アプリケーション関連テスト)
                  +-- test/e2e/network/ (ネットワーク関連テスト)
                  +-- test/e2e/storage/ (ストレージ関連テスト)
                  +-- test/e2e/scheduling/ (スケジューリング関連テスト)
                  +-- ...
```

### データフロー図

```
[入力]                    [処理]                          [出力]

kubeconfig ──────> Ginkgoテストランナー ──────> JUnit XMLレポート
テストフラグ       テストケース実行              テストログ
                  (K8s API操作)                  コンフォーマンス結果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| e2e/ | `test/e2e/` | テスト | メインE2Eテストスイート |
| e2e_node/ | `test/e2e_node/` | テスト | ノードE2Eテスト |
| e2e_dra/ | `test/e2e_dra/` | テスト | DRA E2Eテスト |
| e2e_kubeadm/ | `test/e2e_kubeadm/` | テスト | kubeadm E2Eテスト |
| conformance/ | `test/conformance/` | テスト | コンフォーマンステスト |
| utils/ | `test/utils/` | ソース | テストユーティリティ |
| images/ | `test/images/` | 設定 | テスト用コンテナイメージ |
| fixtures/ | `test/fixtures/` | テスト | テスト用フィクスチャデータ |
| integration/ | `test/integration/` | テスト | 統合テスト |
| ginkgo-e2e.sh | `hack/ginkgo-e2e.sh` | スクリプト | E2Eテスト実行スクリプト |
