# 機能設計書 154-ビルドシステム

## 概要

本ドキュメントは、Kubernetesバイナリのビルド、テスト、リリースのためのMakefile/スクリプトを提供する「ビルドシステム」機能の設計について記述する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesは多数のバイナリ（kube-apiserver、kube-controller-manager、kube-scheduler、kubelet、kube-proxy、kubectl等）で構成されるプロジェクトであり、これらを一貫してビルド・テスト・リリースするためのビルドシステムが不可欠である。Makefileとシェルスクリプトにより、開発者とCI/CDシステムの両方が利用できる統一されたビルドインターフェースを提供する。

**機能の利用シーン**：開発者がローカルでバイナリをビルドする際、CI/CDパイプラインでテストを実行する際、リリースイメージを作成する際、クロスコンパイルを行う際に利用される。

**主要な処理内容**：
1. Goバイナリのビルド（ネイティブおよびクロスコンパイル）
2. コンテナイメージのビルドとプッシュ
3. テストの実行（ユニットテスト、統合テスト、E2Eテスト）
4. リリースアーティファクトの作成（tarball、イメージ）
5. コード生成の実行（protobuf、deepcopy等）
6. 依存関係の管理と検証

**関連システム・外部連携**：Go コンパイラ、Docker/Podman（コンテナイメージビルド）、コンテナレジストリ、CI/CDシステム（GitHub Actions、Prow等）。

**権限による制御**：ビルドシステム自体にはランタイム権限制御はない。リリースイメージのプッシュにはコンテナレジストリへの書き込み権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | ビルドシステムのため関連画面なし |

## 機能種別

ビルド・開発支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| WHAT | string | No | ビルド対象のバイナリ名 | 有効なバイナリ名 |
| KUBE_BUILD_PLATFORMS | string | No | ビルド対象のプラットフォーム | os/arch形式 |
| GOFLAGS | string | No | Go ビルドフラグ | 有効なGoフラグ |
| DBG | bool | No | デバッグビルドの有効化 | 0 or 1 |

### 入力データソース

Kubernetesソースコードリポジトリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| バイナリファイル | 実行ファイル | 各コンポーネントの実行バイナリ |
| コンテナイメージ | Docker image | 各コンポーネントのコンテナイメージ |
| tarball | tar.gz | リリース用アーカイブ |

### 出力先

`_output/` ディレクトリ配下にビルド成果物を出力

## 処理フロー

### 処理シーケンス

```
1. make all (またはmake build)
   └─ Goコンパイラによる全バイナリのビルド
2. make test
   └─ ユニットテストの実行
3. make test-integration
   └─ 統合テストの実行
4. make release
   └─ リリースアーティファクト（バイナリ、イメージ、tarball）の作成
```

### フローチャート

```mermaid
flowchart TD
    A[make コマンド実行] --> B{ターゲット}
    B -->|all/build| C[Goバイナリビルド]
    B -->|test| D[ユニットテスト実行]
    B -->|release| E[リリースビルド]
    B -->|quick-release| F[クイックリリース]
    C --> G[_output/に出力]
    D --> H[テスト結果出力]
    E --> I[tarball/イメージ生成]
    F --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-154-1 | クロスコンパイル | linux/amd64, linux/arm64等の複数プラットフォーム向けビルドをサポート | KUBE_BUILD_PLATFORMS指定時 |
| BR-154-2 | バージョン埋め込み | ビルド時にGitバージョン情報がバイナリに埋め込まれる | 全ビルド |
| BR-154-3 | 依存関係検証 | ビルド前に依存関係の整合性が検証される | make verify |

### 計算ロジック

特になし。

## データベース操作仕様

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | コンパイルエラー | Goソースの構文エラー | ソースコードを修正 |
| - | 依存関係エラー | go.modとgo.sumの不整合 | go mod tidy を実行 |
| - | イメージビルドエラー | Docker/Podman未インストール | コンテナランタイムをインストール |

### リトライ仕様

ビルドシステムのため、自動リトライはない。エラー修正後に再実行する。

## トランザクション仕様

該当なし。

## パフォーマンス要件

フルビルド（全プラットフォーム）は30分-1時間程度。単一プラットフォームのビルドは数分で完了する。

## セキュリティ考慮事項

- リリースバイナリにはGitバージョンとコミットハッシュが埋め込まれる
- コンテナイメージは署名されてレジストリにプッシュされる
- ビルド環境のセキュリティはCI/CDインフラに依存

## 備考

- `build/` ディレクトリにはDockerベースのビルドインフラが含まれる
- `hack/` ディレクトリには開発支援スクリプトが多数含まれる
- `Makefile` がビルドのメインエントリーポイント

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Makefile | `Makefile` | ビルドターゲットの一覧と依存関係 |
| 1-2 | common.sh | `build/common.sh` | ビルド共通関数 |

**読解のコツ**: MakefileはGoバイナリビルドを`hack/build-go.sh`や`build/`配下のスクリプトに委譲している。まず主要ターゲット（all, test, release）を確認する。

#### Step 2: ビルドスクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | build-go.sh | `hack/build-go.sh` | Goバイナリのビルドスクリプト |
| 2-2 | build-cross.sh | `hack/build-cross.sh` | クロスコンパイルスクリプト |
| 2-3 | lib/ | `build/lib/` | ビルドライブラリ関数 |

#### Step 3: リリーススクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | release.sh | `build/release.sh` | リリースビルドスクリプト |
| 3-2 | release-images.sh | `build/release-images.sh` | リリースイメージビルド |
| 3-3 | package-tarballs.sh | `build/package-tarballs.sh` | tarball作成 |

### プログラム呼び出し階層図

```
Makefile
    |
    +-- hack/build-go.sh (Goビルド)
    |      +-- build/lib/ (ビルドライブラリ)
    |
    +-- hack/build-cross.sh (クロスコンパイル)
    |
    +-- build/release.sh (リリース)
    |      +-- build/release-images.sh (イメージ)
    |      +-- build/package-tarballs.sh (tarball)
    |
    +-- build/run.sh (コンテナ内ビルド)
           +-- build/build-image/ (ビルドイメージ)
```

### データフロー図

```
[入力]                    [処理]                     [出力]

Goソースコード ──────> Goコンパイラ ──────> _output/bin/バイナリ
Dockerfile ──────> Docker build ──────> コンテナイメージ
バイナリ群 ──────> package-tarballs ──> リリースtarball
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Makefile | `Makefile` | ビルド設定 | メインビルドエントリーポイント |
| common.sh | `build/common.sh` | スクリプト | ビルド共通関数 |
| build-go.sh | `hack/build-go.sh` | スクリプト | Goビルドスクリプト |
| build-cross.sh | `hack/build-cross.sh` | スクリプト | クロスコンパイル |
| release.sh | `build/release.sh` | スクリプト | リリースビルド |
| release-images.sh | `build/release-images.sh` | スクリプト | リリースイメージ |
| package-tarballs.sh | `build/package-tarballs.sh` | スクリプト | tarball作成 |
| run.sh | `build/run.sh` | スクリプト | コンテナ内ビルド実行 |
| lib/ | `build/lib/` | スクリプト | ビルドライブラリ |
| build-image/ | `build/build-image/` | 設定 | ビルド用Dockerイメージ |
