# 機能設計書 156-PriorityClass管理

## 概要

本ドキュメントは、Podの優先度クラスの定義とスケジューリング優先度の管理を行う「PriorityClass管理」機能の設計について記述する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesクラスターでは、複数のワークロードが限られたリソースを共有する。PriorityClassにより、Podに優先度を割り当てることで、リソース不足時にどのPodを優先的にスケジューリングし、どのPodをプリエンプション（退避）するかを制御できる。システムクリティカルなPod（kube-system等）は高い優先度を持ち、確実にスケジュールされることが保証される。

**機能の利用シーン**：クラスター管理者がPriorityClassリソースを作成してPodの優先度階層を定義する際、API Server起動時にシステムPriorityClass（system-cluster-critical、system-node-critical）が自動作成される際に利用される。

**主要な処理内容**：
1. PriorityClassリソースのCRUD管理（作成・読取・更新・削除）
2. PriorityClassのバリデーション（名前、値、グローバルデフォルト設定の整合性）
3. システムPriorityClassの自動ブートストラップ
4. Workloadリソースの管理（v1alpha1、GenericWorkloadフィーチャーゲート）

**関連システム・外部連携**：etcd（永続化ストレージ）、スケジューラー（PriorityClass参照）、プリエンプションプラグイン。

**権限による制御**：PriorityClassはクラスタースコープのリソースであり、作成・変更にはcluster-admin相当の権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | バックエンドAPIのため関連画面なし |

## 機能種別

CRUD操作 / 設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| metadata.name | string | Yes | PriorityClassの名前 | DNS-1123準拠 |
| value | int32 | Yes | 優先度の数値（大きいほど高優先） | 整数値 |
| globalDefault | bool | No | グローバルデフォルトとして使用するか | クラスター内で1つのみ |
| description | string | No | PriorityClassの説明 | 任意のテキスト |
| preemptionPolicy | string | No | プリエンプションポリシー | Never/PreemptLowerPriority |

### 入力データソース

API Serverへの直接的なREST APIリクエスト、システムブートストラップポリシー

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| PriorityClass | Object | PriorityClassリソース（metadata + value + globalDefault等） |

### 出力先

etcd（永続化）、API Serverのレスポンス

## 処理フロー

### 処理シーケンス

```
1. API Server起動
   └─ PostStartHook "scheduling/bootstrap-system-priority-classes" が登録される
2. システムPriorityClassの自動作成
   └─ system-cluster-critical, system-node-critical 等の作成を試行
3. ユーザーによるPriorityClass CRUD操作
   └─ バリデーション → etcd永続化 → レスポンス返却
```

### フローチャート

```mermaid
flowchart TD
    A[API Server起動] --> B[PostStartHook実行]
    B --> C[システムPriorityClass一覧取得]
    C --> D{既存チェック}
    D -->|未存在| E[PriorityClass作成]
    D -->|既存| F[スキップ]
    E --> G{全システムPC作成完了?}
    F --> G
    G -->|No| C
    G -->|Yes| H[ブートストラップ完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-156-1 | クラスタースコープ | PriorityClassはNamespaceに属さないクラスタースコープリソース | 全操作 |
| BR-156-2 | 作成専用 | AllowCreateOnUpdate=falseでPOSTによる作成が必要 | 作成操作 |
| BR-156-3 | 無条件更新許可 | AllowUnconditionalUpdate=trueで条件なし更新が可能 | 更新操作 |
| BR-156-4 | Generation管理 | 作成時にGeneration=1が設定される | 作成操作 |
| BR-156-5 | システムPC自動作成 | API Server起動時にシステムPriorityClassが30秒以内に作成される | 起動時 |
| BR-156-6 | 冪等作成 | AlreadyExists エラーは正常として処理される | ブートストラップ時 |

### 計算ロジック

PriorityClassのvalueフィールドは整数値であり、大きい値が高優先度を意味する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| PriorityClass作成 | priorityclasses | INSERT | PriorityClassリソースの作成 |
| PriorityClass取得 | priorityclasses | SELECT | PriorityClassの取得 |
| PriorityClass更新 | priorityclasses | UPDATE | PriorityClassの更新 |
| PriorityClass削除 | priorityclasses | DELETE | PriorityClassの削除 |

### テーブル別操作詳細

#### priorityclasses

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | value, globalDefault, description, preemptionPolicy | ユーザー指定値 | Generation=1自動設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 409 | AlreadyExists | 同名PriorityClassが既存 | 名前を変更または更新操作を使用 |
| 422 | Invalid | バリデーションエラー | リクエスト内容を修正 |
| 503 | ServiceUnavailable | API Serverがストレージバージョン更新中 | リトライ |

### リトライ仕様

ブートストラップ時は1秒間隔で最大30秒間リトライ。ServiceUnavailableの場合もリトライ対象。

## トランザクション仕様

各PriorityClassの操作はetcdのアトミック操作で実行される。

## パフォーマンス要件

ブートストラップは30秒以内に完了する必要がある（タイムアウト設定）。

## セキュリティ考慮事項

- PriorityClassの変更はクラスター全体のスケジューリングに影響するため、cluster-admin権限が必要
- 不正に高い優先度のPriorityClassを作成されるとリソース独占のリスクがある

## 備考

- scheduling.k8s.io APIグループに属する
- v1（GA）バージョンが利用可能
- GenericWorkloadフィーチャーゲート有効時にWorkloadリソースも管理される（v1alpha1）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造と戦略を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | strategy.go | `pkg/registry/scheduling/priorityclass/strategy.go` | PriorityClassのバリデーション・準備戦略 |

**読解のコツ**: **37行目**でStrategy変数が定義。**40-42行目**でNamespaceScoped()=falseが確認でき、クラスタースコープであることがわかる。**45-48行目**のPrepareForCreateでGeneration=1設定。**54-57行目**のValidateでValidatePriorityClassが呼ばれる。**68-70行目**のAllowCreateOnUpdate()=falseでPOST必須。

#### Step 2: ストレージ層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | storage.go | `pkg/registry/scheduling/priorityclass/storage/storage.go` | PriorityClassのREST API実装 |

#### Step 3: RESTストレージプロバイダーとブートストラップを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | storage_scheduling.go | `pkg/registry/scheduling/rest/storage_scheduling.go` | RESTストレージプロバイダー |

**主要処理フロー**:
- **45行目**: PostStartHookName "scheduling/bootstrap-system-priority-classes"
- **51-67行目**: NewRESTStorageでv1とv1alpha1のストレージマップを構築
- **69-82行目**: v1Storageでpriorityclassesのストレージを登録
- **84-100行目**: v1alpha1Storageでworkloads（GenericWorkloadフィーチャーゲート必須）を登録
- **106-148行目**: AddSystemPriorityClassesで1秒間隔・30秒タイムアウトでシステムPCを自動作成。**117行目**でSystemPriorityClasses()から一覧取得、**120-121行目**でNotFoundの場合にCreate実行

### プログラム呼び出し階層図

```
RESTStorageProvider.PostStartHook()
    |
    +-- AddSystemPriorityClasses()
           |
           +-- wait.Poll(1s, 30s)
                  |
                  +-- schedulingclient.NewForConfig()
                  +-- SystemPriorityClasses() (一覧取得)
                  +-- PriorityClasses().Get() (各PC存在確認)
                  +-- PriorityClasses().Create() (未存在の場合作成)
```

### データフロー図

```
[入力]                              [処理]                       [出力]

SystemPriorityClasses() ──────> AddSystemPriorityClasses ──> etcd (PriorityClass)
(ハードコード値)                  (Get→Create パターン)

API リクエスト ──────────────> PriorityClass Strategy ────> etcd (PriorityClass)
(ユーザー定義)                  (バリデーション/準備)          API レスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| strategy.go | `pkg/registry/scheduling/priorityclass/strategy.go` | ソース | PriorityClassバリデーション・準備戦略 |
| storage.go | `pkg/registry/scheduling/priorityclass/storage/storage.go` | ソース | PriorityClassストレージ実装 |
| storage_scheduling.go | `pkg/registry/scheduling/rest/storage_scheduling.go` | ソース | RESTストレージプロバイダー |
| strategy.go (workload) | `pkg/registry/scheduling/workload/strategy.go` | ソース | Workloadリソース戦略 |
| storage.go (workload) | `pkg/registry/scheduling/workload/storage/storage.go` | ソース | Workloadストレージ実装 |
