# 機能設計書 157-RBAC管理

## 概要

本ドキュメントは、Role、ClusterRole、RoleBinding、ClusterRoleBindingによるロールベースアクセス制御を管理する「RBAC管理」機能の設計について記述する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesクラスターにおけるセキュリティの基盤であるRBAC（Role-Based Access Control）は、誰が（Subject）、どのリソースに（Resource）、何をできるか（Verb）を定義する仕組みである。本機能は、RBAC関連リソース（Role, ClusterRole, RoleBinding, ClusterRoleBinding）のレジストリ管理、ポリシーベースのアクセス制御、ブートストラップロールの自動作成・リコンシリエーションを提供する。

**機能の利用シーン**：クラスター管理者がユーザーやサービスアカウントに権限を付与する際、API Server起動時にブートストラップロール/バインディングが自動作成される際、kubectl auth can-iで権限確認する際に利用される。

**主要な処理内容**：
1. Role/ClusterRole/RoleBinding/ClusterRoleBindingの4リソースのCRUD管理
2. ポリシーベースのストレージ（権限昇格チェック付きの作成・更新）
3. ブートストラップロールとバインディングの自動作成・リコンシリエーション
4. 集約ClusterRoleのマイグレーション
5. ClusterRoleBindingの分割マイグレーション
6. エスカレーションチェック（権限昇格防止）
7. バインディング認可チェック

**関連システム・外部連携**：etcd（永続化）、API Serverの認可モジュール、kubectl auth。

**権限による制御**：RBACリソースの操作にはescalate/bind権限が必要。system:mastersグループのメンバーはエスカレーションが常に許可される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | kubectl auth | API連携 | can-iコマンドでRBACポリシーに基づくアクセス判定を行う |

## 機能種別

CRUD操作 / アクセス制御 / 設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Role.rules | []PolicyRule | Yes | 許可するリソースとVerbの組み合わせ | バリデーション関数 |
| ClusterRole.rules | []PolicyRule | Yes | クラスタースコープの許可ルール | バリデーション関数 |
| ClusterRole.aggregationRule | AggregationRule | No | ラベルセレクターによるルール集約 | バリデーション関数 |
| RoleBinding.roleRef | RoleRef | Yes | バインド先のRole/ClusterRole参照 | 不変（変更不可） |
| RoleBinding.subjects | []Subject | Yes | 権限を付与する対象 | バリデーション関数 |

### 入力データソース

API Serverへの直接的なREST APIリクエスト、ブートストラップポリシー（bootstrappolicy パッケージ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Role | Object | Namespace内のロール定義 |
| ClusterRole | Object | クラスタースコープのロール定義 |
| RoleBinding | Object | Namespace内のロールバインディング |
| ClusterRoleBinding | Object | クラスタースコープのロールバインディング |

### 出力先

etcd（永続化）、API Serverのレスポンス

## 処理フロー

### 処理シーケンス

```
1. API Server起動
   └─ PostStartHook "rbac/bootstrap-roles" が登録される
2. ブートストラップロールの作成
   └─ 1秒間隔・30秒タイムアウトで以下を順番に実行
   a. etcd応答確認（ClusterRoles/ClusterRoleBindingsのList）
   b. 集約ClusterRoleのマイグレーション
   c. ClusterRoleBindingの分割マイグレーション
   d. ClusterRoleのリコンシリエーション
   e. ClusterRoleBindingのリコンシリエーション
   f. Namespace Roleのリコンシリエーション
   g. Namespace RoleBindingのリコンシリエーション
3. ユーザーによるRBACリソースCRUD操作
   └─ ポリシーチェック → バリデーション → etcd永続化
```

### フローチャート

```mermaid
flowchart TD
    A[API Server起動] --> B[PostStartHook: rbac/bootstrap-roles]
    B --> C[etcd応答確認]
    C --> D[集約ClusterRoleマイグレーション]
    D --> E[ClusterRoleBinding分割]
    E --> F[ClusterRoleリコンシリエーション]
    F --> G[ClusterRoleBindingリコンシリエーション]
    G --> H[Namespace Roleリコンシリエーション]
    H --> I[Namespace RoleBindingリコンシリエーション]
    I --> J{全て成功?}
    J -->|No| C
    J -->|Yes| K[ブートストラップ完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-157-1 | エスカレーション防止 | ユーザーは自身が持っていない権限をRoleに設定できない（escalate権限がない場合） | Role/ClusterRole作成・更新時 |
| BR-157-2 | バインディング認可 | RoleBindingの作成にはroleRefのRole/ClusterRoleに対するbind権限が必要 | RoleBinding作成時 |
| BR-157-3 | system:mastersバイパス | system:mastersグループのメンバーはエスカレーション・バインディングチェックをバイパス | 全操作 |
| BR-157-4 | リコンシリエーション保護 | reconcile-protectedアノテーション付きリソースは自動リコンシリエーションから保護される | ブートストラップ時 |
| BR-157-5 | コンフリクトリトライ | Conflict/ServiceUnavailableエラーは自動リトライされる | ブートストラップ時 |

### 計算ロジック

AuthorizationRuleResolverにより、Role/RoleBinding/ClusterRole/ClusterRoleBindingから現在のユーザーの権限を解決し、要求された操作が許可されるかを判定する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ブートストラップ | roles, clusterroles, rolebindings, clusterrolebindings | INSERT/UPDATE | ブートストラップリソースの作成・更新 |
| ユーザーCRUD | roles, clusterroles, rolebindings, clusterrolebindings | 全種別 | ユーザー操作のCRUD |

### テーブル別操作詳細

#### clusterroles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| リコンシリエーション | rules | ブートストラップポリシーのルール | MissingRulesのみ追加 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | escalate/bind権限がない | 権限を付与するか、system:masters経由で操作 |
| 409 | Conflict | 同時更新の競合 | リトライ |
| 503 | ServiceUnavailable | ストレージバージョン更新中 | リトライ |

### リトライ仕様

ブートストラップ時はwait.Pollで1秒間隔・30秒タイムアウト。個別リコンシリエーションはretry.DefaultBackoffでConflict/ServiceUnavailableエラーをリトライ。

## トランザクション仕様

各リソース操作はetcdのアトミック操作。4リソース間のトランザクションはないが、ブートストラップ処理は全体の成功/失敗で判定される。

## パフォーマンス要件

ブートストラップは30秒以内に完了する必要がある。

## セキュリティ考慮事項

- エスカレーション防止機構により、権限昇格攻撃を防止
- バインディング認可により、不正なロール付与を防止
- system:mastersグループは信頼された特権グループとして扱われる
- reconcile-protectedアノテーションにより、カスタマイズされたロールが自動更新で上書きされることを防止

## 備考

- rbac.authorization.k8s.io APIグループに属する
- v1（GA）バージョンが利用可能
- PostStartHook名: "rbac/bootstrap-roles"

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エスカレーションチェックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | escalation_check.go | `pkg/registry/rbac/escalation_check.go` | エスカレーション・バインディング認可ロジック |

**読解のコツ**: **32-47行目**のEscalationAllowedでsystem:mastersグループのバイパスを確認。**55-98行目**のRoleEscalationAuthorizedで「escalate」verbによる認可確認。**101-146行目**のBindingAuthorizedで「bind」verbによるRoleRef認可確認。

#### Step 2: RESTストレージプロバイダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | storage_rbac.go | `pkg/registry/rbac/rest/storage_rbac.go` | RESTストレージプロバイダーとブートストラップ処理 |

**主要処理フロー**:
- **59行目**: PostStartHookName "rbac/bootstrap-roles"
- **67-79行目**: NewRESTStorageで4リソースのストレージ構築
- **81-129行目**: storage関数でRole/RoleBinding/ClusterRole/ClusterRoleBinding各ストレージを初期化。**101-106行目**でAuthorizationRuleResolverを構築
- **131-141行目**: PostStartHookでブートストラップポリシーを設定
- **162-180行目**: EnsureRBACPolicyで1秒/30秒ポーリング
- **183-340行目**: ensureRBACPolicyでetcd確認→集約マイグレーション→分割マイグレーション→ClusterRole/Binding/Role/Bindingのリコンシリエーション

#### Step 3: ポリシーベースストレージを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | storage.go (role policybased) | `pkg/registry/rbac/role/policybased/storage.go` | Roleのポリシーチェック付きストレージ |
| 3-2 | storage.go (clusterrole policybased) | `pkg/registry/rbac/clusterrole/policybased/storage.go` | ClusterRoleのポリシーチェック付きストレージ |
| 3-3 | storage.go (rolebinding policybased) | `pkg/registry/rbac/rolebinding/policybased/storage.go` | RoleBindingのポリシーチェック付きストレージ |
| 3-4 | storage.go (clusterrolebinding policybased) | `pkg/registry/rbac/clusterrolebinding/policybased/storage.go` | ClusterRoleBindingのポリシーチェック付きストレージ |

#### Step 4: バリデーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | rule.go | `pkg/registry/rbac/validation/rule.go` | RBAC ルール解決ロジック |
| 4-2 | policy_compact.go | `pkg/registry/rbac/validation/policy_compact.go` | ポリシーの圧縮表示 |

### プログラム呼び出し階層図

```
RESTStorageProvider.PostStartHook()
    |
    +-- PolicyData.EnsureRBACPolicy()
           |
           +-- wait.Poll(1s, 30s)
                  |
                  +-- ensureRBACPolicy()
                         |
                         +-- ClusterRoles().List() (etcd確認)
                         +-- ClusterRoleBindings().List() (etcd確認)
                         +-- primeAggregatedClusterRoles() (集約マイグレーション)
                         +-- primeSplitClusterRoleBindings() (分割マイグレーション)
                         +-- reconciliation.ReconcileRoleOptions.Run() (各リソースリコンシリエーション)
```

### データフロー図

```
[入力]                                [処理]                          [出力]

bootstrappolicy.ClusterRoles() ──> reconciliation.Run() ──────> etcd (ClusterRole)
bootstrappolicy.ClusterRoleBindings() ────────────────────────> etcd (ClusterRoleBinding)
bootstrappolicy.NamespaceRoles() ─────────────────────────────> etcd (Role)
bootstrappolicy.NamespaceRoleBindings() ──────────────────────> etcd (RoleBinding)

API リクエスト ──> policybased.Storage ──> escalation/bind check ──> etcd
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| storage_rbac.go | `pkg/registry/rbac/rest/storage_rbac.go` | ソース | RESTストレージプロバイダーとブートストラップ |
| escalation_check.go | `pkg/registry/rbac/escalation_check.go` | ソース | エスカレーション・バインディング認可チェック |
| helpers.go | `pkg/registry/rbac/helpers.go` | ソース | RBAC ヘルパー関数 |
| strategy.go (role) | `pkg/registry/rbac/role/strategy.go` | ソース | Role戦略 |
| strategy.go (clusterrole) | `pkg/registry/rbac/clusterrole/strategy.go` | ソース | ClusterRole戦略 |
| strategy.go (rolebinding) | `pkg/registry/rbac/rolebinding/strategy.go` | ソース | RoleBinding戦略 |
| strategy.go (clusterrolebinding) | `pkg/registry/rbac/clusterrolebinding/strategy.go` | ソース | ClusterRoleBinding戦略 |
| storage.go (role policybased) | `pkg/registry/rbac/role/policybased/storage.go` | ソース | Roleポリシーベースストレージ |
| storage.go (clusterrole policybased) | `pkg/registry/rbac/clusterrole/policybased/storage.go` | ソース | ClusterRoleポリシーベースストレージ |
| rule.go | `pkg/registry/rbac/validation/rule.go` | ソース | ルール解決ロジック |
