# 機能設計書 158-リース管理

## 概要

本ドキュメントは、Leaseリソースによるリーダーエレクション、ノードハートビート管理を行う「リース管理」機能の設計について記述する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesの分散システムにおいて、リーダーエレクション（単一のアクティブなコントローラーの選出）やノードの生存確認（ハートビート）は重要な機構である。Leaseリソースは、これらの目的で使用される軽量なロック機構を提供する。Kubeletがノードのハートビートを効率的に報告し、コントローラーが安全にリーダーエレクションを実行するための基盤となる。

**機能の利用シーン**：Kubeletがノードのハートビートを更新する際、kube-controller-managerやkube-schedulerがリーダーエレクションを行う際、LeaseCandidateリソースによるCoordinated Leader Electionを行う際に利用される。

**主要な処理内容**：
1. Leaseリソースの CRUD管理（Namespaceスコープ）
2. LeaseCandidateリソースの管理（v1beta1/v1alpha2）
3. Leaseのバリデーションとバージョン間の整合性管理
4. Coordinated Leader ElectionフィーチャーゲートによるStrategy/PreferredHolderフィールドの制御
5. 複数APIバージョン（v1, v1beta1, v1alpha2）のストレージ管理

**関連システム・外部連携**：etcd（永続化ストレージ）、Kubelet（ノードハートビート）、コントローラーマネージャー（リーダーエレクション）。

**権限による制御**：Leaseリソースへの読み書きはRBACにより制御される。各コンポーネントは自身のLeaseリソースのみ更新できるよう設定される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | バックエンドAPIのため関連画面なし |

## 機能種別

CRUD操作 / ロック管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| metadata.namespace | string | Yes | Leaseが属するNamespace | 有効なNamespace名 |
| metadata.name | string | Yes | Lease名 | DNS-1123準拠 |
| spec.holderIdentity | *string | No | 現在のリース保持者のID | 任意の文字列 |
| spec.leaseDurationSeconds | *int32 | No | リースの有効期間（秒） | 正の整数 |
| spec.acquireTime | *MicroTime | No | リース取得時刻 | 有効なタイムスタンプ |
| spec.renewTime | *MicroTime | No | リース更新時刻 | 有効なタイムスタンプ |
| spec.leaseTransitions | *int32 | No | リーダー遷移回数 | 非負整数 |
| spec.strategy | *CoordinatedLeaseStrategy | No | リーダーエレクション戦略 | CoordinatedLeaderElection有効時のみ |
| spec.preferredHolder | *string | No | 優先リーダー候補 | CoordinatedLeaderElection有効時のみ |

### 入力データソース

API Serverへの直接的なREST APIリクエスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Lease | Object | Leaseリソース（metadata + spec） |
| LeaseCandidate | Object | LeaseCandidateリソース |

### 出力先

etcd（永続化）、API Serverのレスポンス

## 処理フロー

### 処理シーケンス

```
1. Lease作成リクエスト受信
   └─ PrepareForCreateでフィーチャーゲートに基づくフィールド制御
2. バリデーション実行
   └─ validation.ValidateLeaseで入力検証
3. etcd永続化
   └─ ストレージ層でetcdに書き込み
4. レスポンス返却
   └─ 作成されたLeaseオブジェクトを返却
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B{操作種別}
    B -->|Create| C[PrepareForCreate]
    B -->|Update| D[PrepareForUpdate]
    C --> E{CoordinatedLeaderElection有効?}
    E -->|No| F[Strategy/PreferredHolder削除]
    E -->|Yes| G[そのまま]
    F --> H[バリデーション]
    G --> H
    D --> I{フィーチャーゲートチェック}
    I --> H
    H --> J[etcd永続化]
    J --> K[レスポンス返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-158-1 | Namespaceスコープ | LeaseはNamespace内にスコープされる | 全操作 |
| BR-158-2 | PUT作成許可 | AllowCreateOnUpdate=trueでPUTリクエストでの作成が可能 | 作成/更新操作 |
| BR-158-3 | 条件付き更新 | AllowUnconditionalUpdate=falseで条件なし更新は不可 | 更新操作 |
| BR-158-4 | フィーチャーゲート制御 | CoordinatedLeaderElectionが無効の場合、Strategy/PreferredHolderは削除される | 作成・更新時 |
| BR-158-5 | 既存フィールド保持 | 更新時、既存リソースにStrategy/PreferredHolderがある場合は無効時でも保持 | 更新操作 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Lease作成 | leases | INSERT | Leaseリソースの作成 |
| Lease更新 | leases | UPDATE | ハートビート更新等 |
| Lease取得 | leases | SELECT | リーダー確認等 |
| Lease削除 | leases | DELETE | Leaseの削除 |
| LeaseCandidate操作 | leasecandidates | 全種別 | LeaseCandidateのCRUD |

### テーブル別操作詳細

#### leases

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | spec.renewTime | 現在時刻 | ハートビート更新 |
| UPDATE | spec.holderIdentity | リーダーID | リーダーエレクション |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 409 | Conflict | 楽観的ロック競合（resourceVersionの不一致） | 再取得してリトライ |
| 404 | NotFound | 指定されたLeaseが存在しない | Leaseを作成 |
| 422 | Invalid | バリデーションエラー | リクエスト内容を修正 |

### リトライ仕様

リーダーエレクションクライアントが内部でリトライロジックを持つ。Leaseの更新失敗時はリーダーシップを喪失する。

## トランザクション仕様

etcdの楽観的ロック（resourceVersionベース）により、同時更新の整合性を保証する。AllowUnconditionalUpdate=falseにより、resourceVersionの一致が必須。

## パフォーマンス要件

ノードハートビートは通常10秒間隔で更新される。大規模クラスターではLease更新のスループットが重要。

## セキュリティ考慮事項

- 各コンポーネントは自身のLeaseのみ更新するようRBACで制御
- Leaseの不正な更新はリーダーエレクションの破綻やハートビートの偽装につながるリスクがある

## 備考

- coordination.k8s.io APIグループに属する
- v1（GA）、v1beta1、v1alpha2の3バージョンが利用可能
- LeaseCandidateはv1beta1/v1alpha2で提供される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Lease戦略を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | strategy.go (lease) | `pkg/registry/coordination/lease/strategy.go` | Leaseのバリデーション・準備戦略 |

**読解のコツ**: **39行目**でStrategy変数定義。**42-44行目**でNamespaceScoped()=trueが確認できる。**47-54行目**のPrepareForCreateでCoordinatedLeaderElectionフィーチャーゲートに基づくフィールド制御が行われる。**57-68行目**のPrepareForUpdateで既存リソースのフィールド保持ロジックが実装されている。**84-86行目**でAllowCreateOnUpdate()=true、**99-101行目**でAllowUnconditionalUpdate()=falseが確認できる。

#### Step 2: ストレージ層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | storage.go | `pkg/registry/coordination/lease/storage/storage.go` | Leaseのストレージ実装 |
| 2-2 | storage.go (leasecandidate) | `pkg/registry/coordination/leasecandidate/storage/storage.go` | LeaseCandidateのストレージ |

#### Step 3: RESTストレージプロバイダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | storage_coordination.go | `pkg/registry/coordination/rest/storage_coordination.go` | RESTストレージプロバイダー |

**主要処理フロー**:
- **35-59行目**: NewRESTStorageでv1/v1beta1/v1alpha2の3バージョンのストレージを構築
- **61-73行目**: v1Storageでleasesリソースを登録
- **75-87行目**: v1beta1Storageでleasecandidatesを登録
- **89-101行目**: v1alpha2Storageでleasecandidatesを登録

### プログラム呼び出し階層図

```
RESTStorageProvider.NewRESTStorage()
    |
    +-- v1Storage()
    |      +-- leasestorage.NewREST() -> Lease Strategy
    |
    +-- v1beta1Storage()
    |      +-- leasecandidatestorage.NewREST() -> LeaseCandidate Strategy
    |
    +-- v1alpha2Storage()
           +-- leasecandidatestorage.NewREST() -> LeaseCandidate Strategy
```

### データフロー図

```
[入力]                     [処理]                      [出力]

Kubelet ──────────> Lease Update ──────────> etcd (Lease)
(ハートビート)         (renewTime更新)

Controller ────────> Lease Create/Update ──> etcd (Lease)
(リーダーエレクション)  (holderIdentity設定)

LeaseCandidate ────> LeaseCandidate CRUD ──> etcd (LeaseCandidate)
(Coordinated LE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| strategy.go | `pkg/registry/coordination/lease/strategy.go` | ソース | Leaseバリデーション・準備戦略 |
| storage.go | `pkg/registry/coordination/lease/storage/storage.go` | ソース | Leaseストレージ実装 |
| strategy.go | `pkg/registry/coordination/leasecandidate/strategy.go` | ソース | LeaseCandidate戦略 |
| storage.go | `pkg/registry/coordination/leasecandidate/storage/storage.go` | ソース | LeaseCandidateストレージ |
| storage_coordination.go | `pkg/registry/coordination/rest/storage_coordination.go` | ソース | RESTストレージプロバイダー |
