# 機能設計書 4-アドミッション制御

## 概要

本ドキュメントは、Kubernetes API Serverにおけるアドミッション制御機能の設計書である。リソースの作成・更新・削除リクエストに対してMutating/Validating Admission Webhookおよびビルトインプラグインによる検証・変換を行う。

### 本機能の処理概要

アドミッション制御は、認証・認可を通過したリクエストに対して、リソースの内容を検証・変換する最後のゲートキーパーである。Mutatingフェーズでリソースを変換し、Validatingフェーズで最終検証を行う。

**業務上の目的・背景**：リソースの品質保証とポリシー適用を自動化するために不可欠な機能である。例えば、全Podにサイドカーコンテナを自動注入する（Istio等）、リソースリミットのデフォルト値を設定する、Namespaceラベルに基づくポリシーを適用する、セキュリティポリシーの遵守を強制するなど、クラスター運用のベストプラクティスを自動化する。

**機能の利用シーン**：リソースのCREATE、UPDATE、DELETE、CONNECT操作時に自動実行される。Webhookによるカスタムポリシーの適用（OPA/Gatekeeper等）、ビルトインプラグインによるデフォルト値設定（DefaultStorageClass等）、Pod Security Admissionによるセキュリティ検証、リソースクォータの使用量チェックなど。

**主要な処理内容**：
1. Mutating Admission Webhookの実行（リソースの変換・デフォルト値設定）
2. ビルトインMutatingプラグインの実行
3. オブジェクトスキーマバリデーション
4. Validating Admission Webhookの実行（リソースの検証）
5. ビルトインValidatingプラグインの実行
6. ValidatingAdmissionPolicyによるCEL式ベースの検証
7. MutatingAdmissionPolicyによるCEL式ベースの変換

**関連システム・外部連携**：外部Webhook（HTTP/HTTPS）、OPA/Gatekeeper、Istio、cert-manager等

**権限による制御**：MutatingWebhookConfigurationおよびValidatingWebhookConfigurationの作成・変更は管理者権限が必要。namespaceSelector/objectSelectorによりWebhookの適用範囲を制限可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | kubectl create | API連携 | リソース作成時にMutating/Validating Admission Webhookによる検証・変換が実行される |
| 30 | kubectl apply | API連携 | 適用時にAdmission Webhookによる検証・変換が実行される |

## 機能種別

バリデーション / データ変換 / ポリシー適用

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AdmissionRequest.Object | runtime.Object | Yes | 変更後のリソースオブジェクト | スキーマ準拠 |
| AdmissionRequest.OldObject | runtime.Object | No | 変更前のリソースオブジェクト（UPDATE時） | - |
| AdmissionRequest.Operation | string | Yes | CREATE/UPDATE/DELETE/CONNECT | 有効な操作 |
| AdmissionRequest.Resource | GVR | Yes | APIグループ/バージョン/リソース | 有効なGVR |
| AdmissionRequest.UserInfo | user.Info | Yes | リクエスト送信者情報 | 認証済み |
| AdmissionRequest.DryRun | bool | No | ドライラン実行フラグ | - |

### 入力データソース

認可通過後のAPIリクエスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AdmissionResponse.Allowed | bool | 許可/拒否 |
| AdmissionResponse.Patch | []byte | Mutating時のJSONパッチ |
| AdmissionResponse.PatchType | string | パッチタイプ（JSONPatch） |
| AdmissionResponse.Warnings | []string | 警告メッセージ |
| AdmissionResponse.Result | Status | エラー時の詳細ステータス |

### 出力先

API Serverの処理パイプライン（許可された場合はストレージ永続化へ、拒否された場合はエラーレスポンス返却）

## 処理フロー

### 処理シーケンス

```
1. 認可通過後のリクエスト受信
   └─ AdmissionRequestオブジェクトを構築
2. Mutating Admission実行
   └─ ビルトインMutatingプラグインとMutating Webhookを順次実行
3. オブジェクトデフォルト値設定
   └─ APIグループのデフォルト値を適用
4. スキーマバリデーション
   └─ OpenAPIスキーマに基づくフィールド検証
5. Validating Admission実行
   └─ ビルトインValidatingプラグインとValidating Webhookを並列実行
6. ValidatingAdmissionPolicy実行
   └─ CEL式に基づくポリシー検証
7. 最終結果判定
   └─ 全てのアドミッション制御が許可した場合のみストレージへ永続化
```

### フローチャート

```mermaid
flowchart TD
    A[認可通過リクエスト] --> B[Mutating Admission]
    B --> B1[ビルトインMutatingプラグイン]
    B1 --> B2[Mutating Webhooks]
    B2 --> C[スキーマバリデーション]
    C --> D[Validating Admission]
    D --> D1[ビルトインValidatingプラグイン]
    D1 --> D2[Validating Webhooks]
    D2 --> D3[ValidatingAdmissionPolicy]
    D3 -->|全て許可| E[ストレージ永続化]
    D3 -->|いずれか拒否| F[422エラー返却]
    B2 -->|拒否| F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-1 | Mutating先行 | Mutating Admissionが先に実行され、その結果をValidating Admissionが検証 | CREATE/UPDATE操作時 |
| BR-2 | Validating並列実行 | Validating Webhookは並列で実行可能（順序保証なし） | Validatingフェーズ |
| BR-3 | failurePolicy | Webhook到達不能時のfailurePolicy（Fail/Ignore）で動作を制御 | Webhook通信エラー時 |
| BR-4 | reinvocationPolicy | Mutating Webhookの再呼び出しポリシー（Never/IfNeeded） | Mutating Webhook間の依存時 |
| BR-5 | matchPolicy | Exact/Equivalentで一致するリソースバージョンの範囲を制御 | API バージョン変換時 |
| BR-6 | sideEffects | NoneまたはNoneOnDryRunの指定が必須 | ドライラン対応 |

### 計算ロジック

Mutating Webhookはチェーン順序で実行され、各Webhookが返すJSONパッチがオブジェクトに適用される。reinvocationPolicy=IfNeededの場合、前のWebhookが変更したオブジェクトで後のWebhookを再実行する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Webhook設定読み取り | etcd | SELECT | MutatingWebhookConfiguration, ValidatingWebhookConfigurationの読み取り |
| Policy読み取り | etcd | SELECT | ValidatingAdmissionPolicy, MutatingAdmissionPolicyの読み取り |

### テーブル別操作詳細

#### etcd (Admission Configuration)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | /registry/mutatingwebhookconfigurations/{name} | Webhook設定の読み取り | Informerキャッシュで高速化 |
| SELECT | /registry/validatingwebhookconfigurations/{name} | Webhook設定の読み取り | Informerキャッシュで高速化 |
| SELECT | /registry/validatingadmissionpolicies/{name} | CELベースポリシーの読み取り | Informerキャッシュで高速化 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 422 | Unprocessable | アドミッション制御がリソースを拒否 | リソースマニフェストをポリシーに適合するよう修正 |
| 500 | InternalServerError | Webhook通信エラー（failurePolicy=Fail） | Webhookサービスの状態を確認 |
| 408 | Timeout | Webhookのタイムアウト（デフォルト10秒） | Webhook処理の高速化またはタイムアウト延長 |

### リトライ仕様

Webhook通信エラー時のリトライはクライアント側で実装。API Server側ではfailurePolicyに基づき即時判定を返却。

## トランザクション仕様

アドミッション制御は単一リクエスト内で完結する。Mutating WebhookのJSONパッチ適用はアトミックに実行される。

## パフォーマンス要件

- Webhookタイムアウト: デフォルト10秒、設定可能（最大30秒）
- Validating Webhookの並列実行による高速化
- ValidatingAdmissionPolicyのCEL式はインプロセスで評価され、Webhookより高速

## セキュリティ考慮事項

- WebhookサービスとのTLS通信が必須
- caBundle設定による信頼するCA証明書の明示的指定
- namespaceSelector/objectSelectorによるWebhook適用範囲の限定
- Webhook設定変更は管理者権限に限定すべき
- Mutating Webhookは任意のリソース変更が可能なため、信頼性の検証が重要

## 備考

ValidatingAdmissionPolicyはKubernetes 1.26で導入されたCELベースのインプロセス検証機能であり、Webhookと比較してレイテンシが低い。MutatingAdmissionPolicyはより新しい機能として開発中。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/admissionregistration/v1/types.go` | MutatingWebhookConfiguration, ValidatingWebhookConfiguration, Webhook構造体 |
| 1-2 | admission interfaces | `staging/src/k8s.io/apiserver/pkg/admission/` | Interface, MutationInterface, ValidationInterface |

**読解のコツ**: admission.Interfaceが全プラグインの基底インターフェース。MutationInterfaceがAdmit()、ValidationInterfaceがValidate()を提供する。

#### Step 2: Admission制御チェーンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | admission/ | `staging/src/k8s.io/apiserver/pkg/admission/` | chainAdmissionHandler, pluginInitializer |
| 2-2 | webhook/ | `staging/src/k8s.io/apiserver/pkg/admission/plugin/webhook/` | Webhook実行ロジック |

#### Step 3: レジストリを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rest/ | `pkg/registry/admissionregistration/rest/` | Admission関連リソースのRESTストレージ |
| 3-2 | resolver/ | `pkg/registry/admissionregistration/resolver/` | Webhookリゾルバー |

### プログラム呼び出し階層図

```
API Request (post-authorization)
    │
    ├─ Mutating Admission Chain
    │      ├─ Built-in Mutating Plugins
    │      │      ├─ DefaultStorageClass
    │      │      ├─ DefaultTolerationSeconds
    │      │      └─ ServiceAccount (auto-mount)
    │      └─ Mutating Webhooks (sequential)
    │             └─ HTTP POST → External Webhook Service
    │
    ├─ Schema Validation
    │
    └─ Validating Admission Chain
           ├─ Built-in Validating Plugins
           │      ├─ ResourceQuota
           │      ├─ LimitRanger
           │      └─ PodSecurity
           ├─ Validating Webhooks (parallel)
           │      └─ HTTP POST → External Webhook Service
           └─ ValidatingAdmissionPolicy (CEL)
```

### データフロー図

```
[入力]                     [処理]                             [出力]

AdmissionRequest ──────▶ Mutating Chain ──────▶ 変換済みオブジェクト
├─ Object                 │                        │
├─ OldObject              └─ JSONPatch適用          │
├─ Operation                                        ▼
├─ UserInfo             Validating Chain ──────▶ 許可/拒否
└─ DryRun               ├─ Webhooks (並列)        ├─ Allowed: bool
                         └─ CEL Policies           └─ Warnings: []string
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| admission/ | `staging/src/k8s.io/apiserver/pkg/admission/` | ソース | アドミッション制御フレームワーク |
| webhook/ | `staging/src/k8s.io/apiserver/pkg/admission/plugin/webhook/` | ソース | Webhook実行ロジック |
| rest/ | `pkg/registry/admissionregistration/rest/` | ソース | AdmissionRegistration RESTストレージ |
| mutatingwebhookconfiguration/ | `pkg/registry/admissionregistration/mutatingwebhookconfiguration/` | ソース | MutatingWebhookConfigurationレジストリ |
| validatingwebhookconfiguration/ | `pkg/registry/admissionregistration/validatingwebhookconfiguration/` | ソース | ValidatingWebhookConfigurationレジストリ |
| validatingadmissionpolicy/ | `pkg/registry/admissionregistration/validatingadmissionpolicy/` | ソース | ValidatingAdmissionPolicyレジストリ |
| plugin/pkg/admission/ | `plugin/pkg/admission/` | ソース | ビルトインアドミッションプラグイン |
