# 機能設計書 43-TaintTolerationプラグイン

## 概要

本ドキュメントは、Kubernetesスケジューラーの`TaintToleration`プラグインの機能設計を記述する。本プラグインはノードのTaint（汚染）とPodのToleration（許容）を照合し、Podがノードに配置可能かどうかのフィルタリングと、PreferNoSchedule Taintに基づくスコアリングを行う。

### 本機能の処理概要

**業務上の目的・背景**：Taint/Tolerationは、特定のノードに特定のPodのみを配置するための仕組みである。ノードにTaintを設定すると、対応するTolerationを持たないPodはそのノードにスケジュールされない。これにより専用ノード、GPU搭載ノード、メンテナンス中ノードなどの制御を実現する。

**機能の利用シーン**：ノードにTaintが設定されている場合に自動的に動作する。NoSchedule Taintによるハードフィルタリング、PreferNoSchedule Taintによるソフトスコアリングの2段階で制御。

**主要な処理内容**：
1. Filter: ノードのTaint（NoSchedule/NoExecute）とPodのTolerationを照合し、未許容のTaintがある場合はフィルタ失敗
2. PreScore: PodのPreferNoSchedule Tolerationをリスト化しCycleStateに保存
3. Score: ノードのPreferNoSchedule Taintのうち未許容数をカウント（少ないほど高スコア）
4. NormalizeScore: スコアを逆転正規化（未許容Taintが少ないノードが高スコア）

**関連システム・外部連携**：なし。

**権限による制御**：フィーチャーゲート（EnableSchedulingQueueHint、EnableTaintTolerationComparisonOperators）により動作が制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | スケジューラー内部プラグインとして自動実行 |

## 機能種別

フィルタリング / スコアリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Pod | v1.Pod | Yes | スケジュール対象Pod（Tolerations含む） | - |
| NodeInfo | fwk.NodeInfo | Yes | ノード情報（Taints含む） | - |

### 入力データソース

- Pod.Spec.Tolerations
- Node.Spec.Taints

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| FilterStatus | fwk.Status | フィルタリング結果（nil=通過、UnschedulableAndUnresolvable=Taint不許容） |
| Score | int64 | 未許容PreferNoSchedule Taint数（NormalizeScoreで逆転） |

## 処理フロー

### 処理シーケンス

```
1. Filter: Taint/Toleration照合
   └─ FindMatchingUntoleratedTaint で NoSchedule/NoExecute Taintを検索
   └─ DoNotScheduleTaintsFilterFunc がフィルタ関数として使用
   └─ 未許容Taintがあれば UnschedulableAndUnresolvable を返す

2. PreScore: PreferNoSchedule Tolerationの抽出
   └─ getAllTolerationPreferNoSchedule でPreferNoSchedule/空Effect Tolerationを収集
   └─ CycleStateに保存

3. Score: 未許容PreferNoSchedule Taintのカウント
   └─ countIntolerableTaintsPreferNoSchedule で未許容数を算出

4. NormalizeScore: スコア逆転正規化
   └─ helper.DefaultNormalizeScore で最大値からの逆転（100 - normalized）
```

### フローチャート

```mermaid
flowchart TD
    A[Filter: Taint/Toleration照合] --> B{未許容NoSchedule/NoExecute Taintあり?}
    B -->|Yes| C[UnschedulableAndUnresolvable]
    B -->|No| D[フィルタ通過]
    D --> E[PreScore: PreferNoSchedule Toleration抽出]
    E --> F[Score: 未許容PreferNoSchedule Taint数カウント]
    F --> G[NormalizeScore: 逆転正規化]
    G --> H["高スコア = 未許容Taint少"]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | NoSchedule排除 | NoSchedule Taintに対応するTolerationがない場合はフィルタ失敗 | Taint Effect=NoSchedule |
| BR-02 | NoExecute排除 | NoExecute Taintに対応するTolerationがない場合もフィルタ失敗 | Taint Effect=NoExecute |
| BR-03 | PreferNoScheduleスコア | PreferNoSchedule Taintの未許容数が少ないノードほど高スコア | Taint Effect=PreferNoSchedule |
| BR-04 | 空Effect Toleration | Effect未指定のTolerationは全Effectに適用 | Toleration.Effect="" |
| BR-05 | ComparisonOperators | EnableTaintTolerationComparisonOperators有効時、Taintの比較演算子を使用 | フィーチャーゲート有効時 |

## データベース操作仕様

本機能はデータベースへの直接操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| UnschedulableAndUnresolvable | Taint不許容 | NoSchedule/NoExecute Taint未許容 | 別ノード検索 |

## トランザクション仕様

トランザクションは使用しない。

## パフォーマンス要件

- QueueingHintによりTaint変更時のみ再スケジュールをトリガー
- Pod Tolerationの変更も検知してQueueに戻す

## セキュリティ考慮事項

- Taint/TolerationはRBACにより制御可能

## 備考

- EnableTaintTolerationComparisonOperatorsフィーチャーゲートにより比較演算子が利用可能

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | taint_toleration.go | `pkg/scheduler/framework/plugins/tainttoleration/taint_toleration.go` | TaintToleration構造体（35-39行目）、preScoreState（135-137行目） |

#### Step 2: フィルタリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | taint_toleration.go | `pkg/scheduler/framework/plugins/tainttoleration/taint_toleration.go` | Filter関数（119-132行目） |

**主要処理**: **123-125行目**: `FindMatchingUntoleratedTaint`で未許容Taintを検索。`DoNotScheduleTaintsFilterFunc()`がNoScheduleとNoExecuteを対象とするフィルタ関数。

#### Step 3: スコアリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | taint_toleration.go | `pkg/scheduler/framework/plugins/tainttoleration/taint_toleration.go` | PreScore（157-164行目）、Score（195-207行目）、NormalizeScore（210-212行目） |

**主要処理**:
- **146-154行目**: `getAllTolerationPreferNoSchedule` - Effect空またはPreferNoScheduleのTolerationを収集
- **180-192行目**: `countIntolerableTaintsPreferNoSchedule` - PreferNoSchedule Taintの未許容数をカウント
- **211行目**: `helper.DefaultNormalizeScore`で逆転正規化（true=reverse）

#### Step 4: QueueingHintを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | taint_toleration.go | `pkg/scheduler/framework/plugins/tainttoleration/taint_toleration.go` | isSchedulableAfterNodeChange（96-116行目）、isSchedulableAfterPodTolerationChange（229-244行目） |

### プログラム呼び出し階層図

```
New (初期化)
    │
    ├─ Filter
    │      └─ v1helper.FindMatchingUntoleratedTaint
    │             └─ helper.DoNotScheduleTaintsFilterFunc
    │
    ├─ PreScore
    │      └─ getAllTolerationPreferNoSchedule
    │
    ├─ Score
    │      └─ countIntolerableTaintsPreferNoSchedule
    │             └─ v1helper.TolerationsTolerateTaint
    │
    └─ NormalizeScore
           └─ helper.DefaultNormalizeScore (reverse=true)
```

### データフロー図

```
[入力]                         [処理]                           [出力]

Node.Spec.Taints      ───▶  Filter                    ───▶  FilterStatus
Pod.Spec.Tolerations         (NoSchedule/NoExecute照合)

Pod.Spec.Tolerations   ───▶  PreScore                  ───▶  preScoreState
                              (PreferNoSchedule抽出)

Node.Spec.Taints      ───▶  Score                     ───▶  未許容Taint数
preScoreState                (PreferNoSchedule照合)

Score結果              ───▶  NormalizeScore             ───▶  Score (0-100)
                              (逆転正規化)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| taint_toleration.go | `pkg/scheduler/framework/plugins/tainttoleration/taint_toleration.go` | ソース | プラグイン全機能の実装 |
| helper.go | `pkg/scheduler/framework/plugins/helper/normalize_score.go` | ソース | DefaultNormalizeScore |
| corev1/taint.go | `staging/src/k8s.io/component-helpers/scheduling/corev1/` | ソース | FindMatchingUntoleratedTaint、TolerationsTolerateTaint |
