# 機能設計書 49-Podライフサイクル管理

## 概要

本ドキュメントは、KubeletにおけるPodライフサイクル管理機能の設計を記述する。Kubeletはノード上のPodの作成、同期、終了、クリーンアップの全ライフサイクルを管理する。中心となるのはPodWorkerで、Pod毎に専用のgoroutineで状態遷移を制御する。

### 本機能の処理概要

**業務上の目的・背景**：KubeletはKubernetesクラスター内の各ノード上で動作するエージェントであり、APIサーバーから受け取ったPod仕様に基づいてコンテナの起動・停止を制御する。Podのライフサイクル管理はKubeletの最も基本的な機能であり、コンテナの作成・ヘルスチェック・再起動・終了・リソース回収の全フェーズを管理する。

**機能の利用シーン**：APIサーバーからPodが割り当てられた際、Static Pod定義の検出時、Pod削除時、Pod退去（Eviction）時、ノードシャットダウン時に動作する。

**主要な処理内容**：
1. Pod受信: config.PodConfigからPodの追加/更新/削除を受信
2. PodWorker: Pod毎のgoroutineでFIFO順に状態変更を処理
3. syncPod: Pod実行中の同期処理（コンテナ作成、ネットワーク設定、ボリュームマウント等）
4. syncTerminatingPod: Pod終了時のコンテナ停止処理
5. syncTerminatedPod: Pod終了後のリソースクリーンアップ
6. ステータス更新: Pod StatusManagerを通じたAPIサーバーへのステータス報告

**関連システム・外部連携**：Container Runtime（CRI経由）、Volume Manager、Network Plugin、Image Manager、Probe Manager、Eviction Manager。

**権限による制御**：フィーチャーゲート（InPlacePodVerticalScaling、SidecarContainers、PodDisruptionConditions等）により動作が制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | Kubelet内部処理として自動実行 |

## 機能種別

ライフサイクル管理 / 状態遷移制御

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| UpdatePodOptions | UpdatePodOptions | Yes | Pod更新オプション（UpdateType、Pod、MirrorPod等） | - |
| KillPodOptions | KillPodOptions | No | Pod停止オプション（Evict、GracePeriodOverride等） | - |

### 入力データソース

- APIサーバーからのPod Watch
- Static Pod設定ファイル
- Pod Admission結果
- Container Runtime Status

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| PodStatus | v1.PodStatus | APIサーバーに報告されるPodステータス |
| PodWorkerState | PodWorkerState | Pod Workerの内部状態（SyncPod/TerminatingPod/TerminatedPod） |

## 処理フロー

### 処理シーケンス

```
1. Pod受信と分配
   ├─ config.PodConfig → syncLoopIteration
   └─ UpdatePod → PodWorker

2. PodWorker状態遷移
   ├─ SyncPod (実行中)
   │      ├─ syncPod: コンテナの作成と同期
   │      ├─ ボリュームマウント
   │      ├─ Probe（Liveness/Readiness/Startup）の開始
   │      └─ ステータス更新
   │
   ├─ TerminatingPod (終了処理中)
   │      ├─ syncTerminatingPod: コンテナの停止
   │      ├─ GracePeriod付きSIGTERM送信
   │      ├─ PreStop Hook実行
   │      └─ コンテナ停止確認
   │
   └─ TerminatedPod (終了後クリーンアップ)
          ├─ syncTerminatedPod: リソース回収
          ├─ ボリュームアンマウント
          ├─ cgroup削除
          └─ 最終ステータス報告

3. SyncKnownPods
   └─ 不要なPod Workerの検出と削除
```

### フローチャート

```mermaid
flowchart TD
    A[Pod受信] --> B[UpdatePod]
    B --> C{WorkType?}
    C -->|Create/Update| D[SyncPod]
    C -->|Kill| E[TerminatingPod]
    D --> F{Pod Running?}
    F -->|Yes| G[コンテナ同期]
    F -->|No| H[コンテナ作成]
    G --> I[Probe開始]
    D --> J{削除/Failed/Succeeded?}
    J -->|Yes| E
    E --> K[syncTerminatingPod]
    K --> L{全コンテナ停止?}
    L -->|No| M[GracePeriod付き停止]
    L -->|Yes| N[TerminatedPod]
    N --> O[syncTerminatedPod]
    O --> P[リソースクリーンアップ]
    P --> Q[最終ステータス報告]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | FIFO処理 | 同一PodのUpdatePodはFIFO順で逐次処理 | 常時 |
| BR-02 | 不可逆終了 | 一度TerminatingPodに遷移したPodはSyncPodに戻らない | 常時 |
| BR-03 | GracePeriod | コンテナ停止時はGracePeriodSecondsを尊重 | 常時 |
| BR-04 | PreStop Hook | コンテナ停止前にPreStop Hookを実行 | PreStop定義時 |
| BR-05 | Eviction | Evict=trueの場合は停止コンテナのリソースをより積極的に回収 | Eviction時 |
| BR-06 | Static Pod | Static PodのMirrorPodをAPIサーバーに作成/更新 | Static Pod時 |
| BR-07 | Orphan Pod検出 | SyncKnownPodsで不要なPod Workerを検出・削除 | 定期実行 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 内容 |
|------|------|------|
| Update | Pod.Status | Podステータスの更新（StatusManager経由） |
| Create/Delete | Pod (Mirror) | Static Pod用MirrorPodの作成/削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ErrCrashLoopBackOff | コンテナ再起動制限 | コンテナが繰り返しクラッシュ | バックオフ付きリスタート |
| ErrImagePull | イメージ取得失敗 | コンテナイメージの取得に失敗 | バックオフ付きリトライ |
| ErrRunContainer | コンテナ起動失敗 | コンテナの起動に失敗 | イベント記録、リトライ |

### リトライ仕様

PodWorkerは自動的にリトライを管理。syncPodはリトライ可能な状態で失敗した場合、次のsyncLoopで再試行される。

## トランザクション仕様

Podライフサイクルの状態遷移は不可逆であり、SyncPod → TerminatingPod → TerminatedPodの一方向遷移のみ。

## パフォーマンス要件

- Pod毎に専用goroutineで並列処理
- PodWorkerDurationメトリクスで処理時間を監視
- SyncKnownPodsによる不要Worker回収

## セキュリティ考慮事項

- SecurityContextの適用（RunAsUser、SELinux、AppArmor等）
- Seccompプロファイルの適用
- ServiceAccountトークンの管理

## 備考

- PodWorkerState: SyncPod=0, TerminatingPod=1, TerminatedPod=2

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pod_workers.go | `pkg/kubelet/pod_workers.go` | PodWorkerState（107-118行目）、PodWorkers interface（157-260行目）、UpdatePodOptions（82-103行目）、KillPodOptions（54-68行目） |
| 1-2 | pod_workers.go | 同上 | podWork構造体（147-154行目）、PodWorkerSync（135-144行目） |

**読解のコツ**: PodWorkerStateは3状態（SyncPod/TerminatingPod/TerminatedPod）の遷移モデル。不可逆な一方向遷移である点が重要。

#### Step 2: PodWorkersインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pod_workers.go | `pkg/kubelet/pod_workers.go` | PodWorkers interface（157-260行目） |

**主要メソッド**:
- **167行目**: UpdatePod - Podの変更通知（Pod毎goroutineでFIFO処理）
- **175行目**: SyncKnownPods - 不要Worker削除
- **185行目**: IsPodKnownTerminated - 終了済み判定
- **192行目**: CouldHaveRunningContainers - コンテナ実行可能性判定
- **205行目**: ShouldPodBeFinished - 完了判定
- **214行目**: IsPodTerminationRequested - 終了要求判定

#### Step 3: Kubeletメインループを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kubelet.go | `pkg/kubelet/kubelet.go` | Kubelet構造体の定義、syncLoop/syncLoopIteration |

### プログラム呼び出し階層図

```
Kubelet.Run
    └─ syncLoop
           └─ syncLoopIteration
                  ├─ configCh (Pod追加/更新/削除)
                  ├─ plegCh (PLEGイベント)
                  ├─ syncCh (定期同期)
                  └─ housekeepingCh (ハウスキーピング)
                         │
                         ▼
                  PodWorker.UpdatePod
                         │
                  ┌──────┼──────┐
                  ▼      ▼      ▼
               syncPod  syncTerminatingPod  syncTerminatedPod
                  │      │                  │
                  ▼      ▼                  ▼
              container  container          cleanup
              runtime    runtime            (volumes, cgroups)
```

### データフロー図

```
[入力]                           [処理]                              [出力]

APIサーバー (Pod Watch)  ───▶  config.PodConfig             ───▶  UpdatePodOptions
Static Pod Config               (Pod変更検知)

UpdatePodOptions         ───▶  PodWorker.UpdatePod          ───▶  podWork
                                (FIFO分配)

podWork                  ───▶  syncPod/syncTerminating/     ───▶  Container操作
                                syncTerminated                      (CRI経由)

Container Status         ───▶  StatusManager                ───▶  API Pod Status更新
Probe Results                   (ステータス集約)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | Kubeletメイン、syncLoop |
| pod_workers.go | `pkg/kubelet/pod_workers.go` | ソース | PodWorker実装（状態遷移制御） |
| kubelet_pods.go | `pkg/kubelet/kubelet_pods.go` | ソース | Pod関連ユーティリティ |
| status_manager.go | `pkg/kubelet/status/status_manager.go` | ソース | Pod Status管理 |
| eviction/ | `pkg/kubelet/eviction/` | ソース | Eviction管理 |
| lifecycle/ | `pkg/kubelet/lifecycle/` | ソース | ライフサイクルハンドラー |
| prober/ | `pkg/kubelet/prober/` | ソース | Probe管理 |
