# 機能設計書 5-API拡張（CRD/Aggregation）

## 概要

本ドキュメントは、Kubernetes API拡張機能の設計書である。CustomResourceDefinition（CRD）によるカスタムリソースの定義と、API Aggregationによる拡張APIサーバーの統合を提供する。

### 本機能の処理概要

API拡張機能は、Kubernetesの標準APIを動的に拡張するための2つの主要メカニズムを提供する。CRDはユーザー定義のリソースタイプを追加し、API AggregationはカスタムAPIサーバーをKubernetes APIに統合する。

**業務上の目的・背景**：Kubernetesのエコシステムでは、標準リソース（Pod, Service等）だけでなく、アプリケーション固有のリソースを定義する必要がある。CRDにより、Operatorパターンでのカスタムリソース管理（例：Database, Certificate, VirtualService等）が可能になる。API Aggregationにより、metrics-serverやcustom-metrics-adapter等の拡張APIサーバーを統合できる。

**機能の利用シーン**：カスタムOperatorの構築（CRD定義とカスタムコントローラー）、Metrics Server等のAPI拡張サーバーの統合、Helm chartでのCRDインストール、サービスメッシュ（Istio等）のカスタムリソース管理など。

**主要な処理内容**：
1. CustomResourceDefinition（CRD）リソースの登録と管理
2. CRDに基づくカスタムリソースのCRUD API自動生成
3. CRDのスキーマバリデーション（OpenAPI v3スキーマ）
4. CRDのバージョン変換（Conversion Webhook）
5. APIServiceリソースによる拡張APIサーバーの登録
6. API Aggregation Layerによるリクエストのプロキシ転送
7. カスタムリソースのサブリソース（status, scale）サポート

**関連システム・外部連携**：Conversion Webhook（CRDバージョン変換）、拡張APIサーバー（metrics-server等）、etcd（カスタムリソースの永続化）

**権限による制御**：CRDの作成はcluster-admin権限が必要。カスタムリソースのCRUD操作はRBACで制御可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接の関連なし（全kubectlコマンドからカスタムリソースの操作が可能） |

## 機能種別

API基盤拡張 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CRD.Spec.Group | string | Yes | カスタムリソースのAPIグループ | DNS形式の有効なグループ名 |
| CRD.Spec.Names | CustomResourceDefinitionNames | Yes | リソース名（kind, plural, singular等） | 命名規約に準拠 |
| CRD.Spec.Scope | string | Yes | Namespaced / Cluster | 有効なスコープ |
| CRD.Spec.Versions | []CustomResourceDefinitionVersion | Yes | バージョン定義（スキーマ、サブリソース等） | 少なくとも1つのバージョン |
| APIService.Spec.Service | ServiceReference | Yes (Agg) | 拡張APIサーバーのService参照 | 有効なService参照 |
| APIService.Spec.Group | string | Yes (Agg) | APIグループ | DNS形式 |
| APIService.Spec.Version | string | Yes (Agg) | APIバージョン | 有効なバージョン |

### 入力データソース

kubectlまたはclient-go経由のCRD/APIServiceマニフェスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| カスタムリソースAPI | REST API | CRD定義に基づいて自動生成されるRESTエンドポイント |
| CRD Status | CRDStatus | CRDの確立状態（Established, NamesAccepted等） |
| APIService Status | APIServiceStatus | 拡張APIサーバーの可用性状態 |

### 出力先

HTTPレスポンス、API Discoveryエンドポイント

## 処理フロー

### 処理シーケンス

```
1. CRD/APIServiceリソースの作成リクエスト受信
   └─ 認証・認可・アドミッション制御を経てetcdに保存
2. CRDコントローラーによる処理（CRDの場合）
   └─ CRD定義に基づいてRESTハンドラを自動生成・登録
3. スキーマ検証の有効化
   └─ OpenAPI v3スキーマに基づくバリデーションルールの設定
4. API Discoveryへの登録
   └─ /apisエンドポイントにカスタムリソース情報を追加
5. APIサーバープロキシの設定（API Aggregationの場合）
   └─ APIServiceに基づいて拡張APIサーバーへのプロキシルートを設定
6. カスタムリソースの利用開始
   └─ 標準リソースと同様のCRUD操作が可能に
```

### フローチャート

```mermaid
flowchart TD
    A[CRD作成リクエスト] --> B[バリデーション]
    B --> C[etcd保存]
    C --> D[CRDコントローラー検知]
    D --> E[RESTハンドラ生成]
    E --> F[API Discovery登録]
    F --> G[CRD Status: Established]
    G --> H[カスタムリソースCRUD利用可能]

    I[APIService作成] --> J[バリデーション]
    J --> K[etcd保存]
    K --> L[Aggregator検知]
    L --> M[プロキシルート設定]
    M --> N[拡張API利用可能]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-1 | CRDスキーマ必須 | CRDにはstructural schemaが必須（apiextensions.k8s.io/v1以降） | CRD v1作成時 |
| BR-2 | バージョン管理 | 複数バージョンのCRDはConversion Webhookまたはstorageバージョンで管理 | 複数バージョンCRD |
| BR-3 | APIService優先度 | APIServiceはpriorityで優先度を制御し、同じグループ内での競合を解決 | API Aggregation |
| BR-4 | ローカルAPIService | Service参照がないAPIServiceはKube API Server内蔵のAPIを示す | ビルトインAPI |
| BR-5 | CRD名前空間 | CRDリソースはCluster scopedであり、カスタムリソースのscopeはCRD定義で決定 | CRD作成時 |

### 計算ロジック

CRDのNamesAccepted条件は、requestedしたplural/singular/shortNames/kindが既存のリソースと衝突しないかチェックして決定される。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| CRD作成 | etcd | INSERT | CRD定義をetcdに保存 |
| カスタムリソース操作 | etcd | CRUD | CRD定義に基づくカスタムリソースのCRUD |
| APIService作成 | etcd | INSERT | APIService定義をetcdに保存 |

### テーブル別操作詳細

#### etcd

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | /registry/apiextensions.k8s.io/customresourcedefinitions/{name} | CRD定義 | Cluster scoped |
| CRUD | /registry/{group}/{resource}/{namespace}/{name} | カスタムリソース | CRD定義に基づくパス |
| INSERT | /registry/apiregistration.k8s.io/apiservices/{name} | APIService定義 | Cluster scoped |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 409 | Conflict | CRD名が既存リソースと衝突 | 一意なグループ・名前を使用 |
| 422 | Unprocessable | CRDスキーマが無効 | OpenAPI v3スキーマを修正 |
| 503 | ServiceUnavailable | 拡張APIサーバーが到達不能（API Aggregation） | 拡張APIサーバーの状態を確認 |

### リトライ仕様

CRDコントローラーはワークキューベースで動作し、エラー時はExponential Backoffで再試行。

## トランザクション仕様

CRDの作成はアトミックにetcdに保存。カスタムリソースのCRUD操作はresourceVersionによる楽観的排他制御。

## パフォーマンス要件

- CRD登録後のAPI利用開始: 数秒以内
- カスタムリソースのCRUD: 標準リソースと同等のレイテンシ
- API Aggregationのプロキシオーバーヘッド: 最小限

## セキュリティ考慮事項

- CRD作成はcluster-admin権限で制限すべき
- Conversion Webhook との通信はTLS必須
- カスタムリソースのRBAC定義を適切に設定すべき
- API Aggregationの拡張APIサーバーのセキュリティを確保すべき

## 備考

apiextensions-apiserverは独立したバイナリとしても動作可能だが、通常はkube-apiserver内に組み込まれる。kube-aggregatorも同様にkube-apiserver内に統合されている。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1/types.go` | CRD関連の型定義（CustomResourceDefinition, CustomResourceDefinitionSpec等） |
| 1-2 | types.go | `staging/src/k8s.io/kube-aggregator/pkg/apis/apiregistration/v1/types.go` | APIService関連の型定義 |

**読解のコツ**: CRDの`Spec.Versions[].Schema.OpenAPIV3Schema`がカスタムリソースのスキーマ定義の核心。API AggregationはAPIServiceリソースを監視してプロキシルートを動的に構成する。

#### Step 2: CRDコントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | apiserver/ | `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/` | apiextensions-apiserverのメインロジック |
| 2-2 | controller/ | `staging/src/k8s.io/apiextensions-apiserver/pkg/controller/` | CRDのEstablishingコントローラー等 |

#### Step 3: API Aggregation Layerを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | apiserver/ | `staging/src/k8s.io/kube-aggregator/pkg/apiserver/` | kube-aggregatorのメインロジック、プロキシハンドラ |
| 3-2 | aggregator.go | `cmd/kube-apiserver/app/aggregator.go` | kube-apiserver内でのaggregator初期化 |

### プログラム呼び出し階層図

```
kube-apiserver
    │
    ├─ apiextensions-apiserver (CRD処理)
    │      ├─ CRD Registry
    │      ├─ Establishing Controller
    │      ├─ Custom Resource Handler (動的生成)
    │      └─ Conversion Webhook Handler
    │
    └─ kube-aggregator (API Aggregation)
           ├─ APIService Registry
           ├─ Availability Controller
           └─ Proxy Handler → 拡張APIサーバー
```

### データフロー図

```
[入力]                     [処理]                           [出力]

CRD定義 ──────────▶ apiextensions-apiserver ──────▶ REST API自動生成
                    ├─ スキーマ検証                    └─ API Discovery登録
                    └─ RESTハンドラ生成

APIService定義 ────▶ kube-aggregator ──────────▶ プロキシルート設定
                    ├─ 可用性チェック                  └─ リクエスト転送
                    └─ ルート登録
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| apiserver/ | `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/` | ソース | CRD APIサーバー |
| controller/ | `staging/src/k8s.io/apiextensions-apiserver/pkg/controller/` | ソース | CRDコントローラー |
| registry/ | `staging/src/k8s.io/apiextensions-apiserver/pkg/registry/` | ソース | CRDレジストリ |
| apiserver/ | `staging/src/k8s.io/kube-aggregator/pkg/apiserver/` | ソース | API Aggregator |
| aggregator.go | `cmd/kube-apiserver/app/aggregator.go` | ソース | Aggregator初期化 |
