# 機能設計書 50-コンテナランタイム管理

## 概要

本ドキュメントは、Kubeletの`kuberuntime`パッケージにおけるコンテナランタイム管理機能の設計を記述する。`kubeGenericRuntimeManager`はCRI（Container Runtime Interface）を通じてコンテナランタイム（containerd、CRI-O等）と通信し、Podのコンテナの作成・起動・停止・状態取得を管理する。

### 本機能の処理概要

**業務上の目的・背景**：KubernetesはCRIを通じてコンテナランタイムを抽象化しており、kuberuntimeパッケージがそのアダプター層として機能する。PodSpecに定義されたコンテナ仕様をCRI APIコールに変換し、コンテナのライフサイクルを管理する。

**機能の利用シーン**：Kubelet PodWorkerからのsyncPod/syncTerminatingPod呼び出し時に動作。コンテナの作成、起動、停止、状態取得、イメージ管理等を実行する。

**主要な処理内容**：
1. SyncPod: Pod仕様に基づくコンテナの同期（Sandboxの作成、InitContainerの実行、通常Containerの起動）
2. KillPod: Pod内の全コンテナの停止
3. GetPodStatus: CRI経由でコンテナ状態を取得しPodStatusに変換
4. Container GC: 不要なコンテナとイメージの回収
5. イメージ管理: イメージのPull、バックオフ管理

**関連システム・外部連携**：CRI Runtime Service、CRI Image Service、Container Manager（cgroup管理）、seccomp/AppArmor/SELinux。

**権限による制御**：フィーチャーゲート（SidecarContainers、InPlacePodVerticalScaling、PodLevelResources、UserNamespacesSupport等）により動作が制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | Kubelet内部処理として自動実行 |

## 機能種別

コンテナ管理 / CRIアダプター

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Pod | v1.Pod | Yes | Pod仕様 | - |
| PodStatus | kubecontainer.PodStatus | Yes | 現在のPod状態 | - |
| PullSecrets | []v1.Secret | No | イメージPull用シークレット | - |
| BackOff | flowcontrol.Backoff | Yes | イメージPullバックオフ | - |

### 入力データソース

- Pod Spec（v1.Pod）
- CRI Runtime Service（コンテナ状態）
- CRI Image Service（イメージ情報）
- Container Manager（リソース制約）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| PodSyncResult | kubecontainer.PodSyncResult | Pod同期結果 |
| PodStatus | kubecontainer.PodStatus | コンテナ状態情報 |
| ContainerID | kubecontainer.ContainerID | 作成されたコンテナID |

## 処理フロー

### 処理シーケンス

```
1. SyncPod: Pod同期処理
   ├─ computePodActions: 必要なアクションを計算
   │      ├─ Sandboxの作成/再作成判定
   │      ├─ InitContainerの実行順序決定
   │      ├─ 通常Containerの起動/再起動判定
   │      └─ SidecarContainerの管理
   ├─ createPodSandbox: CRIを通じてSandbox作成
   │      └─ RuntimeService.RunPodSandbox
   ├─ startContainer: 各コンテナの起動
   │      ├─ イメージPull（EnsureImageExists）
   │      ├─ RuntimeService.CreateContainer
   │      ├─ RuntimeService.StartContainer
   │      ├─ PostStart Hook実行
   │      └─ コンテナログの設定
   └─ リソース割当の適用（actuatedState）

2. KillPod: Pod停止処理
   ├─ killContainersWithSyncResult: 全コンテナの停止
   │      ├─ PreStop Hook実行
   │      ├─ RuntimeService.StopContainer（GracePeriod付き）
   │      └─ RuntimeService.RemoveContainer
   └─ RuntimeService.StopPodSandbox

3. GetPodStatus: Pod状態取得
   └─ RuntimeService.PodSandboxStatus
   └─ RuntimeService.ListContainers → ContainerStatus

4. Container GC: ガベージコレクション
   ├─ 停止済みコンテナの回収
   ├─ 使用されていないSandboxの回収
   └─ 古いログの回収
```

### フローチャート

```mermaid
flowchart TD
    A[SyncPod呼び出し] --> B[computePodActions]
    B --> C{Sandbox必要?}
    C -->|Yes| D[createPodSandbox]
    C -->|No| E[既存Sandbox使用]
    D --> F[InitContainer起動]
    E --> F
    F --> G{全Init完了?}
    G -->|No| H[待機/リトライ]
    G -->|Yes| I[通常Container起動]
    I --> J[startContainer]
    J --> K[イメージPull]
    K --> L[CreateContainer]
    L --> M[StartContainer]
    M --> N[PostStart Hook]
    N --> O[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | InitContainer順次実行 | InitContainerは定義順に逐次実行 | InitContainer定義時 |
| BR-02 | SidecarContainer | RestartableなInitContainerはSidecarとして管理 | SidecarContainers有効時 |
| BR-03 | 最小GracePeriod | minimumGracePeriodInSeconds=2秒以上のGracePeriodを保証 | 常時 |
| BR-04 | イメージPullバックオフ | イメージPull失敗時はexponential backoffで再試行 | イメージPull失敗時 |
| BR-05 | CRI APIバージョン | kubeRuntimeAPIVersion="0.1.0"との互換性チェック | 初期化時 |
| BR-06 | バージョンキャッシュ | ランタイムバージョンはversionCacheTTL=60秒でキャッシュ | 常時 |
| BR-07 | 同一エラー抑制 | 同一エラーメッセージはidenticalErrorDelay=1分間隔で報告 | 常時 |
| BR-08 | Seccompデフォルト | seccompDefault=true時、全ワークロードにRuntimeDefaultプロファイルを適用 | 設定時 |
| BR-09 | actuatedState | コンテナの実際のリソース割当状態を追跡 | InPlacePodVerticalScaling時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 内容 |
|------|------|------|
| Create | Container (CRI) | コンテナの作成 |
| Start | Container (CRI) | コンテナの起動 |
| Stop | Container (CRI) | コンテナの停止 |
| Remove | Container (CRI) | コンテナの削除 |
| Pull | Image (CRI) | イメージのダウンロード |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ErrVersionNotSupported | CRIバージョン不一致 | ランタイムAPIバージョン非互換 | ランタイム更新 |
| ErrImagePull | イメージ取得失敗 | Pull失敗 | バックオフ付きリトライ |
| CRI Error | コンテナ操作失敗 | CRI APIエラー | イベント記録、リトライ |

### リトライ仕様

- イメージPull: flowcontrol.Backoff によるexponential backoff
- コンテナ作成: syncPodの次回呼び出しでリトライ

## トランザクション仕様

CRI操作はアトミックではない。Sandbox作成→Container作成→Container起動の各段階で失敗し得るため、computePodActionsで差分計算を行い冪等に処理する。

## パフォーマンス要件

- versionCacheTTL=60秒でランタイムバージョンをキャッシュ
- identicalErrorDelay=1分で重複エラーログを抑制
- OpenTelemetryトレーシングによる処理時間の計測

## セキュリティ考慮事項

- SecurityContextの完全適用（RunAsUser/Group、SELinux、AppArmor、Seccomp）
- ImagePull Secretsの安全な処理
- CredentialProviderPluginとの連携
- UserNamespaces対応

## 備考

- instrumentationScope = "k8s.io/kubernetes/pkg/kubelet/kuberuntime" でOpenTelemetryトレーシング
- actuatedPodsStateFile = "actuated_pods_state" でリソース割当状態を永続化

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | kubeGenericRuntimeManager構造体（109-194行目） |
| 1-2 | kuberuntime_manager.go | 同上 | podStateProvider interface（103-107行目）、KubeGenericRuntime interface（197-201行目） |

**読解のコツ**: kubeGenericRuntimeManagerは多数のフィールドを持つが、主要なのはruntimeService（CRIランタイムクライアント）、imageService（CRIイメージクライアント）、containerGC（GC管理）。

#### Step 2: 初期化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | NewKubeGenericRuntimeManager関数（204行目以降） |

#### Step 3: 主要フィールドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kuberuntime_manager.go | 同上 | runtimeService（146行目）、imageService（147行目）、containerGC（118行目）、imagePuller（143行目） |

**主要フィールド**:
- **110行目**: runtimeName - ランタイム名称
- **115行目**: machineInfo - マシン情報
- **118行目**: containerGC - コンテナGCマネージャー
- **121行目**: runner - ライフサイクルイベントランナー
- **127-129行目**: livenessManager/readinessManager/startupManager - Probeマネージャー
- **143行目**: imagePuller - イメージPullマネージャー
- **146-147行目**: runtimeService/imageService - CRIクライアント
- **168行目**: actuatedState - 実リソース割当状態

### プログラム呼び出し階層図

```
NewKubeGenericRuntimeManager (初期化)
    │
    ├─ SyncPod
    │      ├─ computePodActions
    │      ├─ createPodSandbox
    │      │      └─ RuntimeService.RunPodSandbox
    │      └─ startContainer
    │             ├─ EnsureImageExists (imagePuller)
    │             ├─ RuntimeService.CreateContainer
    │             ├─ RuntimeService.StartContainer
    │             └─ runner.Run (PostStart Hook)
    │
    ├─ KillPod
    │      ├─ killContainersWithSyncResult
    │      │      ├─ runner.Run (PreStop Hook)
    │      │      └─ RuntimeService.StopContainer
    │      └─ RuntimeService.StopPodSandbox
    │
    ├─ GetPodStatus
    │      ├─ RuntimeService.PodSandboxStatus
    │      └─ RuntimeService.ListContainers
    │
    └─ GarbageCollect
           └─ containerGC.GarbageCollect
```

### データフロー図

```
[入力]                           [処理]                              [出力]

Pod Spec                 ───▶  computePodActions            ───▶  PodActions
PodStatus (CRI)                 (差分計算)

PodActions               ───▶  SyncPod                      ───▶  PodSyncResult
                                (CRI API呼び出し)

Pod (Kill)               ───▶  KillPod                      ───▶  停止完了
                                (PreStop + StopContainer)

CRI Container Status     ───▶  GetPodStatus                 ───▶  PodStatus
                                (CRI → k8s変換)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | ソース | ランタイムマネージャーメイン |
| kuberuntime_container.go | `pkg/kubelet/kuberuntime/kuberuntime_container.go` | ソース | コンテナ操作（Create/Start/Stop/Remove） |
| kuberuntime_sandbox.go | `pkg/kubelet/kuberuntime/kuberuntime_sandbox.go` | ソース | Sandbox操作 |
| kuberuntime_image.go | `pkg/kubelet/kuberuntime/kuberuntime_image.go` | ソース | イメージ操作 |
| kuberuntime_gc.go | `pkg/kubelet/kuberuntime/kuberuntime_gc.go` | ソース | コンテナGC |
| kuberuntime_container_linux.go | `pkg/kubelet/kuberuntime/kuberuntime_container_linux.go` | ソース | Linux固有のコンテナ設定 |
| kuberuntime_container_windows.go | `pkg/kubelet/kuberuntime/kuberuntime_container_windows.go` | ソース | Windows固有のコンテナ設定 |
| security_context.go | `pkg/kubelet/kuberuntime/security_context.go` | ソース | セキュリティコンテキスト変換 |
