# 機能設計書 6-OpenAPI仕様公開

## 概要

本ドキュメントは、Kubernetes API ServerにおけるOpenAPI仕様公開機能の設計書である。APIのOpenAPI v2/v3仕様を自動生成して公開する。

### 本機能の処理概要

OpenAPI仕様公開機能は、Kubernetes APIの全リソース定義をOpenAPI v2（Swagger 2.0）およびOpenAPI v3形式で自動生成し、HTTPエンドポイントとして公開する。これにより、APIクライアントの自動生成やAPIドキュメントの提供が可能になる。

**業務上の目的・背景**：Kubernetes APIは数百のリソースタイプと数千のフィールドを持つ大規模なAPIである。OpenAPI仕様を公開することで、kubectl explainコマンドによるフィールドドキュメントの表示、client-goやその他言語のクライアントライブラリの自動生成、APIドキュメントの自動生成、バリデーションツールの作成が可能になる。

**機能の利用シーン**：kubectl explainコマンドの実行時にOpenAPI仕様が参照される。APIクライアントライブラリの自動生成時、カスタムリソース（CRD）のスキーマ公開時、API互換性検証ツールの利用時に使用される。

**主要な処理内容**：
1. ビルトインAPIリソースのOpenAPI仕様生成
2. CRDで定義されたカスタムリソースのOpenAPI仕様統合
3. API AggregationされたAPIのOpenAPI仕様統合
4. /openapi/v2 エンドポイントでのOpenAPI v2仕様の提供
5. /openapi/v3 エンドポイントでのOpenAPI v3仕様の提供
6. APIバージョン変更時の仕様自動更新

**関連システム・外部連携**：apiextensions-apiserver（CRDスキーマ）、kube-aggregator（拡張APIスキーマ）、code-generator

**権限による制御**：OpenAPI仕様の取得は通常認証不要（公開API）。ただしkube-apiserverの設定で制限可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | kubectl explain | API連携 | OpenAPI v2/v3仕様を取得してリソースフィールドの説明を表示する |

## 機能種別

API仕様公開 / ドキュメント生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Accept Header | string | No | レスポンス形式（application/json, application/com.github.proto-openapi.spec.v2@v1.0+protobuf） | サポートされる形式 |
| APIグループ/バージョン | string | No（v3） | OpenAPI v3での特定グループ/バージョンの仕様取得 | 有効なグループ/バージョン |

### 入力データソース

API Server内部のレジストリ情報、CRD定義、APIService定義

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| OpenAPI v2 Spec | JSON/Protobuf | Swagger 2.0形式のAPI仕様 |
| OpenAPI v3 Spec | JSON | OpenAPI v3形式のAPI仕様（グループ・バージョン単位で分割可能） |

### 出力先

HTTPレスポンス（/openapi/v2, /openapi/v3エンドポイント）

## 処理フロー

### 処理シーケンス

```
1. API Server起動時の初期仕様生成
   └─ ビルトインAPIリソースのOpenAPI定義を収集・統合
2. CRD作成/更新時の仕様更新
   └─ CRDのOpenAPI v3スキーマを全体仕様に統合
3. APIService登録時の仕様更新
   └─ 拡張APIサーバーからOpenAPI仕様を取得して統合
4. /openapi/v2リクエストの処理
   └─ キャッシュされたOpenAPI v2仕様を返却
5. /openapi/v3リクエストの処理
   └─ グループ/バージョン単位で分割されたOpenAPI v3仕様を返却
```

### フローチャート

```mermaid
flowchart TD
    A[API Server起動] --> B[ビルトインAPI仕様収集]
    B --> C[OpenAPI仕様統合]
    C --> D[仕様キャッシュ]

    E[CRD作成/更新] --> F[CRDスキーマ抽出]
    F --> C

    G[APIService登録] --> H[拡張API仕様取得]
    H --> C

    I[/openapi/v2リクエスト] --> D --> J[OpenAPI v2レスポンス]
    K[/openapi/v3リクエスト] --> D --> L[OpenAPI v3レスポンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-1 | 仕様の自動更新 | CRDやAPIServiceの変更時にOpenAPI仕様を自動再生成 | CRD/APIService変更時 |
| BR-2 | v3グループ分割 | OpenAPI v3仕様はAPIグループ/バージョン単位で分割して提供 | /openapi/v3リクエスト時 |
| BR-3 | Protobufサポート | OpenAPI v2仕様はProtobuf形式でも提供可能 | Accept Headerがprotobuf指定時 |
| BR-4 | ETag対応 | If-None-Matchヘッダーによるキャッシュ検証に対応 | クライアントがETag送信時 |

### 計算ロジック

OpenAPI仕様はビルトインAPIの定義、CRDのスキーマ定義、拡張APIサーバーの仕様をマージして生成される。CRD変更時は差分更新によりパフォーマンスを最適化。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| CRDスキーマ読み取り | etcd | SELECT | CRDのOpenAPIスキーマ定義を取得 |

### テーブル別操作詳細

#### etcd

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | /registry/apiextensions.k8s.io/customresourcedefinitions/ | CRD定義からスキーマを抽出 | Informerキャッシュ経由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 406 | NotAcceptable | サポートされないAcceptヘッダー | application/jsonを指定 |
| 304 | NotModified | ETagが一致（変更なし） | キャッシュされた仕様を使用 |
| 500 | InternalServerError | 仕様生成エラー | サーバーログを確認 |

### リトライ仕様

OpenAPI仕様の取得エラーはクライアント側でリトライを実装。サーバー側はキャッシュからの応答のため通常エラーは発生しない。

## トランザクション仕様

読み取り専用のため、トランザクション管理は不要。

## パフォーマンス要件

- OpenAPI仕様応答: キャッシュからの応答のため高速
- CRD変更後の仕様更新: 数秒以内

## セキュリティ考慮事項

- OpenAPI仕様はクラスター内のAPIリソース構造を公開するため、外部公開時は注意が必要
- APIグループ・リソースの存在情報がメタデータとして露出する

## 備考

api/openapi-spec/ディレクトリにはビルド時に生成される静的なOpenAPI仕様ファイル（swagger.json）が含まれる。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | swagger.json | `api/openapi-spec/swagger.json` | 静的に生成されたOpenAPI v2仕様。APIリソースの全定義を含む |
| 1-2 | v3/ | `api/openapi-spec/v3/` | OpenAPI v3仕様（グループ/バージョン単位で分割） |

**読解のコツ**: swagger.jsonは巨大なファイル。特定のリソースのスキーマを確認する際は、definitions内の`io.k8s.api.core.v1.Pod`等のキーで検索すると効率的。

#### Step 2: OpenAPI仕様の生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | openapi/ | `staging/src/k8s.io/apiserver/pkg/endpoints/openapi/` | OpenAPIサービスの実装 |
| 2-2 | builder/ | `staging/src/k8s.io/kube-openapi/pkg/builder/` | OpenAPI仕様のビルダー |

#### Step 3: CRD/AggregationとのOpenAPI統合を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | apiserver/ | `staging/src/k8s.io/apiextensions-apiserver/pkg/apiserver/` | CRDのOpenAPIスキーマ統合ロジック |

### プログラム呼び出し階層図

```
GenericAPIServer
    │
    ├─ OpenAPI v2 Handler (/openapi/v2)
    │      └─ OpenAPIService
    │             ├─ ビルトインAPI定義
    │             ├─ CRDスキーマ統合
    │             └─ Aggregated APIスキーマ統合
    │
    └─ OpenAPI v3 Handler (/openapi/v3)
           └─ OpenAPIV3Service
                  ├─ グループ/バージョン別仕様
                  └─ CRDスキーマ統合
```

### データフロー図

```
[入力]                        [処理]                        [出力]

ビルトインAPI定義 ──────▶ OpenAPI Builder ──────▶ /openapi/v2 (JSON/Protobuf)
CRDスキーマ ──────────▶ 仕様マージ ──────────▶ /openapi/v3 (JSON)
拡張APIスキーマ ──────▶ キャッシュ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| swagger.json | `api/openapi-spec/swagger.json` | 仕様 | 静的OpenAPI v2仕様 |
| v3/ | `api/openapi-spec/v3/` | 仕様 | 静的OpenAPI v3仕様 |
| openapi/ | `staging/src/k8s.io/apiserver/pkg/endpoints/openapi/` | ソース | OpenAPIサービス実装 |
| builder/ | `staging/src/k8s.io/kube-openapi/pkg/builder/` | ソース | OpenAPI仕様ビルダー |
| README.md | `api/openapi-spec/README.md` | ドキュメント | OpenAPI仕様の説明 |
