# 機能設計書 63-統計情報収集

## 概要

本ドキュメントは、Kubeletにおけるコンテナ・ノードのリソース使用量統計を収集する機能の設計を記述する。

### 本機能の処理概要

KubeletのStats Providerは、cAdvisorおよびCRI（Container Runtime Interface）を通じてコンテナとノードのCPU、メモリ、ファイルシステム、ネットワーク等のリソース使用量統計を収集・提供するコンポーネントである。

**業務上の目的・背景**：Kubernetesクラスターにおけるリソース使用量の可視化は、キャパシティプランニング、オートスケーリング、Eviction判定、課金等の基盤となる。Stats Providerは、Metrics APIやkubectl topコマンド、Eviction Managerなどの上位機能にリソースメトリクスデータを提供する。

**機能の利用シーン**：(1) kubectl top nodes/podsによるリソース使用量表示、(2) HPAによるメトリクスベースのオートスケーリング、(3) Eviction Managerによるリソース逼迫検知、(4) /stats/summary APIによる統計情報取得。

**主要な処理内容**：
1. cAdvisorを通じてノード全体のリソース使用量（CPU、メモリ、ファイルシステム）を取得する
2. CRI StatsProviderまたはcAdvisor StatsProviderを通じてPod/コンテナ毎の統計を収集する
3. cgroup統計を取得し、コンテナ/ノードレベルのメトリクスを生成する
4. ルートファイルシステム・イメージファイルシステムの使用量を報告する
5. プロセス数制限（PID Limit）の統計を提供する

**関連システム・外部連携**：cAdvisor、CRI RuntimeService/ImageService、cgroups（Linux）。

**権限による制御**：統計情報APIへのアクセスにはKubelet APIの認証・認可が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | kubectl top | API連携 | Metrics APIを通じてCPU/メモリ使用量のメトリクスを取得する |

## 機能種別

データ収集・集計処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| cgroupName | string | Yes (GetCgroupStats) | cgroup名 | 有効なcgroupパス |
| updateStats | bool | No | 統計の強制更新フラグ | - |
| podAndContainerStatsFromCRI | bool | No | CRIからPod/コンテナ統計を取得するか | - |

### 入力データソース

- cAdvisor: ノードレベルのコンテナ情報、ファイルシステム情報
- CRI RuntimeService: Pod/コンテナのCPU/メモリ統計
- CRI ImageService: イメージファイルシステム情報
- cgroups: cgroupベースのリソース使用量

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| PodStats | []statsapi.PodStats | Pod単位の統計情報（CPU、メモリ、ネットワーク、ボリューム等） |
| ContainerStats | *statsapi.ContainerStats | コンテナ単位の統計情報 |
| FsStats | *statsapi.FsStats | ファイルシステムの使用量統計 |
| NetworkStats | *statsapi.NetworkStats | ネットワーク統計 |
| RlimitStats | *statsapi.RlimitStats | プロセス数制限統計 |

### 出力先

- Kubelet Summary API (/stats/summary)
- Resource Metrics API (/metrics/resource)
- Eviction Manager（内部利用）
- cAdvisor Metrics API (/metrics/cadvisor)

## 処理フロー

### 処理シーケンス

```
1. 統計リクエスト受信（APIまたは内部呼び出し）
   └─ Provider.ListPodStats() / GetCgroupStats() / RootFsStats() 等
2. cAdvisor / CRI からデータ取得
   └─ cadvisor.SubcontainerInfo() / runtimeService.ListPodSandboxStats()
3. データ変換
   └─ cadvisorInfoToContainerStats() / cadvisorInfoToNetworkStats()
4. 統計応答を返却
```

### フローチャート

```mermaid
flowchart TD
    A[統計リクエスト] --> B{データソース}
    B -->|cAdvisor| C[cAdvisor SubcontainerInfo]
    B -->|CRI| D[CRI ListPodSandboxStats]
    C --> E[cadvisorInfoToContainerStats]
    D --> F[CRI統計変換]
    E --> G[statsapi.PodStats/ContainerStats]
    F --> G
    G --> H[応答返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-63-01 | プロバイダ選択 | CRI StatsProviderが優先され、フォールバックとしてcAdvisor StatsProviderが使用される | 初期化時の設定 |
| BR-63-02 | 専用イメージFS判定 | イメージFSデバイスがルートFSデバイスと異なる場合、専用イメージFSとみなす | HasDedicatedImageFs呼び出し時 |
| BR-63-03 | inode使用量計算 | inodesUsed = Inodes - InodesFree | RootFsStats取得時 |

### 計算ロジック

- inodesUsed: `*rootFsInfo.Inodes - *rootFsInfo.InodesFree`
- 専用FS判定: `device != rootFsInfo.Device` またはイメージFSとコンテナFSが異なる場合

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを直接操作しない。cAdvisorおよびCRIから統計を読み取り専用で取得する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ErrDataNotFound | cAdvisorにcgroup統計が存在しない | エラーメッセージ返却 |
| - | CRIエラー | CRI API呼び出し失敗 | エラーをラップして返却 |
| - | cAdvisorエラー | cAdvisor API呼び出し失敗 | エラーをラップして返却 |

### リトライ仕様

統計取得は呼び出し元（定期ポーリングまたはAPIリクエスト）の再試行に依存する。Provider自体にはリトライロジックはない。

## トランザクション仕様

該当なし（読み取り専用操作）。

## パフォーマンス要件

- cAdvisor統計はメモリ内キャッシュから取得されるため低レイテンシ
- CRI統計はgRPC呼び出しで取得
- updateStats=falseの場合はキャッシュデータを返す

## セキュリティ考慮事項

- /stats/summary APIへのアクセスにはKubelet APIの認証・認可が必要
- 統計情報にはリソース使用量のみが含まれ、機密データは含まない

## 備考

- KEP 4191により、イメージFSとコンテナFSが別デバイスの場合も検出可能になった
- PID制限統計はLinuxのみで利用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | provider.go | `pkg/kubelet/stats/provider.go` | Provider構造体（92-96行目）: cAdvisorとcontainerStatsProviderを保持 |
| 1-2 | provider.go | `pkg/kubelet/stats/provider.go` | containerStatsProviderインターフェース（100-108行目）: Pod/コンテナ統計の取得API |

**読解のコツ**: ProviderはcAdvisor（ノード統計）とcontainerStatsProvider（コンテナ統計）の2つのデータソースを抽象化している。

#### Step 2: ファクトリ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | provider.go | `pkg/kubelet/stats/provider.go` | NewCRIStatsProvider（49-61行目）: CRI統計プロバイダの生成 |
| 2-2 | provider.go | `pkg/kubelet/stats/provider.go` | NewCadvisorStatsProvider（65-75行目）: cAdvisor統計プロバイダの生成 |

#### Step 3: 統計取得メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | provider.go | `pkg/kubelet/stats/provider.go` | GetCgroupStats（117-132行目）: cgroup統計取得 |
| 3-2 | provider.go | `pkg/kubelet/stats/provider.go` | RootFsStats（150-178行目）: ルートFS統計 |
| 3-3 | provider.go | `pkg/kubelet/stats/provider.go` | HasDedicatedImageFs（182-203行目）: 専用イメージFS判定 |
| 3-4 | cri_stats_provider.go | `pkg/kubelet/stats/cri_stats_provider.go` | CRI固有の統計取得実装 |

### プログラム呼び出し階層図

```
Stats Provider
    │
    ├─ RootFsStats()
    │      └─ cadvisor.RootFsInfo()
    │
    ├─ GetCgroupStats()
    │      ├─ getCgroupInfo() → cadvisor
    │      └─ cadvisorInfoToContainerStats()
    │
    ├─ HasDedicatedImageFs()
    │      ├─ containerStatsProvider.ImageFsDevice()
    │      └─ cadvisor.RootFsInfo()
    │
    ├─ ListPodStats() [delegate to containerStatsProvider]
    │      ├─ CRI: runtimeService.ListPodSandboxStats()
    │      └─ cAdvisor: cadvisor.SubcontainerInfo()
    │
    └─ RlimitStats()
           └─ pidlimit.Stats()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

cAdvisor メモリキャッシュ ──▶ Provider ──────────────▶ statsapi.PodStats
CRI gRPC API ──────────────▶ containerStatsProvider ──▶ statsapi.ContainerStats
cgroups ───────────────────▶ getCgroupInfo() ─────────▶ statsapi.FsStats
/proc ─────────────────────▶ pidlimit.Stats() ────────▶ statsapi.RlimitStats
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| provider.go | `pkg/kubelet/stats/provider.go` | ソース | 統計プロバイダの基本構造 |
| cri_stats_provider.go | `pkg/kubelet/stats/cri_stats_provider.go` | ソース | CRI統計プロバイダ実装 |
| cadvisor_stats_provider.go | `pkg/kubelet/stats/cadvisor_stats_provider.go` | ソース | cAdvisor統計プロバイダ実装 |
| helper.go | `pkg/kubelet/stats/helper.go` | ソース | 統計変換ヘルパー関数 |
| host_stats_provider.go | `pkg/kubelet/stats/host_stats_provider.go` | ソース | ホスト統計プロバイダ |
| cadvisor_linux.go | `pkg/kubelet/cadvisor/cadvisor_linux.go` | ソース | cAdvisor Linux実装 |
| types.go | `pkg/kubelet/cadvisor/types.go` | ソース | cAdvisorインターフェース定義 |
