# 機能設計書 66-Kubelet API Server

## 概要

本ドキュメントは、Kubeletが公開するHTTP/gRPC APIサーバー機能の設計を記述する。

### 本機能の処理概要

Kubelet API Serverは、Kubeletが外部に公開するHTTPおよびgRPCのエンドポイントを管理するコンポーネントである。メトリクス、ログ、Pod情報、統計情報、ヘルスチェック等のAPIを提供する。

**業務上の目的・背景**：KubeletはKubernetesクラスターにおけるノードエージェントであり、API Server、監視システム、kubectlなどの外部コンポーネントからの情報取得やコマンド実行を受け付ける必要がある。Kubelet API Serverは、go-restfulフレームワークを使用してRESTful APIを公開し、認証・認可・監査ログ等のセキュリティ機能を統合的に提供する。

**機能の利用シーン**：(1) kubectl logs/exec/port-forward等のPod操作、(2) Prometheus等の監視システムによるメトリクス収集、(3) API ServerからのPod情報取得（/pods）、(4) ヘルスチェック（/healthz）。

**主要な処理内容**：
1. go-restfulコンテナの初期化とルーティング設定
2. 認証・認可フィルターの適用
3. メトリクスエンドポイント（/metrics、/metrics/cadvisor、/metrics/resource、/metrics/probes）の公開
4. Pod操作エンドポイント（/exec、/attach、/portForward、/logs）の公開
5. Pod情報エンドポイント（/pods、/runningpods）の公開
6. 統計情報エンドポイント（/stats/summary）の公開
7. PodResources gRPC APIの公開

**関連システム・外部連携**：API Server（認証・認可の委譲）、Prometheus（メトリクス収集）、kubectl（Pod操作）、CRI（exec/attach/portforward）。

**権限による制御**：全てのリクエストは認証（AuthN）と認可（AuthZ）のフィルターを通過する必要がある。匿名アクセスの制限が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | kubectl exec | API連携 | Kubelet exec APIを通じてコンテナ内コマンドを実行 |
| 10 | kubectl attach | API連携 | Kubelet attach APIを通じてコンテナに接続 |
| 11 | kubectl port-forward | API連携 | Kubelet portForward APIを通じてポート転送 |
| 20 | kubectl logs | API連携 | Kubelet logs APIを通じてコンテナログを取得 |

## 機能種別

APIゲートウェイ（HTTP/gRPCサーバー）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| addr | net.Addr | Yes | リスンアドレス | 有効なネットワークアドレス |
| tlsOptions | *TLSOptions | No | TLS設定 | 有効な証明書/鍵 |
| auth | AuthInterface | Yes | 認証・認可インターフェース | - |
| host | HostInterface | Yes | Kubeletホストインターフェース | - |

### 入力データソース

- HTTPリクエスト: 外部クライアントからのAPIリクエスト
- gRPCリクエスト: PodResources APIクライアント

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTTP応答 | http.ResponseWriter | 各API応答（JSON/text/streaming） |
| gRPC応答 | protobuf | PodResources API応答 |
| メトリクス | Prometheus形式 | 各メトリクスエンドポイント |

### 出力先

- HTTPクライアント: APIリクエストに対する応答
- gRPCクライアント: PodResources APIの応答

## 処理フロー

### 処理シーケンス

```
1. サーバー初期化 (NewServer)
   └─ go-restfulコンテナ作成 → 認証フィルター登録 → 各エンドポイント登録
2. リクエスト受信
   └─ go-restfulフィルターチェーン: ロギング → 認証 → 認可 → ハンドラ実行
3. エンドポイント処理
   └─ 各ハンドラがhostインターフェースを通じて処理を実行
4. レスポンス返却
   └─ メトリクス記録 → HTTP応答送信
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B[httplog.WithLogging]
    B --> C[認証フィルター]
    C --> D{認証成功?}
    D -->|No| E[401 Unauthorized]
    D -->|Yes| F[認可フィルター]
    F --> G{認可成功?}
    G -->|No| H[403 Forbidden]
    G -->|Yes| I[エンドポイントハンドラ]
    I --> J[レスポンス返却]
    J --> K[メトリクス記録]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-66-01 | 認証必須 | 全リクエストは認証フィルターを通過する | 常時 |
| BR-66-02 | 認可必須 | 認証済みリクエストは認可フィルターを通過する | 常時 |
| BR-66-03 | メトリクスバケット | リクエストメトリクスは設定されたパスバケットに分類される | 常時 |
| BR-66-04 | TLSサポート | TLSオプション設定時はHTTPSで提供 | TLS設定時 |

### 計算ロジック

- メトリクスパス: metricsPath("/metrics")、cadvisorMetricsPath("/metrics/cadvisor")、resourceMetricsPath("/metrics/resource")、proberMetricsPath("/metrics/probes")

## データベース操作仕様

本機能はデータベースを直接操作しない。各エンドポイントハンドラがhostインターフェースを通じて内部データにアクセスする。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | Bad Request | パラメータ不正 | エラーメッセージ返却 |
| 401 | Unauthorized | 認証失敗 | 認証エラー返却 |
| 403 | Forbidden | 認可失敗 | 認可エラー返却 |
| 404 | Not Found | リソース不存在 | Not Found返却 |
| 500 | Internal Server Error | 内部処理エラー | エラーメッセージ返却 |

## トランザクション仕様

該当なし（HTTPリクエスト/レスポンスのステートレス処理）。

## パフォーマンス要件

- ストリーミングAPI（exec/attach/logs）はFlushWriterを使用してリアルタイムデータ送信
- メトリクス応答はPromQL/OpenMetrics形式で効率的にシリアライズ
- OpenTelemetryトレーシングによるリクエスト追跡が可能

## セキュリティ考慮事項

- 認証・認可は全リクエストに適用される
- exec/attach APIはWebSocket/SPDYプロトコルを使用（プロトコルアップグレード）
- pprofエンドポイントは認可済みユーザーのみアクセス可能
- Content-Typeヘッダーの適切な設定によるXSS防止

## 備考

- go-restful v3フレームワークを使用
- OpenTelemetry統合による分散トレーシングサポート
- CheckpointContainer APIはフィーチャーゲートで制御

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | server.go | `pkg/kubelet/server/server.go` | Server構造体（120-129行目）: サーバーの内部状態 |
| 1-2 | server.go | `pkg/kubelet/server/server.go` | TLSOptions構造体（132-136行目）: TLS設定 |
| 1-3 | server.go | `pkg/kubelet/server/server.go` | エンドポイントパス定数（100-112行目）: APIパス定義 |

**読解のコツ**: Serverはgo-restfulのContainerInterface、AuthInterface、HostInterfaceの3つの主要インターフェースを保持する。HostInterfaceがKubelet本体への委譲インターフェースである。

#### Step 2: 初期化処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | server.go | `pkg/kubelet/server/server.go` | NewServer関数: サーバー初期化とルーティング設定 |
| 2-2 | server.go | `pkg/kubelet/server/server.go` | 認証・認可フィルターの登録 |

#### Step 3: 主要エンドポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | server.go | `pkg/kubelet/server/server.go` | /pods, /runningpods エンドポイント |
| 3-2 | server.go | `pkg/kubelet/server/server.go` | /exec, /attach, /portForward エンドポイント |
| 3-3 | server.go | `pkg/kubelet/server/server.go` | /stats/summary エンドポイント |

### プログラム呼び出し階層図

```
Kubelet API Server
    │
    ├─ go-restful Container
    │      ├─ Filter: httplog.WithLogging
    │      ├─ Filter: Authentication
    │      ├─ Filter: Authorization
    │      │
    │      ├─ /pods → handlePods() → host.GetPods()
    │      ├─ /runningpods → handleRunningPods()
    │      ├─ /exec → handleExec() → host.GetExec() → CRI
    │      ├─ /attach → handleAttach() → host.GetAttach() → CRI
    │      ├─ /portForward → handlePortForward() → host.GetPortForward() → CRI
    │      ├─ /logs → journalServer.ServeHTTP()
    │      ├─ /metrics → legacyregistry.Handler()
    │      ├─ /metrics/cadvisor → cadvisor metrics handler
    │      ├─ /metrics/resource → resource metrics handler
    │      ├─ /stats/ → stats handler
    │      └─ /healthz → healthz.Handler
    │
    └─ gRPC Server (PodResources API)
           ├─ List() → podresources handler
           ├─ GetAllocatableResources()
           └─ Get()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

HTTPリクエスト ────────▶ go-restful Filter Chain ──▶ 認証・認可チェック
                              │
認証済みリクエスト ────▶ エンドポイントハンドラ ──────▶ HostInterface委譲
                              │
HostInterface応答 ────▶ レスポンス生成 ──────────▶ HTTP応答

gRPCリクエスト ────────▶ PodResources Handler ────▶ gRPC応答
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| server.go | `pkg/kubelet/server/server.go` | ソース | Kubelet APIサーバー実装 |
| auth.go | `pkg/kubelet/server/auth.go` | ソース | 認証・認可フィルター |
| stats/handler.go | `pkg/kubelet/server/stats/handler.go` | ソース | 統計APIハンドラ |
| stats/resource_analyzer.go | `pkg/kubelet/server/stats/resource_analyzer.go` | ソース | リソース解析 |
| metrics/ | `pkg/kubelet/server/metrics/` | ソース | サーバーメトリクス |
| server_test.go | `pkg/kubelet/server/server_test.go` | テスト | APIサーバーのテスト |
