# 機能設計書 74-Serviceプロキシ（iptables）

## 概要

本ドキュメントは、kube-proxyのiptablesモードにおけるServiceプロキシ機能の設計を記述する。iptablesルールを管理してKubernetes ServiceへのトラフィックをバックエンドPodに転送するメカニズムを定義する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetes Serviceは仮想IPアドレス（ClusterIP）を提供し、バックエンドPodへのロードバランシングを行う。iptablesモードはLinuxカーネルのnetfilter/iptablesを利用して、カーネル空間でパケット転送を行うことで、ユーザー空間プロキシよりも高いパフォーマンスと低いレイテンシを実現する。

**機能の利用シーン**：kube-proxyが各ノードで起動し、API ServerからServiceおよびEndpointSliceの変更をWatchして、iptablesルールを動的に更新する。

**主要な処理内容**：
1. ServiceChangeTrackerによるService変更の追跡
2. EndpointsChangeTrackerによるエンドポイント変更の追跡
3. iptablesルールの生成と一括適用（syncProxyRules）
4. DNAT/SNATルールによるトラフィック転送
5. ClusterIP、NodePort、LoadBalancer、ExternalIPの各Serviceタイプ対応
6. Session Affinityの実装
7. トポロジー対応ルーティング
8. conntrackエントリのクリーンアップ

**関連システム・外部連携**：Linux iptables/netfilter、conntrackテーブル、ヘルスチェックサーバー。

**権限による制御**：kube-proxyはノード上でiptablesルールを操作するためroot権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | バックグラウンドプロセスのため直接の画面関連はなし |

## 機能種別

ネットワーク制御 / データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ipFamily | v1.IPFamily | Yes | IPv4またはIPv6 | IPv4Protocol/IPv6Protocol |
| syncPeriod | time.Duration | Yes | 同期間隔 | 正の値 |
| minSyncPeriod | time.Duration | Yes | 最小同期間隔 | 0以上 |
| masqueradeAll | bool | No | 全トラフィックにSNAT適用 | - |
| masqueradeBit | int | Yes | マスカレードマークのビット位置 | 0-31 |
| localhostNodePorts | bool | No | localhost経由のNodePortアクセス許可 | - |

### 入力データソース

- API Server: Service、EndpointSlice、Nodeリソース（Informer経由）
- sysctl: net/ipv4/conf/all/route_localnet等

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iptablesルール | テキスト | nat/filterテーブルのルール群 |
| conntrackエントリ削除 | - | 不要なconntrackエントリの削除 |

### 出力先

Linux iptables（natテーブル、filterテーブル）

## 処理フロー

### 処理シーケンス

```
1. Proxier初期化（NewProxier）
   ├─ iptablesインターフェース設定
   ├─ ServiceChangeTracker/EndpointsChangeTracker作成
   ├─ sysctlパラメータ設定（route_localnet等）
   └─ ヘルスチェックサーバー連携
2. Sync Loop（BoundedFrequencyRunner）
   ├─ Service/Endpoint変更検知
   └─ syncProxyRules呼び出し
3. syncProxyRules
   ├─ ServicePortMap/EndpointsMapの更新
   ├─ iptablesルール生成
   │   ├─ KUBE-SERVICES チェーン（ClusterIP）
   │   ├─ KUBE-NODEPORTS チェーン（NodePort）
   │   ├─ KUBE-EXTERNAL-SERVICES チェーン（ExternalIP/LB）
   │   ├─ KUBE-POSTROUTING チェーン（SNAT/マスカレード）
   │   ├─ KUBE-MARK-MASQ チェーン（マスカレードマーク）
   │   ├─ KUBE-FORWARD チェーン（転送許可）
   │   └─ KUBE-PROXY-FIREWALL チェーン（ファイアウォール）
   ├─ iptables-restore による一括適用
   └─ conntrackクリーンアップ
```

### フローチャート

```mermaid
flowchart TD
    A[Service/Endpoint変更検知] --> B[syncProxyRules]
    B --> C[ServicePortMap更新]
    C --> D[EndpointsMap更新]
    D --> E[iptablesルール生成]
    E --> F{大規模クラスター?}
    F -->|>1000 endpoints| G[パフォーマンス最適化モード]
    F -->|<=1000| H[通常モード]
    G --> I[iptables-restore一括適用]
    H --> I
    I --> J[conntrackクリーンアップ]
    J --> K[ヘルスチェック更新]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-74-01 | ClusterIPルーティング | ClusterIPへのトラフィックをバックエンドPodにDNAT | ClusterIP Serviceに対するトラフィック |
| BR-74-02 | NodePort転送 | 全ノードの指定ポートへのトラフィックをバックエンドに転送 | NodePort/LoadBalancer Service |
| BR-74-03 | SessionAffinity | ClientIPベースのセッション維持 | Service.Spec.SessionAffinityがClientIP |
| BR-74-04 | マスカレード | クラスター外部からのトラフィックにSNAT適用 | externalTrafficPolicyがCluster、またはmasqueradeAll |
| BR-74-05 | 大規模クラスター最適化 | 1000エンドポイント以上でパフォーマンス最適化 | largeClusterEndpointsThreshold超過 |
| BR-74-06 | DualStack対応 | IPv4/IPv6それぞれ独立したProxierを作成 | DualStackクラスター |
| BR-74-07 | チェーン命名 | Service/Endpointチェーン名はSHA256ハッシュで生成 | 全Service/Endpoint |

### 計算ロジック

チェーン名のハッシュ生成：`base32(sha256(protocol + ":" + namespace + "/" + name + ":" + portName))`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | iptables natテーブル | WRITE | DNATルールの追加・削除 |
| - | iptables filterテーブル | WRITE | フォワード・ファイアウォールルール |
| - | conntrackテーブル | DELETE | 不要エントリの削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | iptables-restore失敗 | iptablesルール適用エラー | ログ出力、次回同期で再試行 |
| - | sysctl設定失敗 | カーネルパラメータ変更不可 | 起動時エラー |
| - | conntrackクリーンアップ失敗 | conntrackエントリ削除エラー | ログ出力、処理継続 |

### リトライ仕様

BoundedFrequencyRunnerにより、minSyncPeriodとsyncPeriodの範囲で自動再試行される。

## トランザクション仕様

iptables-restoreによるアトミックなルール適用。全ルールが一括で適用されるか、全く適用されないかのいずれか。

## パフォーマンス要件

- iptablesルールの適用はO(N)（NはService/Endpoint数）
- 1000エンドポイント超過時にlargeClusterモードで最適化
- iptables-restoreによる一括適用で個別ルール追加のオーバーヘッドを回避

## セキュリティ考慮事項

- KUBE-PROXY-FIREWALLチェーンによるLoadBalancerSourceRangesの制御
- KUBE-MARK-MASQによるマスカレード制御
- route_localnet sysctlの有効化によるセキュリティ影響の認識が必要

## 備考

- iptablesモードはLinux専用（`//go:build linux`）
- IPv4とIPv6はMetaProxierにより統合管理される
- KUBE-FIREWALLチェーンはKubeletのファイアウォールチェーンの複製

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | proxier.go | `pkg/proxy/iptables/proxier.go` | Proxier構造体（132-150行目）とチェーン定数（53-87行目） |

**読解のコツ**: Proxier構造体のフィールドは大きく3つのカテゴリに分類される。(1)変更追跡（endpointsChanges/serviceChanges）、(2)現在の状態（svcPortMap/endpointsMap）、(3)設定パラメータ。

#### Step 2: 初期化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | proxier.go | `pkg/proxy/iptables/proxier.go` | NewDualStackProxier（93-130行目）、NewProxier関数 |

**主要処理フロー**:
1. **93-130行目**: DualStack用にIPv4/IPv6の2つのProxierを作成しMetaProxierでラップ
2. NewProxier内でsyscltの設定、ChangeTrackerの初期化、BoundedFrequencyRunnerの設定

#### Step 3: 同期ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | proxier.go | `pkg/proxy/iptables/proxier.go` | syncProxyRules関数（本ファイルの主要部分） |

### プログラム呼び出し階層図

```
kube-proxy main
    |
    +-- NewDualStackProxier / NewProxier
    |       +-- proxy.NewServiceChangeTracker
    |       +-- proxy.NewEndpointsChangeTracker
    |
    +-- Proxier.SyncLoop (BoundedFrequencyRunner)
            |
            +-- syncProxyRules
                    +-- serviceChanges.Update
                    +-- endpointsChanges.Update
                    +-- [iptablesルール生成]
                    +-- iptables.RestoreAll (iptables-restore)
                    +-- conntrack.CleanStaleEntries
                    +-- healthcheck.Updated
```

### データフロー図

```
[入力]                          [処理]                    [出力]

API Server                                               iptables natテーブル
  Service ----Watch----> ServiceChangeTracker ----+       iptables filterテーブル
  EndpointSlice -Watch-> EndpointsChangeTracker --+
                                                  |
                                         syncProxyRules
                                                  |
  Node info ---------> topologyLabels ----------->+----> iptables-restore
                                                  |
                                                  +----> conntrack cleanup
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| proxier.go | `pkg/proxy/iptables/proxier.go` | ソース | iptablesモードのメインProxierロジック |
| cleanup.go | `pkg/proxy/iptables/cleanup.go` | ソース | iptablesルールのクリーンアップ |
| doc.go | `pkg/proxy/iptables/doc.go` | ソース | パッケージドキュメント |
| proxier_test.go | `pkg/proxy/iptables/proxier_test.go` | テスト | ユニットテスト |
| endpointschangetracker.go | `pkg/proxy/endpointschangetracker.go` | ソース | エンドポイント変更追跡 |
| servicechangetracker.go | `pkg/proxy/servicechangetracker.go` | ソース | Service変更追跡 |
| topology.go | `pkg/proxy/topology.go` | ソース | トポロジー対応ルーティング |
