# 機能設計書 75-Serviceプロキシ（IPVS）

## 概要

本ドキュメントは、kube-proxyのIPVSモードにおけるServiceプロキシ機能の設計を記述する。IP Virtual Server（IPVS）を利用した高性能なロードバランシングメカニズムを定義する。

### 本機能の処理概要

**業務上の目的・背景**：大規模クラスターにおいて、iptablesモードではルール数がO(N)でパケット処理されるため、Service/Endpoint数が増加するとパフォーマンスが低下する。IPVSはLinuxカーネルのレイヤー4ロードバランサーであり、ハッシュテーブルベースのO(1)ルックアップを提供するため、大規模環境でも安定したパフォーマンスを実現する。

**機能の利用シーン**：kube-proxyの`--proxy-mode=ipvs`指定時に使用される。数千のServiceを持つ大規模クラスターで特に有効。

**主要な処理内容**：
1. IPVS仮想サーバーおよびリアルサーバーの管理
2. ダミーインターフェース（kube-ipvs0）へのService IPバインド
3. ipsetを使用した効率的なIP管理
4. iptablesルールとの併用（SNAT、ファイアウォール等）
5. 複数のスケジューリングアルゴリズム対応（rr, lc, dh, sh, sed, nq等）
6. 接続タイムアウトの管理（TCP, TCP-FIN, UDP）
7. StrictARPモードの制御
8. Graceful Terminationによる接続の安全な切断

**関連システム・外部連携**：Linux IPVS（ip_vs カーネルモジュール）、ipset、iptables、conntrack、ダミーネットワークインターフェース。

**権限による制御**：root権限が必要。ip_vsカーネルモジュールのロードが必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | バックグラウンドプロセスのため直接の画面関連はなし |

## 機能種別

ネットワーク制御 / データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ipFamily | v1.IPFamily | Yes | IPv4またはIPv6 | - |
| scheduler | string | No | IPVSスケジューリングアルゴリズム（デフォルト: rr） | rr/lc/dh/sh/sed/nq |
| syncPeriod | time.Duration | Yes | 同期間隔 | 正の値 |
| strictARP | bool | No | StrictARPモードの有効化 | - |
| tcpTimeout | time.Duration | No | TCP接続タイムアウト | - |
| tcpFinTimeout | time.Duration | No | TCP FINタイムアウト | - |
| udpTimeout | time.Duration | No | UDP接続タイムアウト | - |
| excludeCIDRs | []string | No | IPVS仮想サーバーから除外するCIDR | 有効なCIDR形式 |

### 入力データソース

- API Server: Service、EndpointSlice、Nodeリソース（Informer経由）
- sysctl: net/ipv4/vs/conntrack、net/ipv4/vs/conn_reuse_mode等

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| IPVS仮想サーバー | - | Service毎の仮想サーバー設定 |
| IPVSリアルサーバー | - | Endpoint毎のリアルサーバー設定 |
| ipsetエントリ | - | IP/ポートのセット管理 |
| iptablesルール | - | SNAT/ファイアウォール用ルール |

### 出力先

Linux IPVS（netlink経由）、ipset、iptables

## 処理フロー

### 処理シーケンス

```
1. Proxier初期化（NewProxier）
   ├─ IPVSインターフェース初期化
   ├─ ipsetインターフェース初期化
   ├─ iptablesインターフェース初期化
   ├─ ダミーデバイス（kube-ipvs0）確認/作成
   ├─ sysctlパラメータ設定
   └─ ChangeTracker作成
2. Sync Loop
   ├─ Service/Endpoint変更検知
   └─ syncProxyRules呼び出し
3. syncProxyRules
   ├─ ServicePortMap/EndpointsMapの更新
   ├─ IPVS仮想サーバーの追加/更新/削除
   ├─ IPVSリアルサーバーの追加/更新/削除
   ├─ ipsetエントリの更新
   ├─ iptablesルールの更新
   ├─ ダミーデバイスへのIPバインド/アンバインド
   └─ conntrackクリーンアップ
```

### フローチャート

```mermaid
flowchart TD
    A[Service/Endpoint変更] --> B[syncProxyRules]
    B --> C[ServicePortMap更新]
    C --> D[EndpointsMap更新]
    D --> E[IPVS仮想サーバー管理]
    E --> F[IPVSリアルサーバー管理]
    F --> G[ipsetエントリ更新]
    G --> H[iptablesルール更新]
    H --> I[ダミーデバイスIPバインド]
    I --> J[conntrackクリーンアップ]
    J --> K[ヘルスチェック更新]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-75-01 | デフォルトスケジューラー | 未指定時はrr（Round Robin）を使用 | schedulerパラメータ未設定 |
| BR-75-02 | ダミーデバイス | kube-ipvs0にService IPをバインド | 全ClusterIP/ExternalIP/LoadBalancerIP |
| BR-75-03 | StrictARP | arp_ignore=1, arp_announce=2を設定 | strictARP=true |
| BR-75-04 | 接続タイムアウト | IPVS仮想サーバーに接続タイムアウトを設定 | tcpTimeout/tcpFinTimeout/udpTimeout指定時 |
| BR-75-05 | DualStack対応 | IPv4/IPv6それぞれ独立したProxierを作成 | DualStackクラスター |
| BR-75-06 | IPVSフィルタ | KUBE-IPVS-FILTERで外部アクセスをフィルタ | 全仮想サーバー |

### 計算ロジック

IPVSのウェイト計算：全エンドポイントに均等ウェイト（デフォルト1）を設定。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | IPVS仮想サーバー | CREATE/UPDATE/DELETE | Service毎の仮想サーバー管理 |
| - | IPVSリアルサーバー | CREATE/UPDATE/DELETE | Endpoint毎のリアルサーバー管理 |
| - | ipset | CREATE/UPDATE/DELETE | IP/ポートセット管理 |
| - | iptables | WRITE | SNAT/ファイアウォールルール |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IPVS操作失敗 | カーネルモジュール未ロード | ip_vsモジュールの手動ロード |
| - | ダミーデバイス作成失敗 | 権限不足 | root権限確認 |
| - | ipset操作失敗 | ipsetカーネルモジュール未対応 | カーネルアップグレード |

### リトライ仕様

BoundedFrequencyRunnerによる自動再試行。

## トランザクション仕様

IPVS操作はnetlink経由で個別に行われるため、アトミックではない。部分的な更新失敗時は次回同期で修復される。

## パフォーマンス要件

- IPVSのルックアップはO(1)（ハッシュテーブルベース）
- iptablesモードに比べ、大規模クラスターでの性能が大幅に向上
- ipsetによるIP管理もO(1)

## セキュリティ考慮事項

- KUBE-IPVS-FILTERチェーンによる外部アクセス制御
- KUBE-IPVS-OUT-FILTERによるノードからのアクセス制御
- StrictARPによるARP Spoofing防止
- KUBE-SOURCE-RANGES-FIREWALLによるLoadBalancerSourceRanges制御

## 備考

- IPVSモードはiptablesとの併用が必要（SNAT、ファイアウォール）
- Graceful Terminationにより、エンドポイント削除時の接続断を最小化
- ip_vs, ip_vs_rr, ip_vs_wrr, ip_vs_sh等のカーネルモジュールが必要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | proxier.go | `pkg/proxy/ipvs/proxier.go` | チェーン定数（57-95行目）、sysctl定数（98-106行目） |

**読解のコツ**: IPVSモードはiptablesモードよりも多くのコンポーネント（IPVS, ipset, iptables, dummy device）を組み合わせるため、各コンポーネントの役割を理解することが重要。

#### Step 2: 初期化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | proxier.go | `pkg/proxy/ipvs/proxier.go` | NewDualStackProxier（108-150行目） |

**主要処理フロー**:
1. **108-150行目**: DualStack対応でIPv4/IPv6の2つのProxierを作成
2. **91行目**: defaultScheduler = "rr"（Round Robin）
3. **94行目**: defaultDummyDevice = "kube-ipvs0"

#### Step 3: Graceful Terminationを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | graceful_termination.go | `pkg/proxy/ipvs/graceful_termination.go` | 接続安全切断のロジック |

### プログラム呼び出し階層図

```
kube-proxy main
    |
    +-- NewDualStackProxier / NewProxier
    |       +-- utilipvs.New (IPVS interface)
    |       +-- utilipset.New (ipset interface)
    |       +-- utiliptables.New (iptables interface)
    |       +-- ダミーデバイス管理
    |
    +-- Proxier.SyncLoop (BoundedFrequencyRunner)
            |
            +-- syncProxyRules
                    +-- IPVS仮想/リアルサーバー管理
                    +-- ipsetエントリ管理
                    +-- iptablesルール管理
                    +-- conntrack.CleanStaleEntries
                    +-- healthcheck.Updated
```

### データフロー図

```
[入力]                          [処理]                       [出力]

API Server                                                  IPVS仮想/リアルサーバー
  Service ----Watch----> ServiceChangeTracker ----+         ipsetエントリ
  EndpointSlice -Watch-> EndpointsChangeTracker --+         iptablesルール
                                                  |         kube-ipvs0 IPバインド
                                         syncProxyRules
                                                  |
  Node info ---------> topologyLabels ----------->+----> conntrack cleanup
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| proxier.go | `pkg/proxy/ipvs/proxier.go` | ソース | IPVSモードのメインProxierロジック |
| graceful_termination.go | `pkg/proxy/ipvs/graceful_termination.go` | ソース | 接続の安全な切断 |
| ipset.go | `pkg/proxy/ipvs/ipset.go` | ソース | ipsetエントリの管理 |
| supported.go | `pkg/proxy/ipvs/supported.go` | ソース | カーネルモジュールサポート確認 |
| cleanup.go | `pkg/proxy/ipvs/cleanup.go` | ソース | IPVSルールのクリーンアップ |
| netlink_linux.go | `pkg/proxy/ipvs/netlink_linux.go` | ソース | netlink操作 |
