# 機能設計書 76-Serviceプロキシ（nftables）

## 概要

本ドキュメントは、kube-proxyのnftablesモードにおけるServiceプロキシ機能の設計を記述する。nftablesを利用したServiceトラフィック転送メカニズムを定義する。

### 本機能の処理概要

**業務上の目的・背景**：nftablesはiptablesの後継となるLinuxカーネルのパケットフィルタリングフレームワークであり、iptablesよりも効率的なルール管理とパフォーマンスを提供する。nftablesのmapやset機能を活用することで、大量のServiceに対しても効率的なルール管理が可能となる。

**機能の利用シーン**：kube-proxyの`--proxy-mode=nftables`指定時に使用される。nftablesをネイティブに使用するため、iptablesモードのレガシーな制約を受けない。

**主要な処理内容**：
1. nftablesテーブル（kube-proxy）内でのチェーン/セット/マップの管理
2. Service IPsマップによるClusterIP DNAT
3. Service NodePortsマップによるNodePort転送
4. ファイアウォールチェーンによるLoadBalancerSourceRanges制御
5. マスカレードチェーンによるSNAT
6. エンドポイントなしサービスの処理（reject）
7. ClusterIPsセットによるトラフィック管理

**関連システム・外部連携**：Linux nftables（knftablesライブラリ経由）、conntrack。

**権限による制御**：nftablesルール操作にroot権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | バックグラウンドプロセスのため直接の画面関連はなし |

## 機能種別

ネットワーク制御 / データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ipFamily | v1.IPFamily | Yes | IPv4またはIPv6 | - |
| syncPeriod | time.Duration | Yes | 同期間隔 | 正の値 |
| minSyncPeriod | time.Duration | Yes | 最小同期間隔 | 0以上 |
| masqueradeAll | bool | No | 全トラフィックSNAT適用 | - |
| masqueradeBit | int | Yes | マスカレードマークのビット位置 | - |

### 入力データソース

- API Server: Service、EndpointSlice、Nodeリソース（Informer経由）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| nftablesテーブル | - | kube-proxyテーブル内のルール群 |
| nftablesチェーン | - | 各種フィルタ/NATチェーン |
| nftablesマップ | - | service-ips, service-nodeports等のマップ |
| nftablesセット | - | cluster-ips, nodeport-ips等のセット |

### 出力先

Linux nftables（knftablesライブラリ経由）

## 処理フロー

### 処理シーケンス

```
1. Proxier初期化（NewProxier）
   ├─ knftablesインターフェース初期化
   ├─ ChangeTracker作成
   └─ BoundedFrequencyRunner設定
2. Sync Loop
   ├─ Service/Endpoint変更検知
   └─ syncProxyRules呼び出し
3. syncProxyRules
   ├─ ServicePortMap/EndpointsMapの更新
   ├─ nftablesトランザクション構築
   │   ├─ ベースチェーンの設定
   │   ├─ servicesチェーン（Service dispatch）
   │   ├─ service-ipsマップ（ClusterIP -> チェーン名）
   │   ├─ service-nodeportsマップ（NodePort -> チェーン名）
   │   ├─ cluster-ipsセット
   │   ├─ nodeport-ipsセット
   │   ├─ firewall-ipsマップ（LB Source Ranges）
   │   ├─ masqueradingチェーン
   │   ├─ reject-chain（エンドポイントなしサービス）
   │   └─ 各Service/Endpointのチェーン
   ├─ nftablesトランザクション実行
   └─ conntrackクリーンアップ
```

### フローチャート

```mermaid
flowchart TD
    A[Service/Endpoint変更] --> B[syncProxyRules]
    B --> C[ServicePortMap更新]
    C --> D[EndpointsMap更新]
    D --> E[nftablesトランザクション構築]
    E --> F[ベースチェーン設定]
    F --> G[サービスマップ更新]
    G --> H[エンドポイントチェーン生成]
    H --> I[ファイアウォールルール設定]
    I --> J[マスカレードルール設定]
    J --> K[nftablesトランザクション実行]
    K --> L[conntrackクリーンアップ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-76-01 | テーブル名 | 全ルールはkube-proxyテーブル内に作成 | 常時 |
| BR-76-02 | マップベース転送 | service-ipsマップでClusterIPからサービスチェーンへジャンプ | ClusterIP Service |
| BR-76-03 | NodePort転送 | service-nodeportsマップでNodePortからサービスチェーンへジャンプ | NodePort/LoadBalancer Service |
| BR-76-04 | エンドポイントなし | no-endpoint-servicesマップでREJECTまたはDROPを返す | エンドポイントが0のService |
| BR-76-05 | ファイアウォール | firewall-ipsマップでLoadBalancerSourceRangesを制御 | LoadBalancer Service with SourceRanges |
| BR-76-06 | DualStack対応 | IPv4/IPv6それぞれ独立したProxierを作成 | DualStackクラスター |
| BR-76-07 | チェーン命名 | Service/Endpointチェーン名はSHA256ハッシュベース | 全Service/Endpoint |

### 計算ロジック

チェーン名：`base32(sha256(protocol + ":" + namespace + "/" + name + ":" + portName))`のプレフィックス。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | nftables kube-proxyテーブル | CREATE/UPDATE/DELETE | 全ルールの管理 |
| - | conntrackテーブル | DELETE | 不要エントリの削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | nftables実行失敗 | nftバイナリ不在またはカーネル非対応 | nftablesパッケージインストール確認 |
| - | トランザクション失敗 | ルール適用エラー | ログ出力、次回同期で再試行 |

### リトライ仕様

BoundedFrequencyRunnerおよびrate.Limiterによる自動再試行。

## トランザクション仕様

nftablesのアトミックトランザクション機能を活用。全ルール変更が一括で適用されるか、全く適用されないかのいずれか。iptablesモードよりも堅牢なトランザクション保証。

## パフォーマンス要件

- nftablesのmap/set機能によりO(1)のルックアップ
- iptablesモードのような線形ルール走査が不要
- トランザクションベースの一括適用で効率的なルール更新

## セキュリティ考慮事項

- firewall-checkチェーンによるLoadBalancerSourceRanges制御
- cluster-ips-checkチェーンによる未割り当てClusterIPへのアクセス制御
- filter-input/filter-forwardチェーンによるパケットフィルタリング

## 備考

- nftablesモードはLinux専用（`//go:build linux`）
- knftablesライブラリ（sigs.k8s.io/knftables）を使用
- iptablesモードと異なり、kube-proxyプレフィックスは不要（テーブル内で名前空間化）
- rate.Limiterによる同期レート制御あり

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | proxier.go | `pkg/proxy/nftables/proxier.go` | チェーン/マップ/セット定数（55-97行目） |

**読解のコツ**: nftablesモードでは、iptablesのチェーンに加えてmap（キーバリューマッピング）とset（集合）の概念がある。service-ipsマップは「ClusterIP:port -> サービスチェーン名」の対応を保持する。

#### Step 2: 初期化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | proxier.go | `pkg/proxy/nftables/proxier.go` | NewDualStackProxier（99-134行目） |

**主要処理フロー**:
1. **99-134行目**: DualStack対応でIPv4/IPv6の2つのProxierを作成
2. **136-150行目**: Proxier構造体のフィールド定義

#### Step 3: 同期ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | proxier.go | `pkg/proxy/nftables/proxier.go` | syncProxyRules関数 |

### プログラム呼び出し階層図

```
kube-proxy main
    |
    +-- NewDualStackProxier / NewProxier
    |       +-- knftables.New (nftables interface)
    |       +-- proxy.NewServiceChangeTracker
    |       +-- proxy.NewEndpointsChangeTracker
    |
    +-- Proxier.SyncLoop (BoundedFrequencyRunner)
            |
            +-- syncProxyRules
                    +-- nftablesトランザクション構築
                    +-- nft.Run (トランザクション実行)
                    +-- conntrack.CleanStaleEntries
                    +-- healthcheck.Updated
```

### データフロー図

```
[入力]                          [処理]                       [出力]

API Server                                                  nftables kube-proxyテーブル
  Service ----Watch----> ServiceChangeTracker ----+           - chains
  EndpointSlice -Watch-> EndpointsChangeTracker --+           - maps (service-ips等)
                                                  |           - sets (cluster-ips等)
                                         syncProxyRules
                                                  |
  Node info ---------> topologyLabels ----------->+----> conntrack cleanup
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| proxier.go | `pkg/proxy/nftables/proxier.go` | ソース | nftablesモードのメインProxierロジック |
| cleanup.go | `pkg/proxy/nftables/cleanup.go` | ソース | nftablesルールのクリーンアップ |
| supported.go | `pkg/proxy/nftables/supported.go` | ソース | nftablesサポート確認 |
| doc.go | `pkg/proxy/nftables/doc.go` | ソース | パッケージドキュメント |
| proxier_test.go | `pkg/proxy/nftables/proxier_test.go` | テスト | ユニットテスト |
