# 機能設計書 80-リソース取得（get）

## 概要

本ドキュメントは、kubectlのgetコマンドによるKubernetesリソースの一覧取得と詳細表示機能の設計を記述する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesクラスターの運用において、デプロイされたリソースの状態を確認することは最も基本的かつ頻繁に行われる操作である。`kubectl get`コマンドは、Pods、Deployments、Services等あらゆるKubernetesリソースの一覧取得と詳細情報の表示を提供し、クラスターの状態監視と運用管理の基盤となる。

**機能の利用シーン**：(1) デプロイしたリソースの状態確認、(2) 名前空間内のリソース一覧取得、(3) JSONやYAML形式でのリソース定義の取得、(4) ラベルセレクターによるフィルタリング、(5) Watchモードによるリアルタイム変更監視。

**主要な処理内容**：
1. コマンドライン引数の解析（リソースタイプ、名前、ラベルセレクター等）
2. API Serverへのリソース取得リクエスト送信
3. 複数の出力フォーマット対応（table、wide、json、yaml、custom-columns、go-template）
4. サーバーサイドプリント（ServerPrint）によるテーブル出力
5. ソート機能（--sort-by）
6. Watch/WatchOnlyモードによるリアルタイム監視
7. チャンクサイズ指定による大量リソースのページング取得
8. RAW URIによるカスタムリクエスト
9. サブリソース取得

**関連システム・外部連携**：API Server（REST API）、kubeconfig（クラスター接続情報）。

**権限による制御**：RBACにより、リソースのget/list/watch権限が必要。名前空間スコープのリソースは現在のコンテキストの名前空間に限定される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | kubectl get | 主機能 | Kubernetesリソースの一覧取得と詳細表示を行う主処理 |
| 6 | kubectl get | API連携 | リソース取得リクエストをAPI Serverに送信しレスポンスを受信する |

## 機能種別

データ参照 / CLI操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TYPE | string | Yes* | リソースタイプ（pods, deployments等） | 有効なAPIリソースタイプ |
| NAME | string | No | リソース名 | - |
| -o/--output | string | No | 出力フォーマット（json/yaml/wide/custom-columns等） | AllowedFormatsに含まれること |
| -l/--selector | string | No | ラベルセレクター | 有効なセレクター式 |
| --field-selector | string | No | フィールドセレクター | 有効なフィールドクエリ |
| -A/--all-namespaces | bool | No | 全名前空間から取得 | - |
| -w/--watch | bool | No | 変更のリアルタイム監視 | - |
| --watch-only | bool | No | 監視のみ（初期リスト取得なし） | - |
| --sort-by | string | No | ソートフィールド | 有効なJSONPath式 |
| --raw | string | No | RAW URI指定 | 有効なURLパス |
| --chunk-size | int64 | No | ページングサイズ（デフォルト500） | 0以上 |
| --subresource | string | No | サブリソース名 | 有効なサブリソース |
| -f/--filename | string | No | ファイル指定 | 有効なファイルパス |
| --no-headers | bool | No | ヘッダー非表示 | - |
| --ignore-not-found | bool | No | NotFoundエラーの抑制 | - |
| --output-watch-events | bool | No | Watch イベントオブジェクト出力 | --watchまたは--watch-only必須 |
| --server-print | bool | No | サーバーサイドプリント（デフォルトtrue） | - |

### 入力データソース

- コマンドライン引数
- kubeconfig（クラスター接続情報、名前空間）
- ファイル（-f指定時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| リソース一覧 | text/json/yaml | 指定フォーマットでのリソース情報 |
| エラーメッセージ | text | エラー発生時のメッセージ |

### 出力先

標準出力（stdout）、エラーは標準エラー出力（stderr）。

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析（Complete）
   ├─ 名前空間の解決
   ├─ 出力フォーマットの決定
   ├─ プリンターの構成（ToPrinter）
   └─ Watch/WatchOnlyの設定
2. バリデーション（Validate）
   ├─ --raw と他フラグの排他チェック
   ├─ --show-labels と出力フォーマットの互換性チェック
   └─ --output-watch-events と --watch の依存チェック
3. 実行（Run）
   ├─ RAWモードの場合
   │   └─ rawhttp.RawGet でダイレクトリクエスト
   ├─ 通常モードの場合
   │   ├─ resource.Builderでリソース情報取得
   │   ├─ Watch/WatchOnlyの場合
   │   │   └─ watchtools.UntilWithoutRetry でリアルタイム監視
   │   └─ 通常取得の場合
   │       ├─ infos取得（チャンクサイズ指定可）
   │       ├─ ソート（--sort-by指定時）
   │       └─ プリンターによる出力
```

### フローチャート

```mermaid
flowchart TD
    A[kubectl get] --> B[Complete: 引数解析]
    B --> C[Validate: バリデーション]
    C --> D{RAWモード?}
    D -->|Yes| E[rawhttp.RawGet]
    D -->|No| F[resource.Builder構築]
    F --> G{Watch/WatchOnly?}
    G -->|Yes| H[Watch API接続]
    H --> I[イベントストリーム処理]
    G -->|No| J[リソース取得]
    J --> K{ソート必要?}
    K -->|Yes| L[RuntimeSorter.Sort]
    K -->|No| M[プリンター出力]
    L --> M
    M --> N[stdout出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-80-01 | デフォルトチャンクサイズ | 500件単位でページング取得 | チャンクサイズ未指定時 |
| BR-80-02 | サーバーサイドプリント | デフォルトでサーバーサイドテーブル変換を使用 | output=table/wide |
| BR-80-03 | クライアントサイドフォールバック | custom-columns/yaml/json指定時はクライアントサイド処理 | 該当出力フォーマット指定時 |
| BR-80-04 | RAW排他 | --raw指定時は他フラグ（watch、selector等）と排他 | --raw指定時 |
| BR-80-05 | Watch + Sort | --watch指定時の--sort-byは警告を出して無視 | --watch + --sort-by同時指定 |
| BR-80-06 | 名前空間スコープ | -A未指定時は現在のコンテキスト名前空間に限定 | 名前空間スコープのリソース |
| BR-80-07 | NotFound抑制 | --ignore-not-found指定時はNotFoundエラーを抑制 | 個別リソース取得時 |

### 計算ロジック

ソート処理はJSONPath式でオブジェクトからフィールド値を取得し、比較ソートを行う。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | API Server | GET/LIST/WATCH | リソースの読み取り（etcd経由） |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NotFound | リソース不存在 | 指定名のリソースが存在しない | リソース名の確認、--ignore-not-foundの使用 |
| Forbidden | 権限不足 | RBAC権限がない | 適切なRole/ClusterRoleBindingの設定 |
| - | 引数エラー | リソースタイプ未指定 | `kubectl explain`で利用可能なリソースを確認 |
| - | フォーマットエラー | --rawのURL形式不正 | 有効なURLパスを指定 |

### リトライ仕様

Watch接続の中断時はUntilWithoutRetryにより再接続はしない。ユーザーが手動で再実行する。

## トランザクション仕様

トランザクションの概念はなし。読み取り専用操作。

## パフォーマンス要件

- チャンクサイズ指定により大量リソースの段階的取得が可能
- サーバーサイドプリントにより、不要なフィールドの転送を削減
- ソートはクライアントサイドで行われるため、大量データ時のメモリ使用に注意

## セキュリティ考慮事項

- RBACによるget/list/watchの権限制御
- kubeconfigの認証情報を使用したAPI Serverへの接続
- Secret等の機密リソースの表示に注意

## 備考

- `kubectl get`は最も使用頻度の高いkubectlコマンドの一つ
- サブコマンドのサジェスト: "list", "ps"
- Kustomizeディレクトリ（-k）の指定もサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | GetOptions構造体（55-85行目） |

**読解のコツ**: GetOptions構造体はコマンドの全状態を保持する。PrintFlags、FilenameOptions、Watch関連、セレクター、出力設定等がフィールドとして定義されている。

#### Step 2: コマンド初期化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | NewCmdGet関数（161-194行目） |

**主要処理フロー**:
1. **162行目**: NewGetOptions でデフォルト設定の作成
2. **164-177行目**: cobra.Commandの構築（Run: Complete -> Validate -> Run）
3. **179-193行目**: フラグの登録（output, watch, selector等）

#### Step 3: Complete/Validate/Runの流れを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | Complete関数（197-295行目） |
| 3-2 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | Validate関数（298-320行目） |
| 3-3 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | Run関数（本ファイル後半） |

**主要処理フロー**:
- **206行目**: 名前空間の解決（f.ToRawKubeConfigLoader().Namespace()）
- **222-225行目**: サーバーサイドプリントの判定（custom-columns/yaml/json時は無効化）
- **237-270行目**: ToPrinterの構築（プリンターチェーン: TypeSetter -> SortingPrinter -> skipPrinter -> TablePrinter）
- **298-320行目**: バリデーション（RAW排他、show-labels互換性、output-watch-events依存）

#### Step 4: 出力フォーマットを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | get_flags.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get_flags.go` | PrintFlags定義 |
| 4-2 | table_printer.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/table_printer.go` | TablePrinter |
| 4-3 | sorter.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/sorter.go` | SortingPrinter |

### プログラム呼び出し階層図

```
kubectl get [TYPE] [NAME] [flags]
    |
    +-- NewCmdGet (cobra.Command)
            |
            +-- GetOptions.Complete(f, cmd, args)
            |       +-- f.ToRawKubeConfigLoader().Namespace()
            |       +-- ToPrinter構築
            |
            +-- GetOptions.Validate()
            |
            +-- GetOptions.Run(f, args)
                    |
                    +-- [RAWモード] rawhttp.RawGet
                    |
                    +-- [通常モード]
                            +-- f.NewBuilder()
                            |       +-- .NamespaceParam()
                            |       +-- .LabelSelectorParam()
                            |       +-- .FieldSelectorParam()
                            |       +-- .ResourceTypeOrNameArgs()
                            |       +-- .Do()
                            |
                            +-- [Watch] watchtools.UntilWithoutRetry
                            |
                            +-- [通常] infos取得
                                    +-- RuntimeSorter.Sort()
                                    +-- printer.PrintObj()
```

### データフロー図

```
[入力]                          [処理]                       [出力]

CLI args ---------> Complete (引数解析) --------+
                                                |
kubeconfig -------> Namespace解決 --------+     |
                                          |     |
                    resource.Builder ------+---> API Server GET/LIST
                                                |
                                          PrinterChain
                                                |
                    TypeSetter -> SortingPrinter -> TablePrinter -> stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | getコマンドのメインロジック |
| get_flags.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get_flags.go` | ソース | PrintFlags定義 |
| table_printer.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/table_printer.go` | ソース | テーブル出力プリンター |
| sorter.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/sorter.go` | ソース | ソート機能 |
| customcolumn.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/customcolumn.go` | ソース | カスタムカラム出力 |
| customcolumn_flags.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/customcolumn_flags.go` | ソース | カスタムカラムフラグ |
| humanreadable_flags.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/humanreadable_flags.go` | ソース | 人間が読める出力のフラグ |
| skip_printer.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/skip_printer.go` | ソース | スキッププリンター |
| get_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get_test.go` | テスト | ユニットテスト |
