# 機能設計書 83-リソース削除（delete）

## 概要

本ドキュメントは、kubectlの`delete`コマンドによるKubernetesリソース削除機能の設計を記述する。ファイル名、リソースタイプと名前、またはラベルセレクターに基づいてリソースを削除する。

### 本機能の処理概要

**業務上の目的・背景**：クラスター上の不要なリソースを削除するための基本操作を提供する。グレースフル削除、強制削除、カスケード削除（依存リソースの連鎖削除）など、削除に関する多様な制御を可能にする。

**機能の利用シーン**：不要なPod/Deployment/Serviceの削除、テスト環境のクリーンアップ、ラベルセレクターによる一括削除、メンテナンス時のリソース整理、カスタムリソースの削除後のキャッシュ更新など。

**主要な処理内容**：
1. コマンドライン引数とフラグの解析（Complete）
2. 入力バリデーション（Validate）
3. リソースビルダーによるオブジェクト検索
4. インタラクティブモードでの確認（--interactive）
5. 各リソースに対するDELETEリクエスト送信
6. 削除完了待機（--wait）

**関連システム・外部連携**：API Serverに対してDELETEリクエストを送信する。Garbage CollectorコントローラーがOwnerReferenceに基づくカスケード削除を実行する。

**権限による制御**：対象リソースに対するdelete権限（RBAC）が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | kubectl delete | 主機能 | Kubernetesリソースを削除する主処理 |

## 機能種別

CRUD操作（Delete）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -f / --filename | string[] | 条件付き | リソース定義ファイルのパス | リソース指定方法のいずれかが必要 |
| TYPE NAME | string | 条件付き | リソースタイプと名前 | リソース指定方法のいずれかが必要 |
| -l / --selector | string | No | ラベルセレクター | --allと排他 |
| --field-selector | string | No | フィールドセレクター | --allと排他 |
| --all | bool | No | 全リソースを削除 | -l、--field-selectorと排他 |
| -A / --all-namespaces | bool | No | 全Namespace対象 | - |
| --cascade | string | No | カスケード削除戦略 | background/foreground/orphan |
| --force | bool | No | 強制削除 | --grace-period > 0と排他 |
| --grace-period | int | No | グレースフル終了期間（秒） | デフォルト-1 |
| --now | bool | No | 即時削除（grace-period=1相当） | --grace-periodと排他 |
| --wait | bool | No | 削除完了を待機 | デフォルトtrue |
| --timeout | duration | No | 待機タイムアウト | デフォルト0（無制限） |
| --ignore-not-found | bool | No | NotFoundエラーを無視 | --all時はデフォルトtrue |
| --raw | string | No | Raw URI | 他のフラグと排他制約あり |
| -i / --interactive | bool | No | 対話的確認 | --rawと排他 |
| --dry-run | string | No | DryRun戦略 | none/client/server |
| -o / --output | string | No | 出力形式 | nameのみサポート |

### 入力データソース

- コマンドライン引数（リソースタイプと名前）
- マニフェストファイル（-f指定）
- 標準入力（stdin）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 削除結果 | string | 例: pod "nginx" deleted |
| 強制削除結果 | string | 例: pod "nginx" force deleted |

### 出力先

- 標準出力（stdout）：削除結果メッセージ
- API Server：リソースの削除

## 処理フロー

### 処理シーケンス

```
1. NewCmdDelete: コマンド定義
2. Complete: オプション補完
   ├─ Namespace、DryRun戦略の取得
   ├─ --all/--now/--forceのデフォルト処理
   └─ ResourceBuilder構築
3. Validate: バリデーション
4. RunDelete: 削除処理
   ├─ [--raw] rawhttp.RawDelete
   ├─ [--interactive] プレビュー表示と確認
   └─ DeleteResult: 各リソースの削除
       ├─ deleteResource: API ServerへのDELETEリクエスト
       ├─ PrintObj: 結果表示
       └─ [--wait] WaitOptions.RunWait: 削除完了待機
```

### フローチャート

```mermaid
flowchart TD
    A[開始: RunDelete] --> B{--raw?}
    B -->|Yes| C[rawhttp.RawDelete]
    B -->|No| D{--interactive?}
    D -->|Yes| E[プレビュー表示]
    E --> F{確認 y/N?}
    F -->|No| G[キャンセル]
    F -->|Yes| H[DeleteResult]
    D -->|No| H
    H --> I[各リソースをVisit]
    I --> J{DryRunClient?}
    J -->|Yes| K[PrintObjのみ]
    J -->|No| L[deleteResource]
    L --> M[PrintObj]
    K --> N{次のリソース?}
    M --> N
    N -->|Yes| I
    N -->|No| O{--wait?}
    O -->|Yes| P[WaitOptions.RunWait]
    O -->|No| Q[終了]
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | all/selector排他 | --allと--selectorは同時指定不可 | 常時 |
| BR-02 | all/field-selector排他 | --allと--field-selectorは同時指定不可 | 常時 |
| BR-03 | now/grace-period排他 | --nowと--grace-periodは同時指定不可 | 常時 |
| BR-04 | force/grace-period制約 | --forceかつ--grace-period > 0は不可 | 常時 |
| BR-05 | grace-period=0保護 | --forceなしのgrace-period=0はgrace-period=1に変換 | 後方互換性 |
| BR-06 | 出力モード制約 | -oはnameのみサポート | -o指定時 |
| BR-07 | ignore-not-found自動設定 | --all/-l/--field-selector使用時はデフォルトtrue | フラグ未変更時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース削除 | etcd（API Server経由） | DELETE | リソースの削除（カスケード含む） |

### テーブル別操作詳細

#### etcd（API Server経由）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | リソースオブジェクト | PropagationPolicyに基づく削除 | background/foreground/orphan |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | NotFound | リソースが存在しない | --ignore-not-foundを使用 |
| 403 | Forbidden | RBAC権限不足 | 適切な権限を付与 |
| - | バリデーションエラー | --allと--selectorの同時指定 | いずれか一方を使用 |
| - | 警告 | --force + --grace-period=0 | データ損失リスクの警告 |

### リトライ仕様

クライアント側でのリトライは行わない。--waitによる削除完了待機はwatch APIを使用。

## トランザクション仕様

各リソースは個別に削除される。カスケード削除はAPI Server側のGarbage Collectorが非同期に処理する。

## パフォーマンス要件

- --waitオプションはタイムアウトなしの場合、デフォルト168時間（1週間）に設定される
- --timeoutで明示的にタイムアウトを設定可能

## セキュリティ考慮事項

- delete権限が必要（RBAC）
- --forceによる強制削除はデータ損失リスクがあり、警告メッセージが表示される
- --interactiveにより誤操作を防止可能

## 備考

- CRD削除後のディスカバリーキャッシュの無効化には最大6時間かかる場合がある
- deleteコマンドはリソースバージョンチェックを行わないため、同時更新との競合に注意

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | DeleteOptions構造体（111-143行目）で全オプションを把握 |
| 1-2 | delete_flags.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete_flags.go` | DeleteFlags構造体（35-52行目）でCLIフラグ定義を把握 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | NewCmdDelete関数（145-169行目） |

**主要処理フロー**:
- **155-161行目**: ToOptions -> Complete -> Validate -> RunDelete のパイプライン

#### Step 3: 削除実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | RunDelete関数（319-364行目）で削除実行フローを理解 |
| 3-2 | delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | DeleteResult関数（366-477行目）で各リソースの削除処理を理解 |

**主要処理フロー**:
- **366-432行目**: r.Visit()による各リソースの削除
- **440-476行目**: --wait指定時のWaitOptions.RunWaitによる削除完了待機

### プログラム呼び出し階層図

```
NewCmdDelete (delete.go:145)
    │
    ├─ deleteFlags.ToOptions (delete_flags.go:54)
    ├─ Complete (delete.go:171)
    │      └─ f.NewBuilder().Do()
    ├─ Validate (delete.go:269)
    └─ RunDelete (delete.go:319)
           ├─ [--raw] rawhttp.RawDelete
           ├─ [--interactive] PreviewResult.Visit → confirmation
           └─ DeleteResult (delete.go:366)
                  ├─ r.Visit → deleteResource (delete.go:479)
                  │      └─ resource.NewHelper.DeleteWithOptions
                  └─ [--wait] cmdwait.WaitOptions.RunWait
```

### データフロー図

```
[入力]                      [処理]                              [出力]

ファイル/引数/セレクター ──▶ ResourceBuilder ──▶ r.Visit()
                                                  │
                                                  ▼
                                          deleteResource ──▶ API Server (DELETE)
                                                  │
                                                  ▼
                                            PrintObj ──▶ stdout
                                                  │
                                          [--wait] ▼
                                          WaitOptions.RunWait (Watch API)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | ソース | メインコマンド定義・削除処理 |
| delete_flags.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete_flags.go` | ソース | CLIフラグ定義・パース |
