# 機能設計書 84-リソース編集（edit）

## 概要

本ドキュメントは、kubectlの`edit`コマンドによるKubernetesリソース編集機能の設計を記述する。サーバー上のリソースをエディタで対話的に編集し、変更をAPI Serverに適用する。

### 本機能の処理概要

**業務上の目的・背景**：クラスター上のリソースを対話的に編集するための機能を提供する。`patch`がプログラマティックな部分更新を行うのに対し、`edit`はユーザーがエディタ上でリソースの全体を確認・編集できるため、設定確認と変更を同時に行いたい場面で特に有用である。

**機能の利用シーン**：Deployment、Service、ConfigMapなどの設定変更、リソースのアノテーション・ラベルの編集、トラブルシューティング時のリソース状態確認と修正、YAML/JSON形式でのリソース編集など。

**主要な処理内容**：
1. コマンドフラグの解析（EditOptions初期化）
2. リソースの取得（API Serverから）
3. エディタの起動（KUBE_EDITOR / EDITOR環境変数、またはvi/notepad）
4. 編集結果の解析とパッチの計算
5. API Serverへの更新リクエスト送信
6. 競合時のリトライ処理

**関連システム・外部連携**：API Serverからリソースを取得し、編集後にPATCHリクエストで更新する。外部エディタプロセスを起動する。

**権限による制御**：対象リソースに対するget、patch権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | kubectl edit | 主機能 | リソースをエディタで対話的に編集する主処理 |

## 機能種別

CRUD操作（Read/Update）/ 対話的編集

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| RESOURCE/NAME | string | Yes（-fと排他） | リソースタイプと名前 | リソース指定が必要 |
| -f / --filename | string[] | Yes（RESOURCE/NAMEと排他） | リソース定義ファイルのパス | - |
| -o / --output | string | No | 出力形式（yaml/json） | デフォルトyaml |
| --output-patch | bool | No | パッチ内容を出力 | - |
| --windows-line-endings | bool | No | Windows改行コード使用 | OSデフォルト |
| --field-manager | string | No | フィールドマネージャー名 | デフォルト: kubectl-edit |
| --save-config | bool | No | last-applied-configurationを保存 | - |
| --subresource | string | No | サブリソースを編集 | status等 |
| --validate | string | No | バリデーション指示 | true/false/strict/warn/ignore |
| --record | bool | No | 変更理由を記録（deprecated） | - |

### 入力データソース

- API Serverから取得したリソースオブジェクト
- ユーザーのエディタ入力
- 環境変数（KUBE_EDITOR, EDITOR, SHELL）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 編集結果 | string | 例: service/registry edited |
| パッチ内容 | string | --output-patch時のパッチJSON |
| 警告メッセージ | string | バリデーション警告 |

### 出力先

- 標準出力（stdout）：編集結果メッセージ
- エディタ：一時ファイルを通じてリソースYAML/JSONを表示
- API Server：PATCHリクエスト

## 処理フロー

### 処理シーケンス

```
1. NewCmdEdit: コマンド定義
   └─ editor.NewEditOptions(NormalEditMode)
2. Complete: オプション補完
   ├─ ファイル名、バリデーション等の解決
   └─ ResourceBuilderの構築
3. Validate: 入力バリデーション
4. Run: 編集処理の実行
   ├─ visitToPatch:
   │   ├─ エディタの起動とリソース表示
   │   ├─ ユーザー編集の待機
   │   ├─ 編集結果の解析
   │   ├─ パッチの計算（Strategic Merge Patch）
   │   ├─ API ServerへのPATCHリクエスト
   │   └─ 競合時のリトライ
   └─ 結果の出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始: Run] --> B[リソース取得 - API Server]
    B --> C[一時ファイルにYAML/JSON出力]
    C --> D[エディタ起動]
    D --> E{ユーザーが編集?}
    E -->|No| F[変更なし - 終了]
    E -->|Yes| G[編集結果の解析]
    G --> H[パッチの計算]
    H --> I{バリデーション?}
    I -->|エラー| J[エディタ再起動]
    I -->|OK| K[API ServerへPATCH]
    K --> L{競合?}
    L -->|Yes| M[最新版取得 → エディタ再起動]
    L -->|No| N[結果出力]
    J --> D
    M --> D
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | エディタ優先順位 | KUBE_EDITOR > EDITOR > vi(Linux)/notepad(Windows) | 常時 |
| BR-02 | シェル優先順位 | SHELL > /bin/bash(Linux)/cmd(Windows) | 常時 |
| BR-03 | 変更なし検出 | 編集内容に変更がない場合は更新をスキップ | 常時 |
| BR-04 | 競合時リトライ | ResourceVersion競合時にエディタを再表示 | 更新時 |
| BR-05 | エラー時一時ファイル | エラー発生時に編集内容を一時ファイルに保存 | エラー発生時 |
| BR-06 | フィールドマネージャー | デフォルトはkubectl-edit | 常時 |

### 計算ロジック

- Strategic Merge Patch: 元のリソースと編集後のリソースの差分からパッチを計算

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース取得 | etcd（API Server経由） | SELECT | 編集対象リソースの取得 |
| リソース更新 | etcd（API Server経由） | UPDATE | 編集結果のPATCH適用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 409 | Conflict | 他ユーザーが同時に更新 | 最新版を取得して再編集 |
| 422 | Unprocessable Entity | 無効なリソース定義 | エディタで修正 |
| - | エディタエラー | エディタが見つからない | KUBE_EDITOR環境変数を設定 |

### リトライ仕様

ResourceVersion競合時、自動的に最新版を取得してエディタを再起動する。

## トランザクション仕様

複数リソースを指定した場合、個別にPATCHが適用される。

## パフォーマンス要件

- エディタプロセスの起動はOS依存
- API Server側のPATCH処理性能はクラスター性能に依存

## セキュリティ考慮事項

- get、patch権限が必要（RBAC）
- 一時ファイルにリソース内容が保存されるため、Secretなどの機密情報が一時的にディスクに保存される
- エディタプロセスの信頼性はユーザー環境に依存

## 備考

- edit.goは薄いラッパーであり、実際の編集ロジックはeditor.EditOptions（editor/editoptions.go）に実装されている
- APIバージョンはリソース取得時のバージョンが使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | edit.go | `staging/src/k8s.io/kubectl/pkg/cmd/edit/edit.go` | NewCmdEdit関数（78-108行目）でコマンド定義を把握。editは薄いラッパーであることに注意 |

**読解のコツ**: edit.goは非常にシンプル。本質的なロジックはeditor.NewEditOptions（79行目）とeditor.EditOptionsパッケージに存在する。

#### Step 2: 編集オプションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | editoptions.go | `staging/src/k8s.io/kubectl/pkg/cmd/util/editor/editoptions.go` | EditOptions構造体で編集処理の全体像を把握 |

**主要処理フロー**:
- NormalEditMode: 通常の編集モード
- EditBeforeCreateMode: create --edit用の作成前編集モード

#### Step 3: 編集処理の実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | editoptions.go | `staging/src/k8s.io/kubectl/pkg/cmd/util/editor/editoptions.go` | Run関数で編集実行フローを理解 |
| 3-2 | editoptions.go | `staging/src/k8s.io/kubectl/pkg/cmd/util/editor/editoptions.go` | visitToPatch関数でパッチ計算の詳細を理解 |

### プログラム呼び出し階層図

```
NewCmdEdit (edit.go:78)
    │
    └─ editor.NewEditOptions(NormalEditMode)
           │
           ├─ Complete (editoptions.go)
           │      └─ f.NewBuilder().Do()
           │
           ├─ Validate (editoptions.go)
           │
           └─ Run (editoptions.go)
                  └─ visitToPatch
                         ├─ エディタ起動（editor.Launch）
                         ├─ 編集結果解析
                         ├─ パッチ計算（Strategic Merge Patch）
                         └─ API Server PATCH
```

### データフロー図

```
[入力]                   [処理]                        [出力]

API Server ──GET──▶ リソース取得
                        │
                        ▼
                   一時ファイル作成
                        │
                        ▼
                   エディタ起動 ──▶ ユーザー編集
                        │
                        ▼
                   差分計算
                        │
                        ▼
                   API Server ──PATCH──▶ stdout (結果表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| edit.go | `staging/src/k8s.io/kubectl/pkg/cmd/edit/edit.go` | ソース | コマンドエントリーポイント（薄いラッパー） |
| editoptions.go | `staging/src/k8s.io/kubectl/pkg/cmd/util/editor/editoptions.go` | ソース | 編集処理のメインロジック |
| editor.go | `staging/src/k8s.io/kubectl/pkg/cmd/util/editor/editor.go` | ソース | エディタの起動と管理 |
