# 機能設計書 86-リソース詳細表示（describe）

## 概要

本ドキュメントは、kubectlの`describe`コマンドによるKubernetesリソースの詳細表示機能の設計を記述する。リソースの詳細情報を、関連イベントやコントローラー情報と共に人間可読な形式で表示する。

### 本機能の処理概要

**業務上の目的・背景**：リソースの状態を詳細に確認するための主要なデバッグ・診断ツールを提供する。`get`コマンドがテーブル形式の簡潔な一覧を表示するのに対し、`describe`はリソースの全フィールド、関連イベント、条件、ボリューム情報など、リソースに関するあらゆる情報を包括的に表示する。

**機能の利用シーン**：Podの状態確認（コンテナ状態、イベント、条件）、Nodeの容量・割り当て確認、Deploymentのロールアウト状態確認、Serviceのエンドポイント確認、名前プレフィックスによる部分一致検索など。

**主要な処理内容**：
1. コマンドライン引数とフラグの解析（ToOptions）
2. リソースビルダーによるオブジェクト検索
3. ResourceDescriber.Describeによる詳細情報の取得
4. 名前プレフィックスマッチングによるフォールバック検索
5. 結果の出力

**関連システム・外部連携**：API Serverから対象リソースおよび関連リソース（イベント等）を取得する。

**権限による制御**：対象リソースに対するget権限、イベント取得にはeventsのlist権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | kubectl describe | 主機能 | リソースの詳細情報を表示する主処理 |

## 機能種別

CRUD操作（Read）/ 情報表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TYPE NAME_PREFIX | string | Yes（-fと排他） | リソースタイプと名前（プレフィックス可） | リソース指定が必要 |
| -f / --filename | string[] | Yes（TYPEと排他） | ファイルからリソースを指定 | - |
| -l / --selector | string | No | ラベルセレクター | - |
| -A / --all-namespaces | bool | No | 全Namespace対象 | - |
| --show-events | bool | No | 関連イベントを表示 | デフォルトtrue |
| --chunk-size | int64 | No | リスト取得のチャンクサイズ | デフォルト500 |

### 入力データソース

- API Server（リソースオブジェクトおよび関連イベント）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 詳細情報 | string | リソースの包括的な詳細テキスト |

### 出力先

- 標準出力（stdout）：リソース詳細テキスト
- 標準エラー出力（stderr）：リソース未検出時のメッセージ

## 処理フロー

### 処理シーケンス

```
1. NewCmdDescribe: コマンド定義
2. ToOptions: CLIフラグからランタイムオプションへ変換
3. Validate: バリデーション（現在は何もチェックしない）
4. Run: 詳細表示の実行
   ├─ NewBuilder().Do(): リソース検索
   ├─ r.Infos(): リソース情報の取得
   ├─ [NotFound] DescribeMatchingResources: プレフィックスマッチ
   └─ 各リソースに対して:
       ├─ Describer(mapping): ResourceDescriber取得
       └─ describer.Describe(): 詳細テキスト生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始: Run] --> B[ResourceBuilder.Do]
    B --> C[r.Infos]
    C --> D{NotFoundエラー?}
    D -->|Yes| E[DescribeMatchingResources]
    D -->|No| F{infos取得成功?}
    E --> F2{プレフィックス一致あり?}
    F2 -->|No| G[元のエラー返却]
    F2 -->|Yes| H[describer.Describe]
    F --> I[各リソースをループ]
    I --> J[Describer取得]
    J --> K[describer.Describe]
    K --> L[stdout出力]
    L --> M{次のリソース?}
    M -->|Yes| I
    M -->|No| N{infos空?}
    N -->|Yes| O[No resources found]
    N -->|No| P[終了]
    H --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 名前プレフィックスマッチ | 完全一致リソースが見つからない場合、名前プレフィックスで部分一致検索 | NotFoundエラー時 |
| BR-02 | イベント表示 | デフォルトで関連イベントを表示 | --show-events=true（デフォルト） |
| BR-03 | チャンクサイズ | リスト取得をチャンク分割して実行 | 常時 |
| BR-04 | 改行区切り | 複数リソースの詳細はダブル改行で区切る | 複数リソース時 |
| BR-05 | エラー重複排除 | 同一エラーメッセージの重複を排除 | エラー発生時 |

### 計算ロジック

特になし。各リソースタイプに対応したDescriberがAPI Serverから情報を取得してテキストを生成する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース取得 | etcd（API Server経由） | SELECT | 対象リソースとイベント |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | NotFound | リソースが存在しない | プレフィックスマッチにフォールバック |
| 403 | Forbidden | 権限不足 | 適切な権限を付与 |
| - | リソース未指定 | 引数なし | リソースタイプと名前を指定 |

### リトライ仕様

リトライは行わない。NotFoundエラー時のプレフィックスマッチがフォールバック動作。

## トランザクション仕様

読み取り専用操作のため、トランザクション管理は不要。

## パフォーマンス要件

- RequestChunksOfによるチャンク取得で大量リソースのリスト取得を効率化
- 各リソースタイプのDescriberは追加のAPI呼び出し（イベント取得等）を行うため、レスポンス時間はリソースの複雑さに依存

## セキュリティ考慮事項

- get権限が必要（RBAC）
- イベント取得にはeventsのlist権限が必要
- Secretをdescribeすると、データフィールドのサイズのみが表示される（値は表示されない）

## 備考

- 各リソースタイプに対応したDescriberはdescribe.DescriberFnで生成される
- カスタムリソースの場合は汎用的なDescriberが使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | describe.go | `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe.go` | DescribeFlags構造体（74-81行目）とDescribeOptions構造体（277-294行目）を把握 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | describe.go | `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe.go` | NewCmdDescribe関数（144-165行目）でコマンド定義を理解 |

**主要処理フロー**:
- **154-159行目**: ToOptions -> Validate -> Runのパイプライン

#### Step 3: 実行処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | describe.go | `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe.go` | Run関数（171-236行目）でメイン処理を理解 |
| 3-2 | describe.go | `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe.go` | DescribeMatchingResources関数（238-275行目）でプレフィックスマッチを理解 |

**主要処理フロー**:
- **172-181行目**: ResourceBuilderの構築とリソース検索
- **190-191行目**: NotFound時のプレフィックスマッチフォールバック
- **198-223行目**: 各リソースのDescribe処理
- **209行目**: describer.Describe()による詳細テキスト生成

### プログラム呼び出し階層図

```
NewCmdDescribe (describe.go:144)
    │
    ├─ flags.ToOptions (describe.go:106)
    │      └─ describe.DescriberFn（Describer生成関数の設定）
    │
    ├─ Validate (describe.go:167) ← 何もチェックしない
    │
    └─ Run (describe.go:171)
           ├─ NewBuilder().Do()
           ├─ r.Infos()
           ├─ [NotFound] DescribeMatchingResources (describe.go:238)
           │      └─ strings.HasPrefix(info.Name, prefix)
           └─ describer.Describe(namespace, name, settings)
```

### データフロー図

```
[入力]                      [処理]                              [出力]

TYPE NAME_PREFIX ──▶ ResourceBuilder ──▶ r.Infos()
                                           │
                                    [NotFound] → DescribeMatchingResources
                                           │            (プレフィックスマッチ)
                                           ▼
                                    describe.DescriberFn → Describer
                                           │
                                           ▼
                                    describer.Describe(ns, name, settings) ──▶ stdout
                                           │
                                    API Server GET (リソース + イベント)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| describe.go | `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe.go` | ソース | コマンド定義・実行処理 |
| describe.go | `staging/src/k8s.io/kubectl/pkg/describe/describe.go` | ソース | 各リソースタイプのDescriber実装 |
