# 機能設計書 9-StatefulSetコントローラー

## 概要

本ドキュメントは、Kubernetes StatefulSetコントローラーの機能設計書である。ステートフルアプリケーションのPodを順序付きで管理し、安定したネットワークIDとストレージを提供する。

### 本機能の処理概要

StatefulSetコントローラーは、StatefulSetリソースで定義されたステートフルアプリケーションのPodを、順序付き・一意性を持って管理する。各Podには安定したホスト名とPersistentVolumeClaimが割り当てられる。

**業務上の目的・背景**：データベース（MySQL, PostgreSQL）、メッセージキュー（Kafka, RabbitMQ）、分散ストレージ（Cassandra, Elasticsearch）等のステートフルアプリケーションは、Pod間の順序関係、安定したネットワークID、永続的なストレージが必要である。StatefulSetはこれらの要件を満たすために設計された。Podの名前は{StatefulSet名}-{序数}の形式で一意に割り当てられ、再起動後も同じIDとストレージを維持する。

**機能の利用シーン**：データベースクラスターのデプロイ（マスター/スレーブ構成）、分散システムのクラスター管理、順序付きのPod起動/停止が必要なアプリケーション、永続ストレージが必要なワークロード。

**主要な処理内容**：
1. StatefulSetリソースの監視（Informer経由）
2. 順序付きPodの作成・削除管理（OrderedReady/Parallel）
3. PersistentVolumeClaimの作成・管理
4. ControllerRevisionによるリビジョン管理
5. ローリングアップデート（partition指定対応）
6. OnDeleteアップデート戦略のサポート
7. PodのreadyCondition確認による順序制御

**関連システム・外部連携**：PersistentVolumeプロビジョナー（ストレージ）、Headless Service（ネットワークID）、API Server

**権限による制御**：StatefulSetの操作にはapps/statefulsetsリソースへのRBACアクセス権が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接の関連なし（kubectl経由でStatefulSetリソースを操作） |

## 機能種別

コントローラー / リコンシリエーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| StatefulSet.Spec.Replicas | *int32 | No | 目標レプリカ数（デフォルト1） | 0以上 |
| StatefulSet.Spec.Selector | LabelSelector | Yes | Pod選択ラベルセレクター | 不変 |
| StatefulSet.Spec.Template | PodTemplateSpec | Yes | Podテンプレート | 有効なPod仕様 |
| StatefulSet.Spec.VolumeClaimTemplates | []PVC | No | PVC テンプレート | 有効なPVC仕様 |
| StatefulSet.Spec.ServiceName | string | Yes | Headless Service名 | 存在するService |
| StatefulSet.Spec.PodManagementPolicy | string | No | OrderedReady/Parallel | 有効なポリシー |
| StatefulSet.Spec.UpdateStrategy | StatefulSetUpdateStrategy | No | RollingUpdate/OnDelete | 有効な戦略 |
| StatefulSet.Spec.UpdateStrategy.RollingUpdate.Partition | *int32 | No | 更新対象のパーティション（序数以上を更新） | 0以上 |
| StatefulSet.Spec.PersistentVolumeClaimRetentionPolicy | PVCRetentionPolicy | No | PVC保持ポリシー（Retain/Delete） | 有効なポリシー |

### 入力データソース

API Server経由のInformer（StatefulSet, Pod, PersistentVolumeClaim, ControllerRevision）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Pod | v1.Pod | 順序付きの名前（{name}-{ordinal}）で作成されるPod |
| PersistentVolumeClaim | v1.PVC | VolumeClaimTemplateに基づいて作成されるPVC |
| ControllerRevision | apps/v1.ControllerRevision | リビジョン管理用のControllerRevision |
| StatefulSet.Status | StatefulSetStatus | ステータス更新 |

### 出力先

API Server経由でetcdに永続化

## 処理フロー

### 処理シーケンス

```
1. Informerからのイベント検知
   └─ StatefulSet/Pod/PVC/ControllerRevisionの変更をWorkQueueにエンキュー
2. sync（メインリコンシリエーションループ）
   └─ WorkQueueからStatefulSetキーを取得して同期処理開始
3. ControllerRevision管理
   └─ 現在のリビジョンと更新リビジョンの特定
4. Pod同期
   └─ 序数0からN-1までの各Podの状態を確認
5. Pod作成/更新/削除
   └─ PodManagementPolicyに従い、Pod操作を実行
6. PVC管理
   └─ VolumeClaimTemplateに基づくPVCの作成と維持
7. ステータス更新
   └─ StatefulSet.Statusの更新
```

### フローチャート

```mermaid
flowchart TD
    A[Informerイベント] --> B[WorkQueueエンキュー]
    B --> C[UpdateStatefulSet]
    C --> D[ControllerRevision管理]
    D --> E[Pod一覧取得・整理]
    E --> F{PodManagementPolicy}
    F -->|OrderedReady| G[順序付きPod処理]
    F -->|Parallel| H[並列Pod処理]
    G --> G1[序数0から順にPod作成]
    G1 --> G2[Ready確認後に次のPod]
    H --> H1[全Pod並列に処理]
    G2 --> I[ローリングアップデート]
    H1 --> I
    I --> J[ステータス更新]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-1 | 順序付き名前 | Pod名は{StatefulSet名}-{序数}形式で固定 | 全Pod |
| BR-2 | OrderedReady | 序数の小さいPodからReady確認後に次のPodを処理 | OrderedReadyポリシー時 |
| BR-3 | Parallel | 全Podを並列に作成/削除可能 | Parallelポリシー時 |
| BR-4 | Partition | partition以上の序数を持つPodのみ更新 | RollingUpdateのpartition指定時 |
| BR-5 | PVC保持 | StatefulSet削除後もPVCはデフォルトで保持（Retain） | PVCRetentionPolicy |
| BR-6 | MaxBatchSize | 並列処理時の最大バッチサイズは500 | Parallelモード時 |
| BR-7 | OnDelete | OnDelete戦略ではPodが手動削除されるまで更新しない | OnDelete戦略時 |

### 計算ロジック

- Pod序数: 0 から spec.replicas - 1 までの連番
- リビジョン管理: ControllerRevisionにPodTemplateSpecのハッシュを保存
- ローリングアップデート: 序数が大きいPodから順に更新（partition以上のみ）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Pod作成 | etcd | INSERT | 序数付きPodの作成 |
| Pod削除 | etcd | DELETE | スケールダウン時のPod削除（大きい序数から） |
| PVC作成 | etcd | INSERT | VolumeClaimTemplateに基づくPVC作成 |
| ControllerRevision作成 | etcd | INSERT | リビジョン管理 |
| StatefulSet Status更新 | etcd | UPDATE | ステータス更新 |

### テーブル別操作詳細

#### etcd

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | /registry/pods/{namespace}/{statefulset-name}-{ordinal} | 序数付きPod | 固定名（generateNameではない） |
| INSERT | /registry/persistentvolumeclaims/{namespace}/{pvc-name}-{statefulset-name}-{ordinal} | PVC | VolumeClaimTemplate由来 |
| INSERT | /registry/controllerrevisions/{namespace}/{name} | リビジョン定義 | ハッシュベース |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Pod作成失敗 | ResourceQuota超過、PVCバインド失敗 | ResourceQuotaやStorageClassを確認 |
| - | PVC作成失敗 | StorageClass不存在 | StorageClassを作成 |
| - | Pod Ready待ちタイムアウト | Podが起動しない | Podのイベントとログを確認 |

### リトライ仕様

ワークキューのrate limiterにより自動リトライ。OrderedReadyモードではPodがReady状態になるまで次のPodの処理を待機。

## トランザクション仕様

各Pod/PVCの操作はAPI Server経由でアトミックに実行。StatefulSet全体の更新は各Podの逐次処理で行われる。

## パフォーマンス要件

- OrderedReadyモードでは各Podの起動時間に依存
- Parallelモードでは最大500Podを並列処理
- ControllerRevisionのキャッシュによる比較高速化（LRUキャッシュ）

## セキュリティ考慮事項

- StatefulSetの操作にはapps/statefulsetsリソースへの適切なRBAC権限が必要
- PVCに保存されるデータのセキュリティはStorageClassの設定に依存

## 備考

StatefulSetはHeadless Service（clusterIP: None）と組み合わせて使用し、各Podに安定したDNS名（{pod-name}.{service-name}.{namespace}.svc.cluster.local）を提供する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stateful_set.go | `pkg/controller/statefulset/stateful_set.go` | StatefulSetController構造体（**60-87行目**）。kubeClient, control, podControl, podIndexer, podLister, setLister, queue, clockフィールド |
| 1-2 | stateful_set_control.go | `pkg/controller/statefulset/stateful_set_control.go` | StatefulSetControlInterface（**46-59行目**）。UpdateStatefulSet, ListRevisions, AdoptOrphanRevisionsメソッド |

**読解のコツ**: StatefulSetControlInterfaceがリコンシリエーションの核心。defaultStatefulSetControl（**73-79行目**）がpodControl, statusUpdater, controllerHistory, revisionEqualityCacheを保持する。MaxBatchSize=500（**42行目**）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stateful_set.go | `pkg/controller/statefulset/stateful_set.go` | NewStatefulSetController関数（**90行目**）でInformerイベントハンドラを登録 |

**主要処理フロー**:
1. **90-97行目**: NewStatefulSetControllerでコントローラー初期化
2. **99行目**: EventBroadcaster生成
3. **102-103行目**: metricsの登録とControllerRevisionインデクサーの追加
4. **107-117行目**: StatefulSetController構造体の初期化（DefaultStatefulSetControl, StatefulPodControl, StatusUpdater, History）

#### Step 3: Pod制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stateful_pod_control.go | `pkg/controller/statefulset/stateful_pod_control.go` | StatefulPodControlがPod/PVCの実際の作成・更新・削除を担当 |
| 3-2 | stateful_set_utils.go | `pkg/controller/statefulset/stateful_set_utils.go` | Pod名生成、序数管理等のユーティリティ |

### プログラム呼び出し階層図

```
StatefulSetController.Run()
    │
    ├─ worker() → processNextWorkItem()
    │      │
    │      └─ sync()
    │             │
    │             ├─ control.UpdateStatefulSet()
    │             │      │
    │             │      ├─ ListRevisions() → ControllerRevision管理
    │             │      ├─ updateStatefulSet()
    │             │      │      ├─ [OrderedReady] 逐次Pod処理
    │             │      │      │      ├─ createStatefulPod() → PVC作成 → Pod作成
    │             │      │      │      └─ updateStatefulPod() → Pod更新/再作成
    │             │      │      └─ [Parallel] 並列Pod処理
    │             │      └─ updateStatefulSetStatus()
    │             │
    │             └─ AdoptOrphanRevisions()
    │
    └─ Informer Event Handlers
           ├─ addStatefulSet() / updateStatefulSet() / deleteStatefulSet()
           ├─ addPod() / updatePod() / deletePod()
           └─ addPVC() (for PVCRetentionPolicy)
```

### データフロー図

```
[入力]                       [処理]                             [出力]

StatefulSet Spec ──────▶ StatefulSetController ──────▶ Pod-0, Pod-1, ..., Pod-N
├─ replicas                 ├─ UpdateStatefulSet()           ├─ 安定した名前
├─ template                 ├─ 逐次/並列Pod処理              └─ OwnerReference
├─ volumeClaimTemplates     └─ PVC管理
└─ serviceName                                           PVC-0, PVC-1, ..., PVC-N
                                                          └─ 永続ストレージ
ControllerRevision ────▶ リビジョン比較 ──────────▶
                                                     StatefulSet Status
                                                      ├─ replicas
                                                      ├─ readyReplicas
                                                      └─ currentRevision/updateRevision
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stateful_set.go | `pkg/controller/statefulset/stateful_set.go` | ソース | コントローラー本体 |
| stateful_set_control.go | `pkg/controller/statefulset/stateful_set_control.go` | ソース | リコンシリエーションロジック |
| stateful_pod_control.go | `pkg/controller/statefulset/stateful_pod_control.go` | ソース | Pod/PVC制御 |
| stateful_set_utils.go | `pkg/controller/statefulset/stateful_set_utils.go` | ソース | ユーティリティ関数 |
| stateful_set_status_updater.go | `pkg/controller/statefulset/stateful_set_status_updater.go` | ソース | ステータス更新 |
| metrics/ | `pkg/controller/statefulset/metrics/` | ソース | コントローラーメトリクス |
| config/ | `pkg/controller/statefulset/config/` | ソース | コントローラー設定 |
