# 機能設計書 91-スケーリング（scale）

## 概要

本ドキュメントは、kubectl scaleコマンドによるKubernetesリソースのレプリカ数変更機能の設計を記述する。

### 本機能の処理概要

kubectl scaleコマンドは、Deployment、ReplicaSet、ReplicationController、StatefulSetのレプリカ数を宣言的に変更するCLI機能である。

**業務上の目的・背景**：アプリケーションの負荷に応じてPod数を手動で増減させる必要がある場合に利用される。トラフィック急増時のスケールアウトや、コスト削減のためのスケールインを迅速に行うための基本的な運用操作である。

**機能の利用シーン**：トラフィック増加に伴うPod数の増加、メンテナンス前のレプリカ数削減、障害復旧時のリソース確保、デプロイ前のキャパシティ調整など、日常的な運用作業で頻繁に利用される。

**主要な処理内容**：
1. コマンドライン引数からターゲットリソースとレプリカ数を解析
2. 前提条件（current-replicas、resource-version）の検証
3. Scale APIを通じてリソースのレプリカ数を更新
4. オプションでスケール完了を待機（timeout指定時）
5. 変更記録のためのMerge Patchを適用

**関連システム・外部連携**：API Server経由でScale サブリソースAPIを呼び出す。スケール後、DeploymentコントローラーやReplicaSetコントローラーが実際のPod数を調整する。

**権限による制御**：対象リソースのscaleサブリソースに対するupdate権限（RBAC）が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | kubectl scale | 主機能 | Deployment、ReplicaSet等のレプリカ数を変更する主処理 |
| 10 | kubectl scale | API連携 | スケーリング結果としてDeploymentコントローラーがレプリカ数を調整する |
| 10 | kubectl scale | API連携 | ReplicaSetコントローラーが目標レプリカ数に合わせてPodを作成/削除する |

## 機能種別

CRUD操作（Update） / リソーススケーリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --replicas | int | Yes | 新しいレプリカ数 | 0以上の整数であること |
| --current-replicas | int | No | 現在のレプリカ数（前提条件） | -1以上の整数。-1はチェックなし |
| --resource-version | string | No | リソースバージョン（前提条件） | 複数リソース指定時は使用不可 |
| --timeout | duration | No | スケール完了待機時間 | 0は待機なし |
| --selector / -l | string | No | ラベルセレクタ | 有効なラベルセレクタ形式 |
| --all | bool | No | 指定タイプの全リソースを選択 | - |
| -f / --filename | string | No | リソース定義ファイル | 有効なファイルパス |
| --dry-run | string | No | dry-run戦略(none/client/server) | - |
| TYPE NAME | string | Yes(ファイル指定なし時) | リソースタイプと名前 | deployment/replicaset/replicationcontroller/statefulset |

### 入力データソース

CLI引数、ファイル（-fオプション）、kubeconfig（クラスター接続情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| スケール結果 | string | "resource scaled" のメッセージ |
| リソースオブジェクト | Object | --output指定時のリソース詳細 |

### 出力先

標準出力（stdout）

## 処理フロー

### 処理シーケンス

```
1. Complete: コマンド引数と環境の初期化
   └─ namespace、builder、scaler、clientSetの設定
2. Validate: 入力パラメータの検証
   └─ replicas >= 0、current-replicas >= -1
3. RunScale: スケーリング実行
   ├─ resource.Builderでリソース情報を取得
   ├─ 前提条件（ScalePrecondition）の設定
   ├─ リトライパラメータの設定（1秒間隔、最大5分）
   ├─ 各リソースに対してScale APIを呼び出し
   ├─ 変更記録のMerge Patch適用
   └─ 結果を出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Complete: 引数解析・初期化]
    B --> C[Validate: パラメータ検証]
    C --> D{replicas >= 0?}
    D -->|No| E[エラー終了]
    D -->|Yes| F[RunScale: リソース取得]
    F --> G{前提条件あり?}
    G -->|Yes| H[ScalePrecondition設定]
    G -->|No| I[blind update]
    H --> J[各リソースループ]
    I --> J
    J --> K{dry-run client?}
    K -->|Yes| L[オブジェクト出力のみ]
    K -->|No| M[scaler.Scale呼び出し]
    M --> N[変更記録Patch]
    N --> O[結果出力]
    L --> O
    O --> P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-91-01 | 前提条件チェック | current-replicasまたはresource-version指定時、現在の値と一致する場合のみスケール実行 | パラメータ指定時 |
| BR-91-02 | リソースバージョン排他 | resource-versionは複数リソース指定時に使用不可 | 複数リソース指定時 |
| BR-91-03 | リトライ設定 | スケールAPIは1秒間隔、最大5分でリトライ | 常時 |
| BR-91-04 | 待機設定 | timeout指定かつdry-run=none時のみスケール完了を待機 | timeout > 0 |

### 計算ロジック

特になし。レプリカ数は直接指定される。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Scale | Scale サブリソース | UPDATE | etcd上のscaleサブリソースを更新 |
| Record | 対象リソース | PATCH | 変更記録アノテーションを付与 |

### テーブル別操作詳細

#### Scaleサブリソース

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | spec.replicas | --replicas で指定された値 | Scale APIを通じて更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | replicas < 0 | 正の整数を指定 |
| - | バリデーションエラー | current-replicas < -1 | -1以上の整数を指定 |
| - | 前提条件エラー | 現在のレプリカ数が--current-replicasと不一致 | 正しい値を確認して再実行 |
| - | リソースバージョンエラー | resource-versionが不一致 | 最新のバージョンを取得して再実行 |
| - | 権限エラー | scaleサブリソースへのupdate権限なし | RBAC設定を確認 |

### リトライ仕様

Scale API呼び出しは1秒間隔、最大5分でリトライされる（scale.NewRetryParams）。timeout指定時はスケール完了も同様にポーリングで待機する。

## トランザクション仕様

etcdのoptimistic concurrency制御により、resource-version指定時は楽観ロックが適用される。

## パフォーマンス要件

Scale APIはサブリソースアクセスのため軽量。タイムアウトはユーザー指定（デフォルトは無制限待機なし）。

## セキュリティ考慮事項

- 対象リソースのscaleサブリソースに対するRBAC update権限が必要
- dry-runモード（client/server）でのテスト実行が可能
- kubeconfigによる認証情報管理

## 備考

- 対応リソースタイプ: deployment, replicaset, replicationcontroller, statefulset
- 複数リソースの一括スケーリングが可能
- ファイル指定（-f）によるリソース特定も可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ScaleOptionsがコマンドの全状態を保持する中心的な構造体である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | scale.go | `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` | ScaleOptions構造体（67-93行目）でコマンドの全オプションを確認 |

**読解のコツ**: `genericiooptions.IOStreams`の埋め込みはstdin/stdout/stderrのストリームを提供する。`resource.Builder`はKubernetes CLIの汎用リソース検索パターン。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | scale.go | `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` | NewCmdScale関数（106-138行目）でcobraコマンドの定義とフラグ登録を確認 |

**主要処理フロー**:
1. **118-122行目**: Run関数内でComplete -> Validate -> RunScaleの順に実行
2. **109行目**: validArgsでサポートリソースタイプを定義
3. **131-132行目**: --replicasフラグは必須（MarkFlagRequired）

#### Step 3: 初期化処理（Complete）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scale.go | `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` | Complete関数（140-178行目）でnamespace、builder、scaler等の初期化を確認 |

**主要処理フロー**:
- **159行目**: namespaceをkubeconfigから取得
- **163行目**: resource.Builderの生成
- **170-173行目**: scalerの生成（ScaleClientFnを使用）

#### Step 4: スケーリング実行（RunScale）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | scale.go | `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` | RunScale関数（193-272行目）がスケーリングの本体 |

**主要処理フロー**:
- **194-206行目**: resource.Builderでリソース情報を取得
- **220-223行目**: 前提条件（ScalePrecondition）の設定
- **224行目**: リトライパラメータ（1秒間隔、最大5分）
- **247行目**: scaler.Scaleでスケーリング実行
- **252-263行目**: 変更記録のMerge Patch適用

### プログラム呼び出し階層図

```
NewCmdScale
    │
    ├─ Complete
    │      ├─ f.ToRawKubeConfigLoader().Namespace()
    │      ├─ f.NewBuilder()
    │      ├─ f.KubernetesClientSet()
    │      └─ scaler(f) → scale.NewScaler()
    │
    ├─ Validate
    │      └─ replicas/currentReplicas の範囲チェック
    │
    └─ RunScale
           ├─ builder.Do() → r.Infos()
           ├─ ScalePrecondition設定
           ├─ scaler.Scale()
           │      └─ Scale API呼び出し（リトライ付き）
           ├─ Recorder.MakeRecordMergePatch()
           │      └─ helper.Patch()（変更記録）
           └─ PrintObj()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CLI引数              ───▶ Complete（初期化）
 (--replicas, TYPE/NAME)     │
                             ▼
                        Validate（検証）
                             │
                             ▼
kubeconfig           ───▶ RunScale
                        ├─ Builder.Do()        ───▶ API Server (GET)
                        ├─ scaler.Scale()      ───▶ API Server (PUT /scale)
                        ├─ helper.Patch()      ───▶ API Server (PATCH)
                        └─ PrintObj()          ───▶ stdout（結果表示）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| scale.go | `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` | ソース | scaleコマンドのメイン実装 |
| scale.go | `staging/src/k8s.io/kubectl/pkg/scale/scale.go` | ソース | Scalerインターフェースとスケーリングロジック |
| util.go | `staging/src/k8s.io/kubectl/pkg/cmd/util/factory.go` | ソース | ScaleClientFn等のファクトリユーティリティ |
