# 機能設計書 92-オートスケール設定（autoscale）

## 概要

本ドキュメントは、kubectl autoscaleコマンドによるHorizontalPodAutoscaler（HPA）リソースの作成機能の設計を記述する。

### 本機能の処理概要

kubectl autoscaleコマンドは、Deployment、ReplicaSet、StatefulSet、ReplicationControllerに対してHorizontalPodAutoscaler（HPA）リソースを自動生成するCLI機能である。

**業務上の目的・背景**：CPU使用率等のメトリクスに基づいてPod数を自動的にスケーリングさせる設定を簡易に行うために利用される。手動スケーリング（scale）と異なり、負荷に応じた自動調整を実現する。

**機能の利用シーン**：本番環境でのトラフィック変動に対する自動スケーリング設定、開発/ステージング環境でのHPA動作検証、リソース効率化のためのオートスケーリングポリシー適用。

**主要な処理内容**：
1. コマンドライン引数からターゲットリソースとスケーリングパラメータを解析
2. ターゲットリソースの存在確認とセレクタ取得
3. HPAリソースのGenerator（GeneratorFn）を使用してHPAオブジェクトを生成
4. API Serverに対してHPAリソースを作成

**関連システム・外部連携**：HPA Controllerが作成されたHPAリソースを監視し、metrics-serverから取得したメトリクスに基づいて自動スケーリングを実行する。

**権限による制御**：HPAリソースのcreate権限、対象リソースのget権限（RBAC）が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | kubectl autoscale | 主機能 | HPAリソースの作成 |

## 機能種別

CRUD操作（Create） / リソース自動生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TYPE NAME | string | Yes | スケーリング対象のリソースタイプと名前 | deployment/replicaset/statefulset/replicationcontroller |
| --min | int | No | 最小レプリカ数 | 1以上の整数 |
| --max | int | Yes | 最大レプリカ数 | 1以上の整数 |
| --cpu-percent | int | No | CPU使用率閾値 | 1-100の整数 |
| --name | string | No | HPA名（デフォルトはターゲット名） | DNS-1123形式 |
| --dry-run | string | No | dry-run戦略 | none/client/server |
| -f / --filename | string | No | リソース定義ファイル | 有効なファイルパス |
| -o / --output | string | No | 出力フォーマット | json/yaml/name/wide等 |

### 入力データソース

CLI引数、kubeconfig（クラスター接続情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 作成結果 | string | "horizontalpodautoscaler autoscaled" のメッセージ |
| HPAオブジェクト | Object | --output指定時のHPA詳細 |

### 出力先

標準出力（stdout）

## 処理フロー

### 処理シーケンス

```
1. Complete: コマンド引数と環境の初期化
   └─ namespace、printer、recorderの設定
2. Validate: 入力パラメータの検証
   └─ maxは必須
3. Run: HPA作成実行
   ├─ resource.Builderでターゲットリソース情報を取得
   ├─ HPAジェネレーターでパラメータからHPAオブジェクトを生成
   ├─ Override適用
   ├─ API Serverに対してHPAリソースをCreate
   └─ 結果を出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Complete: 引数解析・初期化]
    B --> C[Validate: パラメータ検証]
    C --> D{--max 指定あり?}
    D -->|No| E[エラー終了]
    D -->|Yes| F[Run: ターゲットリソース取得]
    F --> G[HPA Generatorで生成]
    G --> H[Override適用]
    H --> I{dry-run client?}
    I -->|Yes| J[オブジェクト出力のみ]
    I -->|No| K[API Server CREATE]
    K --> L[結果出力]
    J --> L
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-92-01 | max必須 | --maxの指定は必須 | 常時 |
| BR-92-02 | CPU閾値デフォルト | --cpu-percent未指定時はHPAのデフォルト値を使用 | cpu-percent未指定時 |
| BR-92-03 | 名前デフォルト | --name未指定時はターゲットリソース名をHPA名として使用 | name未指定時 |

### 計算ロジック

HPA Controller側で `desiredReplicas = ceil[currentReplicas * (currentMetric / targetMetric)]` の計算が行われる。autoscaleコマンド自体は閾値の設定のみを行う。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Create | HorizontalPodAutoscaler | CREATE | HPAリソースを新規作成 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | --max未指定 | --maxを指定して再実行 |
| - | リソース未存在 | ターゲットリソースが存在しない | リソース名を確認 |
| - | 権限エラー | HPAのcreate権限なし | RBAC設定を確認 |
| - | 重複エラー | 同名HPAが既に存在 | 既存HPAを削除または別名を指定 |

## トランザクション仕様

API Serverのatomic create操作。既に同名リソースが存在する場合はconflictエラーが返される。

## パフォーマンス要件

HPAリソースの作成は単一API呼び出し。作成後のオートスケーリング動作はHPA Controllerのポーリング間隔（デフォルト15秒）に依存。

## セキュリティ考慮事項

- HPAリソースのcreate権限が必要
- 対象リソースのget権限が必要
- cpu-percentの不適切な設定によるリソース枯渇に注意

## 備考

- HPAはv2 APIを使用して作成される
- metrics-serverのデプロイが前提
- カスタムメトリクスの設定はこのコマンドでは不可（kubectl apply等で直接YAML適用が必要）

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | AutoscaleOptions構造体でコマンドの全オプションを確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | NewCmdAutoscale関数でcobraコマンドの定義とフラグ登録を確認 |

#### Step 3: HPA生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | Run関数内でGeneratorFnを使ったHPAオブジェクト生成を確認 |

### プログラム呼び出し階層図

```
NewCmdAutoscale
    │
    ├─ Complete
    │      ├─ f.ToRawKubeConfigLoader().Namespace()
    │      ├─ PrintFlags.ToPrinter()
    │      └─ RecordFlags.ToRecorder()
    │
    ├─ Validate
    │      └─ パラメータ検証
    │
    └─ Run
           ├─ resource.Builder.Do()
           ├─ generator.Generate(params)
           ├─ overrider.Apply()
           ├─ resource.NewHelper().Create()  ───▶ API Server
           └─ PrintObj()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CLI引数              ───▶ Complete（初期化）
 (--max, --min, TYPE)      │
                           ▼
                        Validate（検証）
                           │
                           ▼
kubeconfig           ───▶ Run
                      ├─ Builder.Do()          ───▶ API Server (GET)
                      ├─ generator.Generate()
                      ├─ NewHelper().Create()  ───▶ API Server (CREATE HPA)
                      └─ PrintObj()            ───▶ stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | ソース | autoscaleコマンドのメイン実装 |
| generators.go | `staging/src/k8s.io/kubectl/pkg/generate/versioned/generator.go` | ソース | HPAジェネレーター定義 |
